<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xhtml="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml"
			version="1.0"
			encoding="utf-8"
			omit-xml-declaration="yes"
			media-type="application/xhtml+xml;"
	/>

	<!--
		Window
		Used to display any program in a virtual window within the OS
		
		@todo		Add header icon support
	-->
	<xsl:template match="window">
		<xsl:apply-templates select="link"/>
		<div class="window">
			<!-- Move this to Javascript on Parse -->
			<xsl:if test="@show or @width or @height">
				<xsl:attribute name="style">
					<xsl:if test="@width != ''">width:<xsl:value-of select="@width"/>;</xsl:if>
					<xsl:if test="@height != ''">height:<xsl:value-of select="@height"/>;</xsl:if>
					<xsl:if test="@show = 'false'">display:none;</xsl:if>
				</xsl:attribute>
			</xsl:if>
			<!-- /MOVE -->
			<div class="head">
				<h3><xsl:value-of select="title"/></h3>
				<img class="window-min" src="templates/default/images/system/arrow-down.png" alt="[-]" title="Minimize Window"/>
				<img class="window-close" src="templates/default/images/system/close.png" alt="[X]" title="Close Window"/>
			</div>
			<div class="container">
				<xsl:if test="menu/buttonwidget">
					<ul class="menubar">
						<xsl:apply-templates select="menu/buttonwidget"/>
					</ul>
				</xsl:if>
				<xsl:if test="count( content/* )">
					<xsl:for-each select="content">
						<xsl:apply-templates select="."/>
					</xsl:for-each>
				</xsl:if>
				<div class="clear"><xsl:comment/></div>
			</div>
			<div class='ui-resizable-e ui-resizable-handle'></div>
			<div class='ui-resizable-s ui-resizable-handle'></div>
			<div class='ui-resizable-w ui-resizable-handle'></div>
			<div class='ui-resizable-se ui-resizable-handle'></div>
			<div class='ui-resizable-sw ui-resizable-handle'></div>
		</div>
	</xsl:template>

	<xsl:template match="buttonwidget">
		<li>
			<a>
<!--				<xsl:choose>
					<xsl:when test="@href !=''">
						<xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
-->						<xsl:attribute name="href">javascript:void(0);</xsl:attribute>
<!--					</xsl:otherwise>
				</xsl:choose>
-->				<xsl:if test="@newwindow = 'true'">
					<xsl:attribute name="onclick">
						newWindow('<xsl:value-of select="@xml"/>','<xsl:value-of select="@template"/>');
					</xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="@icon and @icon !=''">
						<img src="{@icon}" title="{.}" alt="{.}"/>
						<xsl:if test="not( @notext )">
							<span><xsl:value-of select="."/></span>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<span><xsl:value-of select="."/></span>
					</xsl:otherwise>
				</xsl:choose>
			</a>
		</li>
	</xsl:template>

</xsl:stylesheet>