<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xhtml="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output
			method="xml"
			version="1.0"
			encoding="utf-8"
			omit-xml-declaration="no"
			doctype-public="-//W3C//DTD XHTML 1.1//EN"
			doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml11.dtd"
			indent="yes"
			media-type="application/xhtml+xml;"
	/>

	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
			<head>
				<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=utf-8"/>
				<xsl:apply-templates select="page/headers/meta"/>
				<title><xsl:value-of select="page/headers/title"/></title>
				<xsl:apply-templates select="page/headers/style"/>
				<xsl:apply-templates select="page/headers/script"/>
			</head>
			
			<body>
				<xsl:apply-templates select="page/desktop"/>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="meta">
		<meta name="@name" http-equiv="@http-equiv" content="@content"/>
	</xsl:template>
	<xsl:template match="style">
		<style type="{@type}" media="{@media}"><xsl:value-of select="."/></style>
	</xsl:template>
	<xsl:template match="script">
		<script>
			<xsl:if test="@src">
				<xsl:attribute name="src"><xsl:value-of select="@src"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@type">
				<xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
			</xsl:if>
			<xsl:comment/>
		</script>
	</xsl:template>
</xsl:stylesheet>