
(function($){
$.fn.Form = function(op){
	op = jQuery.extend({
		menu: false,
		pass: false
	}, op);
	//-
	var menu = $("select", $(this));
	menu.focus(function(){
		$(this).addClass("Form-focus");
	}).blur(function(){
		$(this).removeClass("Form-focus");
	}).filter(op.menu).each(function(){
		$.data(this, 'sesFormStatus', false);
		//-
		$(this).after("<span>&nbsp;</span>").change(function(){
			$(this).blur();
		}).blur(function(){
			var $this = $(this);
			if($('option', $this).length > 1 && (typeof($this.val()) == "undefined" || $this.val() == "")){ // Not Selected!
			  $this.removeClass("Form-focus").addClass("Form-invalid");
			  var msg = $this.attr("title") + " is not selected!";
			  $.data(this, 'sesFormStatus', msg);
			  $("span", $this.parent()).html(msg).removeClass("Form-success").addClass("Form-error");
			}else{ // No Errors Accepted the Selection
			  $this.removeClass("Form-invalid");
			  $.data(this, 'sesFormStatus', false);
			  $("span", $this.parent()).html("Accepted!").removeClass("Form-error").addClass("Form-success");
			}
		});
	});
	//-
	$(this).submit(function(){
		var result = true;
		var query = ":text,:password,textarea" + ("string" == typeof(op.menu)? "," + op.menu : "");
		$(query, $(this)).blur().each(function(){
			if("string" == typeof($.data(this, "sesFormStatus"))){
				result = result && false;
			}
		});
		
		return result;
	});
	//-
	var text = $(":text,:password,textarea", $(this));
	text.focus(function(){
		$(this).addClass("Form-focus");
	}).blur(function(){
		$(this).removeClass("Form-focus");
	});
	//-
	text.each(function(){ // Setup Validation for all Text Fields!
		var $this = $(this);
		var rules = $this.attr('alt');
		if("string" == typeof(rules)){ // Rules are set we need to setup validation
			$.data(this, 'sesFormRules', rules.toLowerCase().split("|"));
			$this.after("<span>&nbsp;</span>");
			//-
			$this.blur(function(){ // Validate
				return $(this).change().removeClass("Form-focus");
			});
			//-
			$this.change(function(){
				var $obj = $(this);
				$.data(this, 'sesFormStatus', false);
				$("span", $obj.parent()).html("&nbsp;").removeClass("Form-success").removeClass("Form-error");
				//-
				var rules = $.data(this, 'sesFormRules');
				for(x in rules){
					if($.data(this, 'sesFormStatus')){
						continue;
					}
					validateRule($obj, rules[x], $obj.val());
				}
				//-
				var result = $.data(this, 'sesFormStatus');
				if(result){
					$obj.addClass("Form-invalid");
					$("span", $obj.parent()).html(result).addClass("Form-error");
					try{
						$obj.filter(":visible").focus().select();
					}catch(e){
						/*If hidden*/
					}
					return false;
				}else{
					$obj.removeClass("Form-invalid");
					$("span", $obj.parent()).html("Accepted!").addClass("Form-success");
				}
				return true;
			});
		}
	}
	//-
	);
	try{
		text.get(0).focus();
	}catch(e){
		//-
	}
	//-
};
//-
function validateRule($obj, rule, value){
	rule = rule.split(",");
	name = ("string" == typeof($obj.attr('title'))) ? $obj.attr('title') : $obj.attr('id');
	switch(rule[0]){
		default: break;
		case "required":
			if(value.length < 1){
				$.data($obj.get(0), 'sesFormStatus', name + " is required!");
				return false;
			}
		break;
		case "email":
			if(value.length > 0 && !isEmail(value)){
				$.data($obj.get(0), 'sesFormStatus', name + " is not a valid email address!");
				return false;
			}
		break;
		case "number":
			if(value.length > 0 && isNaN(value)){
				$.data($obj.get(0), 'sesFormStatus', name + " is not a valid number!");
				return false;
			}
		break;
		case "alphanumeric":
			if(value.length > 0 && !isAlphaNumeric(value)){
				$.data($obj.get(0), 'sesFormStatus', name + " should only contain (a-z), (0-9) and/or (_) starting with (a-z)!");
				return false;
			}
		break;
		case "password":
			if(value.length > 0 && (value !== $("#"+rule[1]).val())){
				$.data($obj.get(0), 'sesFormStatus', name + " should be the same as " + $("#" + rule[1]).attr("title")+"!");
				return false;
			}
		break;
		case "size":
			if(value.length > 0){
				rule[2] = (rule[2] == '*') ? '*' : rule[2] * 1;
				rule[1] = (rule[1] == '*') ? '*' : rule[1] * 1;
				//-
				if(rule[1] == '*'){
					if(value.length > rule[2]){
						$.data($obj.get(0), 'sesFormStatus', name + " should only contain utmost " + rule[2] + " charactors!");
						return false;
					}
				}else if(rule[2] == '*'){
					if(value.length < rule[1]){
						$.data($obj.get(0), 'sesFormStatus', name + " should contain atleast " + rule[1] + " charactors!");
						return false;
					}
				}else if(value.length < rule[1] || value.length > rule[2]){
					$.data($obj.get(0), 'sesFormStatus', name + " should contain atleast " + rule[1] + " and atmost " + rule[2] + " charactors!");
					return false;
				}
			}
		break;
		case "remote":
			if(value.length > 0){
				$.data($obj.get(0), 'sesFormStatus', false);
				$("span", $obj.parent()).html("Sending to server..").addClass("Form-success");
				//-
				$.getJSON(rule[1], {key:value, op:rule[2], id:$obj.attr('id')}, function(data){
					if(data.value){
						$("span", $('#' + data.id).parent()).html(data.msg).removeClass("Form-error").addClass("Form-success");
					}else{
						$("span", $('#' + data.id).parent()).html(data.msg).removeClass("Form-success").addClass("Form-error");
					}
				});
			}
		break;
	}
}
//-
function validateField(){
	alert($(this));
}
//-
function isEmail(value){
	// Credits: Scott Gonzalez: http://projects.scottsplayground.com/email_address_validation/
	return /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i.test(value);
}
//-
function isValid(mn, mx){
	return true;
}
//-
function isNumber(){
	return !isNaN(1);
}
//-
function isBetween(mn, mx){
	return true;
}
//-
function isChecked(){
	return false;
}
//-
function isSelected(){
	return true;
}
//-
function isAlphaNumeric(){
	new RegExp("[a-z][a-z0-9_]+");
	return true;
}
//-
function isUnique(){
	return true;
}
//-
function isURL(value){
	return /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(value);
}
//-
function isDate(){
	return true;
}
//-
function equalTo(domId){
	return true;
}
})(jQuery);
//-