
/**
 * This simulates a physical clic by the user on a input component (i.e. means to the server that the UI component was activated/validated)
 * Usage: fireChangeEvent($("#xforms_cntrl_DateRappel span")[0]);
 * @param input DOM Element
 */
function fireChangeEvent(input) {
	var events = [xformsCreateEventArray(input, "xxforms-value-change-with-focus-change",
	ORBEON.xforms.Controls.getCurrentValue(input)),
	xformsCreateEventArray(input, "DOMActivate", null)
	];
	xformsFireEvents(events, false);
}

/**
 * Add a double-list to select multiple items in very long lists.
 * To enable this, we must have 3 select inputs (see parameters just below)
 * Usage: (on document load) 	
 * generateDynamicControls("#xforms_cntrl_AutresMotifsTrans", "#xforms_cntrl_AutresMotifsTransUnselected", "#xforms_cntrl_AutresMotifsTransSelected");
 * 
 * @param originalControl		Original value list that holds the values that were selected and that will be submitted
 * @param unselectedControl		Value list showing the available choices (shows the values which were selected)
 * @param selectedControl		Value list showing the choices made (holds the values that are not selected yet)
 */
function generateDynamicControls(originalControl, unselectedControl, selectedControl) {

	// Remove [dynamically] item from the generated lists
	$(unselectedControl + " select option:contains('[dynamically]')").remove();
	$(selectedControl + " select option:contains('[dynamically]')").remove();
	
	// Initial copy of the values of the original list
	$(originalControl + " select option").each(function() {
		$(unselectedControl + " select").append($(this).clone());
	});
	// Add a trigger on click
	// Selected values move to the selected items list, and vice versa
	$(unselectedControl + " select").dblclick(function() {
    	$(unselectedControl + " select option:selected").each(function () {
			// Select in the original list		
			$(originalControl + " select option").each(function() {
				if ($(unselectedControl + " select option:selected").attr("value").match($(this).attr("value"))) {
					$(this).attr("selected", "selected");
				}
//fireChangeEvent($(originalControl + " select")[0]);
			});
			// Copy to the second list, remove selected attribute and order the list
    		$(selectedControl + " select").append($(this));
			try {
				$(this).removeAttr("selected");
			} catch (e) {
				alert(e.message); 
				alert($(this).attr("selected"));
			}
			var options = $(selectedControl + " select option").get().sort(function(a, b) {
				var keyA = $(a).attr("value").toUpperCase();
				var keyB = $(b).attr("value").toUpperCase();
				if (keyA < keyB) return -1;
				if (keyA > keyB) return 1;
				return 0;
			});
		$(selectedControl + " select").append(options);	
    	});
	}).trigger("dblclick"); // Do this on load
	$(selectedControl + " select").dblclick(function() {
    	$(selectedControl + " select option:selected").each(function () {
			// De-select in the original list
			$(originalControl + " select option").each(function() {
				if ($(selectedControl + " select option:selected").attr("value").match($(this).attr("value"))) {
					$(this).removeAttr("selected");
				}
//fireChangeEvent($(originalControl + " select")[0]);					
			});
			// Copy back to the first list, remove selected attribute and order the list
			
			$(unselectedControl + " select").append($(this));
			try {
				$(this).removeAttr("selected");
			} catch (e) {
				alert(e.message); 
				alert($(this).attr("selected"));
			}
			var options = $(unselectedControl + " select option").get().sort(function(a, b) {
				var keyA = $(a).attr("value").toUpperCase();
				var keyB = $(b).attr("value").toUpperCase();
				if (keyA < keyB) return -1;
				if (keyA > keyB) return 1;
				return 0;
			});
			$(unselectedControl + " select").append(options);	
    	});
	});
}