/**
 * 
 * @author 2010 Roman A Ovsyannikov < roman2k9 at gmail dot com >
 */

/**
 * 
 * @param {String} wrapper
 * @param {String} content
 */
function scrollBar(wrapper, content) {
	
	// settings and init
	this.wrapper = $(wrapper);
	this.content = $(content);
	this.sc_bar = $('.sc_bar');
	this.sc_bar_bg = $('.sc_bar_bg');		
	this.show();
	this.scroll_lines = 20;
	this.smooth_scrolling = true;			/* false, true */
	this.scroll_type = 'by_position';	/* by_screen, by_position */
	
	// system vars
	this.dragging = false;						/* draging scroll bar */
	this.isAinmate = false;						/* means that animation is happens now */
	this.mouse_wheel = false;					/* scrolling by mouse wheel */
	this.sc_bar_left = this.sc_bar.position().left;
	this.sc_bar.css({'left' : this.sc_bar_left}); // some bug
	this.bar_scale_ratio = Math.abs((this.sc_bar_bg.width() - this.sc_bar.width()) / (this.content.outerWidth() - this.wrapper.innerWidth()));
	oThis = this;

	this.sc_bar.mousedown(function(e) {
			oThis.x = e.clientX; 
			oThis.sc_bar_left = oThis.sc_bar.position().left;
			oThis.dragging = true;
			oThis.preventSelection(oThis.wrapper);
	}).mouseup(function() {
		oThis.dragging = false;
		oThis.permitSelection(oThis.wrapper);
	}).click(function(e) {
		return false;
	});
	
	$(document).mousemove(function(e){
		if (oThis.dragging) {
			oThis.tmp = e.clientX;
			diff = oThis.x - e.clientX;
			oThis.setpos(diff,'relative');
		}
	}).mouseup(function() {
		oThis.dragging = false;
		oThis.permitSelection(oThis.wrapper);
	});
	
	$('.sc_left_btn').click(function() {
		oThis.sc_bar_left = oThis.sc_bar.position().left;
		oThis.setpos(oThis.scroll_lines,'relative');
	});
	$('.sc_right_btn').click(function() {
		oThis.sc_bar_left = oThis.sc_bar.position().left;
		oThis.setpos(-oThis.scroll_lines,'relative');
	});
	
	this.sc_bar_bg.click(function(e) {
		pos_x = e.offsetX?(e.offsetX):e.pageX-document.getElementById("wrapper").offsetLeft-24; // where the user clicked?

		if (oThis.scroll_type == 'by_page') {
			ratio = Math.abs(oThis.content.width() / (oThis.sc_bar_bg.width()));
			x = (oThis.sc_bar_bg.width()) / ratio;
			oThis.sc_bar_left = oThis.sc_bar.position().left;
			if (pos_x > oThis.sc_bar_left + oThis.sc_bar.width()) 
				oThis.setpos(-x, 'relative');
			else if (pos_x < oThis.sc_bar_left) 
				oThis.setpos(x, 'relative');
		}
		else if (oThis.scroll_type == 'by_position') {
			oThis.sc_bar_left = oThis.sc_bar.position().left;
			oThis.setpos(pos_x - oThis.sc_bar.width()/2+24, 'absolute');
		}
	});
	
	this.wrapper.mousewheel(function(e, delta) {
		oThis.mouse_wheel = true;
		if (delta > 0)
			$('.sc_left_btn').click();
		else if (delta < 0)
			$('.sc_right_btn').click();
		e.stopPropagation();
		e.preventDefault();
	});
}

/**
 * shows scroll bar
 */
scrollBar.prototype.show = function() {
	// TODO
	this.bar_width = Math.round(Math.pow(this.wrapper.innerWidth(),2) / this.content.outerWidth());
	this.sc_bar.width(this.bar_width);
}

/**
 * set position value
 */
scrollBar.prototype.setpos = function(value,type) {
	var new_bar_value;

	if (type == 'relative') {
  	new_bar_value = this.sc_bar_left - value;
  	
  	if (new_bar_value <= 24) 
  		new_bar_value = 24
  	else 
  		if (new_bar_value + this.bar_width - 24 > $('.sc_bar_bg').width()) 
  			new_bar_value = $('.sc_bar_bg').width() - this.bar_width + 24;
  }
  else if (type == 'absolute') 
	{
		new_bar_value = value;
		
  	if (new_bar_value <= 24) 
  		new_bar_value = 24
  	else 
  		if (new_bar_value + this.bar_width - 24 > $('.sc_bar_bg').width()) 
  			new_bar_value = $('.sc_bar_bg').width() - this.bar_width + 24; 
  }
	else return;
	
	new_content_value = Math.round(-((new_bar_value || value)-24)/this.bar_scale_ratio);
	new_bar_value = Math.round(new_bar_value);

	$('#info').text('css=' + this.sc_bar.css('left') + '; position().left=' + this.sc_bar.position().left + '; new value to slide=' + new_bar_value);

	
	
	if (this.smooth_scrolling && !this.dragging && !this.mouse_wheel) {
		if (this.isAnimate) return;
		this.isAnimate = true;
		oThis = this;
  	this.content.animate({ 'left' : new_content_value },400, function() {
			oThis.content.css({'left' : new_content_value }); 
			oThis.isAnimate = false; 
		});
		this.sc_bar.animate({	'left' : new_bar_value || value },400, function() {
			oThis.sc_bar.css({'left' : new_bar_value }); 
			oThis.isAnimate = false; 
		});
  }
  else {
  	this.content.css({ 'left': new_content_value });
  	this.sc_bar.css({	'left': new_bar_value || value });
		if (this.mouse_wheel) this.mouse_wheel = false; 
  }

}

/**
 * prevent selection of element
 * @param {Object} e jQuery element
 */
scrollBar.prototype.preventSelection = function(e) {
	e.css({
		'user-select' : 'none',
		'-moz-user-select' : 'none',
		'-webkit-user-select' : 'none'
	});
}

/**
 * permit selection of element
 * @param {Object} e jQuery element
 */
scrollBar.prototype.permitSelection = function(e) {
	e.css({
		'user-select' : '',
		'-moz-user-select' : '',
		'-webkit-user-select' : ''
	});
}