//* jqimv.js - jQuery Imageview
//*
//* Function:
//*    Fills Browser with zoomable, panable image.
//*
//* Use:
//*    <script type="text/javascript" src="jquery.js"></script>
//*    <script type="text/javascript" src="jquery-ui.custom.min.js"> </script>
//*    <script type="text/javascript" src="jqimv.js"> </script>
//*    <script type="text/javascript">
//*       jQuery(document).ready(function($){
//*          $('.jqimv').jqimv({ [bgcolor: "#ffffcc"] });
//*       });
//*    </script>
//*
//*    <body>
//*    ...
//*       <a class='jqimv' href='[image-url]'> Click to see this image </a>
//*    ...
//*
//*
//* Where:
//*    'bgcolor: "#ffffcc"' (without the brackets) is an optional background-color specification.
//*                         (Web color-names are also valid here)
//*
//* Note:
//*
//* 2010/08/27 - Original version, Paul J. Dickler
//*              Thanks to: Dynamic Drive at http://www.dynamicdrive.com/, "Featured Image Zoomer"
//*
//*

jQuery.noConflict() ;

// globals

var scalecur = 1.0 ;
var scalemin = 1.0 ;
var scaleold = null ;
var firstcall = true ;
var firstclick = true ;
var helpdiv = null ;
var helpshowtime = 15000 ;
var helptimer = null ;
var $imvdivimg = null ;
var $imvdivview = null ;
var imginitheight = null ;
var imginitwidth = null ;
var imgleft = null ;
var imgtop = null ;
var $imvimg = null ;
var mouseimgleft = 0 ;
var mouseimgtop = 0 ;
var mousex = 0 ;
var mousey = 0 ;
var settings_g = {} ;


var imv = {

   settings_d: {
      bgcolor: "gray"                                     // CUSTOMIZE, OVERRIDE
   },


   init: function ($, $atag, options) {
      var settings = $.extend({}, this.settings_d, options) ;       // set locals

      if (firstcall) {                                     // only 1 of each of the following...
         firstcall = false ;
         $imvdivview = $('<div id="imvdivview" style="position:absolute;margin:0;padding:0;width:'
               + ($(window).width() - 6)                  // full-screen...
               + 'px;height:'
               + ($(window).height() - 6)                 // ...
               + 'px;left:-10000px;top:-10000px;display:none;z-index:500;overflow:hidden;'
               + 'cursor:default;'
               + 'background-color:'
               + settings.bgcolor
               + ';border:3px solid cyan;" />')
               .append('<div class="dragable" style="position:relative;left:0;top:0;margin:0;padding:0;" />')  // inner
               .appendTo(document.body); //create magnifier container

         helpdiv = $('<div style="position:absolute;font-size:90%;'
                   + 'border:1px solid cyan; background:white; padding:6px; font:normal 14px Arial;'
                   + 'opacity:0.90; height:auto; width: auto;'
                   + 'display:none;left:0;top:0;z-index:1000" />')
                   .html( 'Use:'
                   + '<br> * Mouse-Wheel to ZOOM @ CURSOR.'
                   + '<br> * Click-Hold then Mouse-Move to PAN.'
                   + '<br> * Click to RESET image.'
                   + '<br> * Click (AGAIN) to REMOVE.'
                   + '</div>')
                   .appendTo(document.body) ;
     }


      $atag.click(function(e) {                            // trap <a> click...

         $atag.css({cursor: 'wait',                        // show progress
            opacity: 0.4
         });
         firstclick = true ;
         e.preventDefault() ;                              // we'll do all the work
         $imvdivimg = $imvdivview.find('div:eq(0)');         // get inner div for zoomable...
         $imvimg = $('<img id="imvimg" src="' + $atag.attr('href') + '" '
                       + 'style="margin:0; padding:0;"/>')
                       .appendTo($imvdivimg) ;


         $imvimg.bind('loadevt', function () { // when hidef loads...

            imv.imagecenter($, $imvimg) ;

            imv.helpdivshow($, $atag, 3000, helpshowtime)         // start show Help routine
            helpshowtime = parseInt(helpshowtime * .7) ;         // decrease for next image init


             $imvdivview.mousemove(function (e) {                  // trap mouse moves
               mousex = e.pageX ;
               mousey = e.pageY ;
            })

            // FireFox 3.x 'mousewheel' is 'DOMMouseScroll'...
            var mousewhlevntname = (/Firefox/i.test(navigator.userAgent)) ? "DOMMouseScroll" : "mousewheel"

            $imvdivview.bind(mousewhlevntname, function (e) {     // trap view mouse wheel deltas
               firstclick = true ;
               imv.imagezoom($, $atag, e)
               e.preventDefault()
            });


            $imvdivview.click(function (e) {               // trap view click
              if (firstclick) {                            // reset image
                firstclick = false ;                       // for next time
                imv.imagecenter($, $imvimg) ;
                e.stopPropagation()
              }
              else {                                       // remove myself...
                helpdiv.stop(true, true).hide() ;
                $imvdivview.hide()
                $imvdivview.unbind() ;                     // release all attached events
                $('#imvimg').remove() ;
                e.stopPropagation()
                firstclick = true ;
              }
            })


            $(".dragable").mousedown(function() {          // change cursor
               $imvdivview.css({
                  cursor: 'move'
               });
            });

            $(".dragable").mouseup(function() {            // restore cursor
               $imvdivview.css({
                  cursor: 'default'
               });
            });

            $(".dragable").draggable({                     // process drag...
               stop: function(event, ui) {
                  firstclick = true ;
                  $imvdivview.css({
                     cursor: 'default'
                  });
                  imgleft = ui.offset.left ;
                  imgtop = ui.offset.top - getScrollTop() ;
               }
            });

         $atag.css({cursor: 'default',                     // restore
            opacity: 1.0
         });

         }) // imvimg loadevt end


         if ($imvimg.get(0).complete) {                    //if image has already loaded...
            $imvimg.trigger('loadevt')                     // process it
         }
         else {
            $imvimg.bind('load', function () {             // prepare for load complete
               $imvimg.trigger('loadevt')                  // then process it
            })
         }

      }) // atag.click end

   }, // init: end


   imagecenter: function ($, $imvimg) {
            $imvimg = $imvdivimg.find('IMG:eq(0)') ;          // get initial img info...
            imginitwidth = $imvimg.attr('width') ;
            imginitheight = $imvimg.attr('height') ;
            wx = $("#imvdivview").width() / imginitwidth  ;  // set initial scale to fill imvdivview...
            wy = $("#imvdivview").height() / imginitheight ;
            scalecur = wx < wy ? wx : wy ;                    // use lowest
            scalemin = scalecur*.8 ;                       // and set a minimum

            var dimennew = [imginitwidth*scalecur -3,       // set dimensions[0,1]
                            imginitheight*scalecur -3]
            $imvimg.css({                                  // apply them
               width: dimennew[0],
               height: dimennew[1]
            })

            imgleft = parseInt( ($(window).width()-6)/2 - dimennew[0]/2) + 3 ;  // center in view...
            imgtop = parseInt( ($(window).height()-6)/2 - dimennew[1]/2) + 1 ;

            $imvdivimg.css({                                      // ...
               left: imgleft + 'px',
               top: imgtop + 'px'
            })

            var bodyscrolled = getScrollTop() ;
            $imvdivview.css({                                     //position/show hidef div
               top: bodyscrolled + 'px',
               left: '0px',
               width: ($(window).width() - 6) + 'px',         // full-screen...
               height: ($(window).height() - 6) + 'px',
               })
               .show() ;
   },


   helpdivshow: function ($, $atag, fadedur, showdur) {
      clearTimeout(helptimer);
      var bodyscrolled = getScrollTop() ;
      helpdiv.css({                               // place on screen
         top: bodyscrolled + 'px',
         left: '3px'
      });

      helpdiv.fadeIn(fadedur)                       //show help div

      helptimer = setTimeout(function () {           //hide after delay
            helpdiv.stop(true, true).hide()
      }, showdur)
   },



   imagezoom: function ($, $atag, e) {

      scaleold = scalecur ;                                // save

      mouseimgleft = parseInt( (mousex - imgleft - 3) / scaleold)  ;  // get mouse-in-image...
      var bodyscrolled = getScrollTop() ;
      mouseimgtop = parseInt( ((mousey - bodyscrolled)  - imgtop    ) / scaleold) ;

      var delta = e.detail ? e.detail * (-120) : e.wheelDelta // wheelDelta = +120/scrollup, -120/scrolldown
      var zoomdir = (delta <= -120) ? "out" : "in"
      var scalenew = (zoomdir == "in") ? (scalecur * 1.2) : (scalecur * 0.8) //get new scale
      if (scalenew <= scalemin) {                          // below minimum?
        scalenew = scalemin ;                              // not allowed
      }

      $imvimg = $imvdivimg.find('img:eq(0)') ;
      var newdimen = [imginitwidth * scalenew, imginitheight * scalenew] //set new dimensions

      mouseimgleft = parseInt( (mouseimgleft +3)* scalenew ) ; // mouse-in-image (new)...
      mouseimgtop = parseInt( (mouseimgtop )* scalenew ) ;

      if (  (mousex < imgleft) || (mousex > (imgleft + (imginitwidth * scaleold))) ) {  // outside image...
         imgleft = $(window).width()/2 - (imginitwidth*scalenew)/2 ;
      }
      else {
         imgleft = mousex - mouseimgleft - 3 ;                // position relative to mouse...
      }

      if ( (mousey < imgtop + bodyscrolled) || (mousey > (imgtop + (imginitheight * scaleold)) ) ) {  // outside...
         imgtop = $(window).height()/2 - (imginitheight*scalenew)/2  ;
      }
      else {
         imgtop = mousey - bodyscrolled - mouseimgtop - 1 ;
      }

      $imvdivimg.css({                                      // set it
         left: imgleft + 'px',
         top: imgtop + 'px'
      });

      $imvimg = $('#imvimg') ;                              // resize it...
      $imvimg.css({
         width: newdimen[0],
         height: newdimen[1]
      });

      scalecur = scalenew                                  // save new scale as current
   },  // imagezoom: end

}; // imv end


jQuery.fn.jqimv = function (options) {
   var $ = jQuery
   return this.each(function () { //return jQuery obj
      if (this.tagName != "A")
         return true;                                      //skip

      imv.init($, $(this), options);
   });
};



//* Utilities...

function getScrollTop(){
   if (typeof pageYOffset!= 'undefined') { // most browsers
      return pageYOffset ;
   }
   else {
      var ieq = document.body ; //IE 'quirks'
      var ied = document.documentElement ; //IE with doctype
      ied = (ied.clientHeight) ? ied : ieq ;
      return ied.scrollTop ;
   }
};
//* jqimv.js - jQuery Imageview - END
