//
//	Author: Oscar Carballal Prego <oscar@oscarcp.com>
//	Version: 1.3.1
//	License: Creative Commons 3.0 Attribution, Non-commercial, Share-Alike
//
//	Now with extra sugar! Commented for dummies :)
//
//	Details:
//	- animate() requires jQuery UI (Core FX) for color animation. If not, it returns color value: 'hexcolor'px (invalid)
//
//	Check:
//	- Check why setWidth() must have an offset value.
//	- Check why in Gecko-based browsers the setWidth() function waits for resize() to be completed instead of
//	  doing it on demand like Webkit.
//	- Sometimes menuItems.hover() hangs up and leaves behind a 'li' element with hover.over() color. This
//	  is a jQuery UI related fix.
//
//	TODO:
//	- Improve checkIE(). It would be great to use dialog() from jQuery UI.
//	- Support IE 7 and 8.
//

// Check if client is Internet Explorer
// We use support.leadingWhitespace() since it returns false for IE6-7-8
function checkIE() {
	if ( $.support.leadingWhitespace == false ) {
		// Load a new url, preventing user from accesing the webpage
		$(document).load("ie.html");
	}
	else {}
};

// Check if wrapper is visible or not
function checkWrapper() {
	wrapperVisible = 0;
	if ( wrapperVisible == 0 ) {
		$("#contentwrapper").fadeIn("slow", function() {
			$("#contentwrapper").slideDown("slow"); // Check speeds
		});
		wrapperVisible = 1;
	}
	else {}
};

// Get document width to stablish content wrapper width
function setWidth() {
	// Get #menu width
	var menuWidth = $("#menu").width();
	// Get document total width
	var docWidth = $(document).width();
	// Detract menuWidth (+40pixel offset) from docWidth
	var contentWidth = docWidth - menuWidth - 40;
	// Set #contentwrapper new width value
	$("#contentwrapper").css({'width': contentWidth});
};

// Menu behaviour
function menu() {
	// Get all hyperlinked li items inside #menu
	var menuItems = $("#menu li a");
	// On hover change item color
	$(menuItems).hover(function() {
		// If you can't guess, 'this' returns current active element within menuItems
		$(this).animate({color:"#ccc"});
	}, function() {
		$(this).animate({color:"#000"});
	});
	// On click load url inside #content
	$(menuItems).click(function (event) {
		// Prevent hyperlink to open the link with the default behaviour
		event.preventDefault();
		// Check if content wrapper is visible or not
		checkWrapper();
		var el = $(this);
		// Get href value and prevents whitespaces
		var url = $.trim(el.attr('href'));
		// This is the interesting bit
		// Fade out #content, load the new url
		// and then fade in again.
		$("#content").fadeOut("slow", function () {
			$("#content").load(url, {}, function () {
				$("#content").fadeIn("slow");
			});
		});
	});
};

// On document ready (DOM Ready)
$(document).ready( function() {
	// Check if browser is IE
	checkIE();
	// Fade wrapper
	$("#wrapper").fadeIn(5000);
	// Set first time width
	setWidth();
	// On window resize recalculate and set new width
	$(window).resize(function() {
		setWidth();
	});
	// Activate menu behaviour
	menu();	
});