/*
 * yuga.js 0.1.0 - 優雅なWeb制作のためのJS
 *
 * Copyright (c) 2006 Kyosuke Nakamura (kyosuke.jp)
 * Licensed under the MIT License:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * Since:     2006-10-30
 * Modified:  2006-11-15
 
 改変・追加kakehashi
 2007-04-15

リンクに絶対パスが含まれているときは、すべて外部リンクになるため、自社サイトorCMSのときはnotを使うことで回避する
.not('[@href^="http://localhost/"]')

 */


var yuga = {
	preloader: {
		loadedImages: [],
		load: function (url){
			var img = this.loadedImages;
			var l = img.length;
			img[l] = new Image();
			img[l].src = url;
		}
	},
	uri: {
		dirName: function(uri){
			var ary = uri.split('/');
			ary.pop();
			return ary.join('/');
		},
		path: function (uri){
			return uri.split('#')[0];
		},
		anchorName: function (uri){
			return uri.split('#')[1];
		},
		isSelfLink: function(href){
			return ((this.path(href) == this.path(location.href)) || (this.path(href) == this.dirName(location.href)+'/'));
		}
	}
};

$(function(){
	
	//リンク画像はロールオーバーを設定
	$('a img.btn').each(function(){
		this.originalSrc = this.src;
		this.rolloverSrc = this.originalSrc.replace(/(\.gif|\.jpg|\.png)/, "_on$1");
		yuga.preloader.load(this.rolloverSrc);
	}).hover(function(){
		this.src = this.rolloverSrc;
	},function(){
		this.src = this.originalSrc;
	});

	//現在のページへのリンク
	/*$('a').each(function(){
		if (yuga.uri.isSelfLink(this.href) && !yuga.uri.anchorName(this.href)) {
			$(this).addClass('current');
			//img要素が含まれていたら現在用画像に設定
			$(this).find('img').each(function(){
				//ロールオーバーが設定されていたら削除
				$(this).unbind('mouseover');
				$(this).unbind('mouseout');
				this.currentSrc = this.getAttribute('src').replace(/(\.gif|\.jpg|\.png)/, "_cr$1");
				this.src = this.currentSrc;
			});
		}
	});*/

	//外部リンクは別ウインドウを設定
	$('a[@href^="http://"]').not('[@href^="http://localhost/"]').click(function(){
		window.open(this.href, '_blank');
		return false;
	}).addClass('externalLink');
	
	//ページ内リンクはするするアニメーション
	$('a[@href^="#"]').click(function(){
		var href = yuga.uri.anchorName(this.href);
		$('#'+href).ScrollTo(500,'easeout');
		return false;
	});

	//画像へ直リンクするとthickboxで表示
	/*$('a[@href$=".jpg"]').add('a[@href$=".gif"]').add('a[@href$=".png"]').click(function(){
		var t = this.title || this.name || null;
		var g = this.rel || false;
		TB_show(t,this.href,g);
		this.blur();
		return false;
	});*/
});