<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN">

<html lang=en>
 <head>
  <title>About the Cascading Style Sheets (CSS) Working Group</title>
  <meta content="width=device-width" name=viewport>
  <meta content="text/html; charset=utf-8" http-equiv=Content-Type>
  <link href="w3c-2010/main" media="screen, handheld, projection, tv"
  rel=stylesheet title=Main>
  <link href="../CSS/floatspan-n" media="screen, handheld, projection,
  tv" rel="alternate stylesheet" title=Cascade>
  <link href="../CSS/daily-color" media="screen, handheld, projection,
  tv" rel="alternate stylesheet" title=Cascade>
  <link href="../CSS/floatspan" media="screen, handheld, projection,
  tv" rel="alternate stylesheet" title="Cascade (older browsers)">
  <link href="../CSS/daily-color" media="screen, handheld, projection,
  tv" rel="alternate stylesheet" title="Cascade (older browsers)">
  <link href="../CSS/asymmetric" media="screen, handheld, projection,
  tv" rel="alternate stylesheet" title=Asymmetric>
  <link href="../CSS/draft" media="screen, projection, tv"
  rel="alternate stylesheet" title="Draft 3">
  <link href="../CSS/draft-rg" media="screen, projection, tv"
  rel="alternate stylesheet" title="Draft 2">
  <link href="../CSS/twocolumn-print" media=print rel=stylesheet>
  <link href="../../" rel=home title=W3C>
  <link href="./" rel=top title=CSS>
  <link href="./" rel=first title=CSS>
  <link href="../CSS/Planet/" rel=last title="The Future Of CSS
  (syndicator)">
  <link href=current-work rel=chapter title=Roadmap>
  <link href="../Examples/007/" rel=chapter title=Examples>
  <link href="../../Consortium/activities" rel=bookmark
  title=Activities>
  <link href="../../TR/" rel=bookmark title="Tech. reports">
  <link href="../../Consortium/Translation/" rel=bookmark
  title=Translations>
  <link href="../../Status" rel=bookmark title=Software>
  <link href="../../Consortium/siteindex" rel=index
  title="Site index">
  <link href="http://search.w3.org/" rel=search title=Search>
  <link href="../../Consortium/Legal/ipr-notice.html#Copyright"
  rel=copyright title=Copyright>
  <link href="mailto:bert@w3.org (Bert Bos)" rev=made>

  <style type="text/css">
    .data td,
    .data th { text-align: left; padding-right: 1em; }
    .fn { white-space: nowrap; }
    .org { font-style: italic; }
  </style>
  <link href=Group.en.html hreflang=en rel=alternate title=English>

 <body>
  <h1>About the CSS Working Group</h1>

  <p>The <dfn><abbr title="Cascading Style Sheets">CSS</abbr> Working
   Group</dfn> is a team of <a
   href="http://www.w3.org/Consortium/">W3C</a> Member representatives
   and <a href="http://www.w3.org/2004/08/invexp">W3C Invited
   Experts</a> who are responsible for maintaining the current <a
   href=Specs>CSS standards</a> and their respective <a
   href="http://www.w3.org/Style/CSS/Test">test suites</a> and for
   designing and specifying the future capabilities of Cascading Style
   Seets.

  <div class=section>
   <h2>Charter and <abbr title="Intellectual Property
    Rights">IPR</abbr></h2>

   <p>The CSS Working Group is governed by its <a
    href="http://www.w3.org/Style/2008/css-charter">charter</a> and the
    <a href="http://www.w3.org/Consortium/Process/">W3C Process</a>.
    Technology developed by the Working Group is subject to the W3C's
    <a
    href="http://www.w3.org/Consortium/Patent-Policy-20040205/">February
    2004 Patent Policy</a>. The W3C maintains a <a
    href="http://www.w3.org/Style/CSS/Disclosures">list of patent
    disclosures</a> relevant to CSS.</p>
  </div>

  <div class=section>
   <h2>Communication</h2>

   <p>The CSS Working Group conducts most of its technical discussion
    on the publicly-archived <a
    href="http://lists.w3.org/Archives/Public/www-style/">www-style@w3.org
    mailing list</a>, where everyone is welcome to join the
    conversation and comment on our <a href=current-work>working
    drafts</a>. We track issues and ideas on <a
    href="http://csswg.org/">our wiki</a> and in our <a
    href="Tracker/">issue tracker</a> and post announcements and
    discussion topics both to <a
    href="http://lists.w3.org/Archives/Public/www-style/">www-style</a>
    and our <a href="http://www.w3.org/blog/CSS">weblog</a>. W3C
    Member-confidential material and administrivia are discussed on an
    <a href="http://lists.w3.org/Archives/Member/w3c-css-wg/">internal
    mailing list</a>.

   <p>The Working Group makes formal decisions by <a
    href="http://www.w3.org/2005/10/Process-20051014/policies.html#Consensus">consensus</a>.
    We meet every week on the phone and thrice-yearly face-to-face. The
    minutes of these discussions are sent to the internal mailing list;
    notes and resolutions are posted publicly both to <a
    href="http://lists.w3.org/Archives/Public/www-style/">www-style</a>
    and to the <a href="http://www.w3.org/blog/CSS">CSSWG blog</a> and
    linked from our unofficial <a
    href="http://twitter.com/csswg">Twitter</a> account.</p>
  </div>

  <div class=section>
   <h2>Members</h2>
   <?php
/*><!--*/
  // There are no form fields, but let's call untaint() anyway...
  require_once '../../Systems/lib/php/utils/taint.php';
  untaint();

  require 'dbinfo.phi';
  require '../../2000/09/dbwg/funcs.phi';

  $group = 32061;             // = CSS WG

  $dbh = @mysql_connect($db_mirror, $db_userid, $db_password);
  if ($dbh == 0) {
      echo "error: mysql_connect returned 0";
      exit;
  }
  mysql_select_db("w3c");

  $query = "
    SELECT
      u.family,
      u.given,
      g.name
    FROM
      userDetails AS u,
      groupDetails AS wg,
      hierarchy AS h,
      ids AS i
   LEFT OUTER JOIN idInclusions ON
     idInclusions.id = i.id
     AND idInclusions.groupId in (102, 105)
   LEFT OUTER JOIN hierarchy AS employee ON
     employee.sub = i.id
     AND employee.stops = 0
   LEFT OUTER JOIN hierarchy AS employer ON
     employer.sub = employee.super
     AND employer.super IN (102, 105)
     AND employer.stops = 0
   LEFT OUTER JOIN groupDetails AS g ON
     g.id = employer.sub
    WHERE
      h.type = 'U'
      AND i.id = h.sub
      AND h.super = $group
      AND h.stops = 0
      AND u.id = i.id
      AND wg.id = h.super
      AND (employer.sub IS NOT NULL OR groupId IS NULL)
    GROUP BY
      i.value
    ORDER BY
      u.family,
      u.given";

  $result = mysql_query($query);

  if (!$result)
      print "\n    <tr><td colspan=3>query failed\n";
  else {
      while ($row = mysql_fetch_array($result)) {
        print "\n    <tr class=vcard>\n      <td class=fn><span>";
        print htmlspecialchars(utf8_encode($row["given"]));
        print " ";
        print htmlspecialchars(utf8_encode($row["family"]));
        print "</span>\n      <td class=org>";
        print htmlspecialchars(utf8_encode($row["name"]));
        print "\n";
      }
      mysql_free_result($result);
  }
/*--><?*/
?>
   </div>

  <div class=section id=banner>
   <h2>Site navigation</h2>

   <form action="http://www.google.com/custom">
    <ul>
     <li class=home><a href="http://www.w3.org/" rel=home><img alt=W3C
      src="http://www.w3.org/Icons/w3c_home"></a>

     <li><a href="./" rel=bookmark title="CSS home page">CSS home</a>

     <li><a href=learning rel=bookmark>Learn &amp; use</a>

     <li><a href=software rel=bookmark>Soft­ware</a>

     <li><a href=current-work rel=bookmark title="Participate in the
      development of the CSS standard">Par­tic­i­pate / <span
      title="All specifications and drafts">drafts</span></a>

     <li class=search><input accesskey=E id=inputField maxlength=255
      name=q size=10> <input accesskey=G id=goButton name=sa
      type=submit value=Search><input name=cof type=hidden
      value="T:black;LW:72;ALC:#ff3300;L:http://www.w3.org/Icons/w3c_home;LC:#000099;LH:48;BGC:white;AH:left;VLC:#660066;GL:0;AWFID:0b9847e42caf283e;"><input
      checked=checked id=searchW3C name=sitesearch type=hidden
      value=www.w3.org><input name=domains type=hidden
      value=www.w3.org>
    </ul>
   </form>
  </div>

  <div class=section id=endmatter>
   <address class=vcard><img alt="" class=photo
    src="../../People/Bos/bert3-small.jpg"> <a class="fn url"
    href="../../People/Bos/">Bert Bos</a>, <span class=role>style
    activity lead</span> — <small><a
    href="/Consortium/Legal/ipr-notice#Copyright"
    rel=Copyright>Copyright</a> © 1994-2011 <a href="/"><acronym
    title="World Wide Web
    Consortium">W3C</acronym><sup>®</sup></a></small></address>

   <p>Last updated 3 May 2011
  </div>

  <div class=section id=translations>
   <h2>Languages</h2>

   <p><a href="/Style/CSS/translating">About the translations</a>
  </div>
