#!/usr/bin/gawk -f

BEGIN {printf "\n"}
/^#/ {if (name == "") {name = substr($0, 3); u = ""}}
/^# *(http:|ftp:)/ {u = $2}
/^URI:/ {if (u == "") u = $2}
/^Content-Language:/ {label[$2] = name; url[$2] = u; lang[n++] = $2; name = ""}
END {
    sort(lang, 0, n - 1);
    for (i = 0; i < n; i++) {
	printf "  <link rel=alternate hreflang=%s title=\"%s\" href=\"%s\">\n",
	    lang[i], label[lang[i]], url[lang[i]];
    }
}
