/*
 * errors.c -- Error messages for ll1gen
 *
 * 21 Feb '93, Bert Bos <bert@let.rug.nl>
 *
 *
 */

#ifndef __lint
static char rcsid[] = "$Header: errors.c,v 0.2 93/02/23 19:28:14 bert Exp $";
#endif

#include <stdio.h>
#include "export.h"
#include "ll1.def"

/* Exported variables */
EXPORT int lineno = 1;
EXPORT char *inputname = NULL;
EXPORT int nrerrors = 0;


EXPORT void error(char *s)
{
    fprintf(stderr, "%s:%d: %s\n", inputname, lineno, s);
    nrerrors++;
}

EXPORT void insertion(tsymbol s)
{
    char msg[256];
    sprintf(msg, "missing %s", symbol_name[s]);
    error(msg);
}

EXPORT void deletion(tsymbol s)
{
    char msg[256];
    sprintf(msg, "unexpected %s", symbol_name[s]);
    error(msg);
}

