/*
 * export.h -- header file for programs that use cexport
 *
 * $Header: export.h,v 1.3 93/05/07 10:20:31 bert Exp $
 *
 * Functions, type definitions, variable declarations can all be
 * exported by putting EXPORT (uppercase only) in front of the
 * declaration. The declarations must be ANSI-C. Macros can be
 * exported with EXPORTDEF. Examples:
 *
 * EXPORT int sqr(int n) {...}		-- exports function sqr()
 * EXPORT typedef struct _Str * MyStr;	-- exports type MyStr
 * EXPORT int maximum;			-- exports variable maximum
 * #define max(a,b) ((a)>(b)?(a):(b))
 * EXPORTDEF(max(a,b))			-- exports macro max(a,b)
 *
 * $Log:	export.h,v $
 * Revision 1.3  93/05/07  10:20:31  10:20:31  bert (Bert Bos)
 * EXPORTDEF(x) defined as EXPORTDEF_##x x
 * 
 * Revision 1.2  93/05/07  10:08:21  10:08:21  bert (Bert Bos)
 * EXPORTDEF is now EXPORTDEF_
 * 
 */
#ifndef _EXPORT_H_
#define _EXPORT_H_

#ifndef __export
#define EXPORT /* nothing */
#define EXPORTDEF(x) /* nothing */
#else
#define EXPORTDEF(x) EXPORTDEF_##x x
#endif

#endif /* _EXPORT_H_ */
