/*
 * errors.c -- Error messages for ll1gen
 *
 * 21 Feb '93, Bert Bos <bert@let.rug.nl>
 *
 *
 */

#ifndef __lint
static char rcsid[] = "$Header: /u/hyctia/home/bert/CVSRepository/Work/LL1-1.3/errors.c,v 1.1 1997/02/19 01:08:59 bert Exp $";
#endif

#include <stdio.h>
#include "export.h"
#include "ll1.def"

/* Exported variables */
EXPORT int lineno = 1;
EXPORT char *inputname = NULL;
EXPORT int nrerrors = 0;


EXPORT void error(char *s)
{
    fprintf(stderr, "%s:%d: %s\n", inputname, lineno, s);
    nrerrors++;
}

EXPORT void insertion(tsymbol s)
{
    char msg[256];
    sprintf(msg, "missing %s", symbol_name[s]);
    error(msg);
}

EXPORT void deletion(tsymbol s)
{
    char msg[256];
    sprintf(msg, "unexpected %s", symbol_name[s]);
    error(msg);
}

