/*
 * main.c -- main program of ll1gen parser generator
 *
 * 20 Feb 1993, Bert Bos <bert@let.rug.nl>
 *
 * Read a grammar and generate a parser for it.
 */

#ifndef __lint
static char rcsid[] = "$Header: /u/hyctia/home/bert/CVSRepository/Work/LL1-1.3/main.c,v 1.1 1997/02/19 01:09:02 bert Exp $";
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include "types.h"
#include "build.e"
#include "generate.e"
/* #include "parse.def" */
#include "ll1.def"
#include "scan.e"
#include "errors.e"

static FILE *output1, *output2;
static char basename[200];


/* get_options -- set inputname, input, output1, output2 */
static void get_options(argc, argv)
    int argc;
    char *argv[];
{
    char *p, name[200];
    
    if (argc != 2) { fprintf(stderr, "Usage: %s file\n", argv[0]); exit(1); }
    inputname = argv[1];
    if (! (input = fopen(argv[1], "r"))) { perror(argv[1]); exit(1); }
    strcpy(basename, argv[1]);
    p = strrchr(basename, '.');
    if (p != NULL) *p = '\0';
    strcat(strcpy(name, basename), ".c");
    if (! (output1 = fopen(name, "w"))) { perror(name); exit(1); }
    strcat(strcpy(name, basename), ".def");
    if (! (output2 = fopen(name, "w"))) { perror(name); exit(1); }
}

int main(argc, argv)
	int argc;
    char *argv[];
{
    int err;

    get_options(argc, argv);
    init_symbols();
    err = ll1parse();
    nrerrors += err;
    if (nrerrors > 0) exit(1);
    compute_sets(); 
    if (nrerrors > 0) exit(1);
    gen_header(output2);
    generate(output1, basename);
    return 0;
}

