/*
 * types.h -- global type definitions for ll1gen
 *
 * $Header: /u/hyctia/home/bert/CVSRepository/Work/LL1-1.3/types.h,v 1.1 1997/02/19 01:09:04 bert Exp $
 *
 * 20 Feb 1993, Bert Bos <bert@let.rug.nl>
 *
 * A Rule is a linear sequence of tokens, not containing alternatives.
 * If sym is __EPSILON, the token contains a semantic action that is not
 * bound to a symbol.
 *
 * A RuleSet is the set of alternative rules for a production.
 *
 * Symbols are identified with numbers. The first two are called
 * __EPSILON and __ENDMARK. __EPSILON is used as the value of sym in a token
 * that contains only a semantic action. __ENDMARK is the token that is
 * (virtually) present at the end of the input.
 *
 * The array `symbol' holds descriptions of all symbols, terminals and
 * nonterminals. For each symbol is stored: the name, the parameters
 * (if any), the local variables (if any), whether it is a terminal or
 * nonterminal, whether it can produce the empty string (only in the
 * case of nonterminals), the set of terminals that can occur at the
 * start of a derivation, and the set of terminals that can possibly
 * follow the symbol.
 *
 * `pseudo' is true for the pseudo-nonterminals that are generated
 * when a bracketed sub-rule is found by the parser.
 *
 * The first part of the array holds the terminals.
 */

#include <stdio.h>
#include "sets.h"

typedef enum { False, True } Boolean;
typedef enum { Once, Star, Plus, Opt } Repetition;

typedef struct _Rule {				/* A string of tokens */
    int sym;					/* Token or __EPSILON */
    char *sem;					/* Semantic or parameters */
    Repetition rep;				/* Once, Star, Plus, Option */
    Set resync;					/* Followers of this & next */
    int resync_nr;				/* Assigned in generate.c */
    int lineno;					/* Line # in source */
    struct _Rule *next;
} *Rule;

typedef struct _RuleSet {			/* List of alternatives */
    Rule rule;
    char *guard;				/* Conflict resolution */
    struct _RuleSet *alternative;
} *RuleSet;

typedef struct {
    char *name;					/* Name of symbol */
    char *params;				/* Semantic parameters */
    char *local_vars;				/* Local variables */
    int lineno;					/* Line # in source */
    Boolean terminal, nullable, pseudo;
    RuleSet rules;				/* List of alternatives */
    Set first, follow;				/* Look-ahead sets */
} Symbol;

typedef enum {
    OInclSys, OInclLoc, OInsertion, ODeletion, OScanner,
    OParser, OState, ONoLineno
} OptionType;

typedef struct _Option {
    OptionType tp;
    char *option;
    struct _Option *next;
} *Option;

#define FIRST_SYM 257
#define MAXSTR 8000

