/*
 * (c) COPYRIGHT 1999 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 * $Id: defs.h,v 1.2 1999/09/20 12:37:33 plehegar Exp $
 */
#ifndef _UTILS_H_
#define _UTILS_H_

#include <stdlib.h>

#ifndef NULL
#define NULL ((void *) 0)
#endif

#define SAC_MALLOC(a)   malloc(a)
#define SAC_CALLOC(a,b) calloc(a, b)
#define SAC_FREE(a)     free(a)

#include <string.h>

#ifndef SAC_CHAR
/*
To use your own character, use these definitions
#define SAC_CHAR           ...
#define SAC_STRING         ...
#define SAC_STRDUP(src)    ...
#define SAC_STRCHR(src, c) ...
#define SAC_CHARS_TO_STRING(src) ...
*/

#define SAC_CHAR           char
#define SAC_STRING         char *
#define SAC_STRDUP(src)    strdup(src)
#define SAC_STRCHR(src, c) strchr(src, c)
#define SAC_CHARS_TO_STRING(src) (src)

#endif

#define DISPOSE_SAC_STRING(a) \
        (a == NULL)?0:SAC_FREE(a)

typedef enum SAC_Boolean {
    SAC_FALSE = 0,
    SAC_TRUE  = 1
} SAC_Boolean;

#ifndef PRIVATE
#define PRIVATE 
#endif

/* sanity check */
#define SAC_CHECK

#define DUP_SAC_STRING(a) \
        (a == NULL)? NULL: SAC_STRDUP(a)

#define SAC_READONLY /* nothing */

#endif /* _UTILS_H_ */
