/*
 * (c) COPYRIGHT 1999 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 * $Id: lexicalUnit.h,v 1.1 1999/09/16 11:05:48 plehegar Exp $
 */
#ifndef _LEXICALUNIT_H_
#define _LEXICALUNIT_H_

#include "defs.h"

typedef enum _SAC_LexicalUnitCode {    
    
    /* Operators */
    /*
      Note that these operators have no meaning for the parser,
      it's up to the user to interpret each operators.
    */
    SAC_OPERATOR_COMMA,			/* , */
    SAC_OPERATOR_PLUS,			/* + */
    SAC_OPERATOR_MINUS,			/* - */
    SAC_OPERATOR_MULTIPLY,		/* * */
    SAC_OPERATOR_SLASH,			/* / */
    SAC_OPERATOR_MOD,			/* % */
    SAC_OPERATOR_EXP,			/* ^ */
    SAC_OPERATOR_LT,			/* < */
    SAC_OPERATOR_GT,			/* > */
    SAC_OPERATOR_LE,			/* <= */
    SAC_OPERATOR_GE,			/* >= */
    SAC_OPERATOR_TILDE,			/* ~ */
    
    SAC_INHERIT,		/* identifier inherit */
    /* Integers and reals numbers */
    SAC_INTEGER,
    SAC_REAL,
    /* Relative lengths */
    SAC_LENGTH_EM,
    SAC_LENGTH_EX,
    SAC_LENGTH_PIXEL,
    /* Absolute lengths */
    SAC_LENGTH_INCH,
    SAC_LENGTH_CENTIMETER,
    SAC_LENGTH_MILLIMETER,
    SAC_LENGTH_POINT,
    SAC_LENGTH_PICA,
    /* Percentages */
    SAC_PERCENTAGE,
    /* URI */
    SAC_URI,
    /* Counters */
    SAC_COUNTER_FUNCTION,
    SAC_COUNTERS_FUNCTION,
    /* RGB Colors */
    SAC_RGBCOLOR,		/* rgb(0, 0, 0) and #000 */
    /* Angles */
    SAC_DEGREE,
    SAC_GRADIAN,
    SAC_RADIAN,
    /* Times */
    SAC_MILLISECOND,
    SAC_SECOND,
    /* Frequencies */
    SAC_HERTZ,
    SAC_KILOHERTZ,
    /* Misc */
    SAC_IDENT,			/* any ident except inherit ! */
    SAC_STRING_VALUE,
    SAC_ATTR,		        /* attribute */
    SAC_RECT_FUNCTION,		/* rect shape function */
    SAC_UNICODERANGE,
    
    /* sub expressions */
    SAC_SUB_EXPRESSION,		/* (a) (a + b) (normal/none) */
    
    /* Unknown values */
    SAC_FUNCTION,		/* unknown function */
    SAC_DIMENSION		/* unknown dimension */
} SAC_LexicalUnitCode;

typedef struct _SAC_LexicalUnit SAC_LexicalUnit;

struct _SAC_LexicalUnit {    
    SAC_LexicalUnitCode lexicalUnitType;
    union _SAC_unit {
	/* SAC_OPERATOR_COMMA */
	/* SAC_OPERATOR_PLUS */			
	/* SAC_OPERATOR_MINUS */			
	/* SAC_OPERATOR_MULTIPLY */		
	/* SAC_OPERATOR_SLASH */			
	/* SAC_OPERATOR_MOD */			
	/* SAC_OPERATOR_EXP */			
	/* SAC_OPERATOR_LT */			
	/* SAC_OPERATOR_GT */			
	/* SAC_OPERATOR_LE */			
	/* SAC_OPERATOR_GE */			
	/* SAC_OPERATOR_TILDE */			
	/* empty */
	
	/* SAC_INHERIT */		
	/* empty */
	
	/* SAC_INTEGER */
	signed long integer;
	
	/* SAC_REAL */    
	/* signed */ double real;
	
	/* SAC_DIMENSION, etc. */
	struct _SAC_Dimension {
	    SAC_STRING unit;	/* The string representation of the unit */
	    union _SAC_DimensionValue {
		/* SAC_DIMENSION */    
		/* SAC_LENGTH_EM */
		/* SAC_LENGTH_EX */
		/* SAC_LENGTH_PIXEL */
		/* SAC_LENGTH_INCH */
		/* SAC_LENGTH_CENTIMETER */
		/* SAC_LENGTH_MILLIMETER */
		/* SAC_LENGTH_POINT */
		/* SAC_LENGTH_PICA */
		/* SAC_PERCENTAGE */
		/* signed */   double sreal;
		
		/* SAC_DEGREE */
		/* SAC_GRADIAN */
		/* SAC_RADIAN */    
		/* SAC_MILLISECOND */
		/* SAC_SECOND */
		/* SAC_HERTZ */
		/* SAC_KILOHERTZ */
		/* unsigned */ double ureal;
	    } value;
	} dimension;
	
	/* SAC_URI */
	SAC_STRING uri;
	
	/* SAC_COUNTER_FUNCTION */
	/* SAC_COUNTERS_FUNCTION */ 
	/* SAC_RGBCOLOR */		
	/* SAC_FUNCTION */
	/* SAC_RECT_FUNCTION */		
	struct _SAC_Function {
	    SAC_STRING      name;
	    /* including operators, like the comma
	       #000 is converted to rgb(0, 0, 0)
	       can be NULL if SAC_FUNCTION
	     */
	    SAC_LexicalUnit * parameters;
	} function;
	
	/* SAC_IDENT */
	SAC_STRING ident;
	/* SAC_STRING_VALUE */
	SAC_STRING stringValue;
	/* SAC_ATTR */
	SAC_STRING attrName;
	
	/* SAC_UNICODERANGE */
	SAC_STRING unicodeRange;	/* @@TO BE DEFINED */
	
	/* SAC_SUB_EXPRESSION */
	SAC_LexicalUnit * subValues;
    } desc;
};
    
    
#endif /* _LEXICALUNIT_H_ */
    
