/*
 * (c) COPYRIGHT 1999 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 * $Id: selectors.h,v 1.16 2002/06/17 14:17:45 plehegar Exp $
 */
#ifndef _SELECTOR_H_
#define _SELECTOR_H_

#include "defs.h"

/*
 * This file defines the types of selectors and conditions
 * A condition can be applied to a selector.
 * Please note that this file defines more selectors and conditions
 * than the CSS syntax can do. This is only for a future usage, the CSS parser
 * is not supposed to support all of them.
 */


typedef enum {
    /* simple selectors */
    SAC_CONDITIONAL_SELECTOR,
    SAC_ANY_NODE_SELECTOR,
    SAC_ROOT_NODE_SELECTOR,
    SAC_NEGATIVE_SELECTOR,
    SAC_ELEMENT_NODE_SELECTOR,
    SAC_TEXT_NODE_SELECTOR,
    SAC_CDATA_SECTION_NODE_SELECTOR,
    SAC_PROCESSING_INSTRUCTION_NODE_SELECTOR,
    SAC_COMMENT_NODE_SELECTOR,
    SAC_PSEUDO_ELEMENT_SELECTOR,

    /* descendant selectors */
    SAC_DESCENDANT_SELECTOR,
    SAC_CHILD_SELECTOR,

    /* sibling selectors */
    SAC_DIRECT_ADJACENT_SELECTOR
} SAC_SelectorType;

typedef enum {
    SAC_AND_CONDITION,
    SAC_OR_CONDITION,
    SAC_NEGATIVE_CONDITION,
    SAC_POSITIONAL_CONDITION,
    SAC_ATTRIBUTE_CONDITION,
    SAC_ID_CONDITION,
    SAC_LANG_CONDITION,
    SAC_ONE_OF_ATTRIBUTE_CONDITION,
    SAC_BEGIN_HYPHEN_ATTRIBUTE_CONDITION,
    SAC_CLASS_CONDITION,
    SAC_PSEUDO_CLASS_CONDITION,
    SAC_ONLY_CHILD_CONDITION,
    SAC_ONLY_TYPE_CONDITION,
    SAC_CONTENT_CONDITION
} SAC_ConditionType;

typedef enum {
    ELEMENT_NODE,
    ATTRIBUTE_NODE,
    TEXT_NODE,
    CDATA_NODE,
    ENTITY_REFERENCE_NODE,
    PROCESSING_INSTRUCTION_NODE,
    COMMENT_NODE,
    ANY_NODE,
} SAC_nodeType;

typedef struct _SAC_Selector SAC_Selector;
typedef struct _SAC_Condition SAC_Condition;

struct _SAC_Selector {
    /* the type of the selector */
    SAC_SelectorType selectorType;

    union _SAC_Sdesc {
	/* SAC_CONDITIONAL_SELECTOR */
	struct _SAC_Conditional {
	    /* can't be a combinator or a conditional selector */
	    SAC_Selector  * simpleSelector;
	    SAC_Condition * condition;
	} conditional;

	/* SAC_ANY_NODE_SELECTOR */
	/* SAC_ROOT_NODE_SELECTOR */
	/* empty */

	/* SAC_NEGATIVE_SELECTOR */
	SAC_Selector * simpleSelector;

	/* SAC_DESCENDANT_SELECTOR */
	/* SAC_CHILD_SELECTOR */
	struct _SAC_Sdescendant {
	    /* not exactly a "parentSelector", "parentOrAdjacentSelector" */
	    SAC_Selector * descendantSelector;
	    /* can't be a descendant or sibling selector */
	    SAC_Selector * simpleSelector;
	} descendant;

	/* SAC_DIRECT_ADJACENT_SELECTOR */
	struct _SAC_Ssibling {
	    SAC_nodeType nodeType;
	    SAC_Selector * firstSelector;
	    /* can't be a descendant or sibling selector */
	    SAC_Selector * secondSelector;
	} sibling;

	/* SAC_ELEMENT_NODE_SELECTOR */
	/* SAC_PSEUDO_ELEMENT_SELECTOR */
	struct _SAC_Element {
	    SAC_STRING namespaceURI;  /* NULL if any */
	    SAC_STRING localName; /* NULL if any */
	} element;

	/* SAC_TEXT_NODE_SELECTOR */
	/* SAC_CDATA_SECTION_NODE_SELECTOR */
	/* SAC_COMMENT_NODE_SELECTOR */
	SAC_STRING data; /* NULL if any */

	/* SAC_PROCESSING_INSTRUCTION_NODE_SELECTOR */
	struct _SAC_Pi {
	    SAC_STRING target; /* NULL if any */
	    SAC_STRING data; /* NULL if no data */
	} pi;
    } desc;
};

struct _SAC_Condition {
    /* the type of the condition */
    SAC_ConditionType conditionType;

    union _SAC_Cdesc {
	/* SAC_AND_CONDITION */
	/* SAC_OR_CONDITION */
	struct _SAC_Ccombinator {
	    SAC_Condition * firstCondition;
	    SAC_Condition * secondCondition;
	} combinator;

	/* SAC_NEGATIVE_SELECTOR */
	SAC_Condition * condition;

	/* SAC_POSITIONAL_CONDITION */
	struct _SAC_CPositional {
	    /* a negative value means from the end of child node list */
	    signed int position;

	    /* SAC_TRUE if the child node list only shows nodes of the same
	                type.
	    */
	    SAC_Boolean typeNode;
	    /* SAC_TRUE if the node should have the same node type.
                        (for element, same namespaceURI and same localName)
	     */
	    SAC_Boolean type;
	} position;

	/* SAC_ATTRIBUTE_CONDITION */
	/* SAC_ONE_OF_ATTRIBUTE_CONDITION */
	/* SAC_BEGIN_HYPHEN_ATTRIBUTE_CONDITION */
	/* SAC_ID_CONDITION */
	/* SAC_CLASS_CONDITION */
	/* SAC_PSEUDO_CLASS_CONDITION */
	struct _SAC_Attribute {
	    /* NULL if :
	       - any 
	       - if conditionType == SAC_ID_CONDITION
	    */
	    SAC_STRING namespaceURI;  
	    /*
	      NULL if:
	      - this attribute condition can match any attribute.
	      - this attribute is a class or a pseudo class.
	     */
	    SAC_STRING localName; 
	    /*
	     * If the attribute must have an explicit value in the original
	     * document, 'specified' is SAC_TRUE; otherwise, it is SAC_FALSE.
	     */
	    SAC_Boolean specified;
	    SAC_STRING  value;	/* NULL if any */
	} attribute;

	/* SAC_LANG_CONDITION */
	SAC_STRING lang; /* NULL if any */

	/* SAC_ONLY_CHILD_CONDITION */
	/* SAC_ONLY_TYPE_CONDITION */
	/* empty */

	/* SAC_CONTENT_CONDITION */
	SAC_STRING data; /* can't be NULL */
    } desc;
};

#endif /* _SELECTOR_H_ */
