/*
 * (c) COPYRIGHT 1999 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 * $Id: utils.h,v 1.2 2000/03/08 22:29:08 plehegar Exp $
 */
#ifndef _CSSUTILS_H_
#define _CSSUTILS_H_

#include "selectors.h"
#include "lexicalUnit.h"

/*
 * Here are some convenient functions to create a selector or a condition.
 * Note that this is not required to use them.
 */
SAC_Selector * SAC_CreateConditionalSelector(SAC_Selector * simpleSelector,
					     SAC_Condition * condition);
SAC_Selector * SAC_CreateAnyNodeSelector();
SAC_Selector * SAC_CreateNegativeSelector(SAC_Selector * simpleSelector);
SAC_Selector * SAC_CreateDescendantSelector(SAC_Selector * parentSelector,
					    SAC_Selector * simpleSelector);
SAC_Selector * SAC_CreateChildSelector(SAC_Selector * parentSelector,
				       SAC_Selector * simpleSelector);
SAC_Selector * 
SAC_CreateDirectAdjacentSelector(SAC_Selector * parentSelector,
				 SAC_Selector * simpleSelector);
SAC_Selector * 
SAC_CreateIndirectAdjacentSelector(SAC_Selector * parentSelector,
				   SAC_Selector * simpleSelector);
SAC_Selector * SAC_CreateElementNodeSelector(const SAC_STRING namespaceURI,
					     const SAC_STRING localName);
SAC_Selector * 
SAC_CreateFirstLinePseudoElementSelector(const SAC_STRING namespaceURI);
SAC_Selector * 
SAC_CreateFirstLetterPseudoElementSelector(const SAC_STRING namespaceURI);
SAC_Selector * 
SAC_CreateBeforePseudoElementSelector(const SAC_STRING namespaceURI);
SAC_Selector * 
SAC_CreateAfterPseudoElementSelector(const SAC_STRING namespaceURI);
SAC_Selector * SAC_CreateTextNodeSelector(const SAC_STRING data);
SAC_Selector * SAC_CreateCDATASectionNodeSelector(const SAC_STRING data);
SAC_Selector * SAC_CreateCommentNodeSelector(const SAC_STRING data);
SAC_Selector * 
SAC_CreateProcessingInstructionNodeSelector(const SAC_STRING target,
					    const SAC_STRING data);
SAC_Condition * SAC_CreateAndCondition(SAC_Condition * firstCondition,
				       SAC_Condition * secondCondition);
SAC_Condition * SAC_CreateOrCondition(SAC_Condition * firstCondition,
				      SAC_Condition * secondCondition);
SAC_Condition * SAC_CreateNegativeCondition(SAC_Condition * condition);
SAC_Condition * SAC_CreatePositionalCondition(signed int position,
					      SAC_Boolean typeNode,
					      SAC_Boolean type);
SAC_Condition * SAC_CreateAttributeCondition(const SAC_STRING namespaceURI,
					     const SAC_STRING localName,
					     SAC_Boolean specified,
					     const SAC_STRING value);
SAC_Condition * SAC_CreateOneOfAttributeCondition(const SAC_STRING namespaceURI,
						  const SAC_STRING localName,
						  SAC_Boolean specified,
						  const SAC_STRING value);
SAC_Condition * 
SAC_CreateBeginHyphenAttributeCondition(const SAC_STRING namespaceURI,
					const SAC_STRING localName,
					SAC_Boolean specified,
					const SAC_STRING value);
SAC_Condition * SAC_CreateClassCondition(const SAC_STRING className);
SAC_Condition * SAC_CreateLinkPseudoClassCondition();
SAC_Condition * SAC_CreateVisitedPseudoClassCondition();
SAC_Condition * SAC_CreateHoverPseudoClassCondition();
SAC_Condition * SAC_CreateActivePseudoClassCondition();
SAC_Condition * SAC_CreateFocusPseudoClassCondition();
SAC_Condition * SAC_CreateTargetPseudoClassCondition();
SAC_Condition * SAC_CreateSubjectPseudoClassCondition();
SAC_Condition * SAC_CreateIdCondition(const SAC_STRING id);
SAC_Condition * SAC_CreateLangCondition(const SAC_STRING lang);
SAC_Condition * SAC_CreateOnlyChildCondition();
SAC_Condition * SAC_CreateContentCondition(const SAC_STRING data);

/* dispose stuff 
 * recurse into the selector.
 */
void SAC_DisposeSelector(SAC_Selector * selector);


SAC_LexicalUnit * SAC_CreateLUOperatorComma();
SAC_LexicalUnit * SAC_CreateLUOperatorPlus();
SAC_LexicalUnit * SAC_CreateLUOperatorMinus();
SAC_LexicalUnit * SAC_CreateLUOperatorMultiply();
SAC_LexicalUnit * SAC_CreateLUOperatorSlash();
SAC_LexicalUnit * SAC_CreateLUOperatorMod();
SAC_LexicalUnit * SAC_CreateLUOperatorExp();
SAC_LexicalUnit * SAC_CreateLUOperatorLT();
SAC_LexicalUnit * SAC_CreateLUOperatorGT();
SAC_LexicalUnit * SAC_CreateLUOperatorLE();
SAC_LexicalUnit * SAC_CreateLUOperatorGE();
SAC_LexicalUnit * SAC_CreateLUOperatorTilde();
SAC_LexicalUnit * SAC_CreateLUInherit();
SAC_LexicalUnit * SAC_CreateLUInteger(signed long integer);
SAC_LexicalUnit * SAC_CreateLUReal(/* unsigned */ double real);
SAC_LexicalUnit * SAC_CreateLUDimension(const SAC_STRING unit,
					/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLULengthEM(/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLULengthEX(/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLULengthPixel(/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLULengthInch(/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLULengthCentimeter(/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLULengthMillimeter(/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLULengthPoint(/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLULengthPica(/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLUPercentage(/* signed */ double sreal);
SAC_LexicalUnit * SAC_CreateLUDegree(/* unsigned */ double ureal);
SAC_LexicalUnit * SAC_CreateLUGradian(/* unsigned */ double ureal);
SAC_LexicalUnit * SAC_CreateLURadian(/* unsigned */ double ureal);
SAC_LexicalUnit * SAC_CreateLUMillisecond(/* unsigned */ double ureal);
SAC_LexicalUnit * SAC_CreateLUSecond(/* unsigned */ double ureal);
SAC_LexicalUnit * SAC_CreateLUHertz(/* unsigned */ double ureal);
SAC_LexicalUnit * SAC_CreateLUKiloHertz(/* unsigned */ double ureal);
SAC_LexicalUnit * SAC_CreateLUURI(const SAC_STRING uri);
SAC_LexicalUnit * SAC_CreateLUCounterFunction(SAC_LexicalUnit * parameters);
SAC_LexicalUnit * SAC_CreateLUCountersFunction(SAC_LexicalUnit * parameters);
SAC_LexicalUnit * SAC_CreateLURGBColor(SAC_LexicalUnit * parameters);
SAC_LexicalUnit * SAC_CreateLUAttr(const SAC_STRING attrName);
SAC_LexicalUnit * SAC_CreateLURectFunction(SAC_LexicalUnit * parameters);
SAC_LexicalUnit * SAC_CreateLUFunction(const SAC_STRING name,
						SAC_LexicalUnit * parameters);
SAC_LexicalUnit * SAC_CreateLUIdent(const SAC_STRING ident);
SAC_LexicalUnit * SAC_CreateLUStringValue(const SAC_STRING stringValue);
SAC_LexicalUnit * SAC_CreateLUSubExpression(SAC_LexicalUnit * subValues);

/* @@ unicode range */
SAC_LexicalUnit * SAC_CreateLUUnicodeRange(const SAC_STRING unicodeRange);

void SAC_DisposeLU(SAC_LexicalUnit * lexicalUnit);

char * SAC_CSS2_Selector_ToString(const SAC_Selector *);



#endif /* _CSSUTILS_H_ */
