#!/usr/bin/gawk -f
#
# Generate the signature for the bottom of each page in the current
# locale. The locale is set with the LC_ALL, LC_MESSAGES or LANG
# environment variables. Input is a single line with an e-mail
# address.
#
# Author: Bert Bos <bert@w3.org>
# Created: 10 July 2012

BEGIN {
  TEXTDOMAIN = "CSS";
  bindtextdomain(root ? root : ".");

  # Default author:
  default_author = "bert@w3.org";

  # All known authors:
  name["bert@w3.org"] = _"Bert Bos";
  url["bert@w3.org"] = "../../People/Bos/";
  title["bert@w3.org"] = _"style activity lead";
  photo["bert@w3.org"] = "../../People/Bos/bert3-small.jpg";

  name["http://fantasai.inkedblade.net/contact"] = _"Elika J. Etemad";
  url["http://fantasai.inkedblade.net/contact"] = "http://fantasai.inkedblade.net/contact";
  # title["http://fantasai.inkedblade.net/contact"] = _"";
  # photo["http://fantasai.inkedblade.net/contact"] = "";
}

/^mailto:/ {
  h = url_decode(html_decode($0));
  if (match(h, /["!#$%&'*=?^`{|}!a-zA-Z0-9+._-]+@[][a-zA-Z0-9+._-]+/)) {
    x = substr(h, RSTART, RLENGTH);

    # If that name is not known, try to find a URL and display name in the URL
    if (! name[x]) {
      url[x] = $0;
      if (match(h, /\(.*\)/)) {	# Address has en embedded comment
	name[x] = html_encode(substr(h, RSTART + 1, RLENGTH - 2));
      } else if (match(h, /<[^>]*>/)) {
	name[x] = html_encode(trim(substr(h, 8, RSTART - 9)));
	if (name[x] == "") name[x] = html_encode("<" x ">")
      } else {
	name[x] = html_encode(substr(h, 8)); # Whole string without "mailto:"
      }
    }
  } else {
    x = substr(h, 8);		# Strange kind of address...
  }
  next;
}

{x = url_decode(html_decode($0))}

END {
  if (!x) x = default_author;
  printf "<address class=vcard>";
  if (photo[x]) printf "<img alt=\"\" class=photo\nsrc=\"%s\">\n", photo[x];
  if (url[x]) printf "<a class=\"fn url\" href=\"%s\"\n>", url[x];
  printf "%s", name[x];
  if (url[x]) printf "</a>";
  if (title[x]) printf ",\n<span class=role>%s</span>", title[x];
  printf "<br>\n";
  printf "<small><a rel=copyright\n";
  printf "href=\"/Consortium/Legal/ipr-notice#Copyright\">%s</a> ©\n",
    _"Copyright";
  printf "1994&ndash;%s <a href=\"/\"><acronym\n", strftime("%Y");
  printf "title=\"World Wide Web Consortium\"\n";
  printf ">W3C</acronym><sup>®</sup></a></small></address>\n";
}


# url_decode -- decode %xx escapes in a string
function url_decode(s,         t)
{
  t = "";
  while (match(s, /%[0-9a-fA-F][0-9a-fA-F]/)) {
    t = t substr(s, 1, RSTART - 1);
    t = t sprintf("%c", strtonum("0x" substr(s, RSTART + 1, 2)));
    s = substr(s, RSTART + RLENGTH);
  }
  return t s;
}


# url_encode -- replace illegal characters by %-escapes
function url_encode(s)
{
  gsub(/%/, "%25", s);
  gsub(/ /, "%20", s);
  gsub(/=/, "%3D", s);
  gsub(/\//, "%2F", s);
  # To do: more...
  return s;
}


# html_decode -- remove HTML entities
function html_decode(s)
{
  gsub(/&lt;/, "<", s);
  gsub(/&gt;/, ">", s);
  gsub(/&quot;/, "\"", s);
  gsub(/&amp;/, "\\&", s);
  return s;
}


# html_encode -- Escape HTML delimiters
function html_encode(s)
{
  gsub(/&/, "\\&amp;", s);
  gsub(/</, "\\&lt;", s);
  gsub(/>/, "\\&gt;", s);
  gsub(/"/, "\\&quot;", s);
  return s;
}


# trim -- collapse white space
function trim(s)
{
  gsub(/[\r\t\n\f]/, " ", s);
  sub(/^ +/, "", s);
  sub(/ +$/, "", s);
  gsub(/  +/, " ", s);
  return s;
}
