#!/usr/bin/gawk -f
#
# Generate the common banner (navigation menu) in the current
# locale. The locale is set with the LC_ALL, LC_MESSAGES or LANG
# environment variables.
#
# Author: Bert Bos <bert@w3.org>
# Created: 10 July 2012

BEGIN {
  TEXTDOMAIN = "CSS";
  bindtextdomain(root ? root : ".");
  printf "<div id=banner class=section>\n";
  printf "<h2>%s</h2>\n",
    _"Site navigation";
  printf "<form action=\"../../Help/search\">\n";
  printf "<ul>\n";
  printf "<li class=home><a href=\"http://www.w3.org/\"\n";
  printf "rel=home><img alt=W3C\n";
  printf "src=\"http://www.w3.org/Icons/w3c_home\"></a>\n";
  printf "<li><a href=\"./\">%s</a>\n",
    _"CSS home";
  printf "<li><a href=\"learning\">%s</a>\n",
    _"Learn &amp; use";
  printf "<li><a href=\"software\">%s</a>\n",
    _"Soft&shy;ware";
  printf "<li><a href=\"current-work\"\n";
  printf "title=\"%s\"\n",
    _"Participate in the development of the CSS standard";
  printf ">%s / <span title=\"%s\"\n",
    _"Par&shy;tic&shy;i&shy;pate",
    _"All specifications and drafts";
  printf ">%s</span></a>\n",
    _"drafts";
  printf "<li class=search><input accesskey=E id=inputField\n";
  printf "maxlength=255 name=q size=10><button accesskey=G type=submit\n";
  printf "name=sa><img src=\"../../2008/site/images/search-button\"\n";
  printf "alt=\"%s\" title=\"%s\"></button>\n",
    _"Search",
    _"Search";
  printf "</ul>\n";
  printf "</form>\n";
  printf "</div>\n";
}
