#!/usr/bin/gawk -f
#
# Read output of "hxpipe blog.stored" (an Atom feed) and output an
# HTML list with the titles of all blog posts it contains.
#
# Author: Bert Bos <bert@w3.org>
# Created: 7 Oct 2010

BEGIN {printf "<ul>\n"}
/^\(title$/ {in_title = 1; t = ""}
/^\)title$/ {in_title = 0}
/^Arel CDATA / {rel = $3}
/^Ahref CDATA / {url = $3}
/^[(|]link$/ {if (!rel || rel == "alternate") {the_url = url}}
/^[|)]/ {rel = ""; url = ""}
/^-/ {if (in_title) t = t substr($0, 2)}
/^\)entry$/ {gsub("\\n", " ", t); printf "<li lang=en><a href=\"%s\">%s</a>\n", the_url, t}
END {printf "</ul>\n"}
