/* quotestoclasses - expand quotes
 *
 * Expands property names in single quotes ('property') and
 * code between pairs of single codes (''code'') to mark-up like
 *
 *     &lsquo;<code class=property>property</code>&rsquo;
 * or
 *     &lsquo;<code class=css>code</code>&rsquo;
 *
 * If there is anything else than letters and dashes between the quotes,
 * it is assumed to be CSS code rather than a property name and will
 * get class=css.
 *
 * Quotes are not expanded inside CODE and PRE elements.
 *
 * The first ' of 'property' may not be preceded by a letter.
 * (This is to protect words like "can't" or "don't.")
 *
 * It is safe to run quotestoclasses on its own output. The second run
 * causes no further changes.
 *
 * Assumes valid HTML, but no errors are reported for invalid input.
 *
 * Assumes ASCII encoding or an 8-bit encoding that leaves ASCII
 * characters unchanged (e.g., ISO-8859-1 or UTF-8).
 *
 * Copyright 2011 World Wide Web Consortium
 * See http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 *
 * Author: Bert Bos <bert@w3.org>
 * Created: 21 April 2011
 */

%option case-insensitive 8bit

%{
#define P "&lsquo;<code class=property>"
#define E "</code>&rsquo;"
#define C "&lsquo;<code class=css>"
#define out(s) fputs((s), stdout)
int nesting;
%}

%s CODE PRE TITLE CSS_D CSS_S MARKUP COMMENT

%%

<INITIAL>"<title"[^a-z]	out(yytext); BEGIN(TITLE);
<INITIAL>"<code"[^a-z]	out(yytext); nesting = 1; BEGIN(CODE);
<INITIAL>"<pre"[^a-z]	out(yytext); BEGIN(PRE);
<INITIAL>"<!--"		out(yytext); BEGIN(COMMENT);
<INITIAL>"<"		out(yytext); BEGIN(MARKUP);
<INITIAL>"''"		out(C); BEGIN(CSS_D);
<INITIAL>[a-z]\'	out(yytext);
<INITIAL>\'[a-z-]+\'	out(P); yytext[yyleng-1]='\0'; out(yytext+1); out(E);
<INITIAL>\'		out(C); BEGIN(CSS_S);

<TITLE>"</title"[^a-z]	out(yytext); BEGIN(INITIAL);

<CODE>"<code"[^a-z]	out(yytext); nesting++;
<CODE>"</code"[^a-z]	out(yytext); nesting--; if (!nesting) BEGIN(INITIAL);

<PRE>"</pre"[^a-z]	out(yytext); BEGIN(INITIAL);

<MARKUP>\'[^']*\'	out(yytext);
<MARKUP>\"[^"]*\"	out(yytext);
<MARKUP>">"		out(yytext); BEGIN(INITIAL);

<COMMENT>"-->"		out(yytext); BEGIN(INITIAL);

<CSS_D>"''"		out(E); BEGIN(INITIAL);

<CSS_S>\'		out(E); BEGIN(INITIAL);
