#!/usr/bin/gawk -f

BEGIN {
  TEXTDOMAIN = "CSS";
  bindtextdomain(root ? root : ".");
  base = "http://www.w3.org/Style/CSS/";
  form = "translationvote";
  email = "site-comments&#64;w3.org";
}
/^# / {if (name == "") {name = substr($0, 3); u = ""}}
/^# *(http:|ftp:)/ {u = $2}
/^# Translator:/ {tn = substr($0, 15)}
/^# Translator-URI:/ {tu = $3}
/^URI:/ {if (u == "") u = $2}
/^Content-Type:/ {}
/^Content-Language:/ {
  sub(/;.*/, "");
  label[$2] = name;
  url[$2] = u;
  lang[n++] = $2;
  if (tn) {translator[$2] = tn; tn = ""}
  if (tu) {translatorurl[$2] = tu; tu = ""}
  name = "";
}
END {

  if (enabled) {		# There's no handler for this form yet...

  lc = tolower("LC_ALL" in ENVIRON ? ENVIRON["LC_ALL"] :
	       LANG in ENVIRON ? ENVIRON["LANG"] : "en_US.UTF-8");
  gsub(/\..*/, "", lc);
  gsub(/_/, "-", lc);
  # Reduce xx-yy to xx, unless there is a translation specifically for xx-yy
  if (! (lc in url)) gsub(/-.*/, "", lc);
  if (lc != "en" && lc in url) {
    printf "\n";
    printf "<div class=section id=feedback>\n";
    printf "<h2>%s</h2>\n", _"Feedback";
    printf "<form action=\"%s\" method=post>\n", form;
    printf "<p>%s\n", _"Was this translation helpful?";
    printf "<input type=hidden name=page value=\"%s%s\">\n", base, url[lc];
    printf "<label><input type=radio name=vote value=1>%s</label\n", _"Yes";
    printf "<label><input type=radio name=vote value=0>%s</label>\n", _"No";
    printf "<input type=submit value=\"%s\">\n", _"Submit";
    printf "<p>%s\n", _"Or send";
    printf "<a href=\"mailto:%s?subject=%s%s\">", email, base, url[lc];
    printf "%s</a>\n", _"feedback by e-mail";
    printf "<em>%s</em>\n", _"(in English, please!)";
    printf "</form>\n";
    printf "</div>"
  }

  }
}
