#!/usr/bin/gawk -f

BEGIN {
  TEXTDOMAIN = "CSS";
  bindtextdomain(root ? root : ".");
  printf "\n";
}
/^# / && !name {name = substr($0, 3); u = ""}
/^# *(http:|ftp:)/ {u = $2}
/^URI:/ {if (u == "") u = $2}
/^Content-Language:/ {
  sub(/;.*/, "");
  if (match(name, /\[(.*)\]/, x)) {
    sub(/ *\[.*\]/, "", name);
    date[$2] = x[1];
  }
  label[$2] = name;
  url[$2] = u;
  lang[n++] = $2;
  name = "";
}
END {
  sort(lang, 0, n - 1);
  printf "<div id=translations class=section>\n";
  printf "<h2>%s</h2>", _"Languages";
  if (n > 1) {
    printf "<ul>\n";
    for (i = 0; i < n; i++) {
      printf "<li><a rel=alternate hreflang=%s href=\"%s\"", lang[i], url[lang[i]];
      if (date[lang[i]]) printf " title=\"%s\"", date[lang[i]];
      printf ">%s</a>\n", label[lang[i]];
    }
    printf "</ul>\n";
  }
  printf "<p><a href=\"/Style/CSS/translating\">%s</a>",
    _"About the translations";
  printf "</div>\n";
}
