%{
#include <stdlib.h>
#include "grammar.def"
/* 
 *  Imprecise calculations! Moreover, printed output will only have 7
 *  digits
 */
#define MM 1.0
#define IN (25.4 * MM)
#define PT (IN/72.0)
#define CM (10 * MM)
#define PC (12 * PT)
#define PX (IN/96.0)			/* Approximately :-) */

#define yywrap() 1
int lineno = 1;
double curnum;
static int count(char *s);
%}


unicode		\\[0-9a-f]{1,4}
latin1		[-]
escape		{unicode}|\\[ -~-]
stringchar	{escape}|{latin1}|[ !#$%&(-~]
nmstrt		[a-z]|{latin1}|{escape}
nmchar		[-a-z0-9]|{latin1}|{escape}
ident		{nmstrt}{nmchar}*
name		{nmchar}+
d		[0-9]
notnm		[^-a-z0-9\\]|{latin1}
w		[ \t\n]*
num		{d}+|{d}*\.{d}+
string		\"({stringchar}|\')*\"|\'({stringchar}|\")*\'

%x COMMENT
%s AFTER_IDENT

%%
"/*"			{BEGIN(COMMENT);}
<COMMENT>"*/"		{BEGIN(0);}
<COMMENT>\n		{lineno++; /* ignore */}
<COMMENT>.		{/* ignore */}
@import			{BEGIN(0); return IMPORT_SYM;}
"!"{w}important		{BEGIN(0); lineno += count(yytext); return IMPORTANT_SYM;}
{ident}			{BEGIN(AFTER_IDENT); return IDENT;}
{string}		{BEGIN(0); return STRING;}

{num}			{BEGIN(0); curnum = atof(yytext); return NUMBER;}
{num}"%"		{BEGIN(0); curnum = atof(yytext); return PERCENTAGE;}
{num}pt/{notnm}		{BEGIN(0); curnum = atof(yytext) * PT; return LENGTH;}
{num}mm/{notnm}		{BEGIN(0); curnum = atof(yytext) * MM; return LENGTH;}
{num}cm/{notnm}		{BEGIN(0); curnum = atof(yytext) * CM; return LENGTH;}
{num}pc/{notnm}		{BEGIN(0); curnum = atof(yytext) * PC; return LENGTH;}
{num}in/{notnm}		{BEGIN(0); curnum = atof(yytext) * IN; return LENGTH;}
{num}px/{notnm}		{BEGIN(0); curnum = atof(yytext) * PX; return LENGTH;}
{num}em/{notnm}		{BEGIN(0); curnum = atof(yytext); return EMS;}
{num}ex/{notnm}		{BEGIN(0); curnum = atof(yytext); return EXS;}

<AFTER_IDENT>":"link		{return LINK_PSCLASS_AFTER_IDENT;}
<AFTER_IDENT>":"visited	{return VISITED_PSCLASS_AFTER_IDENT;}
<AFTER_IDENT>":"active	{return ACTIVE_PSCLASS_AFTER_IDENT;}
<AFTER_IDENT>":"first-line	{return FIRST_LINE_AFTER_IDENT;}
<AFTER_IDENT>":"first-letter	{return FIRST_LETTER_AFTER_IDENT;}
<AFTER_IDENT>"#"{name}          {return HASH_AFTER_IDENT;}
<AFTER_IDENT>"."{name}          {return CLASS_AFTER_IDENT;}

":"link				{BEGIN(AFTER_IDENT); return LINK_PSCLASS;}
":"visited			{BEGIN(AFTER_IDENT); return VISITED_PSCLASS;}
":"active			{BEGIN(AFTER_IDENT); return ACTIVE_PSCLASS;}
":"first-line			{BEGIN(AFTER_IDENT); return FIRST_LINE;}
":"first-letter			{BEGIN(AFTER_IDENT); return FIRST_LETTER;}
"#"{name}			{BEGIN(AFTER_IDENT); return HASH;}
"."{name}			{BEGIN(AFTER_IDENT); return CLASS;}

url\({w}{string}{w}\)				     |
url\({w}([^ \n\'\")]|\\\ |\\\'|\\\"|\\\))+{w}\)    {BEGIN(0); lineno += count(yytext); return URL;}
rgb\({w}{num}%?{w}\,{w}{num}%?{w}\,{w}{num}%?{w}\) {BEGIN(0); lineno += count(yytext); return RGB;}

[-/+{};,#:]		{BEGIN(0); return *yytext;}
[ \t]+			{BEGIN(0); /* ignore whitespace */}
\n			{BEGIN(0); lineno++; /* ignore whitespace */}
\<\!\-\-		{BEGIN(0); return CDO;}
\-\-\>                  {BEGIN(0); return CDC;}
.                       {fprintf(stderr, "%d: Illegal character (%d)\n", lineno, *yytext);}



%%

static int count(char *s)
{
    int n = 0;

    while (*s) {
        if (*s == '\n') n++;
        s++;
    }
    return n;
}
