#!/usr/bin/gawk -f

BEGIN {
  TEXTDOMAIN = "translations2";
  bindtextdomain(root ? root : ".");
  printf "\n";
}
/^#/ {if (name == "") {name = substr($0, 3); u = ""}}
/^# *(http:|ftp:)/ {u = $2}
/^# Translator:/ {tn = substr($0, 15)}
/^# Translator-URI:/ {tu = $3}
/^URI:/ {if (u == "") u = $2}
/^Content-Type:/ {}
/^Content-Language:/ {
  label[$2] = name;
  url[$2] = u;
  lang[n++] = $2;
  if (tn) {translator[$2] = tn; tn = ""}
  if (tu) {translatorurl[$2] = tu; tu = ""}
  name = "";
}
END {
  if (n > 1) {
    printf "<div class=section id=language>\n";
    printf "<p><a href=\"#translations\">%s</a>\n", _"Languages";
    lc = "LC_ALL" in ENVIRON ? ENVIRON["LC_ALL"] :
      LANG in ENVIRON ? ENVIRON["LANG"] : "en_US.UTF-8";
    gsub("_.*", "", lc);
    if (lc != "en") {
      printf "<p>%s\n%s\n<a rel=alternate hreflang=en href=\"%s\">%s</a>\n%s\n",
	_"This is a translation.",
	_"It may contain errors or be out of date with respect to",
	url["en"],
	_"the English version.",
	_"   ";
      # if (lc in url) {
      # }
      if (lc in translator) {
	printf "%s: ",  _"Translator";
	if (lc in translatorurl)
	  printf "<a href=\"%s\">%s</a>\n", translatorurl[lc], translator[lc];
	else
	  printf "%s\n", translator[lc];
      }
    }
    printf "</div>\n";
  }
}
