<?php

$mf_color = $mf_color_default;
$mf_width = $mf_width_default;
$mf_font_size = $mf_font_size_default;

getUserSetting();

function getUserSetting(){
	global $mf_color, $mf_font_size, $mf_width, $mf_menutype, $mf_template_name, $mf_template_absolute_path ;
	global $mf_font_size_default, $mf_color_default, $mf_width_default;

	if (isset($_COOKIE['MFTheme']) && $_COOKIE['MFTheme'] == $mf_template_name){
		if (isset($_COOKIE['ColorCSS']) && $_COOKIE['ColorCSS']){
			$mf_color = $_COOKIE['ColorCSS'];
		}
		if (isset($_COOKIE['ScreenType'])){
			$mf_width = $_COOKIE['ScreenType'];
		}
		if (isset($_COOKIE['FontSize'])){
			$mf_font_size = $_COOKIE['FontSize'];
		}
	}else{
		$exp = time() + 60*60*24*355;
		setcookie ('MFTheme', $mf_template_name, $exp, '/');
		setcookie ('ColorCSS', $mf_color_default, $exp, '/');
		setcookie ('ScreenType', $mf_width_default, $exp, '/');
		setcookie ('FontSize', $mf_font_size_default, $exp, '/');
	}

	if (!is_file("$mf_template_absolute_path/css/colors/$mf_color.css")) $mf_color = $mf_color_default;
}

function getCurrentURL(){
	$cururl = mosGetParam( $_SERVER, 'REQUEST_URI', '' );
	if(($pos = strpos($cururl, "index.php"))!== false){
		$cururl = substr($cururl,$pos);
	}
	$cururl =  sefRelToAbs($cururl);
	$cururl =  ampReplace($cururl);
	return $cururl;
}

function genMenuHead(){
	global $mf_template_path,$mf_menutype, $mf_tool,$mf_font_size;
	$html = "";
	if ($mf_menutype == 1) {
		$html = '<link href="'.$mf_template_path.'/mf_splitmenu/mf-splitmenu.css" rel="stylesheet" type="text/css" />';
	}else if ($mf_menutype == 2) {
		$html = '<link href="'.$mf_template_path.'/mf_cssmenu/mf-sosdmenu.css" rel="stylesheet" type="text/css" />
					<script language="javascript" type="text/javascript" src="'. $mf_template_path.'/mf_cssmenu/ja.cssmenu.js"></script>';
	} else if ($mf_menutype == 3) {
		$html = '<link href="'. $mf_template_path .'/mf_transmenu/mf-transmenuh.css" rel="stylesheet" type="text/css" />
					<script language="javascript" type="text/javascript" src="'.$mf_template_path.'/mf_transmenu/mf-transmenu.js"></script>';
	} else if ($mf_menutype == 4) {
		$html = '<link href="'. $mf_template_path .'/mf_scriptdlmenu/mf-scriptdlmenu.css" rel="stylesheet" type="text/css" />
					<script language="javascript" type="text/javascript" src="'.$mf_template_path.'/mf_scriptdlmenu/mf-scriptdlmenu.js"></script>';
	}

	if ($mf_tool){
	?>
		<script type="text/javascript">
		var currentFontSize = <?php echo $mf_font_size; ?>;
		</script>
	<?php
	}
	echo $html;
}

function genColorHead(){
	global $mf_color_themes, $mf_color, $mf_template_path, $mf_tool;
	$html = '';
	foreach ($mf_color_themes as $mf_color_theme) {
		if ($mf_color == $mf_color_theme){
			$html .= '<link href="'.$mf_template_path.'/css/colors/'.$mf_color_theme.'.css" rel="stylesheet" type="text/css" title="'.$mf_color_theme.'" />'."\n";
		}else{
			if ($mf_tool & 2) //Load this css when color tool enabled
				$html .= '<link href="'.$mf_template_path.'/css/colors/'.$mf_color_theme.'.css" rel="alternate stylesheet" type="text/css" title="'.$mf_color_theme.'" />'."\n";
		}
	}
	echo $html;
}

function genToolMenu($jatool){
	global $mf_template_path,$mf_font_size_default, $mf_font_size, $mf_color_themes, $mf_width, $mf_color;
	if ($jatool & 1){//show screen tools
		?>
		<span class="mf-usertools">
	    <a href="#Narrow" onclick="setScreenType('narrow');return false;"><img title="Narrow screen" src="<?php echo $mf_template_path;?>/images/<?php echo $mf_color?>/user-screen1<?php echo ( ($mf_width=="narrow") ? "-hilite" : "" ) ?>.gif" alt="Narrow screen resolution" id="mf-tool-narrow" onclick="changeToolHilite(curtool, this);curtool=this;" /></a>
	    <a href="#Wide" onclick="setScreenType('wide');return false;"><img title="Wide screen" src="<?php echo $mf_template_path;?>/images/<?php echo $mf_color?>/user-screen2<?php echo ( ($mf_width=="wide") ? "-hilite" : "" ) ?>.gif" alt="Wide screen resolution" id="mf-tool-wide" onclick="changeToolHilite(curtool, this);curtool=this;" /></a>
	    <a href="#Auto" onclick="setScreenType('auto');return false;"><img title="Auto adjust screen size" src="<?php echo $mf_template_path;?>/images/<?php echo $mf_color?>/user-screen3<?php echo ( ($mf_width=="auto") ? "-hilite" : "" ) ?>.gif" alt="Auto adjust screen size" id="mf-tool-auto" onclick="changeToolHilite(curtool, this);curtool=this;" /></a>
		<a href="#Increase" onclick="changeFontSize(1); return false;"><img title="Increase font size" src="<?php echo $mf_template_path;?>/images/<?php echo $mf_color?>/user-increase.gif" alt="Increase font size" id="mf-tool-increase" /></a>
	    <a href="#Decrease" onclick="changeFontSize(-1); return false;"><img title="Decrease font size" src="<?php echo $mf_template_path;?>/images/<?php echo $mf_color?>/user-decrease.gif" alt="Decrease font size" id="mf-tool-decrease" /></a>
	    <a href="#Default" onclick="revertStyles(<?php echo $mf_font_size_default;?>); return false;"><img title="Default size" src="<?php echo $mf_template_path;?>/images/<?php echo $mf_color?>/user-reset.gif" alt="Default font size" id="mf-tool-reset" /></a>
    </span>
	<script type="text/javascript">
	var curtool = document.getElementById('<?php echo "mf-tool-$mf_width"; ?>');
	</script>
		<?php
	}
	if ($jatool & 2){//show color tools
		?>
    <span class="mf-colorthemes">
	<?php
 	foreach ($mf_color_themes as $mf_color_theme) {
	?>
     	<a href="#<?php echo $mf_color_theme;?>" onclick="setActiveStyleSheet('<?php echo $mf_color_theme;?>');"><img style="cursor: pointer;" src="<?php echo $mf_template_path;?>/images/<?php echo $mf_color?>/<?php echo $mf_color_theme;?><?php echo ( ($mf_color==$mf_color_theme) ? "-hilite" : "" ) ?>.gif" title="<?php echo $mf_color_theme;?> color" alt="<?php echo $mf_color_theme;?> color" id="mf-tool-<?php echo $mf_color_theme;?>color" onclick="changeToolHilite(curcolor, this);curcolor=this;return false;" /></a>
	<?php
	}
	?>
    </span>
	<script type="text/javascript">
	var curcolor = document.getElementById('<?php echo ( ($mf_color=="") ? "mf-tool-defaultcolor" : "mf-tool-{$mf_color}color" ) ?>');
	</script>
		<?php
	}
}

function mf_loadHeader($position){
	global $mf_template_path;
	$filename =  mf_getImageSrc($position);
	if ($filename) {
		echo $filename;
	}
}

function mf_getImageSrc ($position){
	global $mf_template_path, $mf_template_absolute_path;
	if (isset( $GLOBALS['_MOS_MODULES'][$position] )) {
		$modules = $GLOBALS['_MOS_MODULES'][$position];
	} else {
		$modules = array();
	}
	foreach ($modules as $module){
		$filename = $module->title;
		$regex = '/(\.gif)|(.jpg)|(.png)|(.bmp)$/i';
		if (is_file($mf_template_absolute_path."/images/header/".$filename) && preg_match($regex, $filename)) {
			return "$mf_template_path/images/header/" . $filename;
		}
	}
	return "";
}

function getCurrentMenuIndex(){
	global $Itemid, $database, $mosConfig_shownoauth, $my;
	//Get top menu id;
	$id = $Itemid;
	$menutype = 'mainmenu';
	$ordering = '0';
	while (1){
		$sql = "select parent, menutype, ordering from #__menu where id = $id limit 1";
		$database->setQuery($sql);
		$row = null;
		$database->loadObject($row);
		if ($row) {
			$menutype = $row->menutype;
			$ordering = $row->ordering;
			if ($row->parent > 0)
			{
				$id = $row->parent;
			}else break;
		}else break;
	}
	if ($mosConfig_shownoauth) {
		$sql = "SELECT count(*) FROM #__menu AS m"
		. "\nWHERE menutype='". $menutype ."' AND published='1' AND parent=0 and ordering < $ordering";
	} else {
		$sql = "SELECT count(*) FROM #__menu AS m"
		. "\nWHERE menutype='". $menutype ."' AND published='1' AND access <= '$my->gid' AND parent=0 and ordering < $ordering";
	}
	$database->setQuery($sql);

	return $database->loadResult();
}
?>
