<?php
// Set which extensions should be approved in the XML file
$extensions = array
(
	'jpg', 'JPG',
	'png', 'PNG',
	'gif', 'GIF',
	'bmp', 'BMP'
);

// Echo the header (XML)
header("Content-Type: application/xml;charset=ISO-8859-1");

// Prepare the XML file
echo '<?xml version="1.0" encoding="ISO-8859-1"?>' . "\r\n";
echo "<images>\r\n";

// Get the files from the current directory
if (file_exists ("./"))
{
	if (is_dir ("./"))
	{
		$dh = opendir ("./") or die (" Directory Open failed !");
		
		// Prepare the images array
		$imgs = array();
		while ($file = readdir ($dh))
		{
			// Only get the files ending with the correct extension
			if ( in_array( substr($file, -3), $extensions ) )
			{
				array_push($imgs, $file);
			}
		}
	Closedir ($dh);
	}
	
	// Sort the array
	sort($imgs);
	
	foreach ($imgs as $img)
	{
		// Return all images in XML format
		echo ('   <image src="' . $img . '" />');
		echo "\r\n";
	}
}
echo "</images>";
?>