<?php
class BlogController extends AppController {

	var $name = 'Blog';
	var $uses = array('Blog');
	
	// Used when indexing the page (http://yourdomain.com/blog/)
	function index($view = null) {
		// Debug for testing purposes (Check if model retrieves data)
		// debug($this->Blog->findAll());
		
		// What to do if a view is set
		if (isset($view))
		{
			$article = $this->Blog->find("id = $view");
			$this->set('article', $article);
			
			debug($article);
			
			// Retrieve and set the metadata
			$this->set('pagetitle', $article['Blog']['title']);
			$this->set('pagedescription', $article['Blog']['meta_description']);
			$this->set('pagekeywords', $article['Blog']['meta_keywords']);
			
			$this->render('article');
		}
		else
		{
			// Give data to the view
			$articles = $this->Blog->find('all');
			$this->set('articles', $articles);
			
			// Retrieve and combine keywords / description
			$keywords = '';
			$description = '';
			foreach ($articles as $article)
			{
				$keywords = $article['Blog']['meta_keywords'] . ', ' . $keywords;
				$description = $article['Blog']['meta_description'] . ', ' . $description;
			}
			$this->set('pagekeywords', $keywords);
			$this->set('pagedescription', $description);
			// Set fixed page title
			$this->set('pagetitle', 'Marcofolio.net building a CakePHP blog');
		}
	}
}
?>