<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Expanding a HTML form using JavaScript</title>
<script type="text/javascript">
/*	Set the counter that will increase every time
	the user adds a new language*/
var counter = 0;
function addlanguage()
{
	// Ask the user for input
	var language = prompt("Language Name","");
	if (language == "" || language == null)
	{
		alert("Please enter a language.");
	}
	else
	{
		counter++;
		// Find the element to be copied
		var newNode = document.getElementById('readnode').cloneNode(true);
		newNode.id = '';
		newNode.style.display = 'block';
		var newField = newNode.childNodes;
		// Give all fields a unique value
		for (var i=0;i<newField.length;i++)
		{
			var theName = newField[i].name;
			var theId = newField[i].id;
			if (theName)
			{
				newField[i].name = theName + counter;
			}
			if (theId == "languagename")
			{
				// Change the field to the user input
				newField[i].innerHTML = language;
			}
			if (theName == "lang")
			{
				// Replace the hidden field with the correct language
				newField[i].value = language;
			}
		}
		// Insert the elements
		var insertHere = document.getElementById('writenode');
		insertHere.parentNode.insertBefore(newNode,insertHere);
	}
}
</script>
</head>

<body>
<p><strong>Hi!</strong> This is a demo page from <a href="http://www.marcofolio.net/" title="Marcofolio.net" target="_blank">Marcofolio.net</a>.</p>
<p>This demo belongs to <a href="http://www.marcofolio.net/webdesign/expanding_a_html_form_using_javascript.html" title="Expanding a HTML form using JavaScript" target="_blank">Expanding a HTML form using JavaScript</a>.</p>
<hr />
<?php
if ($_GET["lang1"] == null)
{ ?>
<strong>What languages can you speak at which level?</strong>
<form>
<span id="writenode"></span>
<input type="button" value="Add language" onClick="addlanguage()" >
<input type="submit" value="Submit" >
</form>
<?php
}
else
{
	$final = 0;
	$i = 1;
	while($final == 0)
	{
		$getLang = "lang" . $i;
		$getRank = "rank" . $i;
		$language = $_GET[$getLang];
		$rank = $_GET[$getRank];

		if ($language == "")
		{
			$final = 1;
		}
		
		if ($rank == 0)
		{
			$rank = "poor";
		}
		else if ($rank == 1)
		{
			$rank = "reasonable";
		}
		else if ($rank == 2)
		{
			$rank = "good";
		}
		else if ($rank == 3)
		{
			$rank = "excellent";
		}

		if ($final == 0)
		{
			// Show the user the input
			echo("<p>Your <strong>$language</strong> is <strong>$rank</strong>.</p>");
		}
		$i++;
	}
} ?>
<hr />
<p><em>Using this technique, you can dynamically expand your HTML forms. You'll copy an existing element and give it a new ID.</em></p>
<p>Go to <a href="http://www.marcofolio.net/webdesign/expanding_a_html_form_using_javascript.html" title="Expanding a HTML form using JavaScript" target="_blank">the article</a> and download the source to implement it on your website.</p>
<div id="readnode" style="display: none">
	<strong id="languagename" name="languagename">Language</strong>
	<input type="hidden" name="lang" value="lang" />
	<select name="rank">
		<option disabled="disabled" selected="selected">Rating</option>
		<option value="3">Excellent</option>
		<option value="2">Good</option>
		<option value="1">Reasonable</option>
		<option value="0">Poor</option>
	</select>
	
	<input type="button" value="X"
		onclick="this.parentNode.parentNode.removeChild(this.parentNode);" />
</div>
</body>
</html>