/*
* Author:      Marco Kuiper (http://www.marcofolio.net/)
* Plugin name: jHTML-Ipsum
* Inpsired by: HTML-Ipsum (http://html-ipsum.com/)
* Description: This plugin allows the user to dynamically create HTML elements to see how it looks.
*/

(function($){
    $.jhtmlipsum = function(el, options){
        var base = this;
        
        base.$el = $(el);
        base.el = el;
        
        base.$el.data("jhtmlipsum", base);
        
        base.init = function(){
            base.options = $.extend({},$.jhtmlipsum.defaultOptions, options);
            
            //
            // Definition of all the HTML elements we can use
            //
            
            var elem = {
            	all : $("<div />")
            		.append($("<h1 />").text("HTML Ipsum Presents"))
            		.append($("<p />")
            			.append($("<strong />").text("Pellentesque habitant morbi tristique"))
            			.append(" senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. ")
            			.append($("<em />").text("Aenean ultricies mi vitae est."))
            			.append(" Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, ")
            			.append($("<code />").text("commodo vitae"))
            			.append(", ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. ")
            			.append($("<a />").attr("href", "#").text("Donec non enim"))
            			.append(" in turpis pulvinar facilisis. Ut felis.")
            		).append($("<h2 />").text("Header Level 2"))
            		.append($("<ol />")
            			.append($("<li />").text("Lorem ipsum dolor sit amet, consectetuer adipiscing elit."))
            			.append($("<li />").text("Aliquam tincidunt mauris eu risus."))
            		).append($("<blockquote />")
            		.append($("<p />").text("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus magna. Cras in mi at felis aliquet congue. Ut a est eget ligula molestie gravida. Curabitur massa. Donec eleifend, libero at sagittis mollis, tellus est malesuada tellus, at luctus turpis elit sit amet quam. Vivamus pretium ornare est."))
            		).append($("<h3 />").text("Header Level 3"))
            		.append($("<ul />")
            			.append($("<li />").text("Lorem ipsum dolor sit amet, consectetuer adipiscing elit."))
            			.append($("<li />").text("Aliquam tincidunt mauris eu risus."))
            		)
            		.append($("<pre />")
            			.append($("<code />").text("#header h1 a {\n\tdisplay: block;\n\twidth: 300px;\n\theight: 80px;\n}"))
            		),
            	dl : $("<dl />")
            		.append($("<dt />").text("Definition list"))
            		.append($("<dd />").text("Consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat."))
            		.append($("<dt />").text("Lorem ipsum dolor sit amet"))
            		.append($("<dd />").text("Consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")),
            	p : $("<p />").text("Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus."),
            	p_med : $("<p />").text("Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo."),
            	p_single : $("<p />").text("Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas."),
            	form : $("<form />")
						.attr("action", "#")
						.attr("method", "post")
						.append(
							$("<div />")
								.append($("<label />").attr("for", "name").text("Text Input:"))
								.append($("<input />").attr("type", "text").attr("name", "name").attr("id", "name").attr("value", "").attr("tabindex", "1"))
						)
						.append(
							$("<div />")
								.append($("<h4 />").text("Radio Button Choice"))
								.append($("<label />").attr("for", "radio-choice-1").text("Choice 1"))
								.append($("<input />").attr("type", "radio").attr("name", "radio-choice").attr("id", "radio-choice-1").attr("tabindex", "2").attr("value", "choice-1"))
								.append($("<label />").attr("for", "radio-choice-2").text("Choice 2"))
								.append($("<input />").attr("type", "radio").attr("name", "radio-choice").attr("id", "radio-choice-2").attr("tabindex", "3").attr("value", "choice-2"))
						)
						.append(
							$("<div />")
								.append($("<label />").attr("for", "select-choice").text("Select Dropdown Choice:"))
								.append($("<select />").attr("name", "select-choice").attr("id", "select-choice")
									.append($("<option />").attr("value", "Choice 1").text("Choice 1"))
									.append($("<option />").attr("value", "Choice 2").text("Choice 2"))
									.append($("<option />").attr("value", "Choice 2").text("Choice 3"))
								)
						)
						.append(
							$("<div />")
								.append($("<label />").attr("for", "textarea").text("Textarea:"))
								.append($("<textarea />").attr("cols", "40").attr("rows", "8").attr("name", "textarea").attr("id", "textarea"))
						)
						.append(
							$("<div />")
								.append($("<label />").attr("for", "checkbox").text("Checkbox:"))
								.append($("<input />").attr("type", "checkbox").attr("name", "checkbox").attr("id", "checkbox"))
						)
						.append(
							$("<div />")
								.append($("<input />").attr("type", "submit").attr("value", "Submit"))
						),
				table : $("<table />")
							.append($("<thead />")
								.append(
									$("<tr />")
										.append($("<th />").text("Heading 1"))
										.append($("<th />").text("Heading 2"))
										.append($("<th />").text("Heading 3"))
										.append($("<th />").text("Heading 4"))								
							)
						)
						.append($("<tbody />")
							.append(
								$("<tr />")
									.append($("<td />").text("Cell 1,1"))
									.append($("<td />").text("Cell 1,2"))
									.append($("<td />").text("Cell 1,3"))
									.append($("<td />").text("Cell 1,4"))
							)
							.append(
								$("<tr />")
									.append($("<td />").text("Cell 2,1"))
									.append($("<td />").text("Cell 2,2"))
									.append($("<td />").text("Cell 2,3"))
									.append($("<td />").text("Cell 2,4"))
							)
							.append(
								$("<tr />")
									.append($("<td />").text("Cell 3,1"))
									.append($("<td />").text("Cell 3,2"))
									.append($("<td />").text("Cell 3,3"))
									.append($("<td />").text("Cell 3,4"))
							)
						),
				navigation : $("<ul />").attr("id", "nav")
							.append($("<li />")
								.append($("<a />").attr("href", "#").text("Home"))
							).append($("<li />")
								.append($("<a />").attr("href", "#").text("About"))
							).append($("<li />")
								.append($("<a />").attr("href", "#").text("Clients"))
							).append($("<li />")
								.append($("<a />").attr("href", "#").text("Contact Us"))
							)
            };
            
            // Create the elements
            for(var i = 0; i < base.options.elements.length; i++) {
            	
            	if("all" == base.options.elements[i]) {
            		elem.all.clone().appendTo(base.$el);
            	}
            	
            	if("p" == base.options.elements[i]) {
            		elem.p.clone().appendTo(base.$el);
            	}
            	
            	if("p_med" == base.options.elements[i]) {
            		elem.p_med.clone().appendTo(base.$el);
            	}
            	
            	if("p_single" == base.options.elements[i]) {
            		elem.p_single.clone().appendTo(base.$el);
            	}
            	
            	if("dl" == base.options.elements[i]) {
            		elem.dl.clone().appendTo(base.$el);
            	}
            	
            	if("form" == base.options.elements[i]) {
            		elem.form.clone().appendTo(base.$el);
            	}
            	
            	if("table" == base.options.elements[i]) {
            		elem.table.clone().appendTo(base.$el);
            	}
            	
            	if("nav" == base.options.elements[i]) {
            		elem.navigation.clone().appendTo(base.$el);
            	}
            	
            }
            
        };
        base.init();
    };
    
    $.jhtmlipsum.defaultOptions = {
        elements: ["all"]
    };
    
    $.fn.jhtmlipsum = function(options){
        return this.each(function(){
            (new $.jhtmlipsum(this, options));
        });
    };
    
})(jQuery);
