/*
* Author:      Marco Kuiper (http://www.marcofolio.net/)
*/

/* Time to preview a preview */
var PREVIEWTIME = 3000;

google.load("jquery", "1.3.1");
google.setOnLoadCallback(function()
{
	// Set the opacity for the movie overlay (start screen)
	$("#overlaybg").fadeTo(0, 0.1);
	
	$("#movieoverlay").click(function(){
		$(this).fadeOut(function(){
			setTimeout("animatePreviews()", 500);	
		});	
	});
});

/* Variable to store which preview is currently viewed */
var currentPreview = -1;

/**
* Animates the previews
*/
function animatePreviews() {
	currentPreview++;
	
	if( $(".preview:eq("+currentPreview+")").hasClass("prevtext") ) {
		animateTextPreview($(".preview:eq("+currentPreview+")"));
	} else if ( $(".preview:eq("+currentPreview+")").hasClass("previmgheight") ) {
		animateImagePreviewHeight($(".preview:eq("+currentPreview+")"));
	} else { 
		animateImagePreviewWide($(".preview:eq("+currentPreview+")"));
	}
}

function animateTextPreview(previewElement) {
	$(previewElement)
		.fadeIn("slow")
		.animate({
			letterSpacing : "3px"
		}, PREVIEWTIME)
		.fadeOut("slow", function(){
			animatePreviews();
		});
}

function animateImagePreviewWide(previewElement) {
	$(previewElement)
		.fadeIn("slow")
		.animate({ marginLeft : "-100px"} , PREVIEWTIME)
		.fadeOut("slow", function(){
			animatePreviews();
		});
}

function animateImagePreviewHeight(previewElement) {
	$(previewElement)
		.fadeIn("slow")
		.animate({ marginTop : "-100px"} , PREVIEWTIME)
		.fadeOut("slow", function(){
			animatePreviews();
		});
}