<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>Personalized Digg Page</title>
<link rel="stylesheet" type="text/css" href="digg.css" />
</head>
<?php
// Set User Variables
$username = 'DIGG_USERNAME';
$appkey = 'APPKEY'; // URL of your site, http://example.com/application
$nrsubmissions = 10; // Max = 100
$nrdugg = 20; // Max = 100
$nrfrienddugg = 50; // Max = 100
$nrfans = 10; // Max = 100

/////////// DON'T EDIT BELOW THIS LINE /////////

// Retrieve all needed XML files and place them in objects
$url = "http://services.digg.com/user/$username/?appkey=$appkey";
$user = @simplexml_load_file($url);
if (!$user)
	die('Unable to load user XML from Digg. Please try again.');
	
$url = "http://services.digg.com/user/$username/submissions?appkey=$appkey&count=$nrsubmissions";
$submissions = @simplexml_load_file($url);
if (!$submissions)
	die('Unable to load user submission XML from Digg. Please try again.');
	
$url = "http://services.digg.com/user/$username/dugg?appkey=$appkey&count=$nrdugg";
$duggs = @simplexml_load_file($url);
if (!$duggs)
	die('Unable to load user duggs XML from Digg. Please try again.');
	
$url = "http://services.digg.com/user/$username/friends/dugg?appkey=$appkey&count=$nrfrienddugg";
$fduggs = @simplexml_load_file($url);
if (!$fduggs)
	die('Unable to load user friends duggs XML from Digg. Please try again.');

$url = "http://services.digg.com/user/$username/fans?appkey=$appkey";
$fans = @simplexml_load_file($url);
if (!$fans)
	die('Unable to load user fans XML from Digg. Please try again.');
	
?>
<body>

<div id="digg">
    <div id="personal">
        <h1><a href="http://digg.com/users/<?= $username ?>"><?= $user->user['fullname'] ?></a></h1>
        <img src="<?= $user->user['icon'] ?>" alt="Digg Picture" />
        <p id="links">
        <?php foreach ($user->user->link as $link) { ?>
        	<a href="<?= $link['href'] ?>"><?= $link['description'] ?></a><br />
        <?php } ?>
        </p>
    </div>
    <div id="duggs">
    	<h2>Latest <?= $nrdugg ?> duggs (<?= $duggs['total'] ?> total)</h2>
        <?php foreach ($duggs->story as $story) { ?>
        	<div class="dugg_story">
        		<p class="digg_btn_big"><a href="<?= $story['href'] ?>" title="<?= htmlentities($story->title) ?> on Digg"><?= $story['diggs'] ?></a></p>
            	<p><strong><a href="<?= $story['link'] ?>" title="<?= htmlentities($story->title) ?>"><?= $story->title ?></a></strong><br />
            	<?= $story->description ?></p>
                <br class="break" />
            </div>
        <?php } ?>
    </div>
    <div id="submissions">
    	<h2>Latest <?= $nrsubmissions ?> submissions (<?= $submissions['total'] ?> total)</h2>
        <?php foreach ($submissions->story as $story) { ?>
        	<div class="submission_story">
            	<p class="digg_btn_small"><a href="<?= $story['href'] ?>" title="<?= htmlentities($story->title) ?> on Digg"><?= $story['diggs'] ?></a></p>
            	<p><a href="<?= $story['link'] ?>" title="<?= htmlentities($story->title) ?>"><?= $story->title ?></a></p>
                <br class="break" />
            </div>
        <?php } ?>
    </div>
    <div id="friends_duggs">
    	<h3>Latest <?= $nrfrienddugg ?> duggs from friends</h3>
    	<?php foreach ($fduggs->story as $story) { ?>
        	<div class="friend_dugg">
            	<p><a href="http://digg.com/users/<?= $story->friends->user['name'] ?>" title="<?= $story->friends->user['name'] ?> on Digg"><img src="<?= $story->friends->user['icon'] ?>" alt="<?= $story->friends->user['name'] ?> on Digg" height="16" /></a></p>
            	<p class="digg_btn_small"><a href="<?= $story['href'] ?>" title="<?= htmlentities($story->title) ?> on Digg"><?= $story['diggs'] ?></a></p>
                <p><a href="<?= $story['link'] ?>" title="<?= htmlentities($story->title) ?>"><?= $story->title ?></a></p>
                <br class="break" />
            </div>
        <?php } ?>
    </div>
    <div id="fans">
    	<h3><?= $nrfans ?> latest fans</h3>
        <?php foreach ($fans->user as $fan) { ?>
			<a href="http://digg.com/users/<?= $fan['name']?>" title="<?= $fan['fullname'] ?>"><img src="<?= $fan['icon'] ?>" alt="<?= $fan['fullname'] ?>" width="24" height="24" /></a>
		<?php } ?>
    </div>
</div>

</body>
</html>