<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>Personalized Twitter Page</title>
<link rel="stylesheet" type="text/css" href="twitter.css" />
</head>
<?php
// Set User Variables
$username = 'USERNAME_NOT_EMAIL';
$password = 'PASSWORD';
$nrtweets = 10; // Max = 20
$nrfriends = 5; // Max = 20
$nrfollowers = 10; // Max = 100

/////////// DON'T EDIT BELOW THIS LINE /////////

// Retrieve user XML and place in object
// Use @ to hide password if file loading fails
$url = "http://$username:$password@twitter.com/statuses/user_timeline.xml";
$xml = @simplexml_load_file($url);
if (!$xml)
	die('Unable to load XML from Twitter. Please try again.');

// Retrieve personal information
$personalinfo = $xml->status->user;

// Retrieve friends XML and place in object
$url = "http://$username:$password@twitter.com/statuses/friends_timeline.xml";
$fxml = @simplexml_load_file($url);
if (!$fxml)
	die('Unable to load XML from Twitter. Please try again.');

?>
<body>

<div id="twitter">
    <div id="personal">
        <h1><a href="http://twitter.com/<?= $username ?>"><?= $personalinfo->name ?></a></h1>
        <a href="<?= $personalinfo->url ?>"><img src="<?= $personalinfo->profile_image_url ?>" alt="Twitter Picture" /></a>
        <p><?= $personalinfo->description ?></p>
        <p>Currently <strong><?= $personalinfo->followers_count ?></strong> tweeters are following me.</p>
    </div>
    <div id="tweets">
    <h2>Latest <?= $nrtweets ?> tweets</h2>
    	<?php
		for ($i = 0; $i < $nrtweets; $i++)
		{
		?>
			<p><?= htmlentities($xml->status[$i]->text) ?>
            <?php
			// Check if message is a reply
			// If true, show reply buttons
			if (!empty($xml->status[$i]->in_reply_to_user_id))
			{
				// Retrieve the friends XML to find the URL
				$url= "http://twitter.com/statuses/user_timeline/" . $xml->status[$i]->in_reply_to_user_id . ".xml";
				$rxml = @simplexml_load_file($url);
				if (!$rxml)
					die('Unable to load XML from Twitter. Please try again.');
				echo '<a href="http://twitter.com/' . $rxml->status->user->screen_name . '/statuses/'. $xml->status[$i]->in_reply_to_status_id .'">
				<img src="reply.png" alt="Reply to ' . $rxml->status->user->screen_name . '" /></a>&nbsp;
				<a href="http://twitter.com/' . $rxml->status->user->screen_name . '"><img src="'.$rxml->status->user->profile_image_url.'" alt="'.$rxml->status->user->screen_name.'" width="16" height="16"></a>';
			}
			
			?></p>
        <?php	
		}
		?>
    </div>
    <div id="friends">
    <h3>Latest <?= $nrfriends ?> tweets from my friends</h3>
    	<?php
		for ($i = 0; $i < $nrfriends; $i++)
		{
		?>
        <div id="friend_tweet">
        	<a href="http://twitter.com/<?= $fxml->status[$i]->user->screen_name ?>"><img src="<?= $fxml->status[$i]->user->profile_image_url ?>" alt="<?= $fxml->status[$i]->user->screen_name ?>" /></a>
            <p><em><?= $fxml->status[$i]->user->name ?>: </em> <?= $fxml->status[$i]->text ?>
            <?php
            // Check if message is a reply
			// If true, show reply buttons
			if (!empty($fxml->status[$i]->in_reply_to_user_id))
			{
				// Retrieve the friends XML to find the URL
				$url= "http://twitter.com/statuses/user_timeline/" . $fxml->status[$i]->in_reply_to_user_id . ".xml";
				$rxml = @simplexml_load_file($url);
				if (!$rxml)
					die('Unable to load XML from Twitter. Please try again.');
				echo '<a href="http://twitter.com/' . $rxml->status->user->screen_name . '/statuses/'. $fxml->status[$i]->in_reply_to_status_id .'">
				<img src="reply.png" alt="Reply to ' . $rxml->status->user->screen_name . '" /></a>&nbsp;
				<a href="http://twitter.com/' . $rxml->status->user->screen_name . '"><img src="'.$rxml->status->user->profile_image_url.'" alt="'.$rxml->status->user->screen_name.'" width="16" height="16"></a>';
			}
			?>
            </p>
        </div>
        <?php
		}
		?>
    </div>
    <div id="followers">
    <h3><?= $nrfollowers ?> random followers</h3>
		<?php
		// Retrieve the followers XML file
		$url = "http://$username:$password@twitter.com/statuses/followers.xml";
		$flxml = @simplexml_load_file($url);
		if (!$flxml)
			die('Unable to load XML from Twitter. Please try again.');
		
		// Place all followers in an array
		$followers = array();
		foreach ($flxml->user as $follower)
		{
			array_push($followers, $follower);
		}
		
		// Randomize the array
		shuffle($followers);
		
		// Show random friends
		for ($i = 0; $i < $nrfollowers; $i++)
		{
			echo '<a href="http://twitter.com/'. $followers[$i]->screen_name .'"><img src="'. $followers[$i]->profile_image_url .'" width="24" height="24" alt="'. $followers[$i]->screen_name .' is following me" /></a>';
		}
		?>
    </div>
</div>

</body>
</html>
