<?php
/**
* referral.php ,v 1.0
* http://creativecommons.org/licenses/by-sa/3.0/
* http://www.marcofolio.net/
*
* Referral checks where users came from & allows you to give
* them a personalized message
*
* Make sure you read the README.txt before configuring this file
*/

	/**
	* Initalize the variables
	**/

	// Textbox settings
	$box_bgcolor = "EEF0EF";
	$box_useImage = "true";
	$box_txtStyle = "2";
	// 1 = Bold, 2 = Italic, 3 = Underline
	// 4 = Bold + Italic, 5 = Bold + Underline
	// 6 = Italic + Underline, 7 = Bold, Italic, Underline
	$box_txtAlign = "left";
	$box_txtColor = "CC3300";
	$box_txtSize = "10";
	$box_paddingTop = "5";
	$box_paddingRight = "20";
	$box_paddingBottom = "5";
	$box_paddingLeft = "60";
	$box_useBorderTop = "true";
	$box_useBorderRight = "false";
	$box_useBorderBottom = "true";
	$box_useBorderLeft = "false";
	$box_borderSize = "2";
	$box_borderColor = "666666";
	$box_borderStyle = "solid";
	$box_button = "small";

	// Referral settings
	$ref_new = "true";
	$ref_new_msg = "You're new! If you like it here, please subscribe to my feed.";
	$ref_new_icon = "rss.png";

	// Social bookmarking websites
	$ref_digg = "true";
	$ref_digg_msg = "Welcome <strong>Digg</strong> user! If you like this article, please consider a digg.";
	$ref_digg_button = "true";
	$ref_reddit = "true";
	$ref_reddit_msg = "Welcome <strong>Reddit</strong> user! If you like this article, please give me some points.";
	$ref_reddit_button = "true";
	$ref_delicious = "true";
	$ref_delicious_msg = "Welcome <strong>del.icio.us</strong> user! Don't forget to save this page to your bookmarks.";
	$ref_facebook = "true";
	$ref_facebook_msg = "Welcome <strong>Facebook</strong> user!";
	$ref_slashdot = "true";
	$ref_slashdot_msg = "Welcome <strong>Slashdot</strong> user!";
	$ref_technorati = "true";
	$ref_technorati_msg = "Welcome <strong>Technorati</strong> user!";
	$ref_stumbleupon = "true";
	$ref_stumbleupon_msg = "Welcome <strong>StumbleUpon</strong> user! If you like this article, simply give it a thumbs up.";
	$ref_fark = "true";
	$ref_fark_msg = "Welcome <strong>Fark</strong> user!";
	$ref_newsvine = "true";
	$ref_newsvine_msg = "Welcome <strong>Newsvine</strong> user!";
	$ref_blinklist = "true";
	$ref_blinklist_msg = "Welcome <strong>Blinklist</strong> user!";
	$ref_propeller = "true";
	$ref_propeller_msg = "Welcome <strong>Propeller</strong> user!";
	$ref_mybloglog = "true";
	$ref_mybloglog_msg = "Welcome <strong>MyBlogLog</strong> user!";
	$ref_magnolia = "true";
	$ref_magnolia_msg = "Welcome <strong>Ma.gnolia</strong> user!";
	$ref_squidoo = "true";
	$ref_squidoo_msg = "Welcome <strong>Squidoo</strong> user!";
	$ref_blogmarks = "true";
	$ref_blogmarks_msg = "Welcome <strong>Blogmarks</strong> user!";
	$ref_simpy = "true";
	$ref_simpy_msg = "Welcome <strong>Simpy</strong> user!";
	$ref_shoutwire = "true";
	$ref_shoutwire_msg = "Welcome <strong>Shoutwire</strong> user!";
	$ref_tailrank = "true";
	$ref_tailrank_msg = "Welcome <strong>Tailrank</strong> user!";
	$ref_dzone = "true";
	$ref_dzone_msg = "Welcome <strong>DZone</strong> user!";
	$ref_furl = "true";
	$ref_furl_msg = "Welcome <strong>Furl</strong> user!";
	$ref_sphinn = "true";
	$ref_sphinn_msg = "Welcome <strong>Sphinn</strong> user! Please sphinn this article.";
	$ref_sphinn_button = "true";
	$ref_designfloat = "true";
	$ref_designfloat_msg = "Welcome <strong>Designfloat</strong> user! Don't forget to float this article if you like it.";
	$ref_designfloat_button = "true";

	// Search engines
	$ref_google = "true";
	$ref_google_msg = "Welcome <strong>Google</strong> user! Did you find what you were looking for? Have a nice stay.";
	$ref_live = "true";
	$ref_live_msg = "Welcome <strong>Live</strong> user! Did you find what you were looking for? Have a nice stay.";
	$ref_yahoo = "true";
	$ref_yahoo_msg = "Welcome <strong>Yahoo</strong> user! Did you find what you were looking for? Have a nice stay.";

	// Custom websites
	$ref_custom1 = "true";
	$ref_custom1_url = "marcofolio.net";
	$ref_custom1_msg = "Welcome Marcofolio.net user!";
	$ref_custom1_icon = "marcofolio.png";
	$ref_custom2 = "true";
	$ref_custom2_url = "feedburner.com";
	$ref_custom2_msg = "Welcome back RSS feed reader! I'm sure you'll like this new article.";
	$ref_custom2_icon = "rss.png";
	$ref_custom3 = "false";
	$ref_custom3_url = "";
	$ref_custom3_msg = "";
	$ref_custom3_icon = "";
	$ref_custom4 = "false";
	$ref_custom4_url = "";
	$ref_custom4_msg = "";
	$ref_custom4_icon = "";
	$ref_custom5 = "false";
	$ref_custom5_url = "";
	$ref_custom5_msg = "";
	$ref_custom5_icon = "";

	// Other websites
	$ref_blogrush = "true";
	$ref_blogrush_msg = "Welcome <strong>BlogRush</strong> user! Feel free to subscribe to my RSS feed if you liked this article.";



	/**
	* For basic usage, DON'T edit anyting under this line
	* unless you have some PHP knowledge
	* ______________________________________________________________________________
	**/

	// Fixing some variables for CSS
	$box_txtSize = $box_txtSize . "px";
	$box_borderSize = $box_borderSize . "px";
	$box_padding = $box_paddingTop . "px " . $box_paddingRight . "px " . $box_paddingBottom . "px " . $box_paddingLeft . "px";


	// Get the server HTTP Referer
	$referral = $_SERVER['HTTP_REFERER'];
	// All to lowercase
	$referral = strtolower($referral);

	// Only get the referral website
	$referral = explode ("/", $referral);
	$referral = $referral[2];

	// Remove www. from the Referer
	if (substr ($referral, 0, 4) == "www.")
	{
		$referral = substr ("$referral", 4);
	}

	// Remove subdomain from the Referer
	// Fix for fake subdomain of del.icio.us & ma.gnolia.com
	if ($referral != "del.icio.us" && $referral != "ma.gnolia.com")
	{
		$referral = explode (".", $referral);
		$i = count($referral);
		$referral = $referral[$i-2] . "." . $referral[$i-1];
	}

	// Fix to cover all Google domains, such as Google.com, Google.co.uk, Google.nl etc.
	if (substr ($referral, 0, 6) == "google")
	{
		$referral = "google";
	}

	/**
	* Start Referral checking
	**/
	$message = "";

	// Social Bookmarking Websites
	if ($referral == "digg.com" && $ref_digg = "true")
	{
		$message = $ref_digg_msg;
		$icon = "digg.png";
		if ($ref_digg_button == "true")
		{
			if ($box_button == "small")
			{
				$button = "<script type=\"text/javascript\">digg_skin = 'compact'; digg_window = 'new';</script><script src=\"http://digg.com/tools/diggthis.js\" type=\"text/javascript\"></script>";
			}
			else
			{
				$button = "<script src=\"http://digg.com/tools/diggthis.js\" type=\"text/javascript\"></script>";
			}
		}
	}
	else if ($referral == "reddit.com" && $ref_reddit = "true")
	{
		$message = $ref_reddit_msg;
		$icon = "reddit.png";
		if ($ref_reddit_button == "true")
		{
			if ($box_button == "small")
			{
				$button = "<script type=\"text/javascript\" src=\"http://reddit.com/button.js?t=1\"></script>";
			}
			else
			{
				$button = "<script type=\"text/javascript\" src=\"http://reddit.com/button.js?t=3\"></script>";
			}
		}
	}
	else if ($referral == "del.icio.us" && $ref_delicious = "true")
	{
		$message = $ref_delicious_msg;
		$icon = "delicious.png";
	}
	else if ($referral == "facebook.com" && $ref_facebook = "true")
	{
		$message = $ref_facebook_msg;
		$icon = "facebook.png";
	}
	else if ($referral == "slashdot.org" && $ref_slashdot = "true")
	{
		$message = $ref_slashdot_msg;
		$icon = "slashdot.png";
	}
	else if ($referral == "technorati.com" && $ref_technorati = "true")
	{
		$message = $ref_technorati_msg;
		$icon = "technorati.png";
	}
	else if ($referral == "stumbleupon.com" && $ref_stumbleupon = "true")
	{
		$message = $ref_stumbleupon_msg;
		$icon = "stumbleupon.png";
	}
	else if ($referral == "fark.com" && $ref_fark = "true")
	{
		$message = $ref_fark_msg;
		$icon = "fark.png";
	}
	else if ($referral == "newsvine.com" && $ref_newsvine = "true")
	{
		$message = $ref_newsvine_msg;
		$icon = "newsvine.png";
	}
	else if ($referral == "blinklist.com" && $ref_blinklist = "true")
	{
		$message = $ref_blinklist_msg;
		$icon = "blinklist.png";
	}
	else if ($referral == "propeller.com" && $ref_propeller = "true")
	{
		$message = $ref_propeller_msg;
		$icon = "propeller.png";
	}
	else if ($referral == "mybloglog.com" && $ref_mybloglog = "true")
	{
		$message = $ref_mybloglog_msg;
		$icon = "mybloglog.png";
	}
	else if ($referral == "ma.gnolia.com" && $ref_magnolia = "true")
	{
		$message = $ref_magnolia_msg;
		$icon = "magnolia.png";
	}
	else if ($referral == "squidoo.com" && $ref_squidoo = "true")
	{
		$message = $ref_squidoo_msg;
		$icon = "squidoo.png";
	}
	else if ($referral == "blogmarks.net" && $ref_blogmarks = "true")
	{
		$message = $ref_blogmarks_msg;
		$icon = "blogmarks.png";
	}
	else if ($referral == "simpy.com" && $ref_simpy = "true")
	{
		$message = $ref_simpy_msg;
		$icon = "simpy.png";
	}
	else if ($referral == "shoutwire.com" && $ref_shoutwire = "true")
	{
		$message = $ref_shoutwire_msg;
		$icon = "shoutwire.png";
	}
	else if ($referral == "tailrank.com" && $ref_tailrank = "true")
	{
		$message = $ref_tailrank_msg;
		$icon = "tailrank.png";
	}
	else if ($referral == "dzone.com" && $ref_dzone = "true")
	{
		$message = $ref_dzone_msg;
		$icon = "dzone.png";
	}
	else if ($referral == "furl.net" && $ref_furl = "true")
	{
		$message = $ref_furl_msg;
		$icon = "furl.png";
	}
	else if ($referral == "sphinn.com" && $ref_sphinn = "true")
	{
		$message = $ref_sphinn_msg;
		$icon = "sphinn.png";
		if ($ref_sphinn_button == "true")
		{
			$button = "<script type=\"text/javascript\" src=\"http://sphinn.com/evb/button.php\"></script>";
		}
	}
	else if ($referral == "designfloat.com" && $ref_designfloat = "true")
	{
		$message = $ref_designfloat_msg;
		$icon = "designfloat.png";
		if ($ref_designfloat_button == "true")
		{
			if ($box_button == "small")
			{
				$button = "<script type=\"text/javascript\" src=\"http://www.designfloat.com/evb/button.php\"></script>";
			}
			else
			{
				$button = "<script type=\"text/javascript\" src=\"http://www.designfloat.com/evb2/button.php\"></script>";
			}
		}
	}

	// Search engines
	else if ($referral == "google" && $ref_google = "true")
	{
		$message = $ref_google_msg;
		$icon = "google.png";
	}
	else if ($referral == "live.com" && $ref_live = "true")
	{
		$message = $ref_live_msg;
		$icon = "live.png";
	}
	else if ($referral == "yahoo.com" && $ref_yahoo = "true")
	{
		$message = $ref_yahoo_msg;
		$icon = "yahoo.png";
	}

	// Custom websites
	else if ($referral == $ref_custom1_url && $ref_custom1 = "true")
	{
		$message = $ref_custom1_msg;
		$icon = $ref_custom1_icon;
	}
	else if ($referral == $ref_custom2_url && $ref_custom2 = "true")
	{
		$message = $ref_custom2_msg;
		$icon = $ref_custom2_icon;
	}
	else if ($referral == $ref_custom3_url && $ref_custom3 = "true")
	{
		$message = $ref_custom3_msg;
		$icon = $ref_custom3_icon;
	}
	else if ($referral == $ref_custom4_url && $ref_custom4 = "true")
	{
		$message = $ref_custom4_msg;
		$icon = $ref_custom4_icon;
	}
	else if ($referral == $ref_custom5_url && $ref_custom5 = "true")
	{
		$message = $ref_custom5_msg;
		$icon = $ref_custom5_icon;
	}


	// Other websites
	else if ($referral == "blogrush.com" && $ref_blogrush = "true")
	{
		$message = $ref_blogrush_msg;
		$icon = "blogrush.png";
	}
	else if ($ref_new = "true")
	{
		$message = $ref_new_msg;
		$icon = $ref_new_icon;
	}

	// Exclude your own domain or direct page loading
	$urlstring = $_SERVER['HTTP_HOST'];
	preg_match("/^(http:\/\/)?([^\/]+)/i", $urlstring, $result);
	$domain = $result[2];
	
	// Remove www. from the domain
	if (substr ($domain, 0, 4) == "www.")
	{
		$domain = substr ("$domain", 4);
	}

	// Remove any subdomain names domain
	$domain = explode (".", $domain);
	$i = count($domain);
	$domain = $domain[$i-2] . "." . $domain[$i-1];
	
	if ($referral != $domain && $referral != "." && $message != "")
	{
		// Create the message box
		echo "<!-- Start referral plugin by Marcofolio.net -->\n";
		echo "<p style=\"background: #$box_bgcolor";
		if ($box_useImage == "true")
		{
			echo " url(icon/$icon) center no-repeat;";
			echo " background-position: 15px 50%;";
		}
		else
		{
			echo ";";
		}
		echo " text-align: $box_txtAlign;";
		echo "color: #$box_txtColor;";
		if ($box_txtStyle == "1" || $box_txtStyle == "4" || $box_txtStyle == "5" || $box_txtStyle == "7")
		{
			echo "font-weight: bold;";
		}
		if ($box_txtStyle == "2" || $box_txtStyle == "4" || $box_txtStyle == "6" || $box_txtStyle == "7")
		{
			echo "font-style: italic;";
		}
		if ($box_txtStyle == "3" || $box_txtStyle == "5" || $box_txtStyle == "6" || $box_txtStyle == "7")
		{
			echo "text-decoration: underline;";
		}
		echo "font-size: $box_txtSize;";
		echo "padding: $box_padding;";
		if ($box_useBorderTop == "true")
		{
			echo "border-top: $box_borderSize $box_borderStyle #$box_borderColor;";
		}
		if ($box_useBorderRight == "true")
		{
			echo "border-right: $box_borderSize $box_borderStyle #$box_borderColor;";
		}
		if ($box_useBorderBottom == "true")
		{
			echo "border-bottom: $box_borderSize $box_borderStyle #$box_borderColor;";
		}
		if ($box_useBorderLeft == "true")
		{
			echo "border-left: $box_borderSize $box_borderStyle #$box_borderColor;";
		}
		echo "\">\n$button$message\n</p>";
		echo "\n<!-- End referral plugin by Marcofolio.net -->";
	}
?>