<?php

/**
* rss_count.php,v 1.0
* @copyright (C) 2008 Marcofolio.net
* http://www.marcofolio.net/
*
* Use the Feedburner Awareness to show off your feedcount
* and use an external image
*/

// Let the browser know we're sending an PNG image
Header ("Content-type: image/png");

// Load the PNG file to use
$img_handle = imageCreateFromPNG("rss_count.png");

// Set the text color (RGB)
$color = ImageColorAllocate ($img_handle, 255, 250, 235);

// Load Feedburner Awareness
$xml = simplexml_load_file("http://api.feedburner.com/awareness/1.0/GetFeedData?uri=marcofolio") or die ("Unable to load XML file!");

// Load Feedcount
$circulation = $xml->feed->entry['circulation'];

// Set the font (Only GDF files)
$font = imageloadfont("bmcorrode.gdf");

// Set the text
$line1 = "$circulation readers";
$line2 = "subscribed here.";
$line3 = "Subscribe today!";

// Write the lines (Image used, font used, x-pos, y-pos, text, color)
ImageString ($img_handle, $font, 100, 10, $line1, $color);
ImageString ($img_handle, $font, 100, 30, $line2, $color);
ImageString ($img_handle, $font, 120, 70, $line3, $color);

ImagePng ($img_handle);
ImageDestroy ($img_handle); 
?>