/*
* Author:      Marco Kuiper (http://www.marcofolio.net/)
*              Sylvain Papet (http://www.com-ocean.com/)
*/
    
(function($) {
  $.bgimgSlideshow = {version: '1.0.0'};
  
  $.fn.bgimgSlideshow = function(options) {
    options = jQuery.extend({
      slideshowSpeed: 6000,
      photos : [],
      markup: '<div id="background">\
  <div id="bis_images">\
    <div id="bis_image1" class="bis_image"></div>\
    <div id="bis_image2" class="bis_image"></div>\
  </div>\
  <div id="bis_container">\
    <div id="bis_nav">\
       <div id="bis_back" class="bis_btn"></div>\
       <div id="bis_control" class="bis_btn"></div>\
       <div id="bis_next" class="bis_btn"></div>\
    </div>\
    <div id="bis_caption">\
      <p class="bis_title">\
         <a href="#" id="bis_titlelink"></a>\
      </p>\
    </div>\
  </div>\
</div>'
      },options);

    var interval;
    var activeContainer = 1;	
    var currentImg = 0;
    var started = false;
    var animating = false;
    var currentZindex = -1;
    
    var image_cache = [];

    $.bgimgSlideshow.preLoadImage = function() {
      var args_len = arguments.length;
      for (var i = args_len; i--;) {
        var cacheImage = document.createElement('img');
        cacheImage.src = arguments[i];
        image_cache.push(cacheImage);
      }
    }

    $.bgimgSlideshow.preLoadPhotoObjects = function(photoObjects) {
      for(i in photoObjects)
      {
        $.bgimgSlideshow.preLoadImage(photoObjects[i].image, photoObjects[i].image);
      }
    }

    $.bgimgSlideshow.initialize = function() {
      $('body').prepend(options.markup);
      $.bgimgSlideshow.preLoadPhotoObjects(options.photos);
  
      // Backwards navigation
      $("#bis_back").click(function() {
      	$.bgimgSlideshow.stopSlideshow();
      	$.bgimgSlideshow.navigate("back");
      });
      
      // Forward navigation
      $("#bis_next").click(function() {
        $.bgimgSlideshow.stopSlideshow();
      	$.bgimgSlideshow.navigate("next");
      });
      
      $("#bis_control").click(function(){ 
        if(started)
        {
          $.bgimgSlideshow.stopSlideshow();
        }
        else
        {
          $.bgimgSlideshow.startSlideshow();
        }
      });
      $.bgimgSlideshow.startSlideshow();
    };
    
    $.bgimgSlideshow.navigate = function(direction) {
    	// Check if no animation is running. If it is, prevent the action
    	if(animating) {
    		return;
    	}
    	
    	// Check which current image we need to show
    	if(direction == "next") {
    		currentImg++;
    		if(currentImg == photos.length + 1) {
    			currentImg = 1;
    		}
    	} else {
    		currentImg--;
    		if(currentImg == 0) {
    			currentImg = photos.length;
    		}
    	}
    	
    	// Check which container we need to use
    	var currentContainer = activeContainer;
    	if(activeContainer == 1) {
    		activeContainer = 2;
    	} else {
    		activeContainer = 1;
    	}
    	
    	$.bgimgSlideshow.showImage((currentImg - 1), currentContainer, activeContainer);
    };
    
    $.bgimgSlideshow.showImage = function(numImg, currentContainer, activeContainer) {
      var photoObject = options.photos[numImg];
    	animating = true;
    	
    	// Make sure the new container is always on the background
    	currentZindex--;
    	
    	// Set the background image of the new active container
    	$("#bis_image" + activeContainer).css({
    		"background-image" : "url(" + photoObject.image + ")",
    		"display" : "block",
    		"z-index" : currentZindex
    	});
    	
      if(photoObject.url)
      {
        $("#bis_caption p").html('<a href="'+photoObject.url+'" target="_blank">'+photoObject.title+'</a>');
      }
      else
      {
        $("#bis_caption p").html(photoObject.title);
      }

    	// Fade out the current container
    	// and display the header text when animation is complete
    	$("#bis_image" + currentContainer).fadeOut(function() {
    		setTimeout(function() {
    			animating = false;
    		}, 500);
    	});
    };

    $.bgimgSlideshow.stopSlideshow = function() {
    	// Change the background image to "play"
      $("#bis_control").css({ "background-image" : "url(/js/bgimg_slideshow/images/btn_play.png)" });
    	// Clear the interval
    	clearInterval(interval);
      started = false;
    };
    
    $.bgimgSlideshow.startSlideshow = function() {
      $("#bis_control").css({ "background-image" : "url(/js/bgimg_slideshow/images/btn_pause.png)" });
    	$.bgimgSlideshow.navigate("next");
    	interval = setInterval(function() { $.bgimgSlideshow.navigate("next"); }, options.slideshowSpeed);
      started = true;
    };    
        
    $.bgimgSlideshow.initialize();
    return this;
  }
 
})(jQuery);
