﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

// The following namespaces are added from the default
using System.Windows.Media.Effects;
using System.Windows.Media.Imaging;
using System.Windows.Threading;
using System.Collections.Generic;

namespace mouseFollower
{
	public partial class MainPage : UserControl
	{
		/// <summary>
		/// List that will contain references from the images in the mouse trail.
		/// </summary>
		private List<Image> trail = new List<Image>();
		
		/// <summary>
		/// Variable to store which cursor is currently showed.
		/// </summary>
		private int currentcursor = 0;

		/// <summary>
		/// List that will contain the URL's to cursors that we can use (images).
		/// </summary>
		private List<String> cursors = new List<String>();
		
		public MainPage()
		{
			// Required to initialize variables
			InitializeComponent();
			
			cursors.Add("http://demo.marcofolio.net/silverlight_mousefollower/images/arrow_circle_double.png");
			cursors.Add("http://demo.marcofolio.net/silverlight_mousefollower/images/plus_circle_frame.png");
			cursors.Add("http://demo.marcofolio.net/silverlight_mousefollower/images/multimedia-player-apple-ipod.png");
			cursors.Add("http://demo.marcofolio.net/silverlight_mousefollower/images/apple.png");
			cursors.Add("http://demo.marcofolio.net/silverlight_mousefollower/images/cursor.png");
			
			StartTimer();
		}
		
		/// <summary>
		/// Event that gets called when the mouse is moved over the layout (root screen).
		/// </summary>
		/// <param name="sender">Sender</param>
		/// <param name="e">Mouse event</param>
		private void LayoutRoot_MouseMove(object sender, System.Windows.Input.MouseEventArgs e)
		{
			// Retrieve X and Y position of the mouse
			double xPos = e.GetPosition(null).X;
			double yPos = e.GetPosition(null).Y;
			
			// Create a new image - Copy of the cursor for the trail
			Image copyImg = new Image();
			copyImg.Source = cursor.Source;
			copyImg.Width = cursor.Width;
			copyImg.Height = cursor.Height;
			copyImg.Margin = new Thickness(xPos, yPos, 0, 0);
			copyImg.Effect = new BlurEffect { Radius = 5 };
			copyImg.Opacity = 1;
			copyImg.HorizontalAlignment = HorizontalAlignment.Left;
			copyImg.VerticalAlignment = VerticalAlignment.Top;
			
			// Add the newly created image to the trail list
			trail.Add(copyImg);
			
			// Add the newly created image to the layout
			LayoutRoot.Children.Add(copyImg);
			
			// Place the current cursor on the mouse position
			cursor.Margin = new Thickness(xPos, yPos, 0, 0);
		}

		
		/// <summary>
		/// Timer to added to the page to use a delegate.
		/// </summary>
		public void StartTimer()
		{
			DispatcherTimer myDispatcherTimer = new System.Windows.Threading.DispatcherTimer();
			myDispatcherTimer.Interval = new TimeSpan(0, 0, 0, 0, 100); // 100 Milliseconds
			myDispatcherTimer.Tick += new EventHandler(FadeTrail); // Every 'tick' (100 Milliseconds), the "FadeTrail" function is called
			myDispatcherTimer.Start();
		}
		
		/// <summary>
		/// Delegate to be called once the timer is called to fade out the cursor trail.
		/// </summary>
		/// <param name="o"></param>
		/// <param name="sender"></param>
		public void FadeTrail(object o, EventArgs sender)
		{
			// Loop through all images in the trail and change the dimensions + opacity
			foreach(Image trailimg in trail) {
				trailimg.Opacity -= 0.1;
				trailimg.Width += 2;
				trailimg.Height += 2;
			}
		}
		
		/// <summary>
		/// Event to be called when the user clicked on the layout (root).
		/// </summary>
		/// <param name="sender">Sender</param>
		/// <param name="e">Mouse event</param>
		private void LayoutRoot_MouseLeftButtonUp(object sender, System.Windows.Input.MouseButtonEventArgs e)
		{
			// Change the cursor image
			Uri uri = new Uri(getNextCursor(), UriKind.Absolute);
			ImageSource imgSource = new BitmapImage(uri);
			cursor.Source = imgSource;
		}
		
		/// <summary>
		/// Retrieve the next cursor image url.
		/// </summary>
		/// <returns>The new image url.</returns>
		private string getNextCursor() {
			currentcursor++;
			if(currentcursor >= cursors.Count) {
				currentcursor = 0;
			}
			return cursors[currentcursor];
		}
		
	}
}