/*
* Author:      Marco Kuiper (http://www.marcofolio.net/)
*/

/**
* Global variables
*/

// Time for the interval to duplicate the dialog
var DUPLICATIONTIME = 100;

// Maxium count of windows before BSOD
var MAXWINDOWCOUNT = 100;

$(document).ready(function()
{
	// Place the error dialog in the center of the screen
	var offset = $("#errordialog").offset();
	var xPos = offset.left;
	var yPos = offset.top;
	$("#errordialog").css({
		'top' : yPos + 200 + 'px',
		'left' : xPos + 200 + 'px'	
	});
	
	
	// Handle for the intervalID
	var intervalId;
	
	// Make the dialog draggable
	$("#errordialog").draggable({
		handle : 'h3', // Only the heading is draggable
		containment : 'parent', // Prevent the window getting dragged out the parent
		start: function(event, ui) {
			// Create an interval when the user starts dragging the window
			intervalId = setInterval("duplicateWindow()", DUPLICATIONTIME);
		},
		stop: function(event, ui) {
			// Clear the interval when the user stopped dragging
			clearInterval(intervalId)
		}
	});
});


/**
* Function to duplicate the error dialog
*/
var windowCount = 0;
var errorDialogZIndex = 1;
function duplicateWindow() {
	// Clone the error dialog and append it to the Windows XP screen
	var clone = $("#errordialog").clone().appendTo('#windowsxp');
	
	// Bring the dragging error dialog up front by changing the Z-index
	errorDialogZIndex++;
	$("#errordialog").css('z-index', errorDialogZIndex);
	
	// Check if the maximum window count has been reached
	windowCount++;
	if(windowCount == MAXWINDOWCOUNT) {
		$("#windowsxp")
			.empty()
			.css('background-image', 'url(images/bsod.jpg)');
	}
}