<?xml version='1.0' encoding='utf-8' standalone='yes'?>

<!-- Microsoft Scripting Instrumentation Manifest for Chakra -->
<instrumentationManifest
    xmlns="http://schemas.microsoft.com/win/2004/08/events" 
    xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events"
    xmlns:xs="http://www.w3.org/2001/XMLSchema">
    <instrumentation>
        <events
            xmlns="http://schemas.microsoft.com/win/2004/08/events"
            xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events"
            xmlns:xs="http://www.w3.org/2001/XMLSchema"
            >
            <provider
                guid="{57277741-3638-4A4B-BDBA-0AC6E45DA56C}"
                message="$(string.JScriptProvider.Name)"
                messageFileName="%SystemRoot%\system32\Chakra.dll"
                name="Microsoft-JScript"
                resourceFileName="%SystemRoot%\system32\Chakra.dll"
                symbol="PROVIDER_JSCRIPT9"
                >
            <keywords>
                <keyword
                    mask="0x1"
                    name="JScriptRuntime"
                    symbol="JSCRIPT_RUNTIME_KEYWORD"
                    />
                <keyword
                    mask="0x2"
                    name="JScriptStartRundown"
                    symbol="JSCRIPT_RUNDOWNSTART_KEYWORD"
                    />
                <keyword
                    mask="0x4"
                    name="JScriptEndRundown"
                    symbol="JSCRIPT_RUNDOWNEND_KEYWORD"
                    />
                <keyword
                    mask="0x8"
                    name="JScriptGCBucketStats"
                    symbol="JSCRIPT_GC_BUCKET_STATS_KEYWORD"
                    />
                <keyword
                    mask="0x10"
                    name="JScriptProjection"
                    symbol="JSCRIPT_PROJECTION_KEYWORD"
                    />
                <keyword
                    mask="0x20"
                    name="JScriptFrontend"
                    symbol="JSCRIPT_FRONTED_KEYWORD"
                    />
                <keyword
                    mask="0x40"
                    name="JScriptGarbageCollection"
                    symbol="JSCRIPT_GC_KEYWORD"
                    />
                <keyword
                    mask="0x80"
                    name="JScriptProfile"
                    symbol="JSCRIPT_PROFILE_PERSISTENCE"
                    />
                <keyword
                    mask="0x100"
                    name="JscriptBackend"
                    symbol="JSCRIPT_BACKEND"
                    />
                <keyword
                    mask="0x200"
                    name="JscriptJit"
                    symbol="JSCRIPT_JIT"
                    />
                <keyword
                    mask="0x400"
                    name="JScriptMemoryTracing"
                    symbol="JSCRIPT_MEMORY_TRACING_KEYWORD"
                    />
                <keyword
                    mask="0x800"
                    name="JScriptObjectAllocation"
                    symbol="JSCRIPT_OBJECT_ALLOCATION_KEYWORD"
                    />
                <keyword
                    mask="0x1000"
                    name="JScriptExternalReferenceAddRef"
                    symbol="JSCRIPT_EXTERNAL_REFERENCE_ADDREF_KEYWORD"
                    />
                <keyword
                    mask="0x2000"
                    name="JScriptObjectCleanup"
                    symbol="JSCRIPT_OBJECT_CLEANUP_KEYWORD"
                    />
                <keyword
                    mask="0x4000"
                    name="JScriptExternalReferenceRelease"
                    symbol="JSCRIPT_EXTERNAL_REFERENCE_RELEASE_KEYWORD"
                    />
                <keyword
                    mask="0x8000"
                    name="JScriptAsyncCausality"
                    symbol="JSCRIPT_ASYNC_CAUSALITY"
                    />
                <keyword
                    mask="0x10000"
                    name="JScriptByteCode"
                    symbol="JSCRIPT_BYTE_CODE_KEYWORD"
                    />
                <keyword
                    mask="0x20000"
                    name="JScriptHosting"
                    symbol="JSCRIPT_HOSTING"
                    />
                <keyword
                    mask="0x40000"
                    name="JScriptStackTrace"
                    symbol="JSCRIPT_STACKTRACE_KEYWORD"
                    />
                <!-- JScriptAsyncCausality_V2 : versioned from JScriptAsyncCausality (can be used in debug/non-debug mode) -->
                <keyword
                    mask="0x80000"
                    name="JScriptAsyncCausality_V2"
                    symbol="JSCRIPT_ASYNC_CAUSALITY_V2"
                    />
                <keyword
                    mask="0x100000"
                    name="JScriptSourceMapping"
                    symbol="JSCRIPT_SOURCEMAPPING_KEYWORD"
                    />
                <keyword
                    mask="0x200000"
                    name="MemProtectGarbageCollection"
                    symbol="MEMPROTECT_GC_KEYWORD"
                    />
                <keyword
                    mask="0x400000"
                    name="MemProtectObjectAllocation"
                    symbol="MEMPROTECT_OBJECT_ALLOCATION_KEYWORD"
                    />
                <keyword
                    mask="0x800000"
                    name="MemProtectHeapSize"
                    symbol="MEMPROTECT_HEAP_SIZE_KEYWORD"
                    />
                <keyword
                    mask="0x1000000"
                    name="Internal"
                    symbol="INTERNAL_KEYWORD"
                    />
                <keyword
                    mask="0x2000000"
                    name="MemProtectGCBucketStats"
                    symbol="MEMPROTECT_GC_BUCKET_STATS_KEYWORD"
                    />
            </keywords>
            <tasks>
                <task
                    name="MethodRuntime"
                    symbol="JSCRIPT_METHOD_RUNTIME_TASK"
                    value="1"
                    >
                <opcodes>
                    <opcode
                        name="MethodLoad"
                        symbol="JSCRIPT_METHOD_METHODLOAD_OPCODE"
                        value="10"
                        />
                    <opcode
                        name="MethodUnload"
                        symbol="JSCRIPT_METHOD_METHODUNLOAD_OPCODE"
                        value="11"
                        />
                </opcodes>
                </task>
                <task
                    name="ScriptContextRuntime"
                    symbol="JSCRIPT_SCRIPTCONTEXT_RUNTIME_TASK"
                    value="2"
                    >
                <opcodes>
                    <opcode
                        name="ScriptContextLoad"
                        symbol="JSCRIPT_SCRIPTCONTEXT_LOAD_OPCODE"
                        value="10"
                        />
                    <opcode
                        name="ScriptContextUnload"
                        symbol="JSCRIPT_SCRIPTCONTEXT_UNLOAD_OPCODE"
                        value="11"
                        />
                    <opcode
                        name="SourceLoad"
                        symbol="JSCRIPT_SOURCELOAD_OPCODE"
                        value="12"
                        />
                    <opcode
                        name="SourceUnload"
                        symbol="JSCRIPT_SOURCEUNLOAD_OPCODE"
                        value="13"
                        />
                    <opcode
                        name="ScriptContextOnStartupComplete"
                        symbol="JSCRIPT_SCRIPTCONTEXT_ON_STARTUP_COMPLETE_OPCODE"
                        value="14"
                        />
                </opcodes>
                </task>
                <task
                    name="MethodRundown"
                    symbol="JSCRIPT_METHOD_RUNDOWN_TASK"
                    value="3"
                    >
                <opcodes>
                    <opcode
                        name="MethodDCStart"
                        symbol="JSCRIPT_METHODDC_METHODDCSTART_OPCODE"
                        value="10"
                        />
                    <opcode
                        name="MethodDCEnd"
                        symbol="JSCRIPT_METHODDC_METHODDCEND_OPCODE"
                        value="11"
                        />
                    <opcode
                        name="DCStartComplete"
                        symbol="JSCRIPT_METHODDC_DCSTARTCOMPLETE_OPCODE"
                        value="12"
                        />
                    <opcode
                        name="DCEndComplete"
                        symbol="JSCRIPT_METHODDC_DCENDCOMPLETE_OPCODE"
                        value="13"
                        />
                    <opcode
                        name="DCStartInit"
                        symbol="JSCRIPT_METHODDC_DCSTARTINIT_OPCODE"
                        value="14"
                        />
                    <opcode
                        name="DCEndInit"
                        symbol="JSCRIPT_METHODDC_DCENDINIT_OPCODE"
                        value="15"
                        />
                </opcodes>
                </task>
                <task
                    name="ScriptContextRundown"
                    symbol="JSCRIPT_SCRIPTCONTEXT_RUNDOWN_TASK"
                    value="4"
                    >
                <opcodes>
                    <opcode
                        name="ScriptContextDCStart"
                        symbol="JSCRIPT_SCRIPTCONTEXT_DCSTART_OPCODE"
                        value="10"
                        />
                    <opcode
                        name="ScriptContextDCEnd"
                        symbol="JSCRIPT_SCRIPTCONTEXT_DCEND_OPCODE"
                        value="11"
                        />
                    <opcode
                        name="SourceDCStart"
                        symbol="JSCRIPT_SOURCE_DCSTART_OPCODE"
                        value="12"
                        />
                    <opcode
                        name="SourceDCEnd"
                        symbol="JSCRIPT_SOURCE_DCEND_OPCODE"
                        value="13"
                        />
                </opcodes>
                </task>
                <task
                    eventGUID="{65E6EC90-7758-4FA8-B88A-261197151E49}"
                    name="Jscript_Projection_ResolveType"
                    value="5"
                    />
                <task
                    eventGUID="{fa44B46D-38DF-4cC2-0A76-167DE98FA621}"
                    name="Jscript_Projection_ConstructRuntimeClass"
                    value="6"
                    />
                <task
                    eventGUID="{e044B46D-38DF-4cC2-0A76-167DE98FB661}"
                    name="Jscript_Projection_MethodCall"
                    value="7"
                    />
                <task
                    eventGUID="{C944B46D-38DF-4cC2-0A86-167DE98FA621}"
                    name="Jscript_Projection_RawMethodCall"
                    value="8"
                    />
                <task
                    eventGUID="{9A94B47D-8aDF-5DC2-0A86-167DE98FA623}"
                    name="Jscript_Projection_InvokesJsDelegate"
                    value="9"
                    />
                <task
                    eventGUID="{9A94B47D-FDa8-5DC2-0A86-167DE98FA624}"
                    name="Jscript_Projection_InvokeNativeDelegate"
                    value="10"
                    />
                <task
                    eventGUID="{9A9c947D-8aDF-5DC2-0A86-167DE98FAD23}"
                    name="Jscript_Projection_AddEventListener"
                    value="11"
                    />
                <task
                    eventGUID="{ab9c947D-8aeF-5DC2-0A86-167DE98FAD02}"
                    name="Jscript_Projection_RemoveEventListener"
                    value="12"
                    />
                <task
                    eventGUID="{6D44B4fA-38DF-4cC2-0A76-167DE98FA631}"
                    name="Jscript_Projection_GetTypeMetaDataInformation"
                    value="13"
                    />
                <task
                    eventGUID="{4C42D2AC-7B3E-48AB-91CE-C7E3FFACF8BF}"
                    name="Jscript_Projection_SetEventHandler"
                    value="14"
                    />
                <task
                    eventGUID="{B4FB623E-A94C-4226-B0E4-FC8253F29DE5}"
                    name="Jscript_Projection_RemoveAllEventsAndEventHandlers"
                    value="15"
                    />
                <task
                    eventGUID="{F0C3C89F-C1D3-46E6-8523-2D4B71E29194}"
                    name="Jscript_Projection_InvokeEvent"
                    value="16"
                    />
                <task
                    eventGUID="{670B4B95-BAF8-42E1-A1FD-BFD478CBF720}"
                    name="Jscript_Projection_InvokeEventEvParamPrep"
                    value="17"
                    />
                <task
                    eventGUID="{90DF5CDF-6EED-47A4-B698-548C7ABF4FE9}"
                    name="Jscript_Projection_GetExprFromConcreteTypeName"
                    value="18"
                    />
                <task
                    eventGUID="{17395D83-1E5C-43AD-A5D4-41631D334F3C}"
                    name="Jscript_Projection_GetTypeFromTypeNameParts"
                    value="19"
                    />
                <task
                    eventGUID="{97B5C7A6-8CC5-4E4D-BB85-3887ED687304}"
                    name="Jscript_Projection_ReferenceOrArrayGetValue"
                    value="20"
                    />
                <task
                    eventGUID="{8A960840-27EA-487F-B7C0-7A6E8764563E}"
                    name="Jscript_Projection_PropertyValueVarFromGRCN"
                    value="21"
                    />
                <task
                    eventGUID="{9FCF06D2-7907-46B4-A2E4-4B5632945965}"
                    name="Jscript_Projection_VarFromGRCN"
                    value="22"
                    />
                <task
                    eventGUID="{1EBC5E72-4C4A-455E-A9AA-53C11B32E3E1}"
                    name="Jscript_Projection_WriteIReference"
                    value="23"
                    />
                <task
                    eventGUID="{48B75069-B48D-404B-9545-9240B69CB7F3}"
                    name="Jscript_Projection_WriteInspectable"
                    value="24"
                    />
                <task
                    eventGUID="{60990A40-3DC5-418E-8C2E-08E5FADE7F8D}"
                    name="Jscript_Projection_GetNonArrayTypeAsPropertyValue"
                    value="25"
                    />
                <task
                    eventGUID="{3D8FEDCE-CF8E-4D65-8EB9-BD1CBBC890D5}"
                    name="Jscript_Projection_GetNonArrayBasicTypeAsPropertyValue"
                    value="26"
                    />
                <task
                    eventGUID="{1DC3AB0F-3C64-405A-9852-5895C133F9A8}"
                    name="Jscript_Projection_GetTypedArrayAsPropertyValue"
                    value="27"
                    />
                <task
                    eventGUID="{4110D5BD-5FF8-4FF2-A33D-D1B92B127606}"
                    name="Jscript_Projection_GetBasicTypedArrayAsPropertyValue"
                    value="28"
                    />
                <task
                    name="GenerateBytecodeMethod"
                    value="29"
                    />
                <task
                    name="ParseMethod"
                    value="30"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcd4}"
                    name="Jscript_GC_ResetMarks"
                    value="31"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcd5}"
                    name="Jscript_GC_ScanRoots"
                    value="32"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcd6}"
                    name="Jscript_GC_ScanStack"
                    value="33"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcd7}"
                    name="Jscript_GC_Mark"
                    value="34"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcd8}"
                    name="Jscript_GC_Rescan"
                    value="35"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcd9}"
                    name="Jscript_GC_Sweep"
                    value="36"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcda}"
                    name="Jscript_GC_SetupBackgroundSweep"
                    value="37"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcdb}"
                    name="Jscript_GC_BackgroundSweep"
                    value="38"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcdc}"
                    name="Jscript_GC_TransferSweptObjects"
                    value="39"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcdd}"
                    name="Jscript_GC_Dispose"
                    value="40"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcde}"
                    name="Jscript_GC_BackgroundMark"
                    value="41"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcdf}"
                    name="Jscript_GC_ResetWriteWatch"
                    value="42"
                    />
                <task
                    name="Jscript_Profile_Persistence"
                    value="43"
                    >
                <opcodes>
                    <opcode
                        name="Load"
                        symbol="JSCRIPT_LOAD"
                        value="15"
                        />
                    <opcode
                        name="Save"
                        symbol="JSCRIPT_SAVE"
                        value="16"
                        />
                </opcodes>
                </task>
                <task
                    name="Jscript_Backend_Inline"
                    value="44"
                    />
                <task
                    name="Jscript_Method_Jit"
                    value="45"
                    >
                <opcodes>
                    <opcode
                        name="Start"
                        symbol="JSCRIPT_JIT_START"
                        value="17"
                        />
                    <opcode
                        name="Stop"
                        symbol="JSCRIPT_JIT_STOP"
                        value="18"
                        />
                    <opcode
                        name="Queue"
                        symbol="JSCRIPT_JIT_QUEUE"
                        value="19"
                        />
                    <opcode
                        name="Dequeue"
                        symbol="JSCRIPT_JIT_DEQUEUE"
                        value="20"
                        />
                </opcodes>
                </task>
                <task
                    eventGUID="{196a6ce6-8826-4d5f-9b33-55ba2d3accbe}"
                    name="Jscript_GC_IdleCollect"
                    value="46"
                    />
                <task
                    eventGUID="{313cb172-9dd2-4f8c-a41f-baf742647490}"
                    name="Jscript_Page_Allocator_Size"
                    symbol="JSCRIPT_PAGE_ALLOCATOR_SIZE_TASK"
                    value="47"
                    >
                <opcodes>
                    <opcode
                        name="UsedPageSize"
                        symbol="JSCRIPT_PAGE_USED_SIZE"
                        value="10"
                        />
                </opcodes>
                </task>
                <task
                    eventGUID="{2d68a40e-b890-4c6f-8c2e-b4c856cc21cf}"
                    name="Jscript_Recycler_Allocation"
                    value="48"
                    >
                <opcodes>
                    <opcode
                        name="Free_Memory"
                        symbol="JSCRIPT_FREE_MEMORY"
                        value="10"
                        />
                    <opcode
                        name="Free_Memory_Block"
                        symbol="JSCRIPT_FREE_MEMORY_BLOCK"
                        value="11"
                        />
                    <opcode
                        name="Allocate_Object"
                        symbol="JSCRIPT_ALLOCATE_OBJECT"
                        value="12"
                        />
                    <opcode
                        name="Allocate_Array"
                        symbol="JSCRIPT_ALLOCATE_ARRAY"
                        value="13"
                        />
                    <opcode
                        name="Allocate_Function"
                        symbol="JSCRIPT_ALLOCATE_Function"
                        value="14"
                        />
                    <opcode
                        name="Allocate_DOM_Object"
                        symbol="JSCRIPT_ALLOCATE_DOM_OBJECT"
                        value="15"
                        />
                    <opcode
                        name="Allocate_WinRT_JSProxy_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_JSPROXY_OBJECT"
                        value="16"
                        />
                    <opcode
                        name="Allocate_PixelArray"
                        symbol="JSCRIPT_ALLOCATE_PIXELARRAY"
                        value="17"
                        />
                    <opcode
                        name="External_AddRef"
                        symbol="JSCRIPT_ALLOCATE_EXTERNAL_ADDREF"
                        value="18"
                        />
                    <opcode
                        name="External_Release"
                        symbol="JSCRIPT_ALLOCATE_EXTERNAL_RELEASE"
                        value="19"
                        />
                    <opcode
                        name="Allocate_WinRT_RuntimeClass_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_RUNTIMECLASS_OBJECT"
                        value="20"
                        />
                    <opcode
                        name="Allocate_WinRT_Namespace_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_NAMESPACE_OBJECT"
                        value="21"
                        />
                    <opcode
                        name="Allocate_WinRT_Struct_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_STRUCT_OBJECT"
                        value="22"
                        />
                    <opcode
                        name="Allocate_WinRT_Enum_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_ENUM_OBJECT"
                        value="23"
                        />
                    <opcode
                        name="Allocate_WinRT_TypedArray_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_TYPEDARRAY_OBJECT"
                        value="24"
                        />
                    <opcode
                        name="Allocate_WinRT_Delegate_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_DELEGATE_OBJECT"
                        value="25"
                        />
                    <opcode
                        name="Allocate_WinRT_EventHandler_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_EVENTHANLDER_OBJECT"
                        value="26"
                        />
                    <opcode
                        name="Allocate_WinRT_Collections_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_COLLECTIONS_OBJECT"
                        value="27"
                        />
                    <opcode
                        name="Allocate_WinRT_PropertyValue_Object"
                        symbol="JSCRIPT_ALLOCATE_WINRT_PROPERTYVALUE_OBJECT"
                        value="28"
                        />
                    <opcode
                        name="Free_WinRT_Delegate_Object"
                        symbol="JSCRIPT_FREE_WINRT_DELEGATE_OBJECT"
                        value="29"
                        />
                    <opcode
                        name="Free_WinRT_EventHandler_Object"
                        symbol="JSCRIPT_FREE_WINRT_EVENTHANLDER_OBJECT"
                        value="30"
                        />
                    <opcode
                        name="Free_WinRT_Collections_Object"
                        symbol="JSCRIPT_FREE_WINRT_COLLECTIONS_OBJECT"
                        value="31"
                        />
                    <opcode
                        name="Free_WinRT_PropertyValue_Object"
                        symbol="JSCRIPT_FREE_WINRT_PROPERTYVALUE_OBJECT"
                        value="32"
                        />
                </opcodes>
                </task>
                <task
                    eventGUID="{66aa7888-cd74-471f-b480-25d257cedcd9}"
                    name="Jscript_GC_SweepWeakRef"
                    value="49"
                    />
                <task
                    eventGUID="{66aa7888-cd74-471f-b480-25d257cedcda}"
                    name="Jscript_GC_ProcessTrackedObject"
                    value="50"
                    />
                <task
                    eventGUID="{66aa7888-cd74-471f-b480-25d257cedcdb}"
                    name="Jscript_GC_ProcessClientTrackedObject"
                    value="51"
                    />
                <task
                    eventGUID="{66aa7888-cd74-471f-b480-25d257cedcdc}"
                    name="Jscript_GC_BackgroundZeroPage"
                    value="52"
                    />
                <task
                    eventGUID="{66aa7888-cd74-471f-b480-25d257cedcdd}"
                    name="Jscript_GC_FlushZeroPage"
                    value="53"
                    />
                <task
                    eventGUID="{66aa7888-cd74-471f-b480-25d257cedcde}"
                    name="Jscript_GC_DecommitConcurrentCollectPageAllocator"
                    value="54"
                    />
                <task
                    eventGUID="{66aa7888-cd74-471f-b480-25d257cedcdf}"
                    name="Jscript_GC_SweepPartialReusePage"
                    value="55"
                    />
                <task
                    eventGUID="{66aa7888-cd74-471f-b480-25d257cedce0}"
                    name="Jscript_GC_BackgroundRescan"
                    value="56"
                    />
                <task
                    eventGUID="{66aa7888-cd74-471f-b480-25d257cedce1}"
                    name="Jscript_GC_BackgroundResetWriteWatch"
                    value="57"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedce2}"
                    name="Jscript_GC_BackgroundScanRoots"
                    value="58"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedce3}"
                    name="Jscript_GC_BackgroundResetMarks"
                    value="59"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedce4}"
                    name="Jscript_GC_RescanMarkWait"
                    value="60"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedce5}"
                    name="Jscript_GC_SynchronousMarkWait"
                    value="61"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedce6}"
                    name="Jscript_GC_FinishConcurrentWait"
                    value="62"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedce7}"
                    name="Jscript_GC_EndMarkOnLowMemory"
                    value="63"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedce8}"
                    name="Jscript_AsyncCausality_StackTrace"
                    value="64"
                    />
                <task
                    eventGUID="{457D74E6-78AD-49fd-8DD1-C185896E7466}"
                    name="JScript_ByteCodeDeserialize"
                    value="65"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedce9}"
                    name="Jscript_Hosting_BinaryInconsistency"
                    value="66"
                    />
                <task
                    eventGUID="{3993e20a-ba62-4adc-8f5c-e55166d08200}"
                    name="Jscript_Hosting_BinaryConsistencyInfo"
                    value="67"
                    />
                <task
                    eventGUID="{4B86D08B-2864-421C-AFB1-BF58AE05044A}"
                    name="Jscript_StackTrace"
                    value="68"
                    />
                <task
                    eventGUID="{cca4995d-2c97-43f6-a974-e11e9fcbab79}"
                    name="Jscript_Host_Native"
                    value="69"
                    />
                <task
                    eventGUID="{4B86D005-2864-421C-AFB1-BF58AE8B044A}"
                    name="Jscript_SourceMapping"
                    value="70"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcea}"
                    name="Jscript_GC_ParallelMark"
                    value="71"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedceb}"
                    name="Jscript_GC_BackgroundParallelMark"
                    value="72"
                    />
                <task
                    eventGUID="{808dc352-cfa5-4912-9907-9e29361d1c08}"
                    name="Memprotect_GC_ResetMarks"
                    value="73"
                    />
                <task
                    eventGUID="{cd3b3d62-3f3e-47ee-857c-bad3ad94dbcd}"
                    name="Memprotect_GC_ScanRoots"
                    value="74"
                    />
                <task
                    eventGUID="{a11cc8a8-fef7-4a9b-b24e-d7fc02a68df5}"
                    name="Memprotect_GC_ScanStack"
                    value="75"
                    />
                <task
                    eventGUID="{cb6d6f0f-27ae-4f00-95e3-9cc085d85686}"
                    name="Memprotect_GC_Mark"
                    value="76"
                    />
                <task
                    eventGUID="{ef982975-087e-456c-897b-2ab23ac59885}"
                    name="Memprotect_GC_Rescan"
                    value="77"
                    />
                <task
                    eventGUID="{6a3587b5-148a-4cd2-8c63-d43ecaff0789}"
                    name="Memprotect_GC_Sweep"
                    value="78"
                    />
                <task
                    eventGUID="{788139af-d655-4abc-9462-2aba2abac238}"
                    name="Memprotect_GC_SetupBackgroundSweep"
                    value="79"
                    />
                <task
                    eventGUID="{bde9822d-c863-4547-ab7e-2c45c81e8ac8}"
                    name="Memprotect_GC_BackgroundSweep"
                    value="80"
                    />
                <task
                    eventGUID="{aa3d9ea4-ad7b-4f0c-940a-58e040f53e19}"
                    name="Memprotect_GC_TransferSweptObjects"
                    value="81"
                    />
                <task
                    eventGUID="{a0a7c40e-cdff-4970-8c39-8a9c27756d87}"
                    name="Memprotect_GC_Dispose"
                    value="82"
                    />
                <task
                    eventGUID="{f8129083-1cb9-4578-be4e-58785bad4e4c}"
                    name="Memprotect_GC_BackgroundMark"
                    value="83"
                    />
                <task
                    eventGUID="{07a1febb-aef7-48b8-8cbd-e866b0eacd5c}"
                    name="Memprotect_GC_ResetWriteWatch"
                    value="84"
                    />
                <task
                    eventGUID="{1440bbe4-b0c3-4c96-a333-031e138e2f9d}"
                    name="Memprotect_GC_IdleCollect"
                    value="85"
                    />
                <task
                    eventGUID="{db6c6ca1-6bb1-461f-a4c1-9b2fa06e1e93}"
                    name="Memprotect_GC_SweepWeakRef"
                    value="86"
                    />
                <task
                    eventGUID="{64c8f2e0-c198-42d9-9fdf-44e9d34ab48f}"
                    name="Memprotect_GC_ProcessTrackedObject"
                    value="87"
                    />
                <task
                    eventGUID="{d6fb5084-cd49-45ae-ba38-40ff751ae35c}"
                    name="Memprotect_GC_ProcessClientTrackedObject"
                    value="88"
                    />
                <task
                    eventGUID="{7ba28b1c-ba06-4d87-8692-796834a68ba0}"
                    name="Memprotect_GC_BackgroundZeroPage"
                    value="89"
                    />
                <task
                    eventGUID="{136f70cc-b5d3-477f-a790-f19345eda28a}"
                    name="Memprotect_GC_FlushZeroPage"
                    value="90"
                    />
                <task
                    eventGUID="{7e40b1d6-b3b0-446e-a795-24235f6fb168}"
                    name="Memprotect_GC_DecommitConcurrentCollectPageAllocator"
                    value="91"
                    />
                <task
                    eventGUID="{6e39f32d-cdf1-483f-8bee-d5d513df60ec}"
                    name="Memprotect_GC_SweepPartialReusePage"
                    value="92"
                    />
                <task
                    eventGUID="{f8ffa8e2-c4a8-4708-afa5-134a6872447c}"
                    name="Memprotect_GC_BackgroundRescan"
                    value="93"
                    />
                <task
                    eventGUID="{df75ab61-b4a0-4cf8-b544-ec3980418a24}"
                    name="Memprotect_GC_BackgroundResetWriteWatch"
                    value="94"
                    />
                <task
                    eventGUID="{71e1ad23-8cf1-49cf-99be-b7c7913e5376}"
                    name="Memprotect_GC_BackgroundScanRoots"
                    value="95"
                    />
                <task
                    eventGUID="{32e45a72-3790-429c-8954-0dd6a6ad6480}"
                    name="Memprotect_GC_BackgroundResetMarks"
                    value="96"
                    />
                <task
                    eventGUID="{18d40cb5-aedb-4adf-8fb6-7db6dff0781d}"
                    name="Memprotect_GC_RescanMarkWait"
                    value="97"
                    />
                <task
                    eventGUID="{6dc7593a-7293-4541-aae1-a494086cd202}"
                    name="Memprotect_GC_SynchronousMarkWait"
                    value="98"
                    />
                <task
                    eventGUID="{5e3e368c-8c86-4100-a56d-abcef87ef59e}"
                    name="Memprotect_GC_FinishConcurrentWait"
                    value="99"
                    />
                <task
                    eventGUID="{8f48f451-aa73-4bad-bfb6-314e8d0a4066}"
                    name="Memprotect_GC_EndMarkOnLowMemory"
                    value="100"
                    />
                <task
                    eventGUID="{a2397418-10af-4eb6-8055-d309269fb668}"
                    name="Memprotect_GC_ParallelMark"
                    value="101"
                    />
                <task
                    eventGUID="{32c86020-c4e1-475c-b353-ab8c58b98153}"
                    name="Memprotect_GC_BackgroundParallelMark"
                    value="102"
                    />
                <task
                    eventGUID="{4fe2e2cd-1498-4b2d-866c-f851ed190ffa}"
                    name="Memprotect_GC"
                    value="103"
                    />
                <task
                    eventGUID="{ca5712cd-23b8-4f93-849e-9107bce9558e}"
                    name="Memprotect_GC_Allocation"
                    value="104"
                    />
                <task
                    eventGUID="{420737b4-4f9c-479c-bd31-28391e1ddfa1}"
                    name="Memprotect_GC_Unroot"
                    value="105"
                    />
                <task
                    eventGUID="{56aa7888-cd74-471f-b480-25d257cedcec}"
                    name="Jscript_GC_Init"
                    value="106"
                    />
                <task
                    eventGUID="{09fdd3c1-a5f7-4b7f-aabc-6eecc4e30309}"
                    name="Memprotect_GC_Heap_Size"
                    value="107"
                    />
                <task
                    eventGUID="{7aabacec-6052-4f52-9aae-10fd5b5bfc0c}"
                    name="Jscript_Internal_Generic_Event"
                    value="108"
                    />
                <task
                    eventGUID="{3b122f5b-4f0d-4bef-a973-7a3953f9bcc8}"
                    name="Jscript_GC_Bucket_Stats"
                    value="109"
                    />
                <task
                    eventGUID="{2780AF73-7C2B-4D48-B73A-285F95F5C9F4}"
                    name="Memprotect_GC_Bucket_Stats"
                    value="110"
                    />
            </tasks>
            <maps>
                <valueMap name="MethodAddressRangeMap">
                <map
                    message="$(string.JScriptProvider.Method.InterpretedMessage)"
                    value="0x1"
                    />
                <map
                    message="$(string.JScriptProvider.Method.JittedMessage)"
                    value="0x2"
                    />
                <map
                    message="$(string.JScriptProvider.Method.JittedLoopBodyMessage)"
                    value="0x3"
                    />
                <map
                    message="$(string.JScriptProvider.Method.JittedLoopBodyMessage)"
                    value="0x4"
                    />
                <map
                    message="$(string.JScriptProvider.Method.JittedLoopBodyMessage)"
                    value="0x5"
                    />
                <map
                    message="$(string.JScriptProvider.Method.JittedLoopBodyMessage)"
                    value="0x6"
                    />
                <map
                    message="$(string.JScriptProvider.Method.JittedLoopBodyMessage)"
                    value="0x7"
                    />
                <map
                    message="$(string.JScriptProvider.Method.JittedLoopBodyMessage)"
                    value="0x8"
                    />
                <map
                    message="$(string.JScriptProvider.Method.JittedLoopBodyMessage)"
                    value="0x9"
                    />
                <map
                    message="$(string.JScriptProvider.Method.JittedLoopBodyMessage)"
                    value="0xA"
                    />
                </valueMap>
                <valueMap name="JitLevelMap">
                <map
                    message="$(string.JScriptProvider.Method.SimpleJitMessage)"
                    value="0x1"
                    />
                <map
                    message="$(string.JScriptProvider.Method.FullJitMessage)"
                    value="0x2"
                    />
                </valueMap>
                <valueMap name="SourceRequestFor">
                <map
                    message="$(string.JScriptProvider.Source.Reason)"
                    value="0x1"
                    />
                <map
                    message="$(string.JScriptProvider.Source.ReasonLength)"
                    value="0x2"
                    />
                </valueMap>
                <valueMap name="GCBucketNames">
                <map
                    message="$(string.JScriptProvider.GCBucket.Normal_S})"
                    value="0x0000"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.Leaf_S})"
                    value="0x0001"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.Fin_S})"
                    value="0x0002"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.NormWB_S})"
                    value="0x0003"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.FinWB_S})"
                    value="0x0004"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.Visited_S})"
                    value="0x0005"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.Normal_M})"
                    value="0x0100"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.Leaf_M})"
                    value="0x0101"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.Fin_M})"
                    value="0x0102"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.NormWB_M})"
                    value="0x0103"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.FinWB_M})"
                    value="0x0104"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.Visited_M})"
                    value="0x0105"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.Large)"
                    value="0x0200"
                    />
                <map
                    message="$(string.JScriptProvider.GCBucket.Total)"
                    value="0x0300"
                    />
                </valueMap>
            </maps>
            <templates>
                <template tid="SourceLoadUnload">
                <data
                    inType="win:UInt64"
                    name="SourceID"
                    />
                <data
                    inType="win:Pointer"
                    name="ScriptContextID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="SourceFlags"
                    />
                <data
                    inType="win:UnicodeString"
                    name="Url"
                    />
                </template>
                <template tid="ScriptContextLoadUnload">
                <data
                    inType="win:Pointer"
                    name="ScriptContextID"
                    outType="win:HexInt64"
                    />
                </template>
                <template tid="MethodLoadUnload">
                <data
                    inType="win:Pointer"
                    name="ScriptContextID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:Pointer"
                    name="MethodStartAddress"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt64"
                    name="MethodSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MethodID"
                    />
                <data
                    inType="win:UInt16"
                    name="MethodFlags"
                    />
                <data
                    inType="win:UInt16"
                    map="MethodAddressRangeMap"
                    name="MethodAddressRangeID"
                    />
                <data
                    inType="win:UInt64"
                    name="SourceID"
                    />
                <data
                    inType="win:UInt32"
                    name="Line"
                    outType="xs:unsignedInt"
                    />
                <data
                    inType="win:UInt32"
                    name="Column"
                    outType="xs:unsignedInt"
                    />
                <data
                    inType="win:UnicodeString"
                    name="MethodName"
                    outType="xs:string"
                    />
                </template>
                <template tid="ProjectionTypeName">
                <data
                    inType="win:UnicodeString"
                    name="TypeName"
                    />
                </template>
                <template tid="ProjectionTypeNameAndMethodName">
                <data
                    inType="win:UnicodeString"
                    name="TypeName"
                    />
                <data
                    inType="win:UnicodeString"
                    name="MethodName"
                    />
                </template>
                <template tid="ProjectionTypeNameAndEventName">
                <data
                    inType="win:UnicodeString"
                    name="TypeName"
                    />
                <data
                    inType="win:UnicodeString"
                    name="EventName"
                    />
                </template>
                <template tid="ProjectionIsBoxedInterface">
                <data
                    inType="win:Boolean"
                    name="IsBoxed"
                    />
                </template>
                <template tid="ParseStartStop">
                <data
                    inType="win:UInt64"
                    name="SourceID"
                    />
                <data
                    inType="win:Pointer"
                    name="ScriptContextID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="MethodID"
                    />
                <data
                    inType="win:UInt32"
                    name="ASTSize"
                    />
                <data
                    inType="win:Boolean"
                    name="IsDeferred"
                    />
                <data
                    inType="win:UnicodeString"
                    name="MethodName"
                    outType="xs:string"
                    />
                </template>
                <template tid="BytecodeGenInfo">
                <data
                    inType="win:UInt64"
                    name="SourceID"
                    />
                <data
                    inType="win:Pointer"
                    name="ScriptContextID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="MethodID"
                    />
                <data
                    inType="win:UInt32"
                    name="BytecodeCount"
                    />
                <data
                    inType="win:UInt32"
                    name="BytecodeSize"
                    />
                <data
                    inType="win:UnicodeString"
                    name="MethodName"
                    outType="xs:string"
                    />
                </template>
                <template tid="GCPhase">
                <data
                    inType="win:Pointer"
                    name="RecyclerID"
                    outType="win:HexInt64"
                    />
                </template>
                <template tid="GCWaitStart">
                <data
                    inType="win:Pointer"
                    name="RecyclerID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="Timeout"
                    />
                </template>
                <template tid="GCWaitStop">
                <data
                    inType="win:Pointer"
                    name="RecyclerID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:Boolean"
                    name="HasTimedout"
                    />
                </template>
                <template tid="GCBackgroundMark">
                <data
                    inType="win:Pointer"
                    name="RecyclerID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:Int8"
                    name="BackgroundMarkRescanCount"
                    />
                </template>
                <template tid="GCPhaseCollect">
                <data
                    inType="win:Pointer"
                    name="RecyclerID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="SweptBytes"
                    />
                </template>
                <template tid="GCBucketStats">
                <data
                    inType="win:Pointer"
                    name="RecyclerID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt16"
                    name="Type"
                    map="GCBucketNames"
                    outType="win:HexInt16"
                    />
                <data
                    inType="win:UInt16"
                    name="SizeCat"
                    />
                <data
                    inType="win:UInt64"
                    name="UsedBytes"
                    />
                <data
                    inType="win:UInt64"
                    name="TotalBytes"
                    />
                </template>
                <template tid="ProfileSave">
                <data
                    inType="win:UInt64"
                    name="SourceID"
                    />
                <data
                    inType="win:Pointer"
                    name="ScriptContextID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="Size"
                    />
                <data
                    inType="win:Boolean"
                    name="IsSaveOnClose"
                    />
                </template>
                <template tid="StartupComplete">
                <data
                    inType="win:Pointer"
                    name="ScriptContextID"
                    outType="win:HexInt64"
                    />
                </template>
                <template tid="ProfileLoad">
                <data
                    inType="win:UInt64"
                    name="SourceID"
                    />
                <data
                    inType="win:Pointer"
                    name="ScriptContextID"
                    outType="win:HexInt64"
                    />
                </template>
                <template tid="InlineInfo">
                <data
                    inType="win:UInt32"
                    name="CallerMethodID"
                    />
                <data
                    inType="win:UInt32"
                    name="InlineeMethodID"
                    />
                <data
                    inType="win:UnicodeString"
                    name="Caller"
                    outType="xs:string"
                    />
                <data
                    inType="win:UnicodeString"
                    name="Inlinee"
                    outType="xs:string"
                    />
                </template>
                <template tid="JitMethodStart">
                <data
                    inType="win:UInt32"
                    name="MethodID"
                    />
                <data
                    inType="win:UnicodeString"
                    name="MethodName"
                    />
                <data
                    inType="win:Pointer"
                    name="ScriptContext"
                    />
                <data
                    inType="win:UInt32"
                    name="InterpretedCount"
                    />
                <data
                    inType="win:UInt32"
                    name="SourceCodeSize"
                    />
                <data
                    inType="win:UInt32"
                    name="ByteCodeSize"
                    />
                <data
                    inType="win:UInt32"
                    name="ByteCodeInLoopSize"
                    />
                <data
                    inType="win:UInt16"
                    map="JitLevelMap"
                    name="JitLevel"
                    />
                </template>
                <template tid="JitMethodStop">
                <data
                    inType="win:UInt32"
                    name="MethodID"
                    />
                <data
                    inType="win:UnicodeString"
                    name="MethodName"
                    />
                <data
                    inType="win:Pointer"
                    name="ScriptContext"
                    />
                <data
                    inType="win:UInt32"
                    name="InterpretedCount"
                    />
                <data
                    inType="win:Pointer"
                    name="MethodStartAddress"
                    />
                <data
                    inType="win:UInt64"
                    name="MethodSize"
                    />
                </template>
                <template tid="JitMethodQueueDequeue">
                <data
                    inType="win:UInt32"
                    name="MethodID"
                    />
                <data
                    inType="win:UnicodeString"
                    name="MethodName"
                    />
                <data
                    inType="win:Pointer"
                    name="ScriptContext"
                    />
                <data
                    inType="win:UInt32"
                    name="InterpretedCount"
                    />
                </template>
                <template tid="JscriptSizeInBytes">
                <data
                    inType="win:UInt64"
                    name="SizeInBytes"
                    outType="xs:unsignedLong"
                    />
                </template>
                <template tid="JscriptAllocation">
                <data
                    inType="win:Pointer"
                    name="MemoryAddress"
                    outType="win:HexInt64"
                    />
                </template>
                <template tid="JscriptRecyclerFree">
                <data
                    inType="win:UInt32"
                    name="Count"
                    />
                <struct
                    count="Count"
                    name="Values"
                    >
                    <data
                        inType="win:Pointer"
                        name="MemoryAddress"
                        outType="win:HexInt64"
                        />
                    <data
                        inType="win:UInt32"
                        name="Size"
                        />
                </struct>
                </template>
                <template tid="JscriptRecyclerFreeBlock">
                <data
                    inType="win:Pointer"
                    name="MemoryAddress"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="BlockSize"
                    />
                <data
                    inType="win:UInt32"
                    name="ObjectSize"
                    />
                </template>
                <template tid="JscriptAllocateFunction">
                <data
                    inType="win:Pointer"
                    name="MemoryAddress"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="MethodID"
                    />
                </template>
                <template tid="JscriptDOMAllocation">
                <data
                    inType="win:Pointer"
                    name="MemoryAddress"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="TypeId"
                    />
                </template>
                <template tid="JScriptWinRTObjectAllocation">
                <data
                    inType="win:Pointer"
                    name="MemoryAddress"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UnicodeString"
                    name="TypeName"
                    outType="xs:string"
                    />
                </template>
                <template tid="JscriptWinRTWrapperAllocation">
                <data
                    inType="win:Pointer"
                    name="MemoryAddress"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UnicodeString"
                    name="TypeName"
                    outType="xs:string"
                    />
                <data
                    inType="win:Pointer"
                    name="jsVar"
                    outType="win:HexInt64"
                    />
                </template>
                <template tid="JscriptWinRTEventHandlerAllocation">
                <data
                    inType="win:Pointer"
                    name="MemoryAddress"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UnicodeString"
                    name="TypeName"
                    outType="xs:string"
                    />
                <data
                    inType="win:Pointer"
                    name="callback"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UnicodeString"
                    name="EventName"
                    outType="xs:string"
                    />
                </template>
                <template tid="JscriptWinRTPropertyValueAllocation">
                <data
                    inType="win:Pointer"
                    name="MemoryAddress"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UnicodeString"
                    name="TypeName"
                    outType="xs:string"
                    />
                <data
                    inType="win:Boolean"
                    name="IsArray"
                    />
                </template>
                <template tid="JscriptWinRTWrapperFree">
                <data
                    inType="win:Pointer"
                    name="MemoryAddress"
                    outType="win:HexInt64"
                    />
                </template>
                <template tid="JscriptAsyncCausalityCallstackPayload">
                <data
                    inType="win:UInt64"
                    name="AsyncOperationId"
                    />
                <data
                    inType="win:UInt16"
                    name="FrameCount"
                    />
                <data
                    inType="win:UInt16"
                    name="NameBufferCount"
                    />
                <data
                    inType="win:UnicodeString"
                    length="NameBufferCount"
                    name="NameBuffer"
                    />
                <struct
                    count="FrameCount"
                    name="Frames"
                    >
                    <data
                        inType="win:UInt64"
                        name="DocumentId"
                        />
                    <data
                        inType="win:UInt32"
                        name="SourceLocationStartIndex"
                        />
                    <data
                        inType="win:UInt32"
                        name="SourceLocationLength"
                        />
                    <data
                        inType="win:UInt16"
                        name="NameIndex"
                        />
                </struct>
                </template>
                <template tid="Element_Zero">
                <data
                    inType="win:Pointer"
                    name="Element"
                    />
                <data
                    inType="win:UInt32"
                    name="Zero"
                    />
                </template>
                <template tid="JscriptHostingBinaryInconsistencyState">
                <data
                    inType="win:UInt32"
                    name="Jscript9EngineSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlEngineSize"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9ContextSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlContextSize"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9LibrarySize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlLibrarySize"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9CEOSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlCEOSize"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9ScriptEngineOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlScriptEngineOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9ScriptContextOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlScriptContextOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9LibraryOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlLibraryOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9TypeOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlTypeOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9TypeIdOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlTypeIdOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9TaggedIntSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlTaggIntSize"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9NumberSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlNumberSize"
                    />
                <data
                    inType="win:UInt32"
                    name="Jscript9TypeIdLimit"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlTypeIdLimit"
                    />
                <data
                    inType="win:UInt32"
                    name="JScript9NumberUtilitiesSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MsHtmlNumberUtilitiesSize"
                    />
                <data
                    inType="win:UInt32"
                    name="JScript9NumberUtilitiesOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MsHtmlNumberUtilitiesOffset"
                    />
                </template>
                <template tid="JscriptHostingBinaryConsistencyInfo">
                <data
                    inType="win:UInt32"
                    name="MshtmlEngineSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlContextSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlLibrarySize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlCEOSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlScriptEngineOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlScriptContextOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlLibraryOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlTypeOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlTypeIdOffset"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlTaggIntSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlNumberSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MshtmlTypeIdLimit"
                    />
                <data
                    inType="win:UInt32"
                    name="MsHtmlNumberUtilitiesSize"
                    />
                <data
                    inType="win:UInt32"
                    name="MsHtmlNumberUtilitiesOffset"
                    />
                </template>
                <template tid="JscriptStackTraceInfo">
                <data
                    inType="win:UInt64"
                    name="OperationId"
                    />
                <data
                    inType="win:UInt16"
                    name="FrameCount"
                    />
                <data
                    inType="win:UInt32"
                    name="FrameNameBufferCount"
                    />
                <data
                    inType="win:UnicodeString"
                    length="FrameNameBufferCount"
                    name="FrameNameBuffer"
                    />
                  <struct
                    count="FrameCount"
                    name="Frames"
                    >
                    <data
                        inType="win:Pointer"
                        name="ScriptContextID"
                        outType="win:HexInt64"
                        />
                    <data
                        inType="win:UInt32"
                        name="SourceLocationLineNumber"
                        />
                    <data
                        inType="win:UInt32"
                        name="SourceLocationColumnNumber"
                        />
                    <data
                        inType="win:UInt32"
                        name="MethodIDOrFrameNameIndex"
                        />
                    <data
                        inType="win:UInt8"
                        name="IsFrameNameIndex"
                        />
                </struct>
                </template>
                <template tid="JscriptHostNativeModuleLoad">
                <data
                    inType="win:Pointer"
                    name="ModuleID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:Binary"
                    length="20"
                    name="SHA1Hash"
                    />
                <data
                    inType="win:UnicodeString"
                    name="Url"
                    />
                <data
                    inType="win:HexInt32"
                    name="ModuleSize"
                    />
                </template>
                <template tid="JscriptHostNativeFunctionLoad">
                <data
                    inType="win:Pointer"
                    name="ModuleID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:HexInt32"
                    name="SerializationIndex"
                    />
                <data
                    inType="win:UnicodeString"
                    name="Name"
                    />
                <data
                    inType="win:HexInt32"
                    name="FunctionOffset"
                    />
                <data
                    inType="win:HexInt32"
                    name="FunctionSize"
                    />
                </template>
                <template tid="JScriptSourceMappingInfo">
                <data
                    inType="win:UnicodeString"
                    name="ReasonBuffer"
                    />
                <data
                    inType="win:UInt16"
                    map="SourceRequestFor"
                    name="SourceRequestFor"
                    />
                </template>
                <template tid="MemprotectObjectAlloc">
                <data
                    inType="win:Pointer"
                    name="HeapHandle"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt64"
                    name="Size"
                    />
                <data
                    inType="win:Pointer"
                    name="Address"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="Source"
                    />
                </template>
                <template tid="MemprotectObjectUnroot">
                <data
                    inType="win:Pointer"
                    name="HeapHandle"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:Pointer"
                    name="Address"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt32"
                    name="Source"
                    />
                </template>
                <template tid="GCInit">
                <data
                    inType="win:Pointer"
                    name="RecyclerID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:Double"
                    name="Timestamp"
                    />
                </template>
                <template tid="MemprotectHeap">
                <data
                    inType="win:Pointer"
                    name="RecyclerID"
                    outType="win:HexInt64"
                    />
                <data
                    inType="win:UInt64"
                    name="UsedBytes"
                    />
                <data
                    inType="win:UInt64"
                    name="ReservedBytes"
                    />
                <data
                    inType="win:UInt64"
                    name="CommittedBytes"
                    />
                <data
                    inType="win:UInt64"
                    name="NumberOfSegments"
                    />
                <data
                    inType="win:Boolean"
                    name="FromGC"
                    />
                </template>
                <template tid="InternalGenericEvent">
                <data
                    inType="win:UnicodeString"
                    name="eventData"
                    />
                </template>
            </templates>
            <events>
                <event
                    keywords="JScriptStartRundown"
                    level="win:Informational"
                    opcode="DCStartInit"
                    symbol="DCStartInit"
                    task="MethodRundown"
                    value="1"
                    />
                <event
                    keywords="JScriptStartRundown"
                    level="win:Informational"
                    opcode="DCStartComplete"
                    symbol="DCStartComplete"
                    task="MethodRundown"
                    value="2"
                    />
                <event
                    keywords="JScriptEndRundown"
                    level="win:Informational"
                    opcode="DCEndInit"
                    symbol="DCEndInit"
                    task="MethodRundown"
                    value="3"
                    />
                <event
                    keywords="JScriptEndRundown"
                    level="win:Informational"
                    opcode="DCEndComplete"
                    symbol="DCEndComplete"
                    task="MethodRundown"
                    value="4"
                    />
                <event
                    keywords="JScriptStartRundown"
                    level="win:Informational"
                    opcode="MethodDCStart"
                    symbol="MethodDCStart"
                    task="MethodRundown"
                    template="MethodLoadUnload"
                    value="5"
                    />
                <event
                    keywords="JScriptEndRundown"
                    level="win:Informational"
                    opcode="MethodDCEnd"
                    symbol="MethodDCEnd"
                    task="MethodRundown"
                    template="MethodLoadUnload"
                    value="6"
                    />
                <event
                    keywords="JScriptStartRundown"
                    level="win:Informational"
                    opcode="ScriptContextDCStart"
                    symbol="ScriptContextDCStart"
                    task="ScriptContextRundown"
                    template="ScriptContextLoadUnload"
                    value="7"
                    />
                <event
                    keywords="JScriptEndRundown"
                    level="win:Informational"
                    opcode="ScriptContextDCEnd"
                    symbol="ScriptContextDCEnd"
                    task="ScriptContextRundown"
                    template="ScriptContextLoadUnload"
                    value="8"
                    />
                <event
                    keywords="JScriptRuntime"
                    level="win:Informational"
                    opcode="MethodLoad"
                    symbol="MethodLoad"
                    task="MethodRuntime"
                    template="MethodLoadUnload"
                    value="9"
                    />
                <event
                    keywords="JScriptRuntime"
                    level="win:Informational"
                    opcode="MethodUnload"
                    symbol="MethodUnload"
                    task="MethodRuntime"
                    template="MethodLoadUnload"
                    value="10"
                    />
                <event
                    keywords="JScriptRuntime"
                    level="win:Informational"
                    opcode="ScriptContextLoad"
                    symbol="ScriptContextLoad"
                    task="ScriptContextRuntime"
                    template="ScriptContextLoadUnload"
                    value="11"
                    />
                <event
                    keywords="JScriptRuntime"
                    level="win:Informational"
                    opcode="ScriptContextUnload"
                    symbol="ScriptContextUnload"
                    task="ScriptContextRuntime"
                    template="ScriptContextLoadUnload"
                    value="12"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_RESOLVETYPE_START"
                    task="Jscript_Projection_ResolveType"
                    template="ProjectionTypeName"
                    value="13"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_RESOLVETYPE_STOP"
                    task="Jscript_Projection_ResolveType"
                    template="ProjectionTypeName"
                    value="14"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_CONSTRUCTRUNTIMECLASS_START"
                    task="Jscript_Projection_ConstructRuntimeClass"
                    template="ProjectionTypeName"
                    value="15"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_CONSTRUCTRUNTIMECLASS_STOP"
                    task="Jscript_Projection_ConstructRuntimeClass"
                    template="ProjectionTypeName"
                    value="16"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_METHODCALL_START"
                    task="Jscript_Projection_MethodCall"
                    template="ProjectionTypeNameAndMethodName"
                    value="17"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_METHODCALL_STOP"
                    task="Jscript_Projection_MethodCall"
                    template="ProjectionTypeNameAndMethodName"
                    value="18"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_RAWMETHODCALL_START"
                    task="Jscript_Projection_RawMethodCall"
                    template="ProjectionTypeNameAndMethodName"
                    value="19"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_RAWMETHODCALL_STOP"
                    task="Jscript_Projection_RawMethodCall"
                    template="ProjectionTypeNameAndMethodName"
                    value="20"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_INVOKEJSDELEGATE_START"
                    task="Jscript_Projection_InvokesJsDelegate"
                    template="ProjectionTypeNameAndMethodName"
                    value="21"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_INVOKEJSDELEGATE_STOP"
                    task="Jscript_Projection_InvokesJsDelegate"
                    template="ProjectionTypeNameAndMethodName"
                    value="22"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_INVOKENATIVEDELEGATE_START"
                    task="Jscript_Projection_InvokeNativeDelegate"
                    template="ProjectionTypeNameAndMethodName"
                    value="23"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_INVOKENATIVEDELEGATE_STOP"
                    task="Jscript_Projection_InvokeNativeDelegate"
                    template="ProjectionTypeNameAndMethodName"
                    value="24"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_ADDEVENTLISTENER_START"
                    task="Jscript_Projection_AddEventListener"
                    template="ProjectionTypeNameAndMethodName"
                    value="25"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_ADDEVENTLISTENER_STOP"
                    task="Jscript_Projection_AddEventListener"
                    template="ProjectionTypeNameAndMethodName"
                    value="26"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_REMOVEEVENTLISTENER_START"
                    task="Jscript_Projection_RemoveEventListener"
                    template="ProjectionTypeNameAndMethodName"
                    value="27"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_REMOVEEVENTLISTENER_STOP"
                    task="Jscript_Projection_RemoveEventListener"
                    template="ProjectionTypeNameAndMethodName"
                    value="28"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_GETTYPEMETADATAINFORMATION_START"
                    task="Jscript_Projection_GetTypeMetaDataInformation"
                    template="ProjectionTypeName"
                    value="29"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_GETTYPEMETADATAINFORMATION_STOP"
                    task="Jscript_Projection_GetTypeMetaDataInformation"
                    template="ProjectionTypeName"
                    value="30"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_SETEVENTHANDLER_START"
                    task="Jscript_Projection_SetEventHandler"
                    template="ProjectionTypeNameAndEventName"
                    value="31"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_SETEVENTHANDLER_STOP"
                    task="Jscript_Projection_SetEventHandler"
                    template="ProjectionTypeNameAndEventName"
                    value="32"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_REMOVEALLEVENTSANDEVENTHANDLERS_START"
                    task="Jscript_Projection_RemoveAllEventsAndEventHandlers"
                    template="ProjectionTypeName"
                    value="33"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_REMOVEALLEVENTSANDEVENTHANDLERS_STOP"
                    task="Jscript_Projection_RemoveAllEventsAndEventHandlers"
                    template="ProjectionTypeName"
                    value="34"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_INVOKEEVENT_START"
                    task="Jscript_Projection_InvokeEvent"
                    template="ProjectionTypeNameAndEventName"
                    value="35"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_INVOKEEVENT_STOP"
                    task="Jscript_Projection_InvokeEvent"
                    template="ProjectionTypeNameAndEventName"
                    value="36"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_INVOKEEVENTEVPARAMPREP_START"
                    task="Jscript_Projection_InvokeEventEvParamPrep"
                    template="ProjectionTypeNameAndEventName"
                    value="37"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_INVOKEEVENTEVPARAMPREP_STOP"
                    task="Jscript_Projection_InvokeEventEvParamPrep"
                    template="ProjectionTypeNameAndEventName"
                    value="38"
                    />
                <event
                    keywords="JScriptStartRundown"
                    level="win:Informational"
                    opcode="SourceDCStart"
                    symbol="SourceDCStart"
                    task="ScriptContextRundown"
                    template="SourceLoadUnload"
                    value="39"
                    />
                <event
                    keywords="JScriptEndRundown"
                    level="win:Informational"
                    opcode="SourceDCEnd"
                    symbol="SourceDCEnd"
                    task="ScriptContextRundown"
                    template="SourceLoadUnload"
                    value="40"
                    />
                <event
                    keywords="JScriptRuntime"
                    level="win:Informational"
                    opcode="SourceLoad"
                    symbol="SourceLoad"
                    task="ScriptContextRuntime"
                    template="SourceLoadUnload"
                    value="41"
                    />
                <event
                    keywords="JScriptRuntime"
                    level="win:Informational"
                    opcode="SourceUnload"
                    symbol="SourceUnload"
                    task="ScriptContextRuntime"
                    template="SourceLoadUnload"
                    value="42"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_GETEXPRFROMCONCRETETYPENAME_START"
                    task="Jscript_Projection_GetExprFromConcreteTypeName"
                    template="ProjectionTypeName"
                    value="43"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_GETEXPRFROMCONCRETETYPENAME_STOP"
                    task="Jscript_Projection_GetExprFromConcreteTypeName"
                    template="ProjectionTypeName"
                    value="44"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_GETTYPEFROMTYPENAMEPARTS_START"
                    task="Jscript_Projection_GetTypeFromTypeNameParts"
                    template="ProjectionTypeName"
                    value="45"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_GETTYPEFROMTYPENAMEPARTS_STOP"
                    task="Jscript_Projection_GetTypeFromTypeNameParts"
                    template="ProjectionTypeName"
                    value="46"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_REFERENCEORARRAYGETVALUE_START"
                    task="Jscript_Projection_ReferenceOrArrayGetValue"
                    template="ProjectionTypeName"
                    value="47"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_REFERENCEORARRAYGETVALUE_STOP"
                    task="Jscript_Projection_ReferenceOrArrayGetValue"
                    template="ProjectionTypeName"
                    value="48"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_PROPERTYVALUEVARFROMGRCN_START"
                    task="Jscript_Projection_PropertyValueVarFromGRCN"
                    template="ProjectionTypeName"
                    value="49"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_PROPERTYVALUEVARFROMGRCN_STOP"
                    task="Jscript_Projection_PropertyValueVarFromGRCN"
                    template="ProjectionTypeName"
                    value="50"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_VARFROMGRCN_START"
                    task="Jscript_Projection_VarFromGRCN"
                    template="ProjectionTypeName"
                    value="51"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_VARFROMGRCN_STOP"
                    task="Jscript_Projection_VarFromGRCN"
                    template="ProjectionTypeName"
                    value="52"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_WRITEIREFERENCE_START"
                    task="Jscript_Projection_WriteIReference"
                    template="ProjectionTypeName"
                    value="53"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_WRITEIREFERENCE_STOP"
                    task="Jscript_Projection_WriteIReference"
                    template="ProjectionTypeName"
                    value="54"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_WRITEINSPECTABLE_START"
                    task="Jscript_Projection_WriteInspectable"
                    template="ProjectionIsBoxedInterface"
                    value="55"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_WRITEINSPECTABLE_STOP"
                    task="Jscript_Projection_WriteInspectable"
                    template="ProjectionIsBoxedInterface"
                    value="56"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_GETNONARRAYTYPEASPROPERTYVALUE_START"
                    task="Jscript_Projection_GetNonArrayTypeAsPropertyValue"
                    template="ProjectionTypeName"
                    value="57"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_GETNONARRAYTYPEASPROPERTYVALUE_STOP"
                    task="Jscript_Projection_GetNonArrayTypeAsPropertyValue"
                    template="ProjectionTypeName"
                    value="58"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_GETNONARRAYBASICTYPEASPROPERTYVALUE_START"
                    task="Jscript_Projection_GetNonArrayBasicTypeAsPropertyValue"
                    template="ProjectionTypeName"
                    value="59"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_GETNONARRAYBASICTYPEASPROPERTYVALUE_STOP"
                    task="Jscript_Projection_GetNonArrayBasicTypeAsPropertyValue"
                    template="ProjectionTypeName"
                    value="60"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_GETTYPEDARRAYASPROPERTYVALUE_START"
                    task="Jscript_Projection_GetTypedArrayAsPropertyValue"
                    template="ProjectionTypeName"
                    value="61"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_GETTYPEDARRAYASPROPERTYVALUE_STOP"
                    task="Jscript_Projection_GetTypedArrayAsPropertyValue"
                    template="ProjectionTypeName"
                    value="62"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Start"
                    symbol="JSCRIPT_PROJECTION_GETBASICTYPEDARRAYASPROPERTYVALUE_START"
                    task="Jscript_Projection_GetBasicTypedArrayAsPropertyValue"
                    template="ProjectionTypeName"
                    value="63"
                    />
                <event
                    keywords="JScriptProjection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PROJECTION_GETBASICTYPEDARRAYASPROPERTYVALUE_STOP"
                    task="Jscript_Projection_GetBasicTypedArrayAsPropertyValue"
                    template="ProjectionTypeName"
                    value="64"
                    />
                <event
                    keywords="JScriptFrontend"
                    opcode="win:Start"
                    symbol="JSCRIPT_PARSE_METHOD_START"
                    task="ParseMethod"
                    template="ParseStartStop"
                    value="65"
                    />
                <event
                    keywords="JScriptFrontend"
                    opcode="win:Stop"
                    symbol="JSCRIPT_PARSE_METHOD_STOP"
                    task="ParseMethod"
                    template="ParseStartStop"
                    value="66"
                    />
                <event
                    keywords="JScriptFrontend"
                    opcode="win:Info"
                    symbol="JSCRIPT_BYTECODEGEN_METHOD"
                    task="GenerateBytecodeMethod"
                    template="BytecodeGenInfo"
                    value="67"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_RESETMARKS_START"
                    task="Jscript_GC_ResetMarks"
                    template="GCPhase"
                    value="68"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_RESETMARKS_STOP"
                    task="Jscript_GC_ResetMarks"
                    template="GCPhase"
                    value="69"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_SCANROOTS_START"
                    task="Jscript_GC_ScanRoots"
                    template="GCPhase"
                    value="70"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_SCANROOTS_STOP"
                    task="Jscript_GC_ScanRoots"
                    template="GCPhase"
                    value="71"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_SCANSTACK_START"
                    task="Jscript_GC_ScanStack"
                    template="GCPhase"
                    value="72"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_SCANSTACK_STOP"
                    task="Jscript_GC_ScanStack"
                    template="GCPhase"
                    value="73"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_MARK_START"
                    task="Jscript_GC_Mark"
                    template="GCPhase"
                    value="74"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_MARK_STOP"
                    task="Jscript_GC_Mark"
                    template="GCPhase"
                    value="75"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_RESCAN_START"
                    task="Jscript_GC_Rescan"
                    template="GCPhase"
                    value="76"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_RESCAN_STOP"
                    task="Jscript_GC_Rescan"
                    template="GCPhase"
                    value="77"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_SWEEP_START"
                    task="Jscript_GC_Sweep"
                    template="GCPhase"
                    value="78"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_SWEEP_STOP"
                    task="Jscript_GC_Sweep"
                    template="GCPhaseCollect"
                    value="79"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_SETUPBACKGROUNDSWEEP_START"
                    task="Jscript_GC_SetupBackgroundSweep"
                    template="GCPhase"
                    value="80"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_SETUPBACKGROUNDSWEEP_STOP"
                    task="Jscript_GC_SetupBackgroundSweep"
                    template="GCPhase"
                    value="81"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_BACKGROUNDSWEEP_START"
                    task="Jscript_GC_BackgroundSweep"
                    template="GCPhase"
                    value="82"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_BACKGROUNDSWEEP_STOP"
                    task="Jscript_GC_BackgroundSweep"
                    template="GCPhaseCollect"
                    value="83"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_TRANSFERSWEPTOBJECTS_START"
                    task="Jscript_GC_TransferSweptObjects"
                    template="GCPhase"
                    value="84"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_TRANSFERSWEPTOBJECTS_STOP"
                    task="Jscript_GC_TransferSweptObjects"
                    template="GCPhase"
                    value="85"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_DISPOSE_START"
                    task="Jscript_GC_Dispose"
                    template="GCPhase"
                    value="86"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_DISPOSE_STOP"
                    task="Jscript_GC_Dispose"
                    template="GCPhaseCollect"
                    value="87"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_BACKGROUNDMARK_START"
                    task="Jscript_GC_BackgroundMark"
                    template="GCBackgroundMark"
                    value="88"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_BACKGROUNDMARK_STOP"
                    task="Jscript_GC_BackgroundMark"
                    template="GCBackgroundMark"
                    value="89"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_RESETWRITEWATCH_START"
                    task="Jscript_GC_ResetWriteWatch"
                    template="GCPhase"
                    value="90"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_RESETWRITEWATCH_STOP"
                    task="Jscript_GC_ResetWriteWatch"
                    template="GCPhase"
                    value="91"
                    />
                <event
                    keywords="JScriptProfile"
                    opcode="Save"
                    symbol="JSCRIPT_PROFILE_SAVE"
                    task="Jscript_Profile_Persistence"
                    template="ProfileSave"
                    value="92"
                    />
                <event
                    keywords="JScriptProfile"
                    opcode="ScriptContextOnStartupComplete"
                    symbol="JSCRIPT_ON_STARTUP_COMPLETE"
                    task="ScriptContextRuntime"
                    template="StartupComplete"
                    value="93"
                    />
                <event
                    keywords="JScriptProfile"
                    opcode="Load"
                    symbol="JSCRIPT_PROFILE_LOAD"
                    task="Jscript_Profile_Persistence"
                    template="ProfileLoad"
                    value="94"
                    />
                <event
                    keywords="JscriptBackend"
                    opcode="win:Info"
                    symbol="JSCRIPT_BACKEND_INLINE"
                    task="Jscript_Backend_Inline"
                    template="InlineInfo"
                    value="95"
                    />
                <event
                    keywords="JscriptJit"
                    opcode="Start"
                    symbol="JSCRIPT_FUNCTION_JIT_START"
                    task="Jscript_Method_Jit"
                    template="JitMethodStart"
                    value="96"
                    />
                <event
                    keywords="JscriptJit"
                    opcode="Stop"
                    symbol="JSCRIPT_FUNCTION_JIT_STOP"
                    task="Jscript_Method_Jit"
                    template="JitMethodStop"
                    value="97"
                    />
                <event
                    keywords="JscriptJit"
                    opcode="Queue"
                    symbol="JSCRIPT_FUNCTION_JIT_QUEUED"
                    task="Jscript_Method_Jit"
                    template="JitMethodQueueDequeue"
                    value="98"
                    />
                <event
                    keywords="JscriptJit"
                    opcode="Dequeue"
                    symbol="JSCRIPT_FUNCTION_JIT_DEQUEUED"
                    task="Jscript_Method_Jit"
                    template="JitMethodQueueDequeue"
                    value="99"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_IDLE_START"
                    task="Jscript_GC_IdleCollect"
                    template="GCPhase"
                    value="100"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Info"
                    symbol="JSCRIPT_GC_IDLE_CALLBACK_NEWCOLLECT"
                    task="Jscript_GC_IdleCollect"
                    template="GCPhase"
                    value="101"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Info"
                    symbol="JSCRIPT_GC_IDLE_CALLBACK_FINISH"
                    task="Jscript_GC_IdleCollect"
                    template="GCPhase"
                    value="102"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Info"
                    symbol="JSCRIPT_GC_IDLE_SCHEDULED"
                    task="Jscript_GC_IdleCollect"
                    template="GCPhase"
                    value="103"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_IDLE_FINISHED"
                    task="Jscript_GC_IdleCollect"
                    template="GCPhase"
                    value="104"
                    />
                <event
                    keywords="JScriptMemoryTracing"
                    opcode="UsedPageSize"
                    symbol="JSCRIPT_PAGE_ALLOCATOR_USED_SIZE"
                    task="Jscript_Page_Allocator_Size"
                    template="JscriptSizeInBytes"
                    value="105"
                    />
                <event
                    keywords="JScriptObjectCleanup"
                    level="win:Informational"
                    opcode="Free_Memory"
                    symbol="JSCRIPT_RECYCLER_FREE_MEMORY"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptRecyclerFree"
                    value="106"
                    />
                <event
                    keywords="JScriptObjectCleanup"
                    level="win:Informational"
                    opcode="Free_Memory_Block"
                    symbol="JSCRIPT_RECYCLER_FREE_MEMORY_BLOCK"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptRecyclerFreeBlock"
                    value="107"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    level="win:Informational"
                    opcode="Allocate_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptAllocation"
                    value="108"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    level="win:Informational"
                    opcode="Allocate_Array"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_ARRAY"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptAllocation"
                    value="109"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    level="win:Informational"
                    opcode="Allocate_Function"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_FUNCTION"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptAllocateFunction"
                    value="110"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    level="win:Informational"
                    opcode="Allocate_DOM_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_DOM_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptDOMAllocation"
                    value="111"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    level="win:Informational"
                    opcode="Allocate_WinRT_JSProxy_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_JSPROXY_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JScriptWinRTObjectAllocation"
                    value="112"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    level="win:Informational"
                    opcode="Allocate_PixelArray"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_PIXELARRAY"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptAllocation"
                    value="113"
                    />
                <event
                    keywords="JScriptExternalReferenceAddRef"
                    level="win:Informational"
                    opcode="External_AddRef"
                    symbol="JSCRIPT_RECYCLER_EXTERNAL_ADDREF"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptAllocation"
                    value="114"
                    />
                <event
                    keywords="JScriptExternalReferenceRelease"
                    level="win:Informational"
                    opcode="External_Release"
                    symbol="JSCRIPT_RECYCLER_EXTERNAL_RELEASE"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptAllocation"
                    value="115"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Allocate_WinRT_RuntimeClass_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_RUNTIMECLASS_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JScriptWinRTObjectAllocation"
                    value="116"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Allocate_WinRT_Namespace_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_NAMESPACE_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JScriptWinRTObjectAllocation"
                    value="117"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Allocate_WinRT_Struct_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_STRUCT_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JScriptWinRTObjectAllocation"
                    value="118"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Allocate_WinRT_Enum_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_ENUM_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JScriptWinRTObjectAllocation"
                    value="119"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Allocate_WinRT_TypedArray_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_TYPEDARRAY_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JScriptWinRTObjectAllocation"
                    value="120"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Allocate_WinRT_Delegate_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_DELEGATE_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptWinRTWrapperAllocation"
                    value="121"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Allocate_WinRT_EventHandler_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_EVENTHANDLER_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptWinRTEventHandlerAllocation"
                    value="122"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Allocate_WinRT_Collections_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_COLLECTIONS_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptWinRTWrapperAllocation"
                    value="123"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Allocate_WinRT_PropertyValue_Object"
                    symbol="JSCRIPT_RECYCLER_ALLOCATE_WINRT_PROPERTYVALUE_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptWinRTPropertyValueAllocation"
                    value="124"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Free_WinRT_Delegate_Object"
                    symbol="JSCRIPT_RECYCLER_FREE_WINRT_DELEGATE_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptWinRTWrapperFree"
                    value="125"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Free_WinRT_EventHandler_Object"
                    symbol="JSCRIPT_RECYCLER_FREE_WINRT_EVENTHANDLER_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptWinRTWrapperFree"
                    value="126"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Free_WinRT_Collections_Object"
                    symbol="JSCRIPT_RECYCLER_FREE_WINRT_COLLECTIONS_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptWinRTWrapperFree"
                    value="127"
                    />
                <event
                    keywords="JScriptObjectAllocation"
                    opcode="Free_WinRT_PropertyValue_Object"
                    symbol="JSCRIPT_RECYCLER_FREE_WINRT_PROPERTYVALUE_OBJECT"
                    task="Jscript_Recycler_Allocation"
                    template="JscriptWinRTWrapperFree"
                    value="128"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_SWEEP_WEAKREF_START"
                    task="Jscript_GC_SweepWeakRef"
                    template="GCPhase"
                    value="129"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_SWEEP_WEAKREF_STOP"
                    task="Jscript_GC_SweepWeakRef"
                    template="GCPhase"
                    value="130"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_PROCESS_TRACKED_OBJECT_START"
                    task="Jscript_GC_ProcessTrackedObject"
                    template="GCPhase"
                    value="131"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_PROCESS_TRACKED_OBJECT_STOP"
                    task="Jscript_GC_ProcessTrackedObject"
                    template="GCPhase"
                    value="132"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_PROCESS_CLIENT_TRACKED_OBJECT_START"
                    task="Jscript_GC_ProcessClientTrackedObject"
                    template="GCPhase"
                    value="133"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_PROCESS_CLIENT_TRACKED_OBJECT_STOP"
                    task="Jscript_GC_ProcessClientTrackedObject"
                    template="GCPhase"
                    value="134"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_BACKGROUNDZEROPAGE_START"
                    task="Jscript_GC_BackgroundZeroPage"
                    template="GCPhase"
                    value="135"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_BACKGROUNDZEROPAGE_STOP"
                    task="Jscript_GC_BackgroundZeroPage"
                    template="GCPhase"
                    value="136"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_FLUSHZEROPAGE_START"
                    task="Jscript_GC_FlushZeroPage"
                    template="GCPhase"
                    value="137"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_FLUSHZEROPAGE_STOP"
                    task="Jscript_GC_FlushZeroPage"
                    template="GCPhase"
                    value="138"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_DECOMMIT_CONCURRENT_COLLECT_PAGE_ALLOCATOR_START"
                    task="Jscript_GC_DecommitConcurrentCollectPageAllocator"
                    template="GCPhase"
                    value="139"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_DECOMMIT_CONCURRENT_COLLECT_PAGE_ALLOCATOR_STOP"
                    task="Jscript_GC_DecommitConcurrentCollectPageAllocator"
                    template="GCPhase"
                    value="140"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_SWEEP_PARTIAL_REUSE_PAGE_START"
                    task="Jscript_GC_SweepPartialReusePage"
                    template="GCPhase"
                    value="141"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_SWEEP_PARTIAL_REUSE_PAGE_STOP"
                    task="Jscript_GC_SweepPartialReusePage"
                    template="GCPhase"
                    value="142"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_BACKGROUNDRESCAN_START"
                    task="Jscript_GC_BackgroundRescan"
                    template="GCBackgroundMark"
                    value="143"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_BACKGROUNDRESCAN_STOP"
                    task="Jscript_GC_BackgroundRescan"
                    template="GCBackgroundMark"
                    value="144"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_BACKGROUNDRESETWRITEWATCH_START"
                    task="Jscript_GC_BackgroundResetWriteWatch"
                    template="GCBackgroundMark"
                    value="145"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_BACKGROUNDRESETWRITEWATCH_STOP"
                    task="Jscript_GC_BackgroundResetWriteWatch"
                    template="GCBackgroundMark"
                    value="146"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_BACKGROUNDSCANROOTS_START"
                    task="Jscript_GC_BackgroundScanRoots"
                    template="GCPhase"
                    value="147"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_BACKGROUNDSCANROOTS_STOP"
                    task="Jscript_GC_BackgroundScanRoots"
                    template="GCPhase"
                    value="148"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_BACKGROUNDRESETMARKS_START"
                    task="Jscript_GC_BackgroundResetMarks"
                    template="GCPhase"
                    value="149"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_BACKGROUNDRESETMARKS_STOP"
                    task="Jscript_GC_BackgroundResetMarks"
                    template="GCPhase"
                    value="150"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_RESCANMARKWAIT_START"
                    task="Jscript_GC_RescanMarkWait"
                    template="GCWaitStart"
                    value="151"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_RESCANMARKWAIT_STOP"
                    task="Jscript_GC_RescanMarkWait"
                    template="GCWaitStop"
                    value="152"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_SYNCHRONOUSMARKWAIT_START"
                    task="Jscript_GC_SynchronousMarkWait"
                    template="GCWaitStart"
                    value="153"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_SYNCHRONOUSMARKWAIT_STOP"
                    task="Jscript_GC_SynchronousMarkWait"
                    template="GCWaitStop"
                    value="154"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_FINISHCONCURRENTWAIT_START"
                    task="Jscript_GC_FinishConcurrentWait"
                    template="GCWaitStart"
                    value="155"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_FINISHCONCURRENTWAIT_STOP"
                    task="Jscript_GC_FinishConcurrentWait"
                    template="GCWaitStop"
                    value="156"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_ENDMARKONLOWMEMORY_START"
                    task="Jscript_GC_EndMarkOnLowMemory"
                    template="GCPhase"
                    value="157"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_ENDMARKONLOWMEMORY_STOP"
                    task="Jscript_GC_EndMarkOnLowMemory"
                    template="GCPhase"
                    value="158"
                    />
                <event
                    keywords="JScriptAsyncCausality"
                    opcode="win:Info"
                    symbol="JSCRIPT_ASYNCCAUSALITY_STACKTRACE"
                    task="Jscript_AsyncCausality_StackTrace"
                    template="JscriptAsyncCausalityCallstackPayload"
                    value="159"
                    />
                <event
                    keywords="JScriptByteCode"
                    opcode="win:Start"
                    symbol="JSCRIPT_BYTECODEDESERIALIZE_START"
                    task="JScript_ByteCodeDeserialize"
                    template="Element_Zero"
                    value="160"
                    />
                <event
                    keywords="JScriptByteCode"
                    opcode="win:Stop"
                    symbol="JSCRIPT_BYTECODEDESERIALIZE_STOP"
                    task="JScript_ByteCodeDeserialize"
                    template="Element_Zero"
                    value="161"
                    />
                <event
                    keywords="JScriptHosting"
                    opcode="win:Info"
                    symbol="JSCRIPT_HOSTING_BINARYINCONSISTENCY"
                    task="Jscript_Hosting_BinaryInconsistency"
                    template="JscriptHostingBinaryInconsistencyState"
                    value="162"
                    />
                <event
                    keywords="JScriptHosting"
                    opcode="win:Info"
                    symbol="JSCRIPT_HOSTING_BINARY_CONSISTENCY_INFO"
                    task="Jscript_Hosting_BinaryConsistencyInfo"
                    template="JscriptHostingBinaryConsistencyInfo"
                    value="163"
                    />
                <event
                    keywords="JScriptStackTrace"
                    opcode="win:Info"
                    symbol="JSCRIPT_STACKTRACE"
                    task="Jscript_StackTrace"
                    template="JscriptStackTraceInfo"
                    value="164"
                    />
                <!-- Same template of JScriptStackTrace is used -->
                <event
                    keywords="JScriptAsyncCausality_V2"
                    opcode="win:Info"
                    symbol="JSCRIPT_ASYNCCAUSALITY_STACKTRACE_V2"
                    task="Jscript_AsyncCausality_StackTrace"
                    template="JscriptStackTraceInfo"
                    value="165"
                    />
                <event
                    keywords="JscriptJit"
                    opcode="win:Info"
                    symbol="JSCRIPT_NATIVE_MODULE_LOAD"
                    task="Jscript_Host_Native"
                    template="JscriptHostNativeModuleLoad"
                    value="166"
                    />
                <event
                    keywords="JscriptJit"
                    opcode="win:Info"
                    symbol="JSCRIPT_NATIVE_FUNCTION_LOAD"
                    task="Jscript_Host_Native"
                    template="JscriptHostNativeFunctionLoad"
                    value="167"
                    />
                <event
                    keywords="JScriptSourceMapping"
                    opcode="win:Info"
                    symbol="JSCRIPT_SOURCEMAPPING"
                    task="Jscript_SourceMapping"
                    template="JScriptSourceMappingInfo"
                    value="168"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_PARALLELMARK_START"
                    task="Jscript_GC_ParallelMark"
                    template="GCPhase"
                    value="169"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_PARALLELMARK_STOP"
                    task="Jscript_GC_ParallelMark"
                    template="GCPhase"
                    value="170"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Start"
                    symbol="JSCRIPT_GC_BACKGROUNDPARALLELMARK_START"
                    task="Jscript_GC_BackgroundParallelMark"
                    template="GCBackgroundMark"
                    value="171"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Stop"
                    symbol="JSCRIPT_GC_BACKGROUNDPARALLELMARK_STOP"
                    task="Jscript_GC_BackgroundParallelMark"
                    template="GCBackgroundMark"
                    value="172"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_RESETMARKS_START"
                    task="Memprotect_GC_ResetMarks"
                    template="GCPhase"
                    value="173"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_RESETMARKS_STOP"
                    task="Memprotect_GC_ResetMarks"
                    template="GCPhase"
                    value="174"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_SCANROOTS_START"
                    task="Memprotect_GC_ScanRoots"
                    template="GCPhase"
                    value="175"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_SCANROOTS_STOP"
                    task="Memprotect_GC_ScanRoots"
                    template="GCPhase"
                    value="176"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_SCANSTACK_START"
                    task="Memprotect_GC_ScanStack"
                    template="GCPhase"
                    value="177"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_SCANSTACK_STOP"
                    task="Memprotect_GC_ScanStack"
                    template="GCPhase"
                    value="178"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_MARK_START"
                    task="Memprotect_GC_Mark"
                    template="GCPhase"
                    value="179"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_MARK_STOP"
                    task="Memprotect_GC_Mark"
                    template="GCPhase"
                    value="180"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_RESCAN_START"
                    task="Memprotect_GC_Rescan"
                    template="GCPhase"
                    value="181"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_RESCAN_STOP"
                    task="Memprotect_GC_Rescan"
                    template="GCPhase"
                    value="182"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_SWEEP_START"
                    task="Memprotect_GC_Sweep"
                    template="GCPhase"
                    value="183"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_SWEEP_STOP"
                    task="Memprotect_GC_Sweep"
                    template="GCPhaseCollect"
                    value="184"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_SETUPBACKGROUNDSWEEP_START"
                    task="Memprotect_GC_SetupBackgroundSweep"
                    template="GCPhase"
                    value="185"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_SETUPBACKGROUNDSWEEP_STOP"
                    task="Memprotect_GC_SetupBackgroundSweep"
                    template="GCPhase"
                    value="186"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_BACKGROUNDSWEEP_START"
                    task="Memprotect_GC_BackgroundSweep"
                    template="GCPhase"
                    value="187"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_BACKGROUNDSWEEP_STOP"
                    task="Memprotect_GC_BackgroundSweep"
                    template="GCPhaseCollect"
                    value="188"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_TRANSFERSWEPTOBJECTS_START"
                    task="Memprotect_GC_TransferSweptObjects"
                    template="GCPhase"
                    value="189"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_TRANSFERSWEPTOBJECTS_STOP"
                    task="Memprotect_GC_TransferSweptObjects"
                    template="GCPhase"
                    value="190"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_DISPOSE_START"
                    task="Memprotect_GC_Dispose"
                    template="GCPhase"
                    value="191"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_DISPOSE_STOP"
                    task="Memprotect_GC_Dispose"
                    template="GCPhaseCollect"
                    value="192"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_BACKGROUNDMARK_START"
                    task="Memprotect_GC_BackgroundMark"
                    template="GCBackgroundMark"
                    value="193"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_BACKGROUNDMARK_STOP"
                    task="Memprotect_GC_BackgroundMark"
                    template="GCBackgroundMark"
                    value="194"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_RESETWRITEWATCH_START"
                    task="Memprotect_GC_ResetWriteWatch"
                    template="GCPhase"
                    value="195"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_RESETWRITEWATCH_STOP"
                    task="Memprotect_GC_ResetWriteWatch"
                    template="GCPhase"
                    value="196"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_IDLE_START"
                    task="Memprotect_GC_IdleCollect"
                    template="GCPhase"
                    value="197"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Info"
                    symbol="MEMPROTECT_GC_IDLE_CALLBACK_NEWCOLLECT"
                    task="Memprotect_GC_IdleCollect"
                    template="GCPhase"
                    value="198"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Info"
                    symbol="MEMPROTECT_GC_IDLE_CALLBACK_FINISH"
                    task="Memprotect_GC_IdleCollect"
                    template="GCPhase"
                    value="199"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Info"
                    symbol="MEMPROTECT_GC_IDLE_SCHEDULED"
                    task="Memprotect_GC_IdleCollect"
                    template="GCPhase"
                    value="200"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_IDLE_FINISHED"
                    task="Memprotect_GC_IdleCollect"
                    template="GCPhase"
                    value="201"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_SWEEP_WEAKREF_START"
                    task="Memprotect_GC_SweepWeakRef"
                    template="GCPhase"
                    value="202"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_SWEEP_WEAKREF_STOP"
                    task="Memprotect_GC_SweepWeakRef"
                    template="GCPhase"
                    value="203"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_PROCESS_TRACKED_OBJECT_START"
                    task="Memprotect_GC_ProcessTrackedObject"
                    template="GCPhase"
                    value="204"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_PROCESS_TRACKED_OBJECT_STOP"
                    task="Memprotect_GC_ProcessTrackedObject"
                    template="GCPhase"
                    value="205"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_PROCESS_CLIENT_TRACKED_OBJECT_START"
                    task="Memprotect_GC_ProcessClientTrackedObject"
                    template="GCPhase"
                    value="206"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_PROCESS_CLIENT_TRACKED_OBJECT_STOP"
                    task="Memprotect_GC_ProcessClientTrackedObject"
                    template="GCPhase"
                    value="207"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_BACKGROUNDZEROPAGE_START"
                    task="Memprotect_GC_BackgroundZeroPage"
                    template="GCPhase"
                    value="208"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_BACKGROUNDZEROPAGE_STOP"
                    task="Memprotect_GC_BackgroundZeroPage"
                    template="GCPhase"
                    value="209"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_FLUSHZEROPAGE_START"
                    task="Memprotect_GC_FlushZeroPage"
                    template="GCPhase"
                    value="210"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_FLUSHZEROPAGE_STOP"
                    task="Memprotect_GC_FlushZeroPage"
                    template="GCPhase"
                    value="211"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_DECOMMIT_CONCURRENT_COLLECT_PAGE_ALLOCATOR_START"
                    task="Memprotect_GC_DecommitConcurrentCollectPageAllocator"
                    template="GCPhase"
                    value="212"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_DECOMMIT_CONCURRENT_COLLECT_PAGE_ALLOCATOR_STOP"
                    task="Memprotect_GC_DecommitConcurrentCollectPageAllocator"
                    template="GCPhase"
                    value="213"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_SWEEP_PARTIAL_REUSE_PAGE_START"
                    task="Memprotect_GC_SweepPartialReusePage"
                    template="GCPhase"
                    value="214"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_SWEEP_PARTIAL_REUSE_PAGE_STOP"
                    task="Memprotect_GC_SweepPartialReusePage"
                    template="GCPhase"
                    value="215"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_BACKGROUNDRESCAN_START"
                    task="Memprotect_GC_BackgroundRescan"
                    template="GCBackgroundMark"
                    value="216"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_BACKGROUNDRESCAN_STOP"
                    task="Memprotect_GC_BackgroundRescan"
                    template="GCBackgroundMark"
                    value="217"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_BACKGROUNDRESETWRITEWATCH_START"
                    task="Memprotect_GC_BackgroundResetWriteWatch"
                    template="GCBackgroundMark"
                    value="218"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_BACKGROUNDRESETWRITEWATCH_STOP"
                    task="Memprotect_GC_BackgroundResetWriteWatch"
                    template="GCBackgroundMark"
                    value="219"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_BACKGROUNDSCANROOTS_START"
                    task="Memprotect_GC_BackgroundScanRoots"
                    template="GCPhase"
                    value="220"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_BACKGROUNDSCANROOTS_STOP"
                    task="Memprotect_GC_BackgroundScanRoots"
                    template="GCPhase"
                    value="221"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_BACKGROUNDRESETMARKS_START"
                    task="Memprotect_GC_BackgroundResetMarks"
                    template="GCPhase"
                    value="222"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_BACKGROUNDRESETMARKS_STOP"
                    task="Memprotect_GC_BackgroundResetMarks"
                    template="GCPhase"
                    value="223"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_RESCANMARKWAIT_START"
                    task="Memprotect_GC_RescanMarkWait"
                    template="GCWaitStart"
                    value="224"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_RESCANMARKWAIT_STOP"
                    task="Memprotect_GC_RescanMarkWait"
                    template="GCWaitStop"
                    value="225"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_SYNCHRONOUSMARKWAIT_START"
                    task="Memprotect_GC_SynchronousMarkWait"
                    template="GCWaitStart"
                    value="226"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_SYNCHRONOUSMARKWAIT_STOP"
                    task="Memprotect_GC_SynchronousMarkWait"
                    template="GCWaitStop"
                    value="227"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_FINISHCONCURRENTWAIT_START"
                    task="Memprotect_GC_FinishConcurrentWait"
                    template="GCWaitStart"
                    value="228"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_FINISHCONCURRENTWAIT_STOP"
                    task="Memprotect_GC_FinishConcurrentWait"
                    template="GCWaitStop"
                    value="229"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_ENDMARKONLOWMEMORY_START"
                    task="Memprotect_GC_EndMarkOnLowMemory"
                    template="GCPhase"
                    value="230"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_ENDMARKONLOWMEMORY_STOP"
                    task="Memprotect_GC_EndMarkOnLowMemory"
                    template="GCPhase"
                    value="231"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_PARALLELMARK_START"
                    task="Memprotect_GC_ParallelMark"
                    template="GCPhase"
                    value="232"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_PARALLELMARK_STOP"
                    task="Memprotect_GC_ParallelMark"
                    template="GCPhase"
                    value="233"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_BACKGROUNDPARALLELMARK_START"
                    task="Memprotect_GC_BackgroundParallelMark"
                    template="GCBackgroundMark"
                    value="234"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_BACKGROUNDPARALLELMARK_STOP"
                    task="Memprotect_GC_BackgroundParallelMark"
                    template="GCBackgroundMark"
                    value="235"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Start"
                    symbol="MEMPROTECT_GC_START"
                    task="Memprotect_GC"
                    template="Element_Zero"
                    value="236"
                    />
                <event
                    keywords="MemProtectGarbageCollection"
                    opcode="win:Stop"
                    symbol="MEMPROTECT_GC_STOP"
                    task="Memprotect_GC"
                    template="Element_Zero"
                    value="237"
                    />
                <event
                    keywords="MemProtectObjectAllocation"
                    opcode="win:Info"
                    symbol="MEMPROTECT_OBJECT_ALLOCATION"
                    task="Memprotect_GC_Allocation"
                    template="MemprotectObjectAlloc"
                    value="238"
                    />
                <event
                    keywords="MemProtectObjectAllocation"
                    opcode="win:Info"
                    symbol="MEMPROTECT_OBJECT_UNROOT"
                    task="Memprotect_GC_Unroot"
                    template="MemprotectObjectUnroot"
                    value="239"
                    />
                <event
                    keywords="JScriptGarbageCollection"
                    opcode="win:Info"
                    symbol="JSCRIPT_GC_INIT"
                    task="Jscript_GC_Init"
                    template="GCInit"
                    value="240"
                    />
                <event
                    keywords="MemProtectHeapSize"
                    opcode="win:Info"
                    symbol="MEMPROTECT_GC_HEAP_SIZE"
                    task="Memprotect_GC_Heap_Size"
                    template="MemprotectHeap"
                    value="241"
                    />
                <event
                    keywords="Internal"
                    opcode="win:Info"
                    symbol="JSCRIPT_INTERNAL_GENERIC_EVENT"
                    task="Jscript_Internal_Generic_Event"
                    template="InternalGenericEvent"
                    value="242"
                    />
                <event
                    keywords="JScriptGCBucketStats"
                    level="win:Verbose"
                    opcode="win:Info"
                    symbol="JSCRIPT_GC_BUCKET_STATS"
                    task="Jscript_GC_Bucket_Stats"
                    template="GCBucketStats"
                    value="243"
                    />
                <event
                    keywords="MemProtectGCBucketStats"
                    level="win:Verbose"
                    opcode="win:Info"
                    symbol="MEMPROTECT_GC_BUCKET_STATS"
                    task="Memprotect_GC_Bucket_Stats"
                    template="GCBucketStats"
                    value="244"
                    />
            </events>
            </provider>
        </events>
    </instrumentation>
    <localization>
        <resources culture="en-US">
            <stringTable>
                <string
                    id="JScriptProvider.Name"
                    value="Microsoft-JScript"
                    />
                <string
                    id="ManDesc"
                    value="Microsoft Scripting Manifest for JScript9"
                    />
                <string
                    id="ManName"
                    value="JScript9 Manifest"
                    />
                <string
                    id="JScriptProvider.Method.InterpretedMessage"
                    value="Interpreted"
                    />
                <string
                    id="JScriptProvider.Method.JittedMessage"
                    value="JIT"
                    />
                <string
                    id="JScriptProvider.Method.JittedLoopBodyMessage"
                    value="JITLoopBody"
                    />
                <string
                    id="JScriptProvider.Method.SimpleJitMessage"
                    value="SimpleJit"
                    />
                <string
                    id="JScriptProvider.Method.FullJitMessage"
                    value="FullJit"
                    />
                <string
                    id="JScriptProvider.Source.ReasonLength"
                    value="ReasonLength"
                    />
                <string
                    id="JScriptProvider.Source.Reason"
                    value="Reason"
                    />
                <string
                    id="JScriptProvider.GCBucket.Normal_S}"
                    value="Normal (S)"
                    />
                <string
                    id="JScriptProvider.GCBucket.Leaf_S}"
                    value="Leaf (S)"
                    />
                <string
                    id="JScriptProvider.GCBucket.Fin_S}"
                    value="Fin (S)"
                    />
                <string
                    id="JScriptProvider.GCBucket.NormWB_S}"
                    value="NormWB (S)"
                    />
                <string
                    id="JScriptProvider.GCBucket.FinWB_S}"
                    value="FinWB (S)"
                    />
                <string
                    id="JScriptProvider.GCBucket.Visited_S}"
                    value="Visited (S)"
                    />
                <string
                    id="JScriptProvider.GCBucket.Normal_M}"
                    value="Normal (M)"
                    />
                <string
                    id="JScriptProvider.GCBucket.Leaf_M}"
                    value="Leaf (M)"
                    />
                <string
                    id="JScriptProvider.GCBucket.Fin_M}"
                    value="Fin (M)"
                    />
                <string
                    id="JScriptProvider.GCBucket.NormWB_M}"
                    value="NormWB (M)"
                    />
                <string
                    id="JScriptProvider.GCBucket.FinWB_M}"
                    value="FinWB (M)"
                    />
                <string
                    id="JScriptProvider.GCBucket.Visited_M}"
                    value="Visited (M)"
                    />
                <string
                    id="JScriptProvider.GCBucket.Large"
                    value="Large"
                    />
                <string
                    id="JScriptProvider.GCBucket.Total"
                    value="Total"
                    />
            </stringTable>
        </resources>
    </localization>
</instrumentationManifest>
