;; This tests that the stack overflow guard page can't be skipped by a function with more than a page of locals.
(module
  (memory 1)
  (export "test-guard-page-skip" (func $test-guard-page-skip))

  (func $test-guard-page-skip
    (param $depth i32)
    (if (i32.eq (get_local $depth) (i32.const 0))
      (then (call $function-with-many-locals))
      (else (call $test-guard-page-skip (i32.sub (get_local $depth) (i32.const 1))))
    )
  )

  (func $function-with-many-locals

    ;; 1056 i64 = 8448 bytes of locals
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x000-0x007
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x008-0x00f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x010-0x017
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x018-0x01f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x020-0x027
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x028-0x02f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x030-0x037
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x038-0x03f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x040-0x047
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x048-0x04f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x050-0x057
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x058-0x05f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x060-0x067
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x068-0x06f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x070-0x077
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x078-0x07f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x080-0x087
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x088-0x08f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x090-0x097
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x098-0x09f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0a0-0x0a7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0a8-0x0af
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0b0-0x0b7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0b8-0x0bf
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0c0-0x0c7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0c8-0x0cf
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0d0-0x0d7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0d8-0x0df
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0e0-0x0e7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0e8-0x0ef
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0f0-0x0f7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x0f8-0x0ff

    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x100-0x107
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x108-0x10f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x110-0x117
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x118-0x11f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x120-0x127
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x128-0x12f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x130-0x137
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x138-0x13f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x140-0x147
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x148-0x14f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x150-0x157
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x158-0x15f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x160-0x167
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x168-0x16f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x170-0x177
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x178-0x17f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x180-0x187
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x188-0x18f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x190-0x197
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x198-0x19f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1a0-0x1a7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1a8-0x1af
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1b0-0x1b7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1b8-0x1bf
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1c0-0x1c7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1c8-0x1cf
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1d0-0x1d7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1d8-0x1df
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1e0-0x1e7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1e8-0x1ef
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1f0-0x1f7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x1f8-0x1ff

    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x200-0x207
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x208-0x20f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x210-0x217
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x218-0x21f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x220-0x227
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x228-0x22f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x230-0x237
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x238-0x23f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x240-0x247
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x248-0x24f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x250-0x257
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x258-0x25f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x260-0x267
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x268-0x26f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x270-0x277
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x278-0x27f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x280-0x287
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x288-0x28f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x290-0x297
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x298-0x29f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2a0-0x2a7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2a8-0x2af
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2b0-0x2b7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2b8-0x2bf
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2c0-0x2c7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2c8-0x2cf
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2d0-0x2d7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2d8-0x2df
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2e0-0x2e7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2e8-0x2ef
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2f0-0x2f7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x2f8-0x2ff

    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x300-0x307
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x308-0x30f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x310-0x317
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x318-0x31f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x320-0x327
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x328-0x32f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x330-0x337
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x338-0x33f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x340-0x347
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x348-0x34f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x350-0x357
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x358-0x35f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x360-0x367
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x368-0x36f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x370-0x377
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x378-0x37f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x380-0x387
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x388-0x38f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x390-0x397
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x398-0x39f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3a0-0x3a7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3a8-0x3af
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3b0-0x3b7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3b8-0x3bf
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3c0-0x3c7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3c8-0x3cf
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3d0-0x3d7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3d8-0x3df
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3e0-0x3e7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3e8-0x3ef
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3f0-0x3f7
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x3f8-0x3ff

    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x400-0x407
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x408-0x40f
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x410-0x417
    (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) (local i64) ;; 0x418-0x41f

    ;; recurse first to try to make the callee access the stack below the space allocated for the locals before the locals themselves have been initialized.
    (call $function-with-many-locals)

    ;; load from memory into the locals
    (set_local 0x000 (i64.load offset=0x000 align=1 (i32.const 0)))
    (set_local 0x001 (i64.load offset=0x001 align=1 (i32.const 0)))
    (set_local 0x002 (i64.load offset=0x002 align=1 (i32.const 0)))
    (set_local 0x003 (i64.load offset=0x003 align=1 (i32.const 0)))
    (set_local 0x004 (i64.load offset=0x004 align=1 (i32.const 0)))
    (set_local 0x005 (i64.load offset=0x005 align=1 (i32.const 0)))
    (set_local 0x006 (i64.load offset=0x006 align=1 (i32.const 0)))
    (set_local 0x007 (i64.load offset=0x007 align=1 (i32.const 0)))
    (set_local 0x008 (i64.load offset=0x008 align=1 (i32.const 0)))
    (set_local 0x009 (i64.load offset=0x009 align=1 (i32.const 0)))
    (set_local 0x00a (i64.load offset=0x00a align=1 (i32.const 0)))
    (set_local 0x00b (i64.load offset=0x00b align=1 (i32.const 0)))
    (set_local 0x00c (i64.load offset=0x00c align=1 (i32.const 0)))
    (set_local 0x00d (i64.load offset=0x00d align=1 (i32.const 0)))
    (set_local 0x00e (i64.load offset=0x00e align=1 (i32.const 0)))
    (set_local 0x00f (i64.load offset=0x00f align=1 (i32.const 0)))
    (set_local 0x010 (i64.load offset=0x010 align=1 (i32.const 0)))
    (set_local 0x011 (i64.load offset=0x011 align=1 (i32.const 0)))
    (set_local 0x012 (i64.load offset=0x012 align=1 (i32.const 0)))
    (set_local 0x013 (i64.load offset=0x013 align=1 (i32.const 0)))
    (set_local 0x014 (i64.load offset=0x014 align=1 (i32.const 0)))
    (set_local 0x015 (i64.load offset=0x015 align=1 (i32.const 0)))
    (set_local 0x016 (i64.load offset=0x016 align=1 (i32.const 0)))
    (set_local 0x017 (i64.load offset=0x017 align=1 (i32.const 0)))
    (set_local 0x018 (i64.load offset=0x018 align=1 (i32.const 0)))
    (set_local 0x019 (i64.load offset=0x019 align=1 (i32.const 0)))
    (set_local 0x01a (i64.load offset=0x01a align=1 (i32.const 0)))
    (set_local 0x01b (i64.load offset=0x01b align=1 (i32.const 0)))
    (set_local 0x01c (i64.load offset=0x01c align=1 (i32.const 0)))
    (set_local 0x01d (i64.load offset=0x01d align=1 (i32.const 0)))
    (set_local 0x01e (i64.load offset=0x01e align=1 (i32.const 0)))
    (set_local 0x01f (i64.load offset=0x01f align=1 (i32.const 0)))
    (set_local 0x020 (i64.load offset=0x020 align=1 (i32.const 0)))
    (set_local 0x021 (i64.load offset=0x021 align=1 (i32.const 0)))
    (set_local 0x022 (i64.load offset=0x022 align=1 (i32.const 0)))
    (set_local 0x023 (i64.load offset=0x023 align=1 (i32.const 0)))
    (set_local 0x024 (i64.load offset=0x024 align=1 (i32.const 0)))
    (set_local 0x025 (i64.load offset=0x025 align=1 (i32.const 0)))
    (set_local 0x026 (i64.load offset=0x026 align=1 (i32.const 0)))
    (set_local 0x027 (i64.load offset=0x027 align=1 (i32.const 0)))
    (set_local 0x028 (i64.load offset=0x028 align=1 (i32.const 0)))
    (set_local 0x029 (i64.load offset=0x029 align=1 (i32.const 0)))
    (set_local 0x02a (i64.load offset=0x02a align=1 (i32.const 0)))
    (set_local 0x02b (i64.load offset=0x02b align=1 (i32.const 0)))
    (set_local 0x02c (i64.load offset=0x02c align=1 (i32.const 0)))
    (set_local 0x02d (i64.load offset=0x02d align=1 (i32.const 0)))
    (set_local 0x02e (i64.load offset=0x02e align=1 (i32.const 0)))
    (set_local 0x02f (i64.load offset=0x02f align=1 (i32.const 0)))
    (set_local 0x030 (i64.load offset=0x030 align=1 (i32.const 0)))
    (set_local 0x031 (i64.load offset=0x031 align=1 (i32.const 0)))
    (set_local 0x032 (i64.load offset=0x032 align=1 (i32.const 0)))
    (set_local 0x033 (i64.load offset=0x033 align=1 (i32.const 0)))
    (set_local 0x034 (i64.load offset=0x034 align=1 (i32.const 0)))
    (set_local 0x035 (i64.load offset=0x035 align=1 (i32.const 0)))
    (set_local 0x036 (i64.load offset=0x036 align=1 (i32.const 0)))
    (set_local 0x037 (i64.load offset=0x037 align=1 (i32.const 0)))
    (set_local 0x038 (i64.load offset=0x038 align=1 (i32.const 0)))
    (set_local 0x039 (i64.load offset=0x039 align=1 (i32.const 0)))
    (set_local 0x03a (i64.load offset=0x03a align=1 (i32.const 0)))
    (set_local 0x03b (i64.load offset=0x03b align=1 (i32.const 0)))
    (set_local 0x03c (i64.load offset=0x03c align=1 (i32.const 0)))
    (set_local 0x03d (i64.load offset=0x03d align=1 (i32.const 0)))
    (set_local 0x03e (i64.load offset=0x03e align=1 (i32.const 0)))
    (set_local 0x03f (i64.load offset=0x03f align=1 (i32.const 0)))
    (set_local 0x040 (i64.load offset=0x040 align=1 (i32.const 0)))
    (set_local 0x041 (i64.load offset=0x041 align=1 (i32.const 0)))
    (set_local 0x042 (i64.load offset=0x042 align=1 (i32.const 0)))
    (set_local 0x043 (i64.load offset=0x043 align=1 (i32.const 0)))
    (set_local 0x044 (i64.load offset=0x044 align=1 (i32.const 0)))
    (set_local 0x045 (i64.load offset=0x045 align=1 (i32.const 0)))
    (set_local 0x046 (i64.load offset=0x046 align=1 (i32.const 0)))
    (set_local 0x047 (i64.load offset=0x047 align=1 (i32.const 0)))
    (set_local 0x048 (i64.load offset=0x048 align=1 (i32.const 0)))
    (set_local 0x049 (i64.load offset=0x049 align=1 (i32.const 0)))
    (set_local 0x04a (i64.load offset=0x04a align=1 (i32.const 0)))
    (set_local 0x04b (i64.load offset=0x04b align=1 (i32.const 0)))
    (set_local 0x04c (i64.load offset=0x04c align=1 (i32.const 0)))
    (set_local 0x04d (i64.load offset=0x04d align=1 (i32.const 0)))
    (set_local 0x04e (i64.load offset=0x04e align=1 (i32.const 0)))
    (set_local 0x04f (i64.load offset=0x04f align=1 (i32.const 0)))
    (set_local 0x050 (i64.load offset=0x050 align=1 (i32.const 0)))
    (set_local 0x051 (i64.load offset=0x051 align=1 (i32.const 0)))
    (set_local 0x052 (i64.load offset=0x052 align=1 (i32.const 0)))
    (set_local 0x053 (i64.load offset=0x053 align=1 (i32.const 0)))
    (set_local 0x054 (i64.load offset=0x054 align=1 (i32.const 0)))
    (set_local 0x055 (i64.load offset=0x055 align=1 (i32.const 0)))
    (set_local 0x056 (i64.load offset=0x056 align=1 (i32.const 0)))
    (set_local 0x057 (i64.load offset=0x057 align=1 (i32.const 0)))
    (set_local 0x058 (i64.load offset=0x058 align=1 (i32.const 0)))
    (set_local 0x059 (i64.load offset=0x059 align=1 (i32.const 0)))
    (set_local 0x05a (i64.load offset=0x05a align=1 (i32.const 0)))
    (set_local 0x05b (i64.load offset=0x05b align=1 (i32.const 0)))
    (set_local 0x05c (i64.load offset=0x05c align=1 (i32.const 0)))
    (set_local 0x05d (i64.load offset=0x05d align=1 (i32.const 0)))
    (set_local 0x05e (i64.load offset=0x05e align=1 (i32.const 0)))
    (set_local 0x05f (i64.load offset=0x05f align=1 (i32.const 0)))
    (set_local 0x060 (i64.load offset=0x060 align=1 (i32.const 0)))
    (set_local 0x061 (i64.load offset=0x061 align=1 (i32.const 0)))
    (set_local 0x062 (i64.load offset=0x062 align=1 (i32.const 0)))
    (set_local 0x063 (i64.load offset=0x063 align=1 (i32.const 0)))
    (set_local 0x064 (i64.load offset=0x064 align=1 (i32.const 0)))
    (set_local 0x065 (i64.load offset=0x065 align=1 (i32.const 0)))
    (set_local 0x066 (i64.load offset=0x066 align=1 (i32.const 0)))
    (set_local 0x067 (i64.load offset=0x067 align=1 (i32.const 0)))
    (set_local 0x068 (i64.load offset=0x068 align=1 (i32.const 0)))
    (set_local 0x069 (i64.load offset=0x069 align=1 (i32.const 0)))
    (set_local 0x06a (i64.load offset=0x06a align=1 (i32.const 0)))
    (set_local 0x06b (i64.load offset=0x06b align=1 (i32.const 0)))
    (set_local 0x06c (i64.load offset=0x06c align=1 (i32.const 0)))
    (set_local 0x06d (i64.load offset=0x06d align=1 (i32.const 0)))
    (set_local 0x06e (i64.load offset=0x06e align=1 (i32.const 0)))
    (set_local 0x06f (i64.load offset=0x06f align=1 (i32.const 0)))
    (set_local 0x070 (i64.load offset=0x070 align=1 (i32.const 0)))
    (set_local 0x071 (i64.load offset=0x071 align=1 (i32.const 0)))
    (set_local 0x072 (i64.load offset=0x072 align=1 (i32.const 0)))
    (set_local 0x073 (i64.load offset=0x073 align=1 (i32.const 0)))
    (set_local 0x074 (i64.load offset=0x074 align=1 (i32.const 0)))
    (set_local 0x075 (i64.load offset=0x075 align=1 (i32.const 0)))
    (set_local 0x076 (i64.load offset=0x076 align=1 (i32.const 0)))
    (set_local 0x077 (i64.load offset=0x077 align=1 (i32.const 0)))
    (set_local 0x078 (i64.load offset=0x078 align=1 (i32.const 0)))
    (set_local 0x079 (i64.load offset=0x079 align=1 (i32.const 0)))
    (set_local 0x07a (i64.load offset=0x07a align=1 (i32.const 0)))
    (set_local 0x07b (i64.load offset=0x07b align=1 (i32.const 0)))
    (set_local 0x07c (i64.load offset=0x07c align=1 (i32.const 0)))
    (set_local 0x07d (i64.load offset=0x07d align=1 (i32.const 0)))
    (set_local 0x07e (i64.load offset=0x07e align=1 (i32.const 0)))
    (set_local 0x07f (i64.load offset=0x07f align=1 (i32.const 0)))
    (set_local 0x080 (i64.load offset=0x080 align=1 (i32.const 0)))
    (set_local 0x081 (i64.load offset=0x081 align=1 (i32.const 0)))
    (set_local 0x082 (i64.load offset=0x082 align=1 (i32.const 0)))
    (set_local 0x083 (i64.load offset=0x083 align=1 (i32.const 0)))
    (set_local 0x084 (i64.load offset=0x084 align=1 (i32.const 0)))
    (set_local 0x085 (i64.load offset=0x085 align=1 (i32.const 0)))
    (set_local 0x086 (i64.load offset=0x086 align=1 (i32.const 0)))
    (set_local 0x087 (i64.load offset=0x087 align=1 (i32.const 0)))
    (set_local 0x088 (i64.load offset=0x088 align=1 (i32.const 0)))
    (set_local 0x089 (i64.load offset=0x089 align=1 (i32.const 0)))
    (set_local 0x08a (i64.load offset=0x08a align=1 (i32.const 0)))
    (set_local 0x08b (i64.load offset=0x08b align=1 (i32.const 0)))
    (set_local 0x08c (i64.load offset=0x08c align=1 (i32.const 0)))
    (set_local 0x08d (i64.load offset=0x08d align=1 (i32.const 0)))
    (set_local 0x08e (i64.load offset=0x08e align=1 (i32.const 0)))
    (set_local 0x08f (i64.load offset=0x08f align=1 (i32.const 0)))
    (set_local 0x090 (i64.load offset=0x090 align=1 (i32.const 0)))
    (set_local 0x091 (i64.load offset=0x091 align=1 (i32.const 0)))
    (set_local 0x092 (i64.load offset=0x092 align=1 (i32.const 0)))
    (set_local 0x093 (i64.load offset=0x093 align=1 (i32.const 0)))
    (set_local 0x094 (i64.load offset=0x094 align=1 (i32.const 0)))
    (set_local 0x095 (i64.load offset=0x095 align=1 (i32.const 0)))
    (set_local 0x096 (i64.load offset=0x096 align=1 (i32.const 0)))
    (set_local 0x097 (i64.load offset=0x097 align=1 (i32.const 0)))
    (set_local 0x098 (i64.load offset=0x098 align=1 (i32.const 0)))
    (set_local 0x099 (i64.load offset=0x099 align=1 (i32.const 0)))
    (set_local 0x09a (i64.load offset=0x09a align=1 (i32.const 0)))
    (set_local 0x09b (i64.load offset=0x09b align=1 (i32.const 0)))
    (set_local 0x09c (i64.load offset=0x09c align=1 (i32.const 0)))
    (set_local 0x09d (i64.load offset=0x09d align=1 (i32.const 0)))
    (set_local 0x09e (i64.load offset=0x09e align=1 (i32.const 0)))
    (set_local 0x09f (i64.load offset=0x09f align=1 (i32.const 0)))
    (set_local 0x0a0 (i64.load offset=0x0a0 align=1 (i32.const 0)))
    (set_local 0x0a1 (i64.load offset=0x0a1 align=1 (i32.const 0)))
    (set_local 0x0a2 (i64.load offset=0x0a2 align=1 (i32.const 0)))
    (set_local 0x0a3 (i64.load offset=0x0a3 align=1 (i32.const 0)))
    (set_local 0x0a4 (i64.load offset=0x0a4 align=1 (i32.const 0)))
    (set_local 0x0a5 (i64.load offset=0x0a5 align=1 (i32.const 0)))
    (set_local 0x0a6 (i64.load offset=0x0a6 align=1 (i32.const 0)))
    (set_local 0x0a7 (i64.load offset=0x0a7 align=1 (i32.const 0)))
    (set_local 0x0a8 (i64.load offset=0x0a8 align=1 (i32.const 0)))
    (set_local 0x0a9 (i64.load offset=0x0a9 align=1 (i32.const 0)))
    (set_local 0x0aa (i64.load offset=0x0aa align=1 (i32.const 0)))
    (set_local 0x0ab (i64.load offset=0x0ab align=1 (i32.const 0)))
    (set_local 0x0ac (i64.load offset=0x0ac align=1 (i32.const 0)))
    (set_local 0x0ad (i64.load offset=0x0ad align=1 (i32.const 0)))
    (set_local 0x0ae (i64.load offset=0x0ae align=1 (i32.const 0)))
    (set_local 0x0af (i64.load offset=0x0af align=1 (i32.const 0)))
    (set_local 0x0b0 (i64.load offset=0x0b0 align=1 (i32.const 0)))
    (set_local 0x0b1 (i64.load offset=0x0b1 align=1 (i32.const 0)))
    (set_local 0x0b2 (i64.load offset=0x0b2 align=1 (i32.const 0)))
    (set_local 0x0b3 (i64.load offset=0x0b3 align=1 (i32.const 0)))
    (set_local 0x0b4 (i64.load offset=0x0b4 align=1 (i32.const 0)))
    (set_local 0x0b5 (i64.load offset=0x0b5 align=1 (i32.const 0)))
    (set_local 0x0b6 (i64.load offset=0x0b6 align=1 (i32.const 0)))
    (set_local 0x0b7 (i64.load offset=0x0b7 align=1 (i32.const 0)))
    (set_local 0x0b8 (i64.load offset=0x0b8 align=1 (i32.const 0)))
    (set_local 0x0b9 (i64.load offset=0x0b9 align=1 (i32.const 0)))
    (set_local 0x0ba (i64.load offset=0x0ba align=1 (i32.const 0)))
    (set_local 0x0bb (i64.load offset=0x0bb align=1 (i32.const 0)))
    (set_local 0x0bc (i64.load offset=0x0bc align=1 (i32.const 0)))
    (set_local 0x0bd (i64.load offset=0x0bd align=1 (i32.const 0)))
    (set_local 0x0be (i64.load offset=0x0be align=1 (i32.const 0)))
    (set_local 0x0bf (i64.load offset=0x0bf align=1 (i32.const 0)))
    (set_local 0x0c0 (i64.load offset=0x0c0 align=1 (i32.const 0)))
    (set_local 0x0c1 (i64.load offset=0x0c1 align=1 (i32.const 0)))
    (set_local 0x0c2 (i64.load offset=0x0c2 align=1 (i32.const 0)))
    (set_local 0x0c3 (i64.load offset=0x0c3 align=1 (i32.const 0)))
    (set_local 0x0c4 (i64.load offset=0x0c4 align=1 (i32.const 0)))
    (set_local 0x0c5 (i64.load offset=0x0c5 align=1 (i32.const 0)))
    (set_local 0x0c6 (i64.load offset=0x0c6 align=1 (i32.const 0)))
    (set_local 0x0c7 (i64.load offset=0x0c7 align=1 (i32.const 0)))
    (set_local 0x0c8 (i64.load offset=0x0c8 align=1 (i32.const 0)))
    (set_local 0x0c9 (i64.load offset=0x0c9 align=1 (i32.const 0)))
    (set_local 0x0ca (i64.load offset=0x0ca align=1 (i32.const 0)))
    (set_local 0x0cb (i64.load offset=0x0cb align=1 (i32.const 0)))
    (set_local 0x0cc (i64.load offset=0x0cc align=1 (i32.const 0)))
    (set_local 0x0cd (i64.load offset=0x0cd align=1 (i32.const 0)))
    (set_local 0x0ce (i64.load offset=0x0ce align=1 (i32.const 0)))
    (set_local 0x0cf (i64.load offset=0x0cf align=1 (i32.const 0)))
    (set_local 0x0d0 (i64.load offset=0x0d0 align=1 (i32.const 0)))
    (set_local 0x0d1 (i64.load offset=0x0d1 align=1 (i32.const 0)))
    (set_local 0x0d2 (i64.load offset=0x0d2 align=1 (i32.const 0)))
    (set_local 0x0d3 (i64.load offset=0x0d3 align=1 (i32.const 0)))
    (set_local 0x0d4 (i64.load offset=0x0d4 align=1 (i32.const 0)))
    (set_local 0x0d5 (i64.load offset=0x0d5 align=1 (i32.const 0)))
    (set_local 0x0d6 (i64.load offset=0x0d6 align=1 (i32.const 0)))
    (set_local 0x0d7 (i64.load offset=0x0d7 align=1 (i32.const 0)))
    (set_local 0x0d8 (i64.load offset=0x0d8 align=1 (i32.const 0)))
    (set_local 0x0d9 (i64.load offset=0x0d9 align=1 (i32.const 0)))
    (set_local 0x0da (i64.load offset=0x0da align=1 (i32.const 0)))
    (set_local 0x0db (i64.load offset=0x0db align=1 (i32.const 0)))
    (set_local 0x0dc (i64.load offset=0x0dc align=1 (i32.const 0)))
    (set_local 0x0dd (i64.load offset=0x0dd align=1 (i32.const 0)))
    (set_local 0x0de (i64.load offset=0x0de align=1 (i32.const 0)))
    (set_local 0x0df (i64.load offset=0x0df align=1 (i32.const 0)))
    (set_local 0x0e0 (i64.load offset=0x0e0 align=1 (i32.const 0)))
    (set_local 0x0e1 (i64.load offset=0x0e1 align=1 (i32.const 0)))
    (set_local 0x0e2 (i64.load offset=0x0e2 align=1 (i32.const 0)))
    (set_local 0x0e3 (i64.load offset=0x0e3 align=1 (i32.const 0)))
    (set_local 0x0e4 (i64.load offset=0x0e4 align=1 (i32.const 0)))
    (set_local 0x0e5 (i64.load offset=0x0e5 align=1 (i32.const 0)))
    (set_local 0x0e6 (i64.load offset=0x0e6 align=1 (i32.const 0)))
    (set_local 0x0e7 (i64.load offset=0x0e7 align=1 (i32.const 0)))
    (set_local 0x0e8 (i64.load offset=0x0e8 align=1 (i32.const 0)))
    (set_local 0x0e9 (i64.load offset=0x0e9 align=1 (i32.const 0)))
    (set_local 0x0ea (i64.load offset=0x0ea align=1 (i32.const 0)))
    (set_local 0x0eb (i64.load offset=0x0eb align=1 (i32.const 0)))
    (set_local 0x0ec (i64.load offset=0x0ec align=1 (i32.const 0)))
    (set_local 0x0ed (i64.load offset=0x0ed align=1 (i32.const 0)))
    (set_local 0x0ee (i64.load offset=0x0ee align=1 (i32.const 0)))
    (set_local 0x0ef (i64.load offset=0x0ef align=1 (i32.const 0)))
    (set_local 0x0f0 (i64.load offset=0x0f0 align=1 (i32.const 0)))
    (set_local 0x0f1 (i64.load offset=0x0f1 align=1 (i32.const 0)))
    (set_local 0x0f2 (i64.load offset=0x0f2 align=1 (i32.const 0)))
    (set_local 0x0f3 (i64.load offset=0x0f3 align=1 (i32.const 0)))
    (set_local 0x0f4 (i64.load offset=0x0f4 align=1 (i32.const 0)))
    (set_local 0x0f5 (i64.load offset=0x0f5 align=1 (i32.const 0)))
    (set_local 0x0f6 (i64.load offset=0x0f6 align=1 (i32.const 0)))
    (set_local 0x0f7 (i64.load offset=0x0f7 align=1 (i32.const 0)))
    (set_local 0x0f8 (i64.load offset=0x0f8 align=1 (i32.const 0)))
    (set_local 0x0f9 (i64.load offset=0x0f9 align=1 (i32.const 0)))
    (set_local 0x0fa (i64.load offset=0x0fa align=1 (i32.const 0)))
    (set_local 0x0fb (i64.load offset=0x0fb align=1 (i32.const 0)))
    (set_local 0x0fc (i64.load offset=0x0fc align=1 (i32.const 0)))
    (set_local 0x0fd (i64.load offset=0x0fd align=1 (i32.const 0)))
    (set_local 0x0fe (i64.load offset=0x0fe align=1 (i32.const 0)))
    (set_local 0x0ff (i64.load offset=0x0ff align=1 (i32.const 0)))
    (set_local 0x100 (i64.load offset=0x100 align=1 (i32.const 0)))
    (set_local 0x101 (i64.load offset=0x101 align=1 (i32.const 0)))
    (set_local 0x102 (i64.load offset=0x102 align=1 (i32.const 0)))
    (set_local 0x103 (i64.load offset=0x103 align=1 (i32.const 0)))
    (set_local 0x104 (i64.load offset=0x104 align=1 (i32.const 0)))
    (set_local 0x105 (i64.load offset=0x105 align=1 (i32.const 0)))
    (set_local 0x106 (i64.load offset=0x106 align=1 (i32.const 0)))
    (set_local 0x107 (i64.load offset=0x107 align=1 (i32.const 0)))
    (set_local 0x108 (i64.load offset=0x108 align=1 (i32.const 0)))
    (set_local 0x109 (i64.load offset=0x109 align=1 (i32.const 0)))
    (set_local 0x10a (i64.load offset=0x10a align=1 (i32.const 0)))
    (set_local 0x10b (i64.load offset=0x10b align=1 (i32.const 0)))
    (set_local 0x10c (i64.load offset=0x10c align=1 (i32.const 0)))
    (set_local 0x10d (i64.load offset=0x10d align=1 (i32.const 0)))
    (set_local 0x10e (i64.load offset=0x10e align=1 (i32.const 0)))
    (set_local 0x10f (i64.load offset=0x10f align=1 (i32.const 0)))
    (set_local 0x110 (i64.load offset=0x110 align=1 (i32.const 0)))
    (set_local 0x111 (i64.load offset=0x111 align=1 (i32.const 0)))
    (set_local 0x112 (i64.load offset=0x112 align=1 (i32.const 0)))
    (set_local 0x113 (i64.load offset=0x113 align=1 (i32.const 0)))
    (set_local 0x114 (i64.load offset=0x114 align=1 (i32.const 0)))
    (set_local 0x115 (i64.load offset=0x115 align=1 (i32.const 0)))
    (set_local 0x116 (i64.load offset=0x116 align=1 (i32.const 0)))
    (set_local 0x117 (i64.load offset=0x117 align=1 (i32.const 0)))
    (set_local 0x118 (i64.load offset=0x118 align=1 (i32.const 0)))
    (set_local 0x119 (i64.load offset=0x119 align=1 (i32.const 0)))
    (set_local 0x11a (i64.load offset=0x11a align=1 (i32.const 0)))
    (set_local 0x11b (i64.load offset=0x11b align=1 (i32.const 0)))
    (set_local 0x11c (i64.load offset=0x11c align=1 (i32.const 0)))
    (set_local 0x11d (i64.load offset=0x11d align=1 (i32.const 0)))
    (set_local 0x11e (i64.load offset=0x11e align=1 (i32.const 0)))
    (set_local 0x11f (i64.load offset=0x11f align=1 (i32.const 0)))
    (set_local 0x120 (i64.load offset=0x120 align=1 (i32.const 0)))
    (set_local 0x121 (i64.load offset=0x121 align=1 (i32.const 0)))
    (set_local 0x122 (i64.load offset=0x122 align=1 (i32.const 0)))
    (set_local 0x123 (i64.load offset=0x123 align=1 (i32.const 0)))
    (set_local 0x124 (i64.load offset=0x124 align=1 (i32.const 0)))
    (set_local 0x125 (i64.load offset=0x125 align=1 (i32.const 0)))
    (set_local 0x126 (i64.load offset=0x126 align=1 (i32.const 0)))
    (set_local 0x127 (i64.load offset=0x127 align=1 (i32.const 0)))
    (set_local 0x128 (i64.load offset=0x128 align=1 (i32.const 0)))
    (set_local 0x129 (i64.load offset=0x129 align=1 (i32.const 0)))
    (set_local 0x12a (i64.load offset=0x12a align=1 (i32.const 0)))
    (set_local 0x12b (i64.load offset=0x12b align=1 (i32.const 0)))
    (set_local 0x12c (i64.load offset=0x12c align=1 (i32.const 0)))
    (set_local 0x12d (i64.load offset=0x12d align=1 (i32.const 0)))
    (set_local 0x12e (i64.load offset=0x12e align=1 (i32.const 0)))
    (set_local 0x12f (i64.load offset=0x12f align=1 (i32.const 0)))
    (set_local 0x130 (i64.load offset=0x130 align=1 (i32.const 0)))
    (set_local 0x131 (i64.load offset=0x131 align=1 (i32.const 0)))
    (set_local 0x132 (i64.load offset=0x132 align=1 (i32.const 0)))
    (set_local 0x133 (i64.load offset=0x133 align=1 (i32.const 0)))
    (set_local 0x134 (i64.load offset=0x134 align=1 (i32.const 0)))
    (set_local 0x135 (i64.load offset=0x135 align=1 (i32.const 0)))
    (set_local 0x136 (i64.load offset=0x136 align=1 (i32.const 0)))
    (set_local 0x137 (i64.load offset=0x137 align=1 (i32.const 0)))
    (set_local 0x138 (i64.load offset=0x138 align=1 (i32.const 0)))
    (set_local 0x139 (i64.load offset=0x139 align=1 (i32.const 0)))
    (set_local 0x13a (i64.load offset=0x13a align=1 (i32.const 0)))
    (set_local 0x13b (i64.load offset=0x13b align=1 (i32.const 0)))
    (set_local 0x13c (i64.load offset=0x13c align=1 (i32.const 0)))
    (set_local 0x13d (i64.load offset=0x13d align=1 (i32.const 0)))
    (set_local 0x13e (i64.load offset=0x13e align=1 (i32.const 0)))
    (set_local 0x13f (i64.load offset=0x13f align=1 (i32.const 0)))
    (set_local 0x140 (i64.load offset=0x140 align=1 (i32.const 0)))
    (set_local 0x141 (i64.load offset=0x141 align=1 (i32.const 0)))
    (set_local 0x142 (i64.load offset=0x142 align=1 (i32.const 0)))
    (set_local 0x143 (i64.load offset=0x143 align=1 (i32.const 0)))
    (set_local 0x144 (i64.load offset=0x144 align=1 (i32.const 0)))
    (set_local 0x145 (i64.load offset=0x145 align=1 (i32.const 0)))
    (set_local 0x146 (i64.load offset=0x146 align=1 (i32.const 0)))
    (set_local 0x147 (i64.load offset=0x147 align=1 (i32.const 0)))
    (set_local 0x148 (i64.load offset=0x148 align=1 (i32.const 0)))
    (set_local 0x149 (i64.load offset=0x149 align=1 (i32.const 0)))
    (set_local 0x14a (i64.load offset=0x14a align=1 (i32.const 0)))
    (set_local 0x14b (i64.load offset=0x14b align=1 (i32.const 0)))
    (set_local 0x14c (i64.load offset=0x14c align=1 (i32.const 0)))
    (set_local 0x14d (i64.load offset=0x14d align=1 (i32.const 0)))
    (set_local 0x14e (i64.load offset=0x14e align=1 (i32.const 0)))
    (set_local 0x14f (i64.load offset=0x14f align=1 (i32.const 0)))
    (set_local 0x150 (i64.load offset=0x150 align=1 (i32.const 0)))
    (set_local 0x151 (i64.load offset=0x151 align=1 (i32.const 0)))
    (set_local 0x152 (i64.load offset=0x152 align=1 (i32.const 0)))
    (set_local 0x153 (i64.load offset=0x153 align=1 (i32.const 0)))
    (set_local 0x154 (i64.load offset=0x154 align=1 (i32.const 0)))
    (set_local 0x155 (i64.load offset=0x155 align=1 (i32.const 0)))
    (set_local 0x156 (i64.load offset=0x156 align=1 (i32.const 0)))
    (set_local 0x157 (i64.load offset=0x157 align=1 (i32.const 0)))
    (set_local 0x158 (i64.load offset=0x158 align=1 (i32.const 0)))
    (set_local 0x159 (i64.load offset=0x159 align=1 (i32.const 0)))
    (set_local 0x15a (i64.load offset=0x15a align=1 (i32.const 0)))
    (set_local 0x15b (i64.load offset=0x15b align=1 (i32.const 0)))
    (set_local 0x15c (i64.load offset=0x15c align=1 (i32.const 0)))
    (set_local 0x15d (i64.load offset=0x15d align=1 (i32.const 0)))
    (set_local 0x15e (i64.load offset=0x15e align=1 (i32.const 0)))
    (set_local 0x15f (i64.load offset=0x15f align=1 (i32.const 0)))
    (set_local 0x160 (i64.load offset=0x160 align=1 (i32.const 0)))
    (set_local 0x161 (i64.load offset=0x161 align=1 (i32.const 0)))
    (set_local 0x162 (i64.load offset=0x162 align=1 (i32.const 0)))
    (set_local 0x163 (i64.load offset=0x163 align=1 (i32.const 0)))
    (set_local 0x164 (i64.load offset=0x164 align=1 (i32.const 0)))
    (set_local 0x165 (i64.load offset=0x165 align=1 (i32.const 0)))
    (set_local 0x166 (i64.load offset=0x166 align=1 (i32.const 0)))
    (set_local 0x167 (i64.load offset=0x167 align=1 (i32.const 0)))
    (set_local 0x168 (i64.load offset=0x168 align=1 (i32.const 0)))
    (set_local 0x169 (i64.load offset=0x169 align=1 (i32.const 0)))
    (set_local 0x16a (i64.load offset=0x16a align=1 (i32.const 0)))
    (set_local 0x16b (i64.load offset=0x16b align=1 (i32.const 0)))
    (set_local 0x16c (i64.load offset=0x16c align=1 (i32.const 0)))
    (set_local 0x16d (i64.load offset=0x16d align=1 (i32.const 0)))
    (set_local 0x16e (i64.load offset=0x16e align=1 (i32.const 0)))
    (set_local 0x16f (i64.load offset=0x16f align=1 (i32.const 0)))
    (set_local 0x170 (i64.load offset=0x170 align=1 (i32.const 0)))
    (set_local 0x171 (i64.load offset=0x171 align=1 (i32.const 0)))
    (set_local 0x172 (i64.load offset=0x172 align=1 (i32.const 0)))
    (set_local 0x173 (i64.load offset=0x173 align=1 (i32.const 0)))
    (set_local 0x174 (i64.load offset=0x174 align=1 (i32.const 0)))
    (set_local 0x175 (i64.load offset=0x175 align=1 (i32.const 0)))
    (set_local 0x176 (i64.load offset=0x176 align=1 (i32.const 0)))
    (set_local 0x177 (i64.load offset=0x177 align=1 (i32.const 0)))
    (set_local 0x178 (i64.load offset=0x178 align=1 (i32.const 0)))
    (set_local 0x179 (i64.load offset=0x179 align=1 (i32.const 0)))
    (set_local 0x17a (i64.load offset=0x17a align=1 (i32.const 0)))
    (set_local 0x17b (i64.load offset=0x17b align=1 (i32.const 0)))
    (set_local 0x17c (i64.load offset=0x17c align=1 (i32.const 0)))
    (set_local 0x17d (i64.load offset=0x17d align=1 (i32.const 0)))
    (set_local 0x17e (i64.load offset=0x17e align=1 (i32.const 0)))
    (set_local 0x17f (i64.load offset=0x17f align=1 (i32.const 0)))
    (set_local 0x180 (i64.load offset=0x180 align=1 (i32.const 0)))
    (set_local 0x181 (i64.load offset=0x181 align=1 (i32.const 0)))
    (set_local 0x182 (i64.load offset=0x182 align=1 (i32.const 0)))
    (set_local 0x183 (i64.load offset=0x183 align=1 (i32.const 0)))
    (set_local 0x184 (i64.load offset=0x184 align=1 (i32.const 0)))
    (set_local 0x185 (i64.load offset=0x185 align=1 (i32.const 0)))
    (set_local 0x186 (i64.load offset=0x186 align=1 (i32.const 0)))
    (set_local 0x187 (i64.load offset=0x187 align=1 (i32.const 0)))
    (set_local 0x188 (i64.load offset=0x188 align=1 (i32.const 0)))
    (set_local 0x189 (i64.load offset=0x189 align=1 (i32.const 0)))
    (set_local 0x18a (i64.load offset=0x18a align=1 (i32.const 0)))
    (set_local 0x18b (i64.load offset=0x18b align=1 (i32.const 0)))
    (set_local 0x18c (i64.load offset=0x18c align=1 (i32.const 0)))
    (set_local 0x18d (i64.load offset=0x18d align=1 (i32.const 0)))
    (set_local 0x18e (i64.load offset=0x18e align=1 (i32.const 0)))
    (set_local 0x18f (i64.load offset=0x18f align=1 (i32.const 0)))
    (set_local 0x190 (i64.load offset=0x190 align=1 (i32.const 0)))
    (set_local 0x191 (i64.load offset=0x191 align=1 (i32.const 0)))
    (set_local 0x192 (i64.load offset=0x192 align=1 (i32.const 0)))
    (set_local 0x193 (i64.load offset=0x193 align=1 (i32.const 0)))
    (set_local 0x194 (i64.load offset=0x194 align=1 (i32.const 0)))
    (set_local 0x195 (i64.load offset=0x195 align=1 (i32.const 0)))
    (set_local 0x196 (i64.load offset=0x196 align=1 (i32.const 0)))
    (set_local 0x197 (i64.load offset=0x197 align=1 (i32.const 0)))
    (set_local 0x198 (i64.load offset=0x198 align=1 (i32.const 0)))
    (set_local 0x199 (i64.load offset=0x199 align=1 (i32.const 0)))
    (set_local 0x19a (i64.load offset=0x19a align=1 (i32.const 0)))
    (set_local 0x19b (i64.load offset=0x19b align=1 (i32.const 0)))
    (set_local 0x19c (i64.load offset=0x19c align=1 (i32.const 0)))
    (set_local 0x19d (i64.load offset=0x19d align=1 (i32.const 0)))
    (set_local 0x19e (i64.load offset=0x19e align=1 (i32.const 0)))
    (set_local 0x19f (i64.load offset=0x19f align=1 (i32.const 0)))
    (set_local 0x1a0 (i64.load offset=0x1a0 align=1 (i32.const 0)))
    (set_local 0x1a1 (i64.load offset=0x1a1 align=1 (i32.const 0)))
    (set_local 0x1a2 (i64.load offset=0x1a2 align=1 (i32.const 0)))
    (set_local 0x1a3 (i64.load offset=0x1a3 align=1 (i32.const 0)))
    (set_local 0x1a4 (i64.load offset=0x1a4 align=1 (i32.const 0)))
    (set_local 0x1a5 (i64.load offset=0x1a5 align=1 (i32.const 0)))
    (set_local 0x1a6 (i64.load offset=0x1a6 align=1 (i32.const 0)))
    (set_local 0x1a7 (i64.load offset=0x1a7 align=1 (i32.const 0)))
    (set_local 0x1a8 (i64.load offset=0x1a8 align=1 (i32.const 0)))
    (set_local 0x1a9 (i64.load offset=0x1a9 align=1 (i32.const 0)))
    (set_local 0x1aa (i64.load offset=0x1aa align=1 (i32.const 0)))
    (set_local 0x1ab (i64.load offset=0x1ab align=1 (i32.const 0)))
    (set_local 0x1ac (i64.load offset=0x1ac align=1 (i32.const 0)))
    (set_local 0x1ad (i64.load offset=0x1ad align=1 (i32.const 0)))
    (set_local 0x1ae (i64.load offset=0x1ae align=1 (i32.const 0)))
    (set_local 0x1af (i64.load offset=0x1af align=1 (i32.const 0)))
    (set_local 0x1b0 (i64.load offset=0x1b0 align=1 (i32.const 0)))
    (set_local 0x1b1 (i64.load offset=0x1b1 align=1 (i32.const 0)))
    (set_local 0x1b2 (i64.load offset=0x1b2 align=1 (i32.const 0)))
    (set_local 0x1b3 (i64.load offset=0x1b3 align=1 (i32.const 0)))
    (set_local 0x1b4 (i64.load offset=0x1b4 align=1 (i32.const 0)))
    (set_local 0x1b5 (i64.load offset=0x1b5 align=1 (i32.const 0)))
    (set_local 0x1b6 (i64.load offset=0x1b6 align=1 (i32.const 0)))
    (set_local 0x1b7 (i64.load offset=0x1b7 align=1 (i32.const 0)))
    (set_local 0x1b8 (i64.load offset=0x1b8 align=1 (i32.const 0)))
    (set_local 0x1b9 (i64.load offset=0x1b9 align=1 (i32.const 0)))
    (set_local 0x1ba (i64.load offset=0x1ba align=1 (i32.const 0)))
    (set_local 0x1bb (i64.load offset=0x1bb align=1 (i32.const 0)))
    (set_local 0x1bc (i64.load offset=0x1bc align=1 (i32.const 0)))
    (set_local 0x1bd (i64.load offset=0x1bd align=1 (i32.const 0)))
    (set_local 0x1be (i64.load offset=0x1be align=1 (i32.const 0)))
    (set_local 0x1bf (i64.load offset=0x1bf align=1 (i32.const 0)))
    (set_local 0x1c0 (i64.load offset=0x1c0 align=1 (i32.const 0)))
    (set_local 0x1c1 (i64.load offset=0x1c1 align=1 (i32.const 0)))
    (set_local 0x1c2 (i64.load offset=0x1c2 align=1 (i32.const 0)))
    (set_local 0x1c3 (i64.load offset=0x1c3 align=1 (i32.const 0)))
    (set_local 0x1c4 (i64.load offset=0x1c4 align=1 (i32.const 0)))
    (set_local 0x1c5 (i64.load offset=0x1c5 align=1 (i32.const 0)))
    (set_local 0x1c6 (i64.load offset=0x1c6 align=1 (i32.const 0)))
    (set_local 0x1c7 (i64.load offset=0x1c7 align=1 (i32.const 0)))
    (set_local 0x1c8 (i64.load offset=0x1c8 align=1 (i32.const 0)))
    (set_local 0x1c9 (i64.load offset=0x1c9 align=1 (i32.const 0)))
    (set_local 0x1ca (i64.load offset=0x1ca align=1 (i32.const 0)))
    (set_local 0x1cb (i64.load offset=0x1cb align=1 (i32.const 0)))
    (set_local 0x1cc (i64.load offset=0x1cc align=1 (i32.const 0)))
    (set_local 0x1cd (i64.load offset=0x1cd align=1 (i32.const 0)))
    (set_local 0x1ce (i64.load offset=0x1ce align=1 (i32.const 0)))
    (set_local 0x1cf (i64.load offset=0x1cf align=1 (i32.const 0)))
    (set_local 0x1d0 (i64.load offset=0x1d0 align=1 (i32.const 0)))
    (set_local 0x1d1 (i64.load offset=0x1d1 align=1 (i32.const 0)))
    (set_local 0x1d2 (i64.load offset=0x1d2 align=1 (i32.const 0)))
    (set_local 0x1d3 (i64.load offset=0x1d3 align=1 (i32.const 0)))
    (set_local 0x1d4 (i64.load offset=0x1d4 align=1 (i32.const 0)))
    (set_local 0x1d5 (i64.load offset=0x1d5 align=1 (i32.const 0)))
    (set_local 0x1d6 (i64.load offset=0x1d6 align=1 (i32.const 0)))
    (set_local 0x1d7 (i64.load offset=0x1d7 align=1 (i32.const 0)))
    (set_local 0x1d8 (i64.load offset=0x1d8 align=1 (i32.const 0)))
    (set_local 0x1d9 (i64.load offset=0x1d9 align=1 (i32.const 0)))
    (set_local 0x1da (i64.load offset=0x1da align=1 (i32.const 0)))
    (set_local 0x1db (i64.load offset=0x1db align=1 (i32.const 0)))
    (set_local 0x1dc (i64.load offset=0x1dc align=1 (i32.const 0)))
    (set_local 0x1dd (i64.load offset=0x1dd align=1 (i32.const 0)))
    (set_local 0x1de (i64.load offset=0x1de align=1 (i32.const 0)))
    (set_local 0x1df (i64.load offset=0x1df align=1 (i32.const 0)))
    (set_local 0x1e0 (i64.load offset=0x1e0 align=1 (i32.const 0)))
    (set_local 0x1e1 (i64.load offset=0x1e1 align=1 (i32.const 0)))
    (set_local 0x1e2 (i64.load offset=0x1e2 align=1 (i32.const 0)))
    (set_local 0x1e3 (i64.load offset=0x1e3 align=1 (i32.const 0)))
    (set_local 0x1e4 (i64.load offset=0x1e4 align=1 (i32.const 0)))
    (set_local 0x1e5 (i64.load offset=0x1e5 align=1 (i32.const 0)))
    (set_local 0x1e6 (i64.load offset=0x1e6 align=1 (i32.const 0)))
    (set_local 0x1e7 (i64.load offset=0x1e7 align=1 (i32.const 0)))
    (set_local 0x1e8 (i64.load offset=0x1e8 align=1 (i32.const 0)))
    (set_local 0x1e9 (i64.load offset=0x1e9 align=1 (i32.const 0)))
    (set_local 0x1ea (i64.load offset=0x1ea align=1 (i32.const 0)))
    (set_local 0x1eb (i64.load offset=0x1eb align=1 (i32.const 0)))
    (set_local 0x1ec (i64.load offset=0x1ec align=1 (i32.const 0)))
    (set_local 0x1ed (i64.load offset=0x1ed align=1 (i32.const 0)))
    (set_local 0x1ee (i64.load offset=0x1ee align=1 (i32.const 0)))
    (set_local 0x1ef (i64.load offset=0x1ef align=1 (i32.const 0)))
    (set_local 0x1f0 (i64.load offset=0x1f0 align=1 (i32.const 0)))
    (set_local 0x1f1 (i64.load offset=0x1f1 align=1 (i32.const 0)))
    (set_local 0x1f2 (i64.load offset=0x1f2 align=1 (i32.const 0)))
    (set_local 0x1f3 (i64.load offset=0x1f3 align=1 (i32.const 0)))
    (set_local 0x1f4 (i64.load offset=0x1f4 align=1 (i32.const 0)))
    (set_local 0x1f5 (i64.load offset=0x1f5 align=1 (i32.const 0)))
    (set_local 0x1f6 (i64.load offset=0x1f6 align=1 (i32.const 0)))
    (set_local 0x1f7 (i64.load offset=0x1f7 align=1 (i32.const 0)))
    (set_local 0x1f8 (i64.load offset=0x1f8 align=1 (i32.const 0)))
    (set_local 0x1f9 (i64.load offset=0x1f9 align=1 (i32.const 0)))
    (set_local 0x1fa (i64.load offset=0x1fa align=1 (i32.const 0)))
    (set_local 0x1fb (i64.load offset=0x1fb align=1 (i32.const 0)))
    (set_local 0x1fc (i64.load offset=0x1fc align=1 (i32.const 0)))
    (set_local 0x1fd (i64.load offset=0x1fd align=1 (i32.const 0)))
    (set_local 0x1fe (i64.load offset=0x1fe align=1 (i32.const 0)))
    (set_local 0x1ff (i64.load offset=0x1ff align=1 (i32.const 0)))
    (set_local 0x200 (i64.load offset=0x200 align=1 (i32.const 0)))
    (set_local 0x201 (i64.load offset=0x201 align=1 (i32.const 0)))
    (set_local 0x202 (i64.load offset=0x202 align=1 (i32.const 0)))
    (set_local 0x203 (i64.load offset=0x203 align=1 (i32.const 0)))
    (set_local 0x204 (i64.load offset=0x204 align=1 (i32.const 0)))
    (set_local 0x205 (i64.load offset=0x205 align=1 (i32.const 0)))
    (set_local 0x206 (i64.load offset=0x206 align=1 (i32.const 0)))
    (set_local 0x207 (i64.load offset=0x207 align=1 (i32.const 0)))
    (set_local 0x208 (i64.load offset=0x208 align=1 (i32.const 0)))
    (set_local 0x209 (i64.load offset=0x209 align=1 (i32.const 0)))
    (set_local 0x20a (i64.load offset=0x20a align=1 (i32.const 0)))
    (set_local 0x20b (i64.load offset=0x20b align=1 (i32.const 0)))
    (set_local 0x20c (i64.load offset=0x20c align=1 (i32.const 0)))
    (set_local 0x20d (i64.load offset=0x20d align=1 (i32.const 0)))
    (set_local 0x20e (i64.load offset=0x20e align=1 (i32.const 0)))
    (set_local 0x20f (i64.load offset=0x20f align=1 (i32.const 0)))
    (set_local 0x210 (i64.load offset=0x210 align=1 (i32.const 0)))
    (set_local 0x211 (i64.load offset=0x211 align=1 (i32.const 0)))
    (set_local 0x212 (i64.load offset=0x212 align=1 (i32.const 0)))
    (set_local 0x213 (i64.load offset=0x213 align=1 (i32.const 0)))
    (set_local 0x214 (i64.load offset=0x214 align=1 (i32.const 0)))
    (set_local 0x215 (i64.load offset=0x215 align=1 (i32.const 0)))
    (set_local 0x216 (i64.load offset=0x216 align=1 (i32.const 0)))
    (set_local 0x217 (i64.load offset=0x217 align=1 (i32.const 0)))
    (set_local 0x218 (i64.load offset=0x218 align=1 (i32.const 0)))
    (set_local 0x219 (i64.load offset=0x219 align=1 (i32.const 0)))
    (set_local 0x21a (i64.load offset=0x21a align=1 (i32.const 0)))
    (set_local 0x21b (i64.load offset=0x21b align=1 (i32.const 0)))
    (set_local 0x21c (i64.load offset=0x21c align=1 (i32.const 0)))
    (set_local 0x21d (i64.load offset=0x21d align=1 (i32.const 0)))
    (set_local 0x21e (i64.load offset=0x21e align=1 (i32.const 0)))
    (set_local 0x21f (i64.load offset=0x21f align=1 (i32.const 0)))
    (set_local 0x220 (i64.load offset=0x220 align=1 (i32.const 0)))
    (set_local 0x221 (i64.load offset=0x221 align=1 (i32.const 0)))
    (set_local 0x222 (i64.load offset=0x222 align=1 (i32.const 0)))
    (set_local 0x223 (i64.load offset=0x223 align=1 (i32.const 0)))
    (set_local 0x224 (i64.load offset=0x224 align=1 (i32.const 0)))
    (set_local 0x225 (i64.load offset=0x225 align=1 (i32.const 0)))
    (set_local 0x226 (i64.load offset=0x226 align=1 (i32.const 0)))
    (set_local 0x227 (i64.load offset=0x227 align=1 (i32.const 0)))
    (set_local 0x228 (i64.load offset=0x228 align=1 (i32.const 0)))
    (set_local 0x229 (i64.load offset=0x229 align=1 (i32.const 0)))
    (set_local 0x22a (i64.load offset=0x22a align=1 (i32.const 0)))
    (set_local 0x22b (i64.load offset=0x22b align=1 (i32.const 0)))
    (set_local 0x22c (i64.load offset=0x22c align=1 (i32.const 0)))
    (set_local 0x22d (i64.load offset=0x22d align=1 (i32.const 0)))
    (set_local 0x22e (i64.load offset=0x22e align=1 (i32.const 0)))
    (set_local 0x22f (i64.load offset=0x22f align=1 (i32.const 0)))
    (set_local 0x230 (i64.load offset=0x230 align=1 (i32.const 0)))
    (set_local 0x231 (i64.load offset=0x231 align=1 (i32.const 0)))
    (set_local 0x232 (i64.load offset=0x232 align=1 (i32.const 0)))
    (set_local 0x233 (i64.load offset=0x233 align=1 (i32.const 0)))
    (set_local 0x234 (i64.load offset=0x234 align=1 (i32.const 0)))
    (set_local 0x235 (i64.load offset=0x235 align=1 (i32.const 0)))
    (set_local 0x236 (i64.load offset=0x236 align=1 (i32.const 0)))
    (set_local 0x237 (i64.load offset=0x237 align=1 (i32.const 0)))
    (set_local 0x238 (i64.load offset=0x238 align=1 (i32.const 0)))
    (set_local 0x239 (i64.load offset=0x239 align=1 (i32.const 0)))
    (set_local 0x23a (i64.load offset=0x23a align=1 (i32.const 0)))
    (set_local 0x23b (i64.load offset=0x23b align=1 (i32.const 0)))
    (set_local 0x23c (i64.load offset=0x23c align=1 (i32.const 0)))
    (set_local 0x23d (i64.load offset=0x23d align=1 (i32.const 0)))
    (set_local 0x23e (i64.load offset=0x23e align=1 (i32.const 0)))
    (set_local 0x23f (i64.load offset=0x23f align=1 (i32.const 0)))
    (set_local 0x240 (i64.load offset=0x240 align=1 (i32.const 0)))
    (set_local 0x241 (i64.load offset=0x241 align=1 (i32.const 0)))
    (set_local 0x242 (i64.load offset=0x242 align=1 (i32.const 0)))
    (set_local 0x243 (i64.load offset=0x243 align=1 (i32.const 0)))
    (set_local 0x244 (i64.load offset=0x244 align=1 (i32.const 0)))
    (set_local 0x245 (i64.load offset=0x245 align=1 (i32.const 0)))
    (set_local 0x246 (i64.load offset=0x246 align=1 (i32.const 0)))
    (set_local 0x247 (i64.load offset=0x247 align=1 (i32.const 0)))
    (set_local 0x248 (i64.load offset=0x248 align=1 (i32.const 0)))
    (set_local 0x249 (i64.load offset=0x249 align=1 (i32.const 0)))
    (set_local 0x24a (i64.load offset=0x24a align=1 (i32.const 0)))
    (set_local 0x24b (i64.load offset=0x24b align=1 (i32.const 0)))
    (set_local 0x24c (i64.load offset=0x24c align=1 (i32.const 0)))
    (set_local 0x24d (i64.load offset=0x24d align=1 (i32.const 0)))
    (set_local 0x24e (i64.load offset=0x24e align=1 (i32.const 0)))
    (set_local 0x24f (i64.load offset=0x24f align=1 (i32.const 0)))
    (set_local 0x250 (i64.load offset=0x250 align=1 (i32.const 0)))
    (set_local 0x251 (i64.load offset=0x251 align=1 (i32.const 0)))
    (set_local 0x252 (i64.load offset=0x252 align=1 (i32.const 0)))
    (set_local 0x253 (i64.load offset=0x253 align=1 (i32.const 0)))
    (set_local 0x254 (i64.load offset=0x254 align=1 (i32.const 0)))
    (set_local 0x255 (i64.load offset=0x255 align=1 (i32.const 0)))
    (set_local 0x256 (i64.load offset=0x256 align=1 (i32.const 0)))
    (set_local 0x257 (i64.load offset=0x257 align=1 (i32.const 0)))
    (set_local 0x258 (i64.load offset=0x258 align=1 (i32.const 0)))
    (set_local 0x259 (i64.load offset=0x259 align=1 (i32.const 0)))
    (set_local 0x25a (i64.load offset=0x25a align=1 (i32.const 0)))
    (set_local 0x25b (i64.load offset=0x25b align=1 (i32.const 0)))
    (set_local 0x25c (i64.load offset=0x25c align=1 (i32.const 0)))
    (set_local 0x25d (i64.load offset=0x25d align=1 (i32.const 0)))
    (set_local 0x25e (i64.load offset=0x25e align=1 (i32.const 0)))
    (set_local 0x25f (i64.load offset=0x25f align=1 (i32.const 0)))
    (set_local 0x260 (i64.load offset=0x260 align=1 (i32.const 0)))
    (set_local 0x261 (i64.load offset=0x261 align=1 (i32.const 0)))
    (set_local 0x262 (i64.load offset=0x262 align=1 (i32.const 0)))
    (set_local 0x263 (i64.load offset=0x263 align=1 (i32.const 0)))
    (set_local 0x264 (i64.load offset=0x264 align=1 (i32.const 0)))
    (set_local 0x265 (i64.load offset=0x265 align=1 (i32.const 0)))
    (set_local 0x266 (i64.load offset=0x266 align=1 (i32.const 0)))
    (set_local 0x267 (i64.load offset=0x267 align=1 (i32.const 0)))
    (set_local 0x268 (i64.load offset=0x268 align=1 (i32.const 0)))
    (set_local 0x269 (i64.load offset=0x269 align=1 (i32.const 0)))
    (set_local 0x26a (i64.load offset=0x26a align=1 (i32.const 0)))
    (set_local 0x26b (i64.load offset=0x26b align=1 (i32.const 0)))
    (set_local 0x26c (i64.load offset=0x26c align=1 (i32.const 0)))
    (set_local 0x26d (i64.load offset=0x26d align=1 (i32.const 0)))
    (set_local 0x26e (i64.load offset=0x26e align=1 (i32.const 0)))
    (set_local 0x26f (i64.load offset=0x26f align=1 (i32.const 0)))
    (set_local 0x270 (i64.load offset=0x270 align=1 (i32.const 0)))
    (set_local 0x271 (i64.load offset=0x271 align=1 (i32.const 0)))
    (set_local 0x272 (i64.load offset=0x272 align=1 (i32.const 0)))
    (set_local 0x273 (i64.load offset=0x273 align=1 (i32.const 0)))
    (set_local 0x274 (i64.load offset=0x274 align=1 (i32.const 0)))
    (set_local 0x275 (i64.load offset=0x275 align=1 (i32.const 0)))
    (set_local 0x276 (i64.load offset=0x276 align=1 (i32.const 0)))
    (set_local 0x277 (i64.load offset=0x277 align=1 (i32.const 0)))
    (set_local 0x278 (i64.load offset=0x278 align=1 (i32.const 0)))
    (set_local 0x279 (i64.load offset=0x279 align=1 (i32.const 0)))
    (set_local 0x27a (i64.load offset=0x27a align=1 (i32.const 0)))
    (set_local 0x27b (i64.load offset=0x27b align=1 (i32.const 0)))
    (set_local 0x27c (i64.load offset=0x27c align=1 (i32.const 0)))
    (set_local 0x27d (i64.load offset=0x27d align=1 (i32.const 0)))
    (set_local 0x27e (i64.load offset=0x27e align=1 (i32.const 0)))
    (set_local 0x27f (i64.load offset=0x27f align=1 (i32.const 0)))
    (set_local 0x280 (i64.load offset=0x280 align=1 (i32.const 0)))
    (set_local 0x281 (i64.load offset=0x281 align=1 (i32.const 0)))
    (set_local 0x282 (i64.load offset=0x282 align=1 (i32.const 0)))
    (set_local 0x283 (i64.load offset=0x283 align=1 (i32.const 0)))
    (set_local 0x284 (i64.load offset=0x284 align=1 (i32.const 0)))
    (set_local 0x285 (i64.load offset=0x285 align=1 (i32.const 0)))
    (set_local 0x286 (i64.load offset=0x286 align=1 (i32.const 0)))
    (set_local 0x287 (i64.load offset=0x287 align=1 (i32.const 0)))
    (set_local 0x288 (i64.load offset=0x288 align=1 (i32.const 0)))
    (set_local 0x289 (i64.load offset=0x289 align=1 (i32.const 0)))
    (set_local 0x28a (i64.load offset=0x28a align=1 (i32.const 0)))
    (set_local 0x28b (i64.load offset=0x28b align=1 (i32.const 0)))
    (set_local 0x28c (i64.load offset=0x28c align=1 (i32.const 0)))
    (set_local 0x28d (i64.load offset=0x28d align=1 (i32.const 0)))
    (set_local 0x28e (i64.load offset=0x28e align=1 (i32.const 0)))
    (set_local 0x28f (i64.load offset=0x28f align=1 (i32.const 0)))
    (set_local 0x290 (i64.load offset=0x290 align=1 (i32.const 0)))
    (set_local 0x291 (i64.load offset=0x291 align=1 (i32.const 0)))
    (set_local 0x292 (i64.load offset=0x292 align=1 (i32.const 0)))
    (set_local 0x293 (i64.load offset=0x293 align=1 (i32.const 0)))
    (set_local 0x294 (i64.load offset=0x294 align=1 (i32.const 0)))
    (set_local 0x295 (i64.load offset=0x295 align=1 (i32.const 0)))
    (set_local 0x296 (i64.load offset=0x296 align=1 (i32.const 0)))
    (set_local 0x297 (i64.load offset=0x297 align=1 (i32.const 0)))
    (set_local 0x298 (i64.load offset=0x298 align=1 (i32.const 0)))
    (set_local 0x299 (i64.load offset=0x299 align=1 (i32.const 0)))
    (set_local 0x29a (i64.load offset=0x29a align=1 (i32.const 0)))
    (set_local 0x29b (i64.load offset=0x29b align=1 (i32.const 0)))
    (set_local 0x29c (i64.load offset=0x29c align=1 (i32.const 0)))
    (set_local 0x29d (i64.load offset=0x29d align=1 (i32.const 0)))
    (set_local 0x29e (i64.load offset=0x29e align=1 (i32.const 0)))
    (set_local 0x29f (i64.load offset=0x29f align=1 (i32.const 0)))
    (set_local 0x2a0 (i64.load offset=0x2a0 align=1 (i32.const 0)))
    (set_local 0x2a1 (i64.load offset=0x2a1 align=1 (i32.const 0)))
    (set_local 0x2a2 (i64.load offset=0x2a2 align=1 (i32.const 0)))
    (set_local 0x2a3 (i64.load offset=0x2a3 align=1 (i32.const 0)))
    (set_local 0x2a4 (i64.load offset=0x2a4 align=1 (i32.const 0)))
    (set_local 0x2a5 (i64.load offset=0x2a5 align=1 (i32.const 0)))
    (set_local 0x2a6 (i64.load offset=0x2a6 align=1 (i32.const 0)))
    (set_local 0x2a7 (i64.load offset=0x2a7 align=1 (i32.const 0)))
    (set_local 0x2a8 (i64.load offset=0x2a8 align=1 (i32.const 0)))
    (set_local 0x2a9 (i64.load offset=0x2a9 align=1 (i32.const 0)))
    (set_local 0x2aa (i64.load offset=0x2aa align=1 (i32.const 0)))
    (set_local 0x2ab (i64.load offset=0x2ab align=1 (i32.const 0)))
    (set_local 0x2ac (i64.load offset=0x2ac align=1 (i32.const 0)))
    (set_local 0x2ad (i64.load offset=0x2ad align=1 (i32.const 0)))
    (set_local 0x2ae (i64.load offset=0x2ae align=1 (i32.const 0)))
    (set_local 0x2af (i64.load offset=0x2af align=1 (i32.const 0)))
    (set_local 0x2b0 (i64.load offset=0x2b0 align=1 (i32.const 0)))
    (set_local 0x2b1 (i64.load offset=0x2b1 align=1 (i32.const 0)))
    (set_local 0x2b2 (i64.load offset=0x2b2 align=1 (i32.const 0)))
    (set_local 0x2b3 (i64.load offset=0x2b3 align=1 (i32.const 0)))
    (set_local 0x2b4 (i64.load offset=0x2b4 align=1 (i32.const 0)))
    (set_local 0x2b5 (i64.load offset=0x2b5 align=1 (i32.const 0)))
    (set_local 0x2b6 (i64.load offset=0x2b6 align=1 (i32.const 0)))
    (set_local 0x2b7 (i64.load offset=0x2b7 align=1 (i32.const 0)))
    (set_local 0x2b8 (i64.load offset=0x2b8 align=1 (i32.const 0)))
    (set_local 0x2b9 (i64.load offset=0x2b9 align=1 (i32.const 0)))
    (set_local 0x2ba (i64.load offset=0x2ba align=1 (i32.const 0)))
    (set_local 0x2bb (i64.load offset=0x2bb align=1 (i32.const 0)))
    (set_local 0x2bc (i64.load offset=0x2bc align=1 (i32.const 0)))
    (set_local 0x2bd (i64.load offset=0x2bd align=1 (i32.const 0)))
    (set_local 0x2be (i64.load offset=0x2be align=1 (i32.const 0)))
    (set_local 0x2bf (i64.load offset=0x2bf align=1 (i32.const 0)))
    (set_local 0x2c0 (i64.load offset=0x2c0 align=1 (i32.const 0)))
    (set_local 0x2c1 (i64.load offset=0x2c1 align=1 (i32.const 0)))
    (set_local 0x2c2 (i64.load offset=0x2c2 align=1 (i32.const 0)))
    (set_local 0x2c3 (i64.load offset=0x2c3 align=1 (i32.const 0)))
    (set_local 0x2c4 (i64.load offset=0x2c4 align=1 (i32.const 0)))
    (set_local 0x2c5 (i64.load offset=0x2c5 align=1 (i32.const 0)))
    (set_local 0x2c6 (i64.load offset=0x2c6 align=1 (i32.const 0)))
    (set_local 0x2c7 (i64.load offset=0x2c7 align=1 (i32.const 0)))
    (set_local 0x2c8 (i64.load offset=0x2c8 align=1 (i32.const 0)))
    (set_local 0x2c9 (i64.load offset=0x2c9 align=1 (i32.const 0)))
    (set_local 0x2ca (i64.load offset=0x2ca align=1 (i32.const 0)))
    (set_local 0x2cb (i64.load offset=0x2cb align=1 (i32.const 0)))
    (set_local 0x2cc (i64.load offset=0x2cc align=1 (i32.const 0)))
    (set_local 0x2cd (i64.load offset=0x2cd align=1 (i32.const 0)))
    (set_local 0x2ce (i64.load offset=0x2ce align=1 (i32.const 0)))
    (set_local 0x2cf (i64.load offset=0x2cf align=1 (i32.const 0)))
    (set_local 0x2d0 (i64.load offset=0x2d0 align=1 (i32.const 0)))
    (set_local 0x2d1 (i64.load offset=0x2d1 align=1 (i32.const 0)))
    (set_local 0x2d2 (i64.load offset=0x2d2 align=1 (i32.const 0)))
    (set_local 0x2d3 (i64.load offset=0x2d3 align=1 (i32.const 0)))
    (set_local 0x2d4 (i64.load offset=0x2d4 align=1 (i32.const 0)))
    (set_local 0x2d5 (i64.load offset=0x2d5 align=1 (i32.const 0)))
    (set_local 0x2d6 (i64.load offset=0x2d6 align=1 (i32.const 0)))
    (set_local 0x2d7 (i64.load offset=0x2d7 align=1 (i32.const 0)))
    (set_local 0x2d8 (i64.load offset=0x2d8 align=1 (i32.const 0)))
    (set_local 0x2d9 (i64.load offset=0x2d9 align=1 (i32.const 0)))
    (set_local 0x2da (i64.load offset=0x2da align=1 (i32.const 0)))
    (set_local 0x2db (i64.load offset=0x2db align=1 (i32.const 0)))
    (set_local 0x2dc (i64.load offset=0x2dc align=1 (i32.const 0)))
    (set_local 0x2dd (i64.load offset=0x2dd align=1 (i32.const 0)))
    (set_local 0x2de (i64.load offset=0x2de align=1 (i32.const 0)))
    (set_local 0x2df (i64.load offset=0x2df align=1 (i32.const 0)))
    (set_local 0x2e0 (i64.load offset=0x2e0 align=1 (i32.const 0)))
    (set_local 0x2e1 (i64.load offset=0x2e1 align=1 (i32.const 0)))
    (set_local 0x2e2 (i64.load offset=0x2e2 align=1 (i32.const 0)))
    (set_local 0x2e3 (i64.load offset=0x2e3 align=1 (i32.const 0)))
    (set_local 0x2e4 (i64.load offset=0x2e4 align=1 (i32.const 0)))
    (set_local 0x2e5 (i64.load offset=0x2e5 align=1 (i32.const 0)))
    (set_local 0x2e6 (i64.load offset=0x2e6 align=1 (i32.const 0)))
    (set_local 0x2e7 (i64.load offset=0x2e7 align=1 (i32.const 0)))
    (set_local 0x2e8 (i64.load offset=0x2e8 align=1 (i32.const 0)))
    (set_local 0x2e9 (i64.load offset=0x2e9 align=1 (i32.const 0)))
    (set_local 0x2ea (i64.load offset=0x2ea align=1 (i32.const 0)))
    (set_local 0x2eb (i64.load offset=0x2eb align=1 (i32.const 0)))
    (set_local 0x2ec (i64.load offset=0x2ec align=1 (i32.const 0)))
    (set_local 0x2ed (i64.load offset=0x2ed align=1 (i32.const 0)))
    (set_local 0x2ee (i64.load offset=0x2ee align=1 (i32.const 0)))
    (set_local 0x2ef (i64.load offset=0x2ef align=1 (i32.const 0)))
    (set_local 0x2f0 (i64.load offset=0x2f0 align=1 (i32.const 0)))
    (set_local 0x2f1 (i64.load offset=0x2f1 align=1 (i32.const 0)))
    (set_local 0x2f2 (i64.load offset=0x2f2 align=1 (i32.const 0)))
    (set_local 0x2f3 (i64.load offset=0x2f3 align=1 (i32.const 0)))
    (set_local 0x2f4 (i64.load offset=0x2f4 align=1 (i32.const 0)))
    (set_local 0x2f5 (i64.load offset=0x2f5 align=1 (i32.const 0)))
    (set_local 0x2f6 (i64.load offset=0x2f6 align=1 (i32.const 0)))
    (set_local 0x2f7 (i64.load offset=0x2f7 align=1 (i32.const 0)))
    (set_local 0x2f8 (i64.load offset=0x2f8 align=1 (i32.const 0)))
    (set_local 0x2f9 (i64.load offset=0x2f9 align=1 (i32.const 0)))
    (set_local 0x2fa (i64.load offset=0x2fa align=1 (i32.const 0)))
    (set_local 0x2fb (i64.load offset=0x2fb align=1 (i32.const 0)))
    (set_local 0x2fc (i64.load offset=0x2fc align=1 (i32.const 0)))
    (set_local 0x2fd (i64.load offset=0x2fd align=1 (i32.const 0)))
    (set_local 0x2fe (i64.load offset=0x2fe align=1 (i32.const 0)))
    (set_local 0x2ff (i64.load offset=0x2ff align=1 (i32.const 0)))
    (set_local 0x300 (i64.load offset=0x300 align=1 (i32.const 0)))
    (set_local 0x301 (i64.load offset=0x301 align=1 (i32.const 0)))
    (set_local 0x302 (i64.load offset=0x302 align=1 (i32.const 0)))
    (set_local 0x303 (i64.load offset=0x303 align=1 (i32.const 0)))
    (set_local 0x304 (i64.load offset=0x304 align=1 (i32.const 0)))
    (set_local 0x305 (i64.load offset=0x305 align=1 (i32.const 0)))
    (set_local 0x306 (i64.load offset=0x306 align=1 (i32.const 0)))
    (set_local 0x307 (i64.load offset=0x307 align=1 (i32.const 0)))
    (set_local 0x308 (i64.load offset=0x308 align=1 (i32.const 0)))
    (set_local 0x309 (i64.load offset=0x309 align=1 (i32.const 0)))
    (set_local 0x30a (i64.load offset=0x30a align=1 (i32.const 0)))
    (set_local 0x30b (i64.load offset=0x30b align=1 (i32.const 0)))
    (set_local 0x30c (i64.load offset=0x30c align=1 (i32.const 0)))
    (set_local 0x30d (i64.load offset=0x30d align=1 (i32.const 0)))
    (set_local 0x30e (i64.load offset=0x30e align=1 (i32.const 0)))
    (set_local 0x30f (i64.load offset=0x30f align=1 (i32.const 0)))
    (set_local 0x310 (i64.load offset=0x310 align=1 (i32.const 0)))
    (set_local 0x311 (i64.load offset=0x311 align=1 (i32.const 0)))
    (set_local 0x312 (i64.load offset=0x312 align=1 (i32.const 0)))
    (set_local 0x313 (i64.load offset=0x313 align=1 (i32.const 0)))
    (set_local 0x314 (i64.load offset=0x314 align=1 (i32.const 0)))
    (set_local 0x315 (i64.load offset=0x315 align=1 (i32.const 0)))
    (set_local 0x316 (i64.load offset=0x316 align=1 (i32.const 0)))
    (set_local 0x317 (i64.load offset=0x317 align=1 (i32.const 0)))
    (set_local 0x318 (i64.load offset=0x318 align=1 (i32.const 0)))
    (set_local 0x319 (i64.load offset=0x319 align=1 (i32.const 0)))
    (set_local 0x31a (i64.load offset=0x31a align=1 (i32.const 0)))
    (set_local 0x31b (i64.load offset=0x31b align=1 (i32.const 0)))
    (set_local 0x31c (i64.load offset=0x31c align=1 (i32.const 0)))
    (set_local 0x31d (i64.load offset=0x31d align=1 (i32.const 0)))
    (set_local 0x31e (i64.load offset=0x31e align=1 (i32.const 0)))
    (set_local 0x31f (i64.load offset=0x31f align=1 (i32.const 0)))
    (set_local 0x320 (i64.load offset=0x320 align=1 (i32.const 0)))
    (set_local 0x321 (i64.load offset=0x321 align=1 (i32.const 0)))
    (set_local 0x322 (i64.load offset=0x322 align=1 (i32.const 0)))
    (set_local 0x323 (i64.load offset=0x323 align=1 (i32.const 0)))
    (set_local 0x324 (i64.load offset=0x324 align=1 (i32.const 0)))
    (set_local 0x325 (i64.load offset=0x325 align=1 (i32.const 0)))
    (set_local 0x326 (i64.load offset=0x326 align=1 (i32.const 0)))
    (set_local 0x327 (i64.load offset=0x327 align=1 (i32.const 0)))
    (set_local 0x328 (i64.load offset=0x328 align=1 (i32.const 0)))
    (set_local 0x329 (i64.load offset=0x329 align=1 (i32.const 0)))
    (set_local 0x32a (i64.load offset=0x32a align=1 (i32.const 0)))
    (set_local 0x32b (i64.load offset=0x32b align=1 (i32.const 0)))
    (set_local 0x32c (i64.load offset=0x32c align=1 (i32.const 0)))
    (set_local 0x32d (i64.load offset=0x32d align=1 (i32.const 0)))
    (set_local 0x32e (i64.load offset=0x32e align=1 (i32.const 0)))
    (set_local 0x32f (i64.load offset=0x32f align=1 (i32.const 0)))
    (set_local 0x330 (i64.load offset=0x330 align=1 (i32.const 0)))
    (set_local 0x331 (i64.load offset=0x331 align=1 (i32.const 0)))
    (set_local 0x332 (i64.load offset=0x332 align=1 (i32.const 0)))
    (set_local 0x333 (i64.load offset=0x333 align=1 (i32.const 0)))
    (set_local 0x334 (i64.load offset=0x334 align=1 (i32.const 0)))
    (set_local 0x335 (i64.load offset=0x335 align=1 (i32.const 0)))
    (set_local 0x336 (i64.load offset=0x336 align=1 (i32.const 0)))
    (set_local 0x337 (i64.load offset=0x337 align=1 (i32.const 0)))
    (set_local 0x338 (i64.load offset=0x338 align=1 (i32.const 0)))
    (set_local 0x339 (i64.load offset=0x339 align=1 (i32.const 0)))
    (set_local 0x33a (i64.load offset=0x33a align=1 (i32.const 0)))
    (set_local 0x33b (i64.load offset=0x33b align=1 (i32.const 0)))
    (set_local 0x33c (i64.load offset=0x33c align=1 (i32.const 0)))
    (set_local 0x33d (i64.load offset=0x33d align=1 (i32.const 0)))
    (set_local 0x33e (i64.load offset=0x33e align=1 (i32.const 0)))
    (set_local 0x33f (i64.load offset=0x33f align=1 (i32.const 0)))
    (set_local 0x340 (i64.load offset=0x340 align=1 (i32.const 0)))
    (set_local 0x341 (i64.load offset=0x341 align=1 (i32.const 0)))
    (set_local 0x342 (i64.load offset=0x342 align=1 (i32.const 0)))
    (set_local 0x343 (i64.load offset=0x343 align=1 (i32.const 0)))
    (set_local 0x344 (i64.load offset=0x344 align=1 (i32.const 0)))
    (set_local 0x345 (i64.load offset=0x345 align=1 (i32.const 0)))
    (set_local 0x346 (i64.load offset=0x346 align=1 (i32.const 0)))
    (set_local 0x347 (i64.load offset=0x347 align=1 (i32.const 0)))
    (set_local 0x348 (i64.load offset=0x348 align=1 (i32.const 0)))
    (set_local 0x349 (i64.load offset=0x349 align=1 (i32.const 0)))
    (set_local 0x34a (i64.load offset=0x34a align=1 (i32.const 0)))
    (set_local 0x34b (i64.load offset=0x34b align=1 (i32.const 0)))
    (set_local 0x34c (i64.load offset=0x34c align=1 (i32.const 0)))
    (set_local 0x34d (i64.load offset=0x34d align=1 (i32.const 0)))
    (set_local 0x34e (i64.load offset=0x34e align=1 (i32.const 0)))
    (set_local 0x34f (i64.load offset=0x34f align=1 (i32.const 0)))
    (set_local 0x350 (i64.load offset=0x350 align=1 (i32.const 0)))
    (set_local 0x351 (i64.load offset=0x351 align=1 (i32.const 0)))
    (set_local 0x352 (i64.load offset=0x352 align=1 (i32.const 0)))
    (set_local 0x353 (i64.load offset=0x353 align=1 (i32.const 0)))
    (set_local 0x354 (i64.load offset=0x354 align=1 (i32.const 0)))
    (set_local 0x355 (i64.load offset=0x355 align=1 (i32.const 0)))
    (set_local 0x356 (i64.load offset=0x356 align=1 (i32.const 0)))
    (set_local 0x357 (i64.load offset=0x357 align=1 (i32.const 0)))
    (set_local 0x358 (i64.load offset=0x358 align=1 (i32.const 0)))
    (set_local 0x359 (i64.load offset=0x359 align=1 (i32.const 0)))
    (set_local 0x35a (i64.load offset=0x35a align=1 (i32.const 0)))
    (set_local 0x35b (i64.load offset=0x35b align=1 (i32.const 0)))
    (set_local 0x35c (i64.load offset=0x35c align=1 (i32.const 0)))
    (set_local 0x35d (i64.load offset=0x35d align=1 (i32.const 0)))
    (set_local 0x35e (i64.load offset=0x35e align=1 (i32.const 0)))
    (set_local 0x35f (i64.load offset=0x35f align=1 (i32.const 0)))
    (set_local 0x360 (i64.load offset=0x360 align=1 (i32.const 0)))
    (set_local 0x361 (i64.load offset=0x361 align=1 (i32.const 0)))
    (set_local 0x362 (i64.load offset=0x362 align=1 (i32.const 0)))
    (set_local 0x363 (i64.load offset=0x363 align=1 (i32.const 0)))
    (set_local 0x364 (i64.load offset=0x364 align=1 (i32.const 0)))
    (set_local 0x365 (i64.load offset=0x365 align=1 (i32.const 0)))
    (set_local 0x366 (i64.load offset=0x366 align=1 (i32.const 0)))
    (set_local 0x367 (i64.load offset=0x367 align=1 (i32.const 0)))
    (set_local 0x368 (i64.load offset=0x368 align=1 (i32.const 0)))
    (set_local 0x369 (i64.load offset=0x369 align=1 (i32.const 0)))
    (set_local 0x36a (i64.load offset=0x36a align=1 (i32.const 0)))
    (set_local 0x36b (i64.load offset=0x36b align=1 (i32.const 0)))
    (set_local 0x36c (i64.load offset=0x36c align=1 (i32.const 0)))
    (set_local 0x36d (i64.load offset=0x36d align=1 (i32.const 0)))
    (set_local 0x36e (i64.load offset=0x36e align=1 (i32.const 0)))
    (set_local 0x36f (i64.load offset=0x36f align=1 (i32.const 0)))
    (set_local 0x370 (i64.load offset=0x370 align=1 (i32.const 0)))
    (set_local 0x371 (i64.load offset=0x371 align=1 (i32.const 0)))
    (set_local 0x372 (i64.load offset=0x372 align=1 (i32.const 0)))
    (set_local 0x373 (i64.load offset=0x373 align=1 (i32.const 0)))
    (set_local 0x374 (i64.load offset=0x374 align=1 (i32.const 0)))
    (set_local 0x375 (i64.load offset=0x375 align=1 (i32.const 0)))
    (set_local 0x376 (i64.load offset=0x376 align=1 (i32.const 0)))
    (set_local 0x377 (i64.load offset=0x377 align=1 (i32.const 0)))
    (set_local 0x378 (i64.load offset=0x378 align=1 (i32.const 0)))
    (set_local 0x379 (i64.load offset=0x379 align=1 (i32.const 0)))
    (set_local 0x37a (i64.load offset=0x37a align=1 (i32.const 0)))
    (set_local 0x37b (i64.load offset=0x37b align=1 (i32.const 0)))
    (set_local 0x37c (i64.load offset=0x37c align=1 (i32.const 0)))
    (set_local 0x37d (i64.load offset=0x37d align=1 (i32.const 0)))
    (set_local 0x37e (i64.load offset=0x37e align=1 (i32.const 0)))
    (set_local 0x37f (i64.load offset=0x37f align=1 (i32.const 0)))
    (set_local 0x380 (i64.load offset=0x380 align=1 (i32.const 0)))
    (set_local 0x381 (i64.load offset=0x381 align=1 (i32.const 0)))
    (set_local 0x382 (i64.load offset=0x382 align=1 (i32.const 0)))
    (set_local 0x383 (i64.load offset=0x383 align=1 (i32.const 0)))
    (set_local 0x384 (i64.load offset=0x384 align=1 (i32.const 0)))
    (set_local 0x385 (i64.load offset=0x385 align=1 (i32.const 0)))
    (set_local 0x386 (i64.load offset=0x386 align=1 (i32.const 0)))
    (set_local 0x387 (i64.load offset=0x387 align=1 (i32.const 0)))
    (set_local 0x388 (i64.load offset=0x388 align=1 (i32.const 0)))
    (set_local 0x389 (i64.load offset=0x389 align=1 (i32.const 0)))
    (set_local 0x38a (i64.load offset=0x38a align=1 (i32.const 0)))
    (set_local 0x38b (i64.load offset=0x38b align=1 (i32.const 0)))
    (set_local 0x38c (i64.load offset=0x38c align=1 (i32.const 0)))
    (set_local 0x38d (i64.load offset=0x38d align=1 (i32.const 0)))
    (set_local 0x38e (i64.load offset=0x38e align=1 (i32.const 0)))
    (set_local 0x38f (i64.load offset=0x38f align=1 (i32.const 0)))
    (set_local 0x390 (i64.load offset=0x390 align=1 (i32.const 0)))
    (set_local 0x391 (i64.load offset=0x391 align=1 (i32.const 0)))
    (set_local 0x392 (i64.load offset=0x392 align=1 (i32.const 0)))
    (set_local 0x393 (i64.load offset=0x393 align=1 (i32.const 0)))
    (set_local 0x394 (i64.load offset=0x394 align=1 (i32.const 0)))
    (set_local 0x395 (i64.load offset=0x395 align=1 (i32.const 0)))
    (set_local 0x396 (i64.load offset=0x396 align=1 (i32.const 0)))
    (set_local 0x397 (i64.load offset=0x397 align=1 (i32.const 0)))
    (set_local 0x398 (i64.load offset=0x398 align=1 (i32.const 0)))
    (set_local 0x399 (i64.load offset=0x399 align=1 (i32.const 0)))
    (set_local 0x39a (i64.load offset=0x39a align=1 (i32.const 0)))
    (set_local 0x39b (i64.load offset=0x39b align=1 (i32.const 0)))
    (set_local 0x39c (i64.load offset=0x39c align=1 (i32.const 0)))
    (set_local 0x39d (i64.load offset=0x39d align=1 (i32.const 0)))
    (set_local 0x39e (i64.load offset=0x39e align=1 (i32.const 0)))
    (set_local 0x39f (i64.load offset=0x39f align=1 (i32.const 0)))
    (set_local 0x3a0 (i64.load offset=0x3a0 align=1 (i32.const 0)))
    (set_local 0x3a1 (i64.load offset=0x3a1 align=1 (i32.const 0)))
    (set_local 0x3a2 (i64.load offset=0x3a2 align=1 (i32.const 0)))
    (set_local 0x3a3 (i64.load offset=0x3a3 align=1 (i32.const 0)))
    (set_local 0x3a4 (i64.load offset=0x3a4 align=1 (i32.const 0)))
    (set_local 0x3a5 (i64.load offset=0x3a5 align=1 (i32.const 0)))
    (set_local 0x3a6 (i64.load offset=0x3a6 align=1 (i32.const 0)))
    (set_local 0x3a7 (i64.load offset=0x3a7 align=1 (i32.const 0)))
    (set_local 0x3a8 (i64.load offset=0x3a8 align=1 (i32.const 0)))
    (set_local 0x3a9 (i64.load offset=0x3a9 align=1 (i32.const 0)))
    (set_local 0x3aa (i64.load offset=0x3aa align=1 (i32.const 0)))
    (set_local 0x3ab (i64.load offset=0x3ab align=1 (i32.const 0)))
    (set_local 0x3ac (i64.load offset=0x3ac align=1 (i32.const 0)))
    (set_local 0x3ad (i64.load offset=0x3ad align=1 (i32.const 0)))
    (set_local 0x3ae (i64.load offset=0x3ae align=1 (i32.const 0)))
    (set_local 0x3af (i64.load offset=0x3af align=1 (i32.const 0)))
    (set_local 0x3b0 (i64.load offset=0x3b0 align=1 (i32.const 0)))
    (set_local 0x3b1 (i64.load offset=0x3b1 align=1 (i32.const 0)))
    (set_local 0x3b2 (i64.load offset=0x3b2 align=1 (i32.const 0)))
    (set_local 0x3b3 (i64.load offset=0x3b3 align=1 (i32.const 0)))
    (set_local 0x3b4 (i64.load offset=0x3b4 align=1 (i32.const 0)))
    (set_local 0x3b5 (i64.load offset=0x3b5 align=1 (i32.const 0)))
    (set_local 0x3b6 (i64.load offset=0x3b6 align=1 (i32.const 0)))
    (set_local 0x3b7 (i64.load offset=0x3b7 align=1 (i32.const 0)))
    (set_local 0x3b8 (i64.load offset=0x3b8 align=1 (i32.const 0)))
    (set_local 0x3b9 (i64.load offset=0x3b9 align=1 (i32.const 0)))
    (set_local 0x3ba (i64.load offset=0x3ba align=1 (i32.const 0)))
    (set_local 0x3bb (i64.load offset=0x3bb align=1 (i32.const 0)))
    (set_local 0x3bc (i64.load offset=0x3bc align=1 (i32.const 0)))
    (set_local 0x3bd (i64.load offset=0x3bd align=1 (i32.const 0)))
    (set_local 0x3be (i64.load offset=0x3be align=1 (i32.const 0)))
    (set_local 0x3bf (i64.load offset=0x3bf align=1 (i32.const 0)))
    (set_local 0x3c0 (i64.load offset=0x3c0 align=1 (i32.const 0)))
    (set_local 0x3c1 (i64.load offset=0x3c1 align=1 (i32.const 0)))
    (set_local 0x3c2 (i64.load offset=0x3c2 align=1 (i32.const 0)))
    (set_local 0x3c3 (i64.load offset=0x3c3 align=1 (i32.const 0)))
    (set_local 0x3c4 (i64.load offset=0x3c4 align=1 (i32.const 0)))
    (set_local 0x3c5 (i64.load offset=0x3c5 align=1 (i32.const 0)))
    (set_local 0x3c6 (i64.load offset=0x3c6 align=1 (i32.const 0)))
    (set_local 0x3c7 (i64.load offset=0x3c7 align=1 (i32.const 0)))
    (set_local 0x3c8 (i64.load offset=0x3c8 align=1 (i32.const 0)))
    (set_local 0x3c9 (i64.load offset=0x3c9 align=1 (i32.const 0)))
    (set_local 0x3ca (i64.load offset=0x3ca align=1 (i32.const 0)))
    (set_local 0x3cb (i64.load offset=0x3cb align=1 (i32.const 0)))
    (set_local 0x3cc (i64.load offset=0x3cc align=1 (i32.const 0)))
    (set_local 0x3cd (i64.load offset=0x3cd align=1 (i32.const 0)))
    (set_local 0x3ce (i64.load offset=0x3ce align=1 (i32.const 0)))
    (set_local 0x3cf (i64.load offset=0x3cf align=1 (i32.const 0)))
    (set_local 0x3d0 (i64.load offset=0x3d0 align=1 (i32.const 0)))
    (set_local 0x3d1 (i64.load offset=0x3d1 align=1 (i32.const 0)))
    (set_local 0x3d2 (i64.load offset=0x3d2 align=1 (i32.const 0)))
    (set_local 0x3d3 (i64.load offset=0x3d3 align=1 (i32.const 0)))
    (set_local 0x3d4 (i64.load offset=0x3d4 align=1 (i32.const 0)))
    (set_local 0x3d5 (i64.load offset=0x3d5 align=1 (i32.const 0)))
    (set_local 0x3d6 (i64.load offset=0x3d6 align=1 (i32.const 0)))
    (set_local 0x3d7 (i64.load offset=0x3d7 align=1 (i32.const 0)))
    (set_local 0x3d8 (i64.load offset=0x3d8 align=1 (i32.const 0)))
    (set_local 0x3d9 (i64.load offset=0x3d9 align=1 (i32.const 0)))
    (set_local 0x3da (i64.load offset=0x3da align=1 (i32.const 0)))
    (set_local 0x3db (i64.load offset=0x3db align=1 (i32.const 0)))
    (set_local 0x3dc (i64.load offset=0x3dc align=1 (i32.const 0)))
    (set_local 0x3dd (i64.load offset=0x3dd align=1 (i32.const 0)))
    (set_local 0x3de (i64.load offset=0x3de align=1 (i32.const 0)))
    (set_local 0x3df (i64.load offset=0x3df align=1 (i32.const 0)))
    (set_local 0x3e0 (i64.load offset=0x3e0 align=1 (i32.const 0)))
    (set_local 0x3e1 (i64.load offset=0x3e1 align=1 (i32.const 0)))
    (set_local 0x3e2 (i64.load offset=0x3e2 align=1 (i32.const 0)))
    (set_local 0x3e3 (i64.load offset=0x3e3 align=1 (i32.const 0)))
    (set_local 0x3e4 (i64.load offset=0x3e4 align=1 (i32.const 0)))
    (set_local 0x3e5 (i64.load offset=0x3e5 align=1 (i32.const 0)))
    (set_local 0x3e6 (i64.load offset=0x3e6 align=1 (i32.const 0)))
    (set_local 0x3e7 (i64.load offset=0x3e7 align=1 (i32.const 0)))
    (set_local 0x3e8 (i64.load offset=0x3e8 align=1 (i32.const 0)))
    (set_local 0x3e9 (i64.load offset=0x3e9 align=1 (i32.const 0)))
    (set_local 0x3ea (i64.load offset=0x3ea align=1 (i32.const 0)))
    (set_local 0x3eb (i64.load offset=0x3eb align=1 (i32.const 0)))
    (set_local 0x3ec (i64.load offset=0x3ec align=1 (i32.const 0)))
    (set_local 0x3ed (i64.load offset=0x3ed align=1 (i32.const 0)))
    (set_local 0x3ee (i64.load offset=0x3ee align=1 (i32.const 0)))
    (set_local 0x3ef (i64.load offset=0x3ef align=1 (i32.const 0)))
    (set_local 0x3f0 (i64.load offset=0x3f0 align=1 (i32.const 0)))
    (set_local 0x3f1 (i64.load offset=0x3f1 align=1 (i32.const 0)))
    (set_local 0x3f2 (i64.load offset=0x3f2 align=1 (i32.const 0)))
    (set_local 0x3f3 (i64.load offset=0x3f3 align=1 (i32.const 0)))
    (set_local 0x3f4 (i64.load offset=0x3f4 align=1 (i32.const 0)))
    (set_local 0x3f5 (i64.load offset=0x3f5 align=1 (i32.const 0)))
    (set_local 0x3f6 (i64.load offset=0x3f6 align=1 (i32.const 0)))
    (set_local 0x3f7 (i64.load offset=0x3f7 align=1 (i32.const 0)))
    (set_local 0x3f8 (i64.load offset=0x3f8 align=1 (i32.const 0)))
    (set_local 0x3f9 (i64.load offset=0x3f9 align=1 (i32.const 0)))
    (set_local 0x3fa (i64.load offset=0x3fa align=1 (i32.const 0)))
    (set_local 0x3fb (i64.load offset=0x3fb align=1 (i32.const 0)))
    (set_local 0x3fc (i64.load offset=0x3fc align=1 (i32.const 0)))
    (set_local 0x3fd (i64.load offset=0x3fd align=1 (i32.const 0)))
    (set_local 0x3fe (i64.load offset=0x3fe align=1 (i32.const 0)))
    (set_local 0x3ff (i64.load offset=0x3ff align=1 (i32.const 0)))
    (set_local 0x400 (i64.load offset=0x400 align=1 (i32.const 0)))
    (set_local 0x401 (i64.load offset=0x401 align=1 (i32.const 0)))
    (set_local 0x402 (i64.load offset=0x402 align=1 (i32.const 0)))
    (set_local 0x403 (i64.load offset=0x403 align=1 (i32.const 0)))
    (set_local 0x404 (i64.load offset=0x404 align=1 (i32.const 0)))
    (set_local 0x405 (i64.load offset=0x405 align=1 (i32.const 0)))
    (set_local 0x406 (i64.load offset=0x406 align=1 (i32.const 0)))
    (set_local 0x407 (i64.load offset=0x407 align=1 (i32.const 0)))
    (set_local 0x408 (i64.load offset=0x408 align=1 (i32.const 0)))
    (set_local 0x409 (i64.load offset=0x409 align=1 (i32.const 0)))
    (set_local 0x40a (i64.load offset=0x40a align=1 (i32.const 0)))
    (set_local 0x40b (i64.load offset=0x40b align=1 (i32.const 0)))
    (set_local 0x40c (i64.load offset=0x40c align=1 (i32.const 0)))
    (set_local 0x40d (i64.load offset=0x40d align=1 (i32.const 0)))
    (set_local 0x40e (i64.load offset=0x40e align=1 (i32.const 0)))
    (set_local 0x40f (i64.load offset=0x40f align=1 (i32.const 0)))
    (set_local 0x410 (i64.load offset=0x410 align=1 (i32.const 0)))
    (set_local 0x411 (i64.load offset=0x411 align=1 (i32.const 0)))
    (set_local 0x412 (i64.load offset=0x412 align=1 (i32.const 0)))
    (set_local 0x413 (i64.load offset=0x413 align=1 (i32.const 0)))
    (set_local 0x414 (i64.load offset=0x414 align=1 (i32.const 0)))
    (set_local 0x415 (i64.load offset=0x415 align=1 (i32.const 0)))
    (set_local 0x416 (i64.load offset=0x416 align=1 (i32.const 0)))
    (set_local 0x417 (i64.load offset=0x417 align=1 (i32.const 0)))
    (set_local 0x418 (i64.load offset=0x418 align=1 (i32.const 0)))
    (set_local 0x419 (i64.load offset=0x419 align=1 (i32.const 0)))
    (set_local 0x41a (i64.load offset=0x41a align=1 (i32.const 0)))
    (set_local 0x41b (i64.load offset=0x41b align=1 (i32.const 0)))
    (set_local 0x41c (i64.load offset=0x41c align=1 (i32.const 0)))
    (set_local 0x41d (i64.load offset=0x41d align=1 (i32.const 0)))
    (set_local 0x41e (i64.load offset=0x41e align=1 (i32.const 0)))
    (set_local 0x41f (i64.load offset=0x41f align=1 (i32.const 0)))

    ;; store the locals back to memory
    (i64.store offset=0x000 align=1 (i32.const 0) (get_local 0x000))
    (i64.store offset=0x001 align=1 (i32.const 0) (get_local 0x001))
    (i64.store offset=0x002 align=1 (i32.const 0) (get_local 0x002))
    (i64.store offset=0x003 align=1 (i32.const 0) (get_local 0x003))
    (i64.store offset=0x004 align=1 (i32.const 0) (get_local 0x004))
    (i64.store offset=0x005 align=1 (i32.const 0) (get_local 0x005))
    (i64.store offset=0x006 align=1 (i32.const 0) (get_local 0x006))
    (i64.store offset=0x007 align=1 (i32.const 0) (get_local 0x007))
    (i64.store offset=0x008 align=1 (i32.const 0) (get_local 0x008))
    (i64.store offset=0x009 align=1 (i32.const 0) (get_local 0x009))
    (i64.store offset=0x00a align=1 (i32.const 0) (get_local 0x00a))
    (i64.store offset=0x00b align=1 (i32.const 0) (get_local 0x00b))
    (i64.store offset=0x00c align=1 (i32.const 0) (get_local 0x00c))
    (i64.store offset=0x00d align=1 (i32.const 0) (get_local 0x00d))
    (i64.store offset=0x00e align=1 (i32.const 0) (get_local 0x00e))
    (i64.store offset=0x00f align=1 (i32.const 0) (get_local 0x00f))
    (i64.store offset=0x010 align=1 (i32.const 0) (get_local 0x010))
    (i64.store offset=0x011 align=1 (i32.const 0) (get_local 0x011))
    (i64.store offset=0x012 align=1 (i32.const 0) (get_local 0x012))
    (i64.store offset=0x013 align=1 (i32.const 0) (get_local 0x013))
    (i64.store offset=0x014 align=1 (i32.const 0) (get_local 0x014))
    (i64.store offset=0x015 align=1 (i32.const 0) (get_local 0x015))
    (i64.store offset=0x016 align=1 (i32.const 0) (get_local 0x016))
    (i64.store offset=0x017 align=1 (i32.const 0) (get_local 0x017))
    (i64.store offset=0x018 align=1 (i32.const 0) (get_local 0x018))
    (i64.store offset=0x019 align=1 (i32.const 0) (get_local 0x019))
    (i64.store offset=0x01a align=1 (i32.const 0) (get_local 0x01a))
    (i64.store offset=0x01b align=1 (i32.const 0) (get_local 0x01b))
    (i64.store offset=0x01c align=1 (i32.const 0) (get_local 0x01c))
    (i64.store offset=0x01d align=1 (i32.const 0) (get_local 0x01d))
    (i64.store offset=0x01e align=1 (i32.const 0) (get_local 0x01e))
    (i64.store offset=0x01f align=1 (i32.const 0) (get_local 0x01f))
    (i64.store offset=0x020 align=1 (i32.const 0) (get_local 0x020))
    (i64.store offset=0x021 align=1 (i32.const 0) (get_local 0x021))
    (i64.store offset=0x022 align=1 (i32.const 0) (get_local 0x022))
    (i64.store offset=0x023 align=1 (i32.const 0) (get_local 0x023))
    (i64.store offset=0x024 align=1 (i32.const 0) (get_local 0x024))
    (i64.store offset=0x025 align=1 (i32.const 0) (get_local 0x025))
    (i64.store offset=0x026 align=1 (i32.const 0) (get_local 0x026))
    (i64.store offset=0x027 align=1 (i32.const 0) (get_local 0x027))
    (i64.store offset=0x028 align=1 (i32.const 0) (get_local 0x028))
    (i64.store offset=0x029 align=1 (i32.const 0) (get_local 0x029))
    (i64.store offset=0x02a align=1 (i32.const 0) (get_local 0x02a))
    (i64.store offset=0x02b align=1 (i32.const 0) (get_local 0x02b))
    (i64.store offset=0x02c align=1 (i32.const 0) (get_local 0x02c))
    (i64.store offset=0x02d align=1 (i32.const 0) (get_local 0x02d))
    (i64.store offset=0x02e align=1 (i32.const 0) (get_local 0x02e))
    (i64.store offset=0x02f align=1 (i32.const 0) (get_local 0x02f))
    (i64.store offset=0x030 align=1 (i32.const 0) (get_local 0x030))
    (i64.store offset=0x031 align=1 (i32.const 0) (get_local 0x031))
    (i64.store offset=0x032 align=1 (i32.const 0) (get_local 0x032))
    (i64.store offset=0x033 align=1 (i32.const 0) (get_local 0x033))
    (i64.store offset=0x034 align=1 (i32.const 0) (get_local 0x034))
    (i64.store offset=0x035 align=1 (i32.const 0) (get_local 0x035))
    (i64.store offset=0x036 align=1 (i32.const 0) (get_local 0x036))
    (i64.store offset=0x037 align=1 (i32.const 0) (get_local 0x037))
    (i64.store offset=0x038 align=1 (i32.const 0) (get_local 0x038))
    (i64.store offset=0x039 align=1 (i32.const 0) (get_local 0x039))
    (i64.store offset=0x03a align=1 (i32.const 0) (get_local 0x03a))
    (i64.store offset=0x03b align=1 (i32.const 0) (get_local 0x03b))
    (i64.store offset=0x03c align=1 (i32.const 0) (get_local 0x03c))
    (i64.store offset=0x03d align=1 (i32.const 0) (get_local 0x03d))
    (i64.store offset=0x03e align=1 (i32.const 0) (get_local 0x03e))
    (i64.store offset=0x03f align=1 (i32.const 0) (get_local 0x03f))
    (i64.store offset=0x040 align=1 (i32.const 0) (get_local 0x040))
    (i64.store offset=0x041 align=1 (i32.const 0) (get_local 0x041))
    (i64.store offset=0x042 align=1 (i32.const 0) (get_local 0x042))
    (i64.store offset=0x043 align=1 (i32.const 0) (get_local 0x043))
    (i64.store offset=0x044 align=1 (i32.const 0) (get_local 0x044))
    (i64.store offset=0x045 align=1 (i32.const 0) (get_local 0x045))
    (i64.store offset=0x046 align=1 (i32.const 0) (get_local 0x046))
    (i64.store offset=0x047 align=1 (i32.const 0) (get_local 0x047))
    (i64.store offset=0x048 align=1 (i32.const 0) (get_local 0x048))
    (i64.store offset=0x049 align=1 (i32.const 0) (get_local 0x049))
    (i64.store offset=0x04a align=1 (i32.const 0) (get_local 0x04a))
    (i64.store offset=0x04b align=1 (i32.const 0) (get_local 0x04b))
    (i64.store offset=0x04c align=1 (i32.const 0) (get_local 0x04c))
    (i64.store offset=0x04d align=1 (i32.const 0) (get_local 0x04d))
    (i64.store offset=0x04e align=1 (i32.const 0) (get_local 0x04e))
    (i64.store offset=0x04f align=1 (i32.const 0) (get_local 0x04f))
    (i64.store offset=0x050 align=1 (i32.const 0) (get_local 0x050))
    (i64.store offset=0x051 align=1 (i32.const 0) (get_local 0x051))
    (i64.store offset=0x052 align=1 (i32.const 0) (get_local 0x052))
    (i64.store offset=0x053 align=1 (i32.const 0) (get_local 0x053))
    (i64.store offset=0x054 align=1 (i32.const 0) (get_local 0x054))
    (i64.store offset=0x055 align=1 (i32.const 0) (get_local 0x055))
    (i64.store offset=0x056 align=1 (i32.const 0) (get_local 0x056))
    (i64.store offset=0x057 align=1 (i32.const 0) (get_local 0x057))
    (i64.store offset=0x058 align=1 (i32.const 0) (get_local 0x058))
    (i64.store offset=0x059 align=1 (i32.const 0) (get_local 0x059))
    (i64.store offset=0x05a align=1 (i32.const 0) (get_local 0x05a))
    (i64.store offset=0x05b align=1 (i32.const 0) (get_local 0x05b))
    (i64.store offset=0x05c align=1 (i32.const 0) (get_local 0x05c))
    (i64.store offset=0x05d align=1 (i32.const 0) (get_local 0x05d))
    (i64.store offset=0x05e align=1 (i32.const 0) (get_local 0x05e))
    (i64.store offset=0x05f align=1 (i32.const 0) (get_local 0x05f))
    (i64.store offset=0x060 align=1 (i32.const 0) (get_local 0x060))
    (i64.store offset=0x061 align=1 (i32.const 0) (get_local 0x061))
    (i64.store offset=0x062 align=1 (i32.const 0) (get_local 0x062))
    (i64.store offset=0x063 align=1 (i32.const 0) (get_local 0x063))
    (i64.store offset=0x064 align=1 (i32.const 0) (get_local 0x064))
    (i64.store offset=0x065 align=1 (i32.const 0) (get_local 0x065))
    (i64.store offset=0x066 align=1 (i32.const 0) (get_local 0x066))
    (i64.store offset=0x067 align=1 (i32.const 0) (get_local 0x067))
    (i64.store offset=0x068 align=1 (i32.const 0) (get_local 0x068))
    (i64.store offset=0x069 align=1 (i32.const 0) (get_local 0x069))
    (i64.store offset=0x06a align=1 (i32.const 0) (get_local 0x06a))
    (i64.store offset=0x06b align=1 (i32.const 0) (get_local 0x06b))
    (i64.store offset=0x06c align=1 (i32.const 0) (get_local 0x06c))
    (i64.store offset=0x06d align=1 (i32.const 0) (get_local 0x06d))
    (i64.store offset=0x06e align=1 (i32.const 0) (get_local 0x06e))
    (i64.store offset=0x06f align=1 (i32.const 0) (get_local 0x06f))
    (i64.store offset=0x070 align=1 (i32.const 0) (get_local 0x070))
    (i64.store offset=0x071 align=1 (i32.const 0) (get_local 0x071))
    (i64.store offset=0x072 align=1 (i32.const 0) (get_local 0x072))
    (i64.store offset=0x073 align=1 (i32.const 0) (get_local 0x073))
    (i64.store offset=0x074 align=1 (i32.const 0) (get_local 0x074))
    (i64.store offset=0x075 align=1 (i32.const 0) (get_local 0x075))
    (i64.store offset=0x076 align=1 (i32.const 0) (get_local 0x076))
    (i64.store offset=0x077 align=1 (i32.const 0) (get_local 0x077))
    (i64.store offset=0x078 align=1 (i32.const 0) (get_local 0x078))
    (i64.store offset=0x079 align=1 (i32.const 0) (get_local 0x079))
    (i64.store offset=0x07a align=1 (i32.const 0) (get_local 0x07a))
    (i64.store offset=0x07b align=1 (i32.const 0) (get_local 0x07b))
    (i64.store offset=0x07c align=1 (i32.const 0) (get_local 0x07c))
    (i64.store offset=0x07d align=1 (i32.const 0) (get_local 0x07d))
    (i64.store offset=0x07e align=1 (i32.const 0) (get_local 0x07e))
    (i64.store offset=0x07f align=1 (i32.const 0) (get_local 0x07f))
    (i64.store offset=0x080 align=1 (i32.const 0) (get_local 0x080))
    (i64.store offset=0x081 align=1 (i32.const 0) (get_local 0x081))
    (i64.store offset=0x082 align=1 (i32.const 0) (get_local 0x082))
    (i64.store offset=0x083 align=1 (i32.const 0) (get_local 0x083))
    (i64.store offset=0x084 align=1 (i32.const 0) (get_local 0x084))
    (i64.store offset=0x085 align=1 (i32.const 0) (get_local 0x085))
    (i64.store offset=0x086 align=1 (i32.const 0) (get_local 0x086))
    (i64.store offset=0x087 align=1 (i32.const 0) (get_local 0x087))
    (i64.store offset=0x088 align=1 (i32.const 0) (get_local 0x088))
    (i64.store offset=0x089 align=1 (i32.const 0) (get_local 0x089))
    (i64.store offset=0x08a align=1 (i32.const 0) (get_local 0x08a))
    (i64.store offset=0x08b align=1 (i32.const 0) (get_local 0x08b))
    (i64.store offset=0x08c align=1 (i32.const 0) (get_local 0x08c))
    (i64.store offset=0x08d align=1 (i32.const 0) (get_local 0x08d))
    (i64.store offset=0x08e align=1 (i32.const 0) (get_local 0x08e))
    (i64.store offset=0x08f align=1 (i32.const 0) (get_local 0x08f))
    (i64.store offset=0x090 align=1 (i32.const 0) (get_local 0x090))
    (i64.store offset=0x091 align=1 (i32.const 0) (get_local 0x091))
    (i64.store offset=0x092 align=1 (i32.const 0) (get_local 0x092))
    (i64.store offset=0x093 align=1 (i32.const 0) (get_local 0x093))
    (i64.store offset=0x094 align=1 (i32.const 0) (get_local 0x094))
    (i64.store offset=0x095 align=1 (i32.const 0) (get_local 0x095))
    (i64.store offset=0x096 align=1 (i32.const 0) (get_local 0x096))
    (i64.store offset=0x097 align=1 (i32.const 0) (get_local 0x097))
    (i64.store offset=0x098 align=1 (i32.const 0) (get_local 0x098))
    (i64.store offset=0x099 align=1 (i32.const 0) (get_local 0x099))
    (i64.store offset=0x09a align=1 (i32.const 0) (get_local 0x09a))
    (i64.store offset=0x09b align=1 (i32.const 0) (get_local 0x09b))
    (i64.store offset=0x09c align=1 (i32.const 0) (get_local 0x09c))
    (i64.store offset=0x09d align=1 (i32.const 0) (get_local 0x09d))
    (i64.store offset=0x09e align=1 (i32.const 0) (get_local 0x09e))
    (i64.store offset=0x09f align=1 (i32.const 0) (get_local 0x09f))
    (i64.store offset=0x0a0 align=1 (i32.const 0) (get_local 0x0a0))
    (i64.store offset=0x0a1 align=1 (i32.const 0) (get_local 0x0a1))
    (i64.store offset=0x0a2 align=1 (i32.const 0) (get_local 0x0a2))
    (i64.store offset=0x0a3 align=1 (i32.const 0) (get_local 0x0a3))
    (i64.store offset=0x0a4 align=1 (i32.const 0) (get_local 0x0a4))
    (i64.store offset=0x0a5 align=1 (i32.const 0) (get_local 0x0a5))
    (i64.store offset=0x0a6 align=1 (i32.const 0) (get_local 0x0a6))
    (i64.store offset=0x0a7 align=1 (i32.const 0) (get_local 0x0a7))
    (i64.store offset=0x0a8 align=1 (i32.const 0) (get_local 0x0a8))
    (i64.store offset=0x0a9 align=1 (i32.const 0) (get_local 0x0a9))
    (i64.store offset=0x0aa align=1 (i32.const 0) (get_local 0x0aa))
    (i64.store offset=0x0ab align=1 (i32.const 0) (get_local 0x0ab))
    (i64.store offset=0x0ac align=1 (i32.const 0) (get_local 0x0ac))
    (i64.store offset=0x0ad align=1 (i32.const 0) (get_local 0x0ad))
    (i64.store offset=0x0ae align=1 (i32.const 0) (get_local 0x0ae))
    (i64.store offset=0x0af align=1 (i32.const 0) (get_local 0x0af))
    (i64.store offset=0x0b0 align=1 (i32.const 0) (get_local 0x0b0))
    (i64.store offset=0x0b1 align=1 (i32.const 0) (get_local 0x0b1))
    (i64.store offset=0x0b2 align=1 (i32.const 0) (get_local 0x0b2))
    (i64.store offset=0x0b3 align=1 (i32.const 0) (get_local 0x0b3))
    (i64.store offset=0x0b4 align=1 (i32.const 0) (get_local 0x0b4))
    (i64.store offset=0x0b5 align=1 (i32.const 0) (get_local 0x0b5))
    (i64.store offset=0x0b6 align=1 (i32.const 0) (get_local 0x0b6))
    (i64.store offset=0x0b7 align=1 (i32.const 0) (get_local 0x0b7))
    (i64.store offset=0x0b8 align=1 (i32.const 0) (get_local 0x0b8))
    (i64.store offset=0x0b9 align=1 (i32.const 0) (get_local 0x0b9))
    (i64.store offset=0x0ba align=1 (i32.const 0) (get_local 0x0ba))
    (i64.store offset=0x0bb align=1 (i32.const 0) (get_local 0x0bb))
    (i64.store offset=0x0bc align=1 (i32.const 0) (get_local 0x0bc))
    (i64.store offset=0x0bd align=1 (i32.const 0) (get_local 0x0bd))
    (i64.store offset=0x0be align=1 (i32.const 0) (get_local 0x0be))
    (i64.store offset=0x0bf align=1 (i32.const 0) (get_local 0x0bf))
    (i64.store offset=0x0c0 align=1 (i32.const 0) (get_local 0x0c0))
    (i64.store offset=0x0c1 align=1 (i32.const 0) (get_local 0x0c1))
    (i64.store offset=0x0c2 align=1 (i32.const 0) (get_local 0x0c2))
    (i64.store offset=0x0c3 align=1 (i32.const 0) (get_local 0x0c3))
    (i64.store offset=0x0c4 align=1 (i32.const 0) (get_local 0x0c4))
    (i64.store offset=0x0c5 align=1 (i32.const 0) (get_local 0x0c5))
    (i64.store offset=0x0c6 align=1 (i32.const 0) (get_local 0x0c6))
    (i64.store offset=0x0c7 align=1 (i32.const 0) (get_local 0x0c7))
    (i64.store offset=0x0c8 align=1 (i32.const 0) (get_local 0x0c8))
    (i64.store offset=0x0c9 align=1 (i32.const 0) (get_local 0x0c9))
    (i64.store offset=0x0ca align=1 (i32.const 0) (get_local 0x0ca))
    (i64.store offset=0x0cb align=1 (i32.const 0) (get_local 0x0cb))
    (i64.store offset=0x0cc align=1 (i32.const 0) (get_local 0x0cc))
    (i64.store offset=0x0cd align=1 (i32.const 0) (get_local 0x0cd))
    (i64.store offset=0x0ce align=1 (i32.const 0) (get_local 0x0ce))
    (i64.store offset=0x0cf align=1 (i32.const 0) (get_local 0x0cf))
    (i64.store offset=0x0d0 align=1 (i32.const 0) (get_local 0x0d0))
    (i64.store offset=0x0d1 align=1 (i32.const 0) (get_local 0x0d1))
    (i64.store offset=0x0d2 align=1 (i32.const 0) (get_local 0x0d2))
    (i64.store offset=0x0d3 align=1 (i32.const 0) (get_local 0x0d3))
    (i64.store offset=0x0d4 align=1 (i32.const 0) (get_local 0x0d4))
    (i64.store offset=0x0d5 align=1 (i32.const 0) (get_local 0x0d5))
    (i64.store offset=0x0d6 align=1 (i32.const 0) (get_local 0x0d6))
    (i64.store offset=0x0d7 align=1 (i32.const 0) (get_local 0x0d7))
    (i64.store offset=0x0d8 align=1 (i32.const 0) (get_local 0x0d8))
    (i64.store offset=0x0d9 align=1 (i32.const 0) (get_local 0x0d9))
    (i64.store offset=0x0da align=1 (i32.const 0) (get_local 0x0da))
    (i64.store offset=0x0db align=1 (i32.const 0) (get_local 0x0db))
    (i64.store offset=0x0dc align=1 (i32.const 0) (get_local 0x0dc))
    (i64.store offset=0x0dd align=1 (i32.const 0) (get_local 0x0dd))
    (i64.store offset=0x0de align=1 (i32.const 0) (get_local 0x0de))
    (i64.store offset=0x0df align=1 (i32.const 0) (get_local 0x0df))
    (i64.store offset=0x0e0 align=1 (i32.const 0) (get_local 0x0e0))
    (i64.store offset=0x0e1 align=1 (i32.const 0) (get_local 0x0e1))
    (i64.store offset=0x0e2 align=1 (i32.const 0) (get_local 0x0e2))
    (i64.store offset=0x0e3 align=1 (i32.const 0) (get_local 0x0e3))
    (i64.store offset=0x0e4 align=1 (i32.const 0) (get_local 0x0e4))
    (i64.store offset=0x0e5 align=1 (i32.const 0) (get_local 0x0e5))
    (i64.store offset=0x0e6 align=1 (i32.const 0) (get_local 0x0e6))
    (i64.store offset=0x0e7 align=1 (i32.const 0) (get_local 0x0e7))
    (i64.store offset=0x0e8 align=1 (i32.const 0) (get_local 0x0e8))
    (i64.store offset=0x0e9 align=1 (i32.const 0) (get_local 0x0e9))
    (i64.store offset=0x0ea align=1 (i32.const 0) (get_local 0x0ea))
    (i64.store offset=0x0eb align=1 (i32.const 0) (get_local 0x0eb))
    (i64.store offset=0x0ec align=1 (i32.const 0) (get_local 0x0ec))
    (i64.store offset=0x0ed align=1 (i32.const 0) (get_local 0x0ed))
    (i64.store offset=0x0ee align=1 (i32.const 0) (get_local 0x0ee))
    (i64.store offset=0x0ef align=1 (i32.const 0) (get_local 0x0ef))
    (i64.store offset=0x0f0 align=1 (i32.const 0) (get_local 0x0f0))
    (i64.store offset=0x0f1 align=1 (i32.const 0) (get_local 0x0f1))
    (i64.store offset=0x0f2 align=1 (i32.const 0) (get_local 0x0f2))
    (i64.store offset=0x0f3 align=1 (i32.const 0) (get_local 0x0f3))
    (i64.store offset=0x0f4 align=1 (i32.const 0) (get_local 0x0f4))
    (i64.store offset=0x0f5 align=1 (i32.const 0) (get_local 0x0f5))
    (i64.store offset=0x0f6 align=1 (i32.const 0) (get_local 0x0f6))
    (i64.store offset=0x0f7 align=1 (i32.const 0) (get_local 0x0f7))
    (i64.store offset=0x0f8 align=1 (i32.const 0) (get_local 0x0f8))
    (i64.store offset=0x0f9 align=1 (i32.const 0) (get_local 0x0f9))
    (i64.store offset=0x0fa align=1 (i32.const 0) (get_local 0x0fa))
    (i64.store offset=0x0fb align=1 (i32.const 0) (get_local 0x0fb))
    (i64.store offset=0x0fc align=1 (i32.const 0) (get_local 0x0fc))
    (i64.store offset=0x0fd align=1 (i32.const 0) (get_local 0x0fd))
    (i64.store offset=0x0fe align=1 (i32.const 0) (get_local 0x0fe))
    (i64.store offset=0x0ff align=1 (i32.const 0) (get_local 0x0ff))
    (i64.store offset=0x100 align=1 (i32.const 0) (get_local 0x100))
    (i64.store offset=0x101 align=1 (i32.const 0) (get_local 0x101))
    (i64.store offset=0x102 align=1 (i32.const 0) (get_local 0x102))
    (i64.store offset=0x103 align=1 (i32.const 0) (get_local 0x103))
    (i64.store offset=0x104 align=1 (i32.const 0) (get_local 0x104))
    (i64.store offset=0x105 align=1 (i32.const 0) (get_local 0x105))
    (i64.store offset=0x106 align=1 (i32.const 0) (get_local 0x106))
    (i64.store offset=0x107 align=1 (i32.const 0) (get_local 0x107))
    (i64.store offset=0x108 align=1 (i32.const 0) (get_local 0x108))
    (i64.store offset=0x109 align=1 (i32.const 0) (get_local 0x109))
    (i64.store offset=0x10a align=1 (i32.const 0) (get_local 0x10a))
    (i64.store offset=0x10b align=1 (i32.const 0) (get_local 0x10b))
    (i64.store offset=0x10c align=1 (i32.const 0) (get_local 0x10c))
    (i64.store offset=0x10d align=1 (i32.const 0) (get_local 0x10d))
    (i64.store offset=0x10e align=1 (i32.const 0) (get_local 0x10e))
    (i64.store offset=0x10f align=1 (i32.const 0) (get_local 0x10f))
    (i64.store offset=0x110 align=1 (i32.const 0) (get_local 0x110))
    (i64.store offset=0x111 align=1 (i32.const 0) (get_local 0x111))
    (i64.store offset=0x112 align=1 (i32.const 0) (get_local 0x112))
    (i64.store offset=0x113 align=1 (i32.const 0) (get_local 0x113))
    (i64.store offset=0x114 align=1 (i32.const 0) (get_local 0x114))
    (i64.store offset=0x115 align=1 (i32.const 0) (get_local 0x115))
    (i64.store offset=0x116 align=1 (i32.const 0) (get_local 0x116))
    (i64.store offset=0x117 align=1 (i32.const 0) (get_local 0x117))
    (i64.store offset=0x118 align=1 (i32.const 0) (get_local 0x118))
    (i64.store offset=0x119 align=1 (i32.const 0) (get_local 0x119))
    (i64.store offset=0x11a align=1 (i32.const 0) (get_local 0x11a))
    (i64.store offset=0x11b align=1 (i32.const 0) (get_local 0x11b))
    (i64.store offset=0x11c align=1 (i32.const 0) (get_local 0x11c))
    (i64.store offset=0x11d align=1 (i32.const 0) (get_local 0x11d))
    (i64.store offset=0x11e align=1 (i32.const 0) (get_local 0x11e))
    (i64.store offset=0x11f align=1 (i32.const 0) (get_local 0x11f))
    (i64.store offset=0x120 align=1 (i32.const 0) (get_local 0x120))
    (i64.store offset=0x121 align=1 (i32.const 0) (get_local 0x121))
    (i64.store offset=0x122 align=1 (i32.const 0) (get_local 0x122))
    (i64.store offset=0x123 align=1 (i32.const 0) (get_local 0x123))
    (i64.store offset=0x124 align=1 (i32.const 0) (get_local 0x124))
    (i64.store offset=0x125 align=1 (i32.const 0) (get_local 0x125))
    (i64.store offset=0x126 align=1 (i32.const 0) (get_local 0x126))
    (i64.store offset=0x127 align=1 (i32.const 0) (get_local 0x127))
    (i64.store offset=0x128 align=1 (i32.const 0) (get_local 0x128))
    (i64.store offset=0x129 align=1 (i32.const 0) (get_local 0x129))
    (i64.store offset=0x12a align=1 (i32.const 0) (get_local 0x12a))
    (i64.store offset=0x12b align=1 (i32.const 0) (get_local 0x12b))
    (i64.store offset=0x12c align=1 (i32.const 0) (get_local 0x12c))
    (i64.store offset=0x12d align=1 (i32.const 0) (get_local 0x12d))
    (i64.store offset=0x12e align=1 (i32.const 0) (get_local 0x12e))
    (i64.store offset=0x12f align=1 (i32.const 0) (get_local 0x12f))
    (i64.store offset=0x130 align=1 (i32.const 0) (get_local 0x130))
    (i64.store offset=0x131 align=1 (i32.const 0) (get_local 0x131))
    (i64.store offset=0x132 align=1 (i32.const 0) (get_local 0x132))
    (i64.store offset=0x133 align=1 (i32.const 0) (get_local 0x133))
    (i64.store offset=0x134 align=1 (i32.const 0) (get_local 0x134))
    (i64.store offset=0x135 align=1 (i32.const 0) (get_local 0x135))
    (i64.store offset=0x136 align=1 (i32.const 0) (get_local 0x136))
    (i64.store offset=0x137 align=1 (i32.const 0) (get_local 0x137))
    (i64.store offset=0x138 align=1 (i32.const 0) (get_local 0x138))
    (i64.store offset=0x139 align=1 (i32.const 0) (get_local 0x139))
    (i64.store offset=0x13a align=1 (i32.const 0) (get_local 0x13a))
    (i64.store offset=0x13b align=1 (i32.const 0) (get_local 0x13b))
    (i64.store offset=0x13c align=1 (i32.const 0) (get_local 0x13c))
    (i64.store offset=0x13d align=1 (i32.const 0) (get_local 0x13d))
    (i64.store offset=0x13e align=1 (i32.const 0) (get_local 0x13e))
    (i64.store offset=0x13f align=1 (i32.const 0) (get_local 0x13f))
    (i64.store offset=0x140 align=1 (i32.const 0) (get_local 0x140))
    (i64.store offset=0x141 align=1 (i32.const 0) (get_local 0x141))
    (i64.store offset=0x142 align=1 (i32.const 0) (get_local 0x142))
    (i64.store offset=0x143 align=1 (i32.const 0) (get_local 0x143))
    (i64.store offset=0x144 align=1 (i32.const 0) (get_local 0x144))
    (i64.store offset=0x145 align=1 (i32.const 0) (get_local 0x145))
    (i64.store offset=0x146 align=1 (i32.const 0) (get_local 0x146))
    (i64.store offset=0x147 align=1 (i32.const 0) (get_local 0x147))
    (i64.store offset=0x148 align=1 (i32.const 0) (get_local 0x148))
    (i64.store offset=0x149 align=1 (i32.const 0) (get_local 0x149))
    (i64.store offset=0x14a align=1 (i32.const 0) (get_local 0x14a))
    (i64.store offset=0x14b align=1 (i32.const 0) (get_local 0x14b))
    (i64.store offset=0x14c align=1 (i32.const 0) (get_local 0x14c))
    (i64.store offset=0x14d align=1 (i32.const 0) (get_local 0x14d))
    (i64.store offset=0x14e align=1 (i32.const 0) (get_local 0x14e))
    (i64.store offset=0x14f align=1 (i32.const 0) (get_local 0x14f))
    (i64.store offset=0x150 align=1 (i32.const 0) (get_local 0x150))
    (i64.store offset=0x151 align=1 (i32.const 0) (get_local 0x151))
    (i64.store offset=0x152 align=1 (i32.const 0) (get_local 0x152))
    (i64.store offset=0x153 align=1 (i32.const 0) (get_local 0x153))
    (i64.store offset=0x154 align=1 (i32.const 0) (get_local 0x154))
    (i64.store offset=0x155 align=1 (i32.const 0) (get_local 0x155))
    (i64.store offset=0x156 align=1 (i32.const 0) (get_local 0x156))
    (i64.store offset=0x157 align=1 (i32.const 0) (get_local 0x157))
    (i64.store offset=0x158 align=1 (i32.const 0) (get_local 0x158))
    (i64.store offset=0x159 align=1 (i32.const 0) (get_local 0x159))
    (i64.store offset=0x15a align=1 (i32.const 0) (get_local 0x15a))
    (i64.store offset=0x15b align=1 (i32.const 0) (get_local 0x15b))
    (i64.store offset=0x15c align=1 (i32.const 0) (get_local 0x15c))
    (i64.store offset=0x15d align=1 (i32.const 0) (get_local 0x15d))
    (i64.store offset=0x15e align=1 (i32.const 0) (get_local 0x15e))
    (i64.store offset=0x15f align=1 (i32.const 0) (get_local 0x15f))
    (i64.store offset=0x160 align=1 (i32.const 0) (get_local 0x160))
    (i64.store offset=0x161 align=1 (i32.const 0) (get_local 0x161))
    (i64.store offset=0x162 align=1 (i32.const 0) (get_local 0x162))
    (i64.store offset=0x163 align=1 (i32.const 0) (get_local 0x163))
    (i64.store offset=0x164 align=1 (i32.const 0) (get_local 0x164))
    (i64.store offset=0x165 align=1 (i32.const 0) (get_local 0x165))
    (i64.store offset=0x166 align=1 (i32.const 0) (get_local 0x166))
    (i64.store offset=0x167 align=1 (i32.const 0) (get_local 0x167))
    (i64.store offset=0x168 align=1 (i32.const 0) (get_local 0x168))
    (i64.store offset=0x169 align=1 (i32.const 0) (get_local 0x169))
    (i64.store offset=0x16a align=1 (i32.const 0) (get_local 0x16a))
    (i64.store offset=0x16b align=1 (i32.const 0) (get_local 0x16b))
    (i64.store offset=0x16c align=1 (i32.const 0) (get_local 0x16c))
    (i64.store offset=0x16d align=1 (i32.const 0) (get_local 0x16d))
    (i64.store offset=0x16e align=1 (i32.const 0) (get_local 0x16e))
    (i64.store offset=0x16f align=1 (i32.const 0) (get_local 0x16f))
    (i64.store offset=0x170 align=1 (i32.const 0) (get_local 0x170))
    (i64.store offset=0x171 align=1 (i32.const 0) (get_local 0x171))
    (i64.store offset=0x172 align=1 (i32.const 0) (get_local 0x172))
    (i64.store offset=0x173 align=1 (i32.const 0) (get_local 0x173))
    (i64.store offset=0x174 align=1 (i32.const 0) (get_local 0x174))
    (i64.store offset=0x175 align=1 (i32.const 0) (get_local 0x175))
    (i64.store offset=0x176 align=1 (i32.const 0) (get_local 0x176))
    (i64.store offset=0x177 align=1 (i32.const 0) (get_local 0x177))
    (i64.store offset=0x178 align=1 (i32.const 0) (get_local 0x178))
    (i64.store offset=0x179 align=1 (i32.const 0) (get_local 0x179))
    (i64.store offset=0x17a align=1 (i32.const 0) (get_local 0x17a))
    (i64.store offset=0x17b align=1 (i32.const 0) (get_local 0x17b))
    (i64.store offset=0x17c align=1 (i32.const 0) (get_local 0x17c))
    (i64.store offset=0x17d align=1 (i32.const 0) (get_local 0x17d))
    (i64.store offset=0x17e align=1 (i32.const 0) (get_local 0x17e))
    (i64.store offset=0x17f align=1 (i32.const 0) (get_local 0x17f))
    (i64.store offset=0x180 align=1 (i32.const 0) (get_local 0x180))
    (i64.store offset=0x181 align=1 (i32.const 0) (get_local 0x181))
    (i64.store offset=0x182 align=1 (i32.const 0) (get_local 0x182))
    (i64.store offset=0x183 align=1 (i32.const 0) (get_local 0x183))
    (i64.store offset=0x184 align=1 (i32.const 0) (get_local 0x184))
    (i64.store offset=0x185 align=1 (i32.const 0) (get_local 0x185))
    (i64.store offset=0x186 align=1 (i32.const 0) (get_local 0x186))
    (i64.store offset=0x187 align=1 (i32.const 0) (get_local 0x187))
    (i64.store offset=0x188 align=1 (i32.const 0) (get_local 0x188))
    (i64.store offset=0x189 align=1 (i32.const 0) (get_local 0x189))
    (i64.store offset=0x18a align=1 (i32.const 0) (get_local 0x18a))
    (i64.store offset=0x18b align=1 (i32.const 0) (get_local 0x18b))
    (i64.store offset=0x18c align=1 (i32.const 0) (get_local 0x18c))
    (i64.store offset=0x18d align=1 (i32.const 0) (get_local 0x18d))
    (i64.store offset=0x18e align=1 (i32.const 0) (get_local 0x18e))
    (i64.store offset=0x18f align=1 (i32.const 0) (get_local 0x18f))
    (i64.store offset=0x190 align=1 (i32.const 0) (get_local 0x190))
    (i64.store offset=0x191 align=1 (i32.const 0) (get_local 0x191))
    (i64.store offset=0x192 align=1 (i32.const 0) (get_local 0x192))
    (i64.store offset=0x193 align=1 (i32.const 0) (get_local 0x193))
    (i64.store offset=0x194 align=1 (i32.const 0) (get_local 0x194))
    (i64.store offset=0x195 align=1 (i32.const 0) (get_local 0x195))
    (i64.store offset=0x196 align=1 (i32.const 0) (get_local 0x196))
    (i64.store offset=0x197 align=1 (i32.const 0) (get_local 0x197))
    (i64.store offset=0x198 align=1 (i32.const 0) (get_local 0x198))
    (i64.store offset=0x199 align=1 (i32.const 0) (get_local 0x199))
    (i64.store offset=0x19a align=1 (i32.const 0) (get_local 0x19a))
    (i64.store offset=0x19b align=1 (i32.const 0) (get_local 0x19b))
    (i64.store offset=0x19c align=1 (i32.const 0) (get_local 0x19c))
    (i64.store offset=0x19d align=1 (i32.const 0) (get_local 0x19d))
    (i64.store offset=0x19e align=1 (i32.const 0) (get_local 0x19e))
    (i64.store offset=0x19f align=1 (i32.const 0) (get_local 0x19f))
    (i64.store offset=0x1a0 align=1 (i32.const 0) (get_local 0x1a0))
    (i64.store offset=0x1a1 align=1 (i32.const 0) (get_local 0x1a1))
    (i64.store offset=0x1a2 align=1 (i32.const 0) (get_local 0x1a2))
    (i64.store offset=0x1a3 align=1 (i32.const 0) (get_local 0x1a3))
    (i64.store offset=0x1a4 align=1 (i32.const 0) (get_local 0x1a4))
    (i64.store offset=0x1a5 align=1 (i32.const 0) (get_local 0x1a5))
    (i64.store offset=0x1a6 align=1 (i32.const 0) (get_local 0x1a6))
    (i64.store offset=0x1a7 align=1 (i32.const 0) (get_local 0x1a7))
    (i64.store offset=0x1a8 align=1 (i32.const 0) (get_local 0x1a8))
    (i64.store offset=0x1a9 align=1 (i32.const 0) (get_local 0x1a9))
    (i64.store offset=0x1aa align=1 (i32.const 0) (get_local 0x1aa))
    (i64.store offset=0x1ab align=1 (i32.const 0) (get_local 0x1ab))
    (i64.store offset=0x1ac align=1 (i32.const 0) (get_local 0x1ac))
    (i64.store offset=0x1ad align=1 (i32.const 0) (get_local 0x1ad))
    (i64.store offset=0x1ae align=1 (i32.const 0) (get_local 0x1ae))
    (i64.store offset=0x1af align=1 (i32.const 0) (get_local 0x1af))
    (i64.store offset=0x1b0 align=1 (i32.const 0) (get_local 0x1b0))
    (i64.store offset=0x1b1 align=1 (i32.const 0) (get_local 0x1b1))
    (i64.store offset=0x1b2 align=1 (i32.const 0) (get_local 0x1b2))
    (i64.store offset=0x1b3 align=1 (i32.const 0) (get_local 0x1b3))
    (i64.store offset=0x1b4 align=1 (i32.const 0) (get_local 0x1b4))
    (i64.store offset=0x1b5 align=1 (i32.const 0) (get_local 0x1b5))
    (i64.store offset=0x1b6 align=1 (i32.const 0) (get_local 0x1b6))
    (i64.store offset=0x1b7 align=1 (i32.const 0) (get_local 0x1b7))
    (i64.store offset=0x1b8 align=1 (i32.const 0) (get_local 0x1b8))
    (i64.store offset=0x1b9 align=1 (i32.const 0) (get_local 0x1b9))
    (i64.store offset=0x1ba align=1 (i32.const 0) (get_local 0x1ba))
    (i64.store offset=0x1bb align=1 (i32.const 0) (get_local 0x1bb))
    (i64.store offset=0x1bc align=1 (i32.const 0) (get_local 0x1bc))
    (i64.store offset=0x1bd align=1 (i32.const 0) (get_local 0x1bd))
    (i64.store offset=0x1be align=1 (i32.const 0) (get_local 0x1be))
    (i64.store offset=0x1bf align=1 (i32.const 0) (get_local 0x1bf))
    (i64.store offset=0x1c0 align=1 (i32.const 0) (get_local 0x1c0))
    (i64.store offset=0x1c1 align=1 (i32.const 0) (get_local 0x1c1))
    (i64.store offset=0x1c2 align=1 (i32.const 0) (get_local 0x1c2))
    (i64.store offset=0x1c3 align=1 (i32.const 0) (get_local 0x1c3))
    (i64.store offset=0x1c4 align=1 (i32.const 0) (get_local 0x1c4))
    (i64.store offset=0x1c5 align=1 (i32.const 0) (get_local 0x1c5))
    (i64.store offset=0x1c6 align=1 (i32.const 0) (get_local 0x1c6))
    (i64.store offset=0x1c7 align=1 (i32.const 0) (get_local 0x1c7))
    (i64.store offset=0x1c8 align=1 (i32.const 0) (get_local 0x1c8))
    (i64.store offset=0x1c9 align=1 (i32.const 0) (get_local 0x1c9))
    (i64.store offset=0x1ca align=1 (i32.const 0) (get_local 0x1ca))
    (i64.store offset=0x1cb align=1 (i32.const 0) (get_local 0x1cb))
    (i64.store offset=0x1cc align=1 (i32.const 0) (get_local 0x1cc))
    (i64.store offset=0x1cd align=1 (i32.const 0) (get_local 0x1cd))
    (i64.store offset=0x1ce align=1 (i32.const 0) (get_local 0x1ce))
    (i64.store offset=0x1cf align=1 (i32.const 0) (get_local 0x1cf))
    (i64.store offset=0x1d0 align=1 (i32.const 0) (get_local 0x1d0))
    (i64.store offset=0x1d1 align=1 (i32.const 0) (get_local 0x1d1))
    (i64.store offset=0x1d2 align=1 (i32.const 0) (get_local 0x1d2))
    (i64.store offset=0x1d3 align=1 (i32.const 0) (get_local 0x1d3))
    (i64.store offset=0x1d4 align=1 (i32.const 0) (get_local 0x1d4))
    (i64.store offset=0x1d5 align=1 (i32.const 0) (get_local 0x1d5))
    (i64.store offset=0x1d6 align=1 (i32.const 0) (get_local 0x1d6))
    (i64.store offset=0x1d7 align=1 (i32.const 0) (get_local 0x1d7))
    (i64.store offset=0x1d8 align=1 (i32.const 0) (get_local 0x1d8))
    (i64.store offset=0x1d9 align=1 (i32.const 0) (get_local 0x1d9))
    (i64.store offset=0x1da align=1 (i32.const 0) (get_local 0x1da))
    (i64.store offset=0x1db align=1 (i32.const 0) (get_local 0x1db))
    (i64.store offset=0x1dc align=1 (i32.const 0) (get_local 0x1dc))
    (i64.store offset=0x1dd align=1 (i32.const 0) (get_local 0x1dd))
    (i64.store offset=0x1de align=1 (i32.const 0) (get_local 0x1de))
    (i64.store offset=0x1df align=1 (i32.const 0) (get_local 0x1df))
    (i64.store offset=0x1e0 align=1 (i32.const 0) (get_local 0x1e0))
    (i64.store offset=0x1e1 align=1 (i32.const 0) (get_local 0x1e1))
    (i64.store offset=0x1e2 align=1 (i32.const 0) (get_local 0x1e2))
    (i64.store offset=0x1e3 align=1 (i32.const 0) (get_local 0x1e3))
    (i64.store offset=0x1e4 align=1 (i32.const 0) (get_local 0x1e4))
    (i64.store offset=0x1e5 align=1 (i32.const 0) (get_local 0x1e5))
    (i64.store offset=0x1e6 align=1 (i32.const 0) (get_local 0x1e6))
    (i64.store offset=0x1e7 align=1 (i32.const 0) (get_local 0x1e7))
    (i64.store offset=0x1e8 align=1 (i32.const 0) (get_local 0x1e8))
    (i64.store offset=0x1e9 align=1 (i32.const 0) (get_local 0x1e9))
    (i64.store offset=0x1ea align=1 (i32.const 0) (get_local 0x1ea))
    (i64.store offset=0x1eb align=1 (i32.const 0) (get_local 0x1eb))
    (i64.store offset=0x1ec align=1 (i32.const 0) (get_local 0x1ec))
    (i64.store offset=0x1ed align=1 (i32.const 0) (get_local 0x1ed))
    (i64.store offset=0x1ee align=1 (i32.const 0) (get_local 0x1ee))
    (i64.store offset=0x1ef align=1 (i32.const 0) (get_local 0x1ef))
    (i64.store offset=0x1f0 align=1 (i32.const 0) (get_local 0x1f0))
    (i64.store offset=0x1f1 align=1 (i32.const 0) (get_local 0x1f1))
    (i64.store offset=0x1f2 align=1 (i32.const 0) (get_local 0x1f2))
    (i64.store offset=0x1f3 align=1 (i32.const 0) (get_local 0x1f3))
    (i64.store offset=0x1f4 align=1 (i32.const 0) (get_local 0x1f4))
    (i64.store offset=0x1f5 align=1 (i32.const 0) (get_local 0x1f5))
    (i64.store offset=0x1f6 align=1 (i32.const 0) (get_local 0x1f6))
    (i64.store offset=0x1f7 align=1 (i32.const 0) (get_local 0x1f7))
    (i64.store offset=0x1f8 align=1 (i32.const 0) (get_local 0x1f8))
    (i64.store offset=0x1f9 align=1 (i32.const 0) (get_local 0x1f9))
    (i64.store offset=0x1fa align=1 (i32.const 0) (get_local 0x1fa))
    (i64.store offset=0x1fb align=1 (i32.const 0) (get_local 0x1fb))
    (i64.store offset=0x1fc align=1 (i32.const 0) (get_local 0x1fc))
    (i64.store offset=0x1fd align=1 (i32.const 0) (get_local 0x1fd))
    (i64.store offset=0x1fe align=1 (i32.const 0) (get_local 0x1fe))
    (i64.store offset=0x1ff align=1 (i32.const 0) (get_local 0x1ff))
    (i64.store offset=0x200 align=1 (i32.const 0) (get_local 0x200))
    (i64.store offset=0x201 align=1 (i32.const 0) (get_local 0x201))
    (i64.store offset=0x202 align=1 (i32.const 0) (get_local 0x202))
    (i64.store offset=0x203 align=1 (i32.const 0) (get_local 0x203))
    (i64.store offset=0x204 align=1 (i32.const 0) (get_local 0x204))
    (i64.store offset=0x205 align=1 (i32.const 0) (get_local 0x205))
    (i64.store offset=0x206 align=1 (i32.const 0) (get_local 0x206))
    (i64.store offset=0x207 align=1 (i32.const 0) (get_local 0x207))
    (i64.store offset=0x208 align=1 (i32.const 0) (get_local 0x208))
    (i64.store offset=0x209 align=1 (i32.const 0) (get_local 0x209))
    (i64.store offset=0x20a align=1 (i32.const 0) (get_local 0x20a))
    (i64.store offset=0x20b align=1 (i32.const 0) (get_local 0x20b))
    (i64.store offset=0x20c align=1 (i32.const 0) (get_local 0x20c))
    (i64.store offset=0x20d align=1 (i32.const 0) (get_local 0x20d))
    (i64.store offset=0x20e align=1 (i32.const 0) (get_local 0x20e))
    (i64.store offset=0x20f align=1 (i32.const 0) (get_local 0x20f))
    (i64.store offset=0x210 align=1 (i32.const 0) (get_local 0x210))
    (i64.store offset=0x211 align=1 (i32.const 0) (get_local 0x211))
    (i64.store offset=0x212 align=1 (i32.const 0) (get_local 0x212))
    (i64.store offset=0x213 align=1 (i32.const 0) (get_local 0x213))
    (i64.store offset=0x214 align=1 (i32.const 0) (get_local 0x214))
    (i64.store offset=0x215 align=1 (i32.const 0) (get_local 0x215))
    (i64.store offset=0x216 align=1 (i32.const 0) (get_local 0x216))
    (i64.store offset=0x217 align=1 (i32.const 0) (get_local 0x217))
    (i64.store offset=0x218 align=1 (i32.const 0) (get_local 0x218))
    (i64.store offset=0x219 align=1 (i32.const 0) (get_local 0x219))
    (i64.store offset=0x21a align=1 (i32.const 0) (get_local 0x21a))
    (i64.store offset=0x21b align=1 (i32.const 0) (get_local 0x21b))
    (i64.store offset=0x21c align=1 (i32.const 0) (get_local 0x21c))
    (i64.store offset=0x21d align=1 (i32.const 0) (get_local 0x21d))
    (i64.store offset=0x21e align=1 (i32.const 0) (get_local 0x21e))
    (i64.store offset=0x21f align=1 (i32.const 0) (get_local 0x21f))
    (i64.store offset=0x220 align=1 (i32.const 0) (get_local 0x220))
    (i64.store offset=0x221 align=1 (i32.const 0) (get_local 0x221))
    (i64.store offset=0x222 align=1 (i32.const 0) (get_local 0x222))
    (i64.store offset=0x223 align=1 (i32.const 0) (get_local 0x223))
    (i64.store offset=0x224 align=1 (i32.const 0) (get_local 0x224))
    (i64.store offset=0x225 align=1 (i32.const 0) (get_local 0x225))
    (i64.store offset=0x226 align=1 (i32.const 0) (get_local 0x226))
    (i64.store offset=0x227 align=1 (i32.const 0) (get_local 0x227))
    (i64.store offset=0x228 align=1 (i32.const 0) (get_local 0x228))
    (i64.store offset=0x229 align=1 (i32.const 0) (get_local 0x229))
    (i64.store offset=0x22a align=1 (i32.const 0) (get_local 0x22a))
    (i64.store offset=0x22b align=1 (i32.const 0) (get_local 0x22b))
    (i64.store offset=0x22c align=1 (i32.const 0) (get_local 0x22c))
    (i64.store offset=0x22d align=1 (i32.const 0) (get_local 0x22d))
    (i64.store offset=0x22e align=1 (i32.const 0) (get_local 0x22e))
    (i64.store offset=0x22f align=1 (i32.const 0) (get_local 0x22f))
    (i64.store offset=0x230 align=1 (i32.const 0) (get_local 0x230))
    (i64.store offset=0x231 align=1 (i32.const 0) (get_local 0x231))
    (i64.store offset=0x232 align=1 (i32.const 0) (get_local 0x232))
    (i64.store offset=0x233 align=1 (i32.const 0) (get_local 0x233))
    (i64.store offset=0x234 align=1 (i32.const 0) (get_local 0x234))
    (i64.store offset=0x235 align=1 (i32.const 0) (get_local 0x235))
    (i64.store offset=0x236 align=1 (i32.const 0) (get_local 0x236))
    (i64.store offset=0x237 align=1 (i32.const 0) (get_local 0x237))
    (i64.store offset=0x238 align=1 (i32.const 0) (get_local 0x238))
    (i64.store offset=0x239 align=1 (i32.const 0) (get_local 0x239))
    (i64.store offset=0x23a align=1 (i32.const 0) (get_local 0x23a))
    (i64.store offset=0x23b align=1 (i32.const 0) (get_local 0x23b))
    (i64.store offset=0x23c align=1 (i32.const 0) (get_local 0x23c))
    (i64.store offset=0x23d align=1 (i32.const 0) (get_local 0x23d))
    (i64.store offset=0x23e align=1 (i32.const 0) (get_local 0x23e))
    (i64.store offset=0x23f align=1 (i32.const 0) (get_local 0x23f))
    (i64.store offset=0x240 align=1 (i32.const 0) (get_local 0x240))
    (i64.store offset=0x241 align=1 (i32.const 0) (get_local 0x241))
    (i64.store offset=0x242 align=1 (i32.const 0) (get_local 0x242))
    (i64.store offset=0x243 align=1 (i32.const 0) (get_local 0x243))
    (i64.store offset=0x244 align=1 (i32.const 0) (get_local 0x244))
    (i64.store offset=0x245 align=1 (i32.const 0) (get_local 0x245))
    (i64.store offset=0x246 align=1 (i32.const 0) (get_local 0x246))
    (i64.store offset=0x247 align=1 (i32.const 0) (get_local 0x247))
    (i64.store offset=0x248 align=1 (i32.const 0) (get_local 0x248))
    (i64.store offset=0x249 align=1 (i32.const 0) (get_local 0x249))
    (i64.store offset=0x24a align=1 (i32.const 0) (get_local 0x24a))
    (i64.store offset=0x24b align=1 (i32.const 0) (get_local 0x24b))
    (i64.store offset=0x24c align=1 (i32.const 0) (get_local 0x24c))
    (i64.store offset=0x24d align=1 (i32.const 0) (get_local 0x24d))
    (i64.store offset=0x24e align=1 (i32.const 0) (get_local 0x24e))
    (i64.store offset=0x24f align=1 (i32.const 0) (get_local 0x24f))
    (i64.store offset=0x250 align=1 (i32.const 0) (get_local 0x250))
    (i64.store offset=0x251 align=1 (i32.const 0) (get_local 0x251))
    (i64.store offset=0x252 align=1 (i32.const 0) (get_local 0x252))
    (i64.store offset=0x253 align=1 (i32.const 0) (get_local 0x253))
    (i64.store offset=0x254 align=1 (i32.const 0) (get_local 0x254))
    (i64.store offset=0x255 align=1 (i32.const 0) (get_local 0x255))
    (i64.store offset=0x256 align=1 (i32.const 0) (get_local 0x256))
    (i64.store offset=0x257 align=1 (i32.const 0) (get_local 0x257))
    (i64.store offset=0x258 align=1 (i32.const 0) (get_local 0x258))
    (i64.store offset=0x259 align=1 (i32.const 0) (get_local 0x259))
    (i64.store offset=0x25a align=1 (i32.const 0) (get_local 0x25a))
    (i64.store offset=0x25b align=1 (i32.const 0) (get_local 0x25b))
    (i64.store offset=0x25c align=1 (i32.const 0) (get_local 0x25c))
    (i64.store offset=0x25d align=1 (i32.const 0) (get_local 0x25d))
    (i64.store offset=0x25e align=1 (i32.const 0) (get_local 0x25e))
    (i64.store offset=0x25f align=1 (i32.const 0) (get_local 0x25f))
    (i64.store offset=0x260 align=1 (i32.const 0) (get_local 0x260))
    (i64.store offset=0x261 align=1 (i32.const 0) (get_local 0x261))
    (i64.store offset=0x262 align=1 (i32.const 0) (get_local 0x262))
    (i64.store offset=0x263 align=1 (i32.const 0) (get_local 0x263))
    (i64.store offset=0x264 align=1 (i32.const 0) (get_local 0x264))
    (i64.store offset=0x265 align=1 (i32.const 0) (get_local 0x265))
    (i64.store offset=0x266 align=1 (i32.const 0) (get_local 0x266))
    (i64.store offset=0x267 align=1 (i32.const 0) (get_local 0x267))
    (i64.store offset=0x268 align=1 (i32.const 0) (get_local 0x268))
    (i64.store offset=0x269 align=1 (i32.const 0) (get_local 0x269))
    (i64.store offset=0x26a align=1 (i32.const 0) (get_local 0x26a))
    (i64.store offset=0x26b align=1 (i32.const 0) (get_local 0x26b))
    (i64.store offset=0x26c align=1 (i32.const 0) (get_local 0x26c))
    (i64.store offset=0x26d align=1 (i32.const 0) (get_local 0x26d))
    (i64.store offset=0x26e align=1 (i32.const 0) (get_local 0x26e))
    (i64.store offset=0x26f align=1 (i32.const 0) (get_local 0x26f))
    (i64.store offset=0x270 align=1 (i32.const 0) (get_local 0x270))
    (i64.store offset=0x271 align=1 (i32.const 0) (get_local 0x271))
    (i64.store offset=0x272 align=1 (i32.const 0) (get_local 0x272))
    (i64.store offset=0x273 align=1 (i32.const 0) (get_local 0x273))
    (i64.store offset=0x274 align=1 (i32.const 0) (get_local 0x274))
    (i64.store offset=0x275 align=1 (i32.const 0) (get_local 0x275))
    (i64.store offset=0x276 align=1 (i32.const 0) (get_local 0x276))
    (i64.store offset=0x277 align=1 (i32.const 0) (get_local 0x277))
    (i64.store offset=0x278 align=1 (i32.const 0) (get_local 0x278))
    (i64.store offset=0x279 align=1 (i32.const 0) (get_local 0x279))
    (i64.store offset=0x27a align=1 (i32.const 0) (get_local 0x27a))
    (i64.store offset=0x27b align=1 (i32.const 0) (get_local 0x27b))
    (i64.store offset=0x27c align=1 (i32.const 0) (get_local 0x27c))
    (i64.store offset=0x27d align=1 (i32.const 0) (get_local 0x27d))
    (i64.store offset=0x27e align=1 (i32.const 0) (get_local 0x27e))
    (i64.store offset=0x27f align=1 (i32.const 0) (get_local 0x27f))
    (i64.store offset=0x280 align=1 (i32.const 0) (get_local 0x280))
    (i64.store offset=0x281 align=1 (i32.const 0) (get_local 0x281))
    (i64.store offset=0x282 align=1 (i32.const 0) (get_local 0x282))
    (i64.store offset=0x283 align=1 (i32.const 0) (get_local 0x283))
    (i64.store offset=0x284 align=1 (i32.const 0) (get_local 0x284))
    (i64.store offset=0x285 align=1 (i32.const 0) (get_local 0x285))
    (i64.store offset=0x286 align=1 (i32.const 0) (get_local 0x286))
    (i64.store offset=0x287 align=1 (i32.const 0) (get_local 0x287))
    (i64.store offset=0x288 align=1 (i32.const 0) (get_local 0x288))
    (i64.store offset=0x289 align=1 (i32.const 0) (get_local 0x289))
    (i64.store offset=0x28a align=1 (i32.const 0) (get_local 0x28a))
    (i64.store offset=0x28b align=1 (i32.const 0) (get_local 0x28b))
    (i64.store offset=0x28c align=1 (i32.const 0) (get_local 0x28c))
    (i64.store offset=0x28d align=1 (i32.const 0) (get_local 0x28d))
    (i64.store offset=0x28e align=1 (i32.const 0) (get_local 0x28e))
    (i64.store offset=0x28f align=1 (i32.const 0) (get_local 0x28f))
    (i64.store offset=0x290 align=1 (i32.const 0) (get_local 0x290))
    (i64.store offset=0x291 align=1 (i32.const 0) (get_local 0x291))
    (i64.store offset=0x292 align=1 (i32.const 0) (get_local 0x292))
    (i64.store offset=0x293 align=1 (i32.const 0) (get_local 0x293))
    (i64.store offset=0x294 align=1 (i32.const 0) (get_local 0x294))
    (i64.store offset=0x295 align=1 (i32.const 0) (get_local 0x295))
    (i64.store offset=0x296 align=1 (i32.const 0) (get_local 0x296))
    (i64.store offset=0x297 align=1 (i32.const 0) (get_local 0x297))
    (i64.store offset=0x298 align=1 (i32.const 0) (get_local 0x298))
    (i64.store offset=0x299 align=1 (i32.const 0) (get_local 0x299))
    (i64.store offset=0x29a align=1 (i32.const 0) (get_local 0x29a))
    (i64.store offset=0x29b align=1 (i32.const 0) (get_local 0x29b))
    (i64.store offset=0x29c align=1 (i32.const 0) (get_local 0x29c))
    (i64.store offset=0x29d align=1 (i32.const 0) (get_local 0x29d))
    (i64.store offset=0x29e align=1 (i32.const 0) (get_local 0x29e))
    (i64.store offset=0x29f align=1 (i32.const 0) (get_local 0x29f))
    (i64.store offset=0x2a0 align=1 (i32.const 0) (get_local 0x2a0))
    (i64.store offset=0x2a1 align=1 (i32.const 0) (get_local 0x2a1))
    (i64.store offset=0x2a2 align=1 (i32.const 0) (get_local 0x2a2))
    (i64.store offset=0x2a3 align=1 (i32.const 0) (get_local 0x2a3))
    (i64.store offset=0x2a4 align=1 (i32.const 0) (get_local 0x2a4))
    (i64.store offset=0x2a5 align=1 (i32.const 0) (get_local 0x2a5))
    (i64.store offset=0x2a6 align=1 (i32.const 0) (get_local 0x2a6))
    (i64.store offset=0x2a7 align=1 (i32.const 0) (get_local 0x2a7))
    (i64.store offset=0x2a8 align=1 (i32.const 0) (get_local 0x2a8))
    (i64.store offset=0x2a9 align=1 (i32.const 0) (get_local 0x2a9))
    (i64.store offset=0x2aa align=1 (i32.const 0) (get_local 0x2aa))
    (i64.store offset=0x2ab align=1 (i32.const 0) (get_local 0x2ab))
    (i64.store offset=0x2ac align=1 (i32.const 0) (get_local 0x2ac))
    (i64.store offset=0x2ad align=1 (i32.const 0) (get_local 0x2ad))
    (i64.store offset=0x2ae align=1 (i32.const 0) (get_local 0x2ae))
    (i64.store offset=0x2af align=1 (i32.const 0) (get_local 0x2af))
    (i64.store offset=0x2b0 align=1 (i32.const 0) (get_local 0x2b0))
    (i64.store offset=0x2b1 align=1 (i32.const 0) (get_local 0x2b1))
    (i64.store offset=0x2b2 align=1 (i32.const 0) (get_local 0x2b2))
    (i64.store offset=0x2b3 align=1 (i32.const 0) (get_local 0x2b3))
    (i64.store offset=0x2b4 align=1 (i32.const 0) (get_local 0x2b4))
    (i64.store offset=0x2b5 align=1 (i32.const 0) (get_local 0x2b5))
    (i64.store offset=0x2b6 align=1 (i32.const 0) (get_local 0x2b6))
    (i64.store offset=0x2b7 align=1 (i32.const 0) (get_local 0x2b7))
    (i64.store offset=0x2b8 align=1 (i32.const 0) (get_local 0x2b8))
    (i64.store offset=0x2b9 align=1 (i32.const 0) (get_local 0x2b9))
    (i64.store offset=0x2ba align=1 (i32.const 0) (get_local 0x2ba))
    (i64.store offset=0x2bb align=1 (i32.const 0) (get_local 0x2bb))
    (i64.store offset=0x2bc align=1 (i32.const 0) (get_local 0x2bc))
    (i64.store offset=0x2bd align=1 (i32.const 0) (get_local 0x2bd))
    (i64.store offset=0x2be align=1 (i32.const 0) (get_local 0x2be))
    (i64.store offset=0x2bf align=1 (i32.const 0) (get_local 0x2bf))
    (i64.store offset=0x2c0 align=1 (i32.const 0) (get_local 0x2c0))
    (i64.store offset=0x2c1 align=1 (i32.const 0) (get_local 0x2c1))
    (i64.store offset=0x2c2 align=1 (i32.const 0) (get_local 0x2c2))
    (i64.store offset=0x2c3 align=1 (i32.const 0) (get_local 0x2c3))
    (i64.store offset=0x2c4 align=1 (i32.const 0) (get_local 0x2c4))
    (i64.store offset=0x2c5 align=1 (i32.const 0) (get_local 0x2c5))
    (i64.store offset=0x2c6 align=1 (i32.const 0) (get_local 0x2c6))
    (i64.store offset=0x2c7 align=1 (i32.const 0) (get_local 0x2c7))
    (i64.store offset=0x2c8 align=1 (i32.const 0) (get_local 0x2c8))
    (i64.store offset=0x2c9 align=1 (i32.const 0) (get_local 0x2c9))
    (i64.store offset=0x2ca align=1 (i32.const 0) (get_local 0x2ca))
    (i64.store offset=0x2cb align=1 (i32.const 0) (get_local 0x2cb))
    (i64.store offset=0x2cc align=1 (i32.const 0) (get_local 0x2cc))
    (i64.store offset=0x2cd align=1 (i32.const 0) (get_local 0x2cd))
    (i64.store offset=0x2ce align=1 (i32.const 0) (get_local 0x2ce))
    (i64.store offset=0x2cf align=1 (i32.const 0) (get_local 0x2cf))
    (i64.store offset=0x2d0 align=1 (i32.const 0) (get_local 0x2d0))
    (i64.store offset=0x2d1 align=1 (i32.const 0) (get_local 0x2d1))
    (i64.store offset=0x2d2 align=1 (i32.const 0) (get_local 0x2d2))
    (i64.store offset=0x2d3 align=1 (i32.const 0) (get_local 0x2d3))
    (i64.store offset=0x2d4 align=1 (i32.const 0) (get_local 0x2d4))
    (i64.store offset=0x2d5 align=1 (i32.const 0) (get_local 0x2d5))
    (i64.store offset=0x2d6 align=1 (i32.const 0) (get_local 0x2d6))
    (i64.store offset=0x2d7 align=1 (i32.const 0) (get_local 0x2d7))
    (i64.store offset=0x2d8 align=1 (i32.const 0) (get_local 0x2d8))
    (i64.store offset=0x2d9 align=1 (i32.const 0) (get_local 0x2d9))
    (i64.store offset=0x2da align=1 (i32.const 0) (get_local 0x2da))
    (i64.store offset=0x2db align=1 (i32.const 0) (get_local 0x2db))
    (i64.store offset=0x2dc align=1 (i32.const 0) (get_local 0x2dc))
    (i64.store offset=0x2dd align=1 (i32.const 0) (get_local 0x2dd))
    (i64.store offset=0x2de align=1 (i32.const 0) (get_local 0x2de))
    (i64.store offset=0x2df align=1 (i32.const 0) (get_local 0x2df))
    (i64.store offset=0x2e0 align=1 (i32.const 0) (get_local 0x2e0))
    (i64.store offset=0x2e1 align=1 (i32.const 0) (get_local 0x2e1))
    (i64.store offset=0x2e2 align=1 (i32.const 0) (get_local 0x2e2))
    (i64.store offset=0x2e3 align=1 (i32.const 0) (get_local 0x2e3))
    (i64.store offset=0x2e4 align=1 (i32.const 0) (get_local 0x2e4))
    (i64.store offset=0x2e5 align=1 (i32.const 0) (get_local 0x2e5))
    (i64.store offset=0x2e6 align=1 (i32.const 0) (get_local 0x2e6))
    (i64.store offset=0x2e7 align=1 (i32.const 0) (get_local 0x2e7))
    (i64.store offset=0x2e8 align=1 (i32.const 0) (get_local 0x2e8))
    (i64.store offset=0x2e9 align=1 (i32.const 0) (get_local 0x2e9))
    (i64.store offset=0x2ea align=1 (i32.const 0) (get_local 0x2ea))
    (i64.store offset=0x2eb align=1 (i32.const 0) (get_local 0x2eb))
    (i64.store offset=0x2ec align=1 (i32.const 0) (get_local 0x2ec))
    (i64.store offset=0x2ed align=1 (i32.const 0) (get_local 0x2ed))
    (i64.store offset=0x2ee align=1 (i32.const 0) (get_local 0x2ee))
    (i64.store offset=0x2ef align=1 (i32.const 0) (get_local 0x2ef))
    (i64.store offset=0x2f0 align=1 (i32.const 0) (get_local 0x2f0))
    (i64.store offset=0x2f1 align=1 (i32.const 0) (get_local 0x2f1))
    (i64.store offset=0x2f2 align=1 (i32.const 0) (get_local 0x2f2))
    (i64.store offset=0x2f3 align=1 (i32.const 0) (get_local 0x2f3))
    (i64.store offset=0x2f4 align=1 (i32.const 0) (get_local 0x2f4))
    (i64.store offset=0x2f5 align=1 (i32.const 0) (get_local 0x2f5))
    (i64.store offset=0x2f6 align=1 (i32.const 0) (get_local 0x2f6))
    (i64.store offset=0x2f7 align=1 (i32.const 0) (get_local 0x2f7))
    (i64.store offset=0x2f8 align=1 (i32.const 0) (get_local 0x2f8))
    (i64.store offset=0x2f9 align=1 (i32.const 0) (get_local 0x2f9))
    (i64.store offset=0x2fa align=1 (i32.const 0) (get_local 0x2fa))
    (i64.store offset=0x2fb align=1 (i32.const 0) (get_local 0x2fb))
    (i64.store offset=0x2fc align=1 (i32.const 0) (get_local 0x2fc))
    (i64.store offset=0x2fd align=1 (i32.const 0) (get_local 0x2fd))
    (i64.store offset=0x2fe align=1 (i32.const 0) (get_local 0x2fe))
    (i64.store offset=0x2ff align=1 (i32.const 0) (get_local 0x2ff))
    (i64.store offset=0x300 align=1 (i32.const 0) (get_local 0x300))
    (i64.store offset=0x301 align=1 (i32.const 0) (get_local 0x301))
    (i64.store offset=0x302 align=1 (i32.const 0) (get_local 0x302))
    (i64.store offset=0x303 align=1 (i32.const 0) (get_local 0x303))
    (i64.store offset=0x304 align=1 (i32.const 0) (get_local 0x304))
    (i64.store offset=0x305 align=1 (i32.const 0) (get_local 0x305))
    (i64.store offset=0x306 align=1 (i32.const 0) (get_local 0x306))
    (i64.store offset=0x307 align=1 (i32.const 0) (get_local 0x307))
    (i64.store offset=0x308 align=1 (i32.const 0) (get_local 0x308))
    (i64.store offset=0x309 align=1 (i32.const 0) (get_local 0x309))
    (i64.store offset=0x30a align=1 (i32.const 0) (get_local 0x30a))
    (i64.store offset=0x30b align=1 (i32.const 0) (get_local 0x30b))
    (i64.store offset=0x30c align=1 (i32.const 0) (get_local 0x30c))
    (i64.store offset=0x30d align=1 (i32.const 0) (get_local 0x30d))
    (i64.store offset=0x30e align=1 (i32.const 0) (get_local 0x30e))
    (i64.store offset=0x30f align=1 (i32.const 0) (get_local 0x30f))
    (i64.store offset=0x310 align=1 (i32.const 0) (get_local 0x310))
    (i64.store offset=0x311 align=1 (i32.const 0) (get_local 0x311))
    (i64.store offset=0x312 align=1 (i32.const 0) (get_local 0x312))
    (i64.store offset=0x313 align=1 (i32.const 0) (get_local 0x313))
    (i64.store offset=0x314 align=1 (i32.const 0) (get_local 0x314))
    (i64.store offset=0x315 align=1 (i32.const 0) (get_local 0x315))
    (i64.store offset=0x316 align=1 (i32.const 0) (get_local 0x316))
    (i64.store offset=0x317 align=1 (i32.const 0) (get_local 0x317))
    (i64.store offset=0x318 align=1 (i32.const 0) (get_local 0x318))
    (i64.store offset=0x319 align=1 (i32.const 0) (get_local 0x319))
    (i64.store offset=0x31a align=1 (i32.const 0) (get_local 0x31a))
    (i64.store offset=0x31b align=1 (i32.const 0) (get_local 0x31b))
    (i64.store offset=0x31c align=1 (i32.const 0) (get_local 0x31c))
    (i64.store offset=0x31d align=1 (i32.const 0) (get_local 0x31d))
    (i64.store offset=0x31e align=1 (i32.const 0) (get_local 0x31e))
    (i64.store offset=0x31f align=1 (i32.const 0) (get_local 0x31f))
    (i64.store offset=0x320 align=1 (i32.const 0) (get_local 0x320))
    (i64.store offset=0x321 align=1 (i32.const 0) (get_local 0x321))
    (i64.store offset=0x322 align=1 (i32.const 0) (get_local 0x322))
    (i64.store offset=0x323 align=1 (i32.const 0) (get_local 0x323))
    (i64.store offset=0x324 align=1 (i32.const 0) (get_local 0x324))
    (i64.store offset=0x325 align=1 (i32.const 0) (get_local 0x325))
    (i64.store offset=0x326 align=1 (i32.const 0) (get_local 0x326))
    (i64.store offset=0x327 align=1 (i32.const 0) (get_local 0x327))
    (i64.store offset=0x328 align=1 (i32.const 0) (get_local 0x328))
    (i64.store offset=0x329 align=1 (i32.const 0) (get_local 0x329))
    (i64.store offset=0x32a align=1 (i32.const 0) (get_local 0x32a))
    (i64.store offset=0x32b align=1 (i32.const 0) (get_local 0x32b))
    (i64.store offset=0x32c align=1 (i32.const 0) (get_local 0x32c))
    (i64.store offset=0x32d align=1 (i32.const 0) (get_local 0x32d))
    (i64.store offset=0x32e align=1 (i32.const 0) (get_local 0x32e))
    (i64.store offset=0x32f align=1 (i32.const 0) (get_local 0x32f))
    (i64.store offset=0x330 align=1 (i32.const 0) (get_local 0x330))
    (i64.store offset=0x331 align=1 (i32.const 0) (get_local 0x331))
    (i64.store offset=0x332 align=1 (i32.const 0) (get_local 0x332))
    (i64.store offset=0x333 align=1 (i32.const 0) (get_local 0x333))
    (i64.store offset=0x334 align=1 (i32.const 0) (get_local 0x334))
    (i64.store offset=0x335 align=1 (i32.const 0) (get_local 0x335))
    (i64.store offset=0x336 align=1 (i32.const 0) (get_local 0x336))
    (i64.store offset=0x337 align=1 (i32.const 0) (get_local 0x337))
    (i64.store offset=0x338 align=1 (i32.const 0) (get_local 0x338))
    (i64.store offset=0x339 align=1 (i32.const 0) (get_local 0x339))
    (i64.store offset=0x33a align=1 (i32.const 0) (get_local 0x33a))
    (i64.store offset=0x33b align=1 (i32.const 0) (get_local 0x33b))
    (i64.store offset=0x33c align=1 (i32.const 0) (get_local 0x33c))
    (i64.store offset=0x33d align=1 (i32.const 0) (get_local 0x33d))
    (i64.store offset=0x33e align=1 (i32.const 0) (get_local 0x33e))
    (i64.store offset=0x33f align=1 (i32.const 0) (get_local 0x33f))
    (i64.store offset=0x340 align=1 (i32.const 0) (get_local 0x340))
    (i64.store offset=0x341 align=1 (i32.const 0) (get_local 0x341))
    (i64.store offset=0x342 align=1 (i32.const 0) (get_local 0x342))
    (i64.store offset=0x343 align=1 (i32.const 0) (get_local 0x343))
    (i64.store offset=0x344 align=1 (i32.const 0) (get_local 0x344))
    (i64.store offset=0x345 align=1 (i32.const 0) (get_local 0x345))
    (i64.store offset=0x346 align=1 (i32.const 0) (get_local 0x346))
    (i64.store offset=0x347 align=1 (i32.const 0) (get_local 0x347))
    (i64.store offset=0x348 align=1 (i32.const 0) (get_local 0x348))
    (i64.store offset=0x349 align=1 (i32.const 0) (get_local 0x349))
    (i64.store offset=0x34a align=1 (i32.const 0) (get_local 0x34a))
    (i64.store offset=0x34b align=1 (i32.const 0) (get_local 0x34b))
    (i64.store offset=0x34c align=1 (i32.const 0) (get_local 0x34c))
    (i64.store offset=0x34d align=1 (i32.const 0) (get_local 0x34d))
    (i64.store offset=0x34e align=1 (i32.const 0) (get_local 0x34e))
    (i64.store offset=0x34f align=1 (i32.const 0) (get_local 0x34f))
    (i64.store offset=0x350 align=1 (i32.const 0) (get_local 0x350))
    (i64.store offset=0x351 align=1 (i32.const 0) (get_local 0x351))
    (i64.store offset=0x352 align=1 (i32.const 0) (get_local 0x352))
    (i64.store offset=0x353 align=1 (i32.const 0) (get_local 0x353))
    (i64.store offset=0x354 align=1 (i32.const 0) (get_local 0x354))
    (i64.store offset=0x355 align=1 (i32.const 0) (get_local 0x355))
    (i64.store offset=0x356 align=1 (i32.const 0) (get_local 0x356))
    (i64.store offset=0x357 align=1 (i32.const 0) (get_local 0x357))
    (i64.store offset=0x358 align=1 (i32.const 0) (get_local 0x358))
    (i64.store offset=0x359 align=1 (i32.const 0) (get_local 0x359))
    (i64.store offset=0x35a align=1 (i32.const 0) (get_local 0x35a))
    (i64.store offset=0x35b align=1 (i32.const 0) (get_local 0x35b))
    (i64.store offset=0x35c align=1 (i32.const 0) (get_local 0x35c))
    (i64.store offset=0x35d align=1 (i32.const 0) (get_local 0x35d))
    (i64.store offset=0x35e align=1 (i32.const 0) (get_local 0x35e))
    (i64.store offset=0x35f align=1 (i32.const 0) (get_local 0x35f))
    (i64.store offset=0x360 align=1 (i32.const 0) (get_local 0x360))
    (i64.store offset=0x361 align=1 (i32.const 0) (get_local 0x361))
    (i64.store offset=0x362 align=1 (i32.const 0) (get_local 0x362))
    (i64.store offset=0x363 align=1 (i32.const 0) (get_local 0x363))
    (i64.store offset=0x364 align=1 (i32.const 0) (get_local 0x364))
    (i64.store offset=0x365 align=1 (i32.const 0) (get_local 0x365))
    (i64.store offset=0x366 align=1 (i32.const 0) (get_local 0x366))
    (i64.store offset=0x367 align=1 (i32.const 0) (get_local 0x367))
    (i64.store offset=0x368 align=1 (i32.const 0) (get_local 0x368))
    (i64.store offset=0x369 align=1 (i32.const 0) (get_local 0x369))
    (i64.store offset=0x36a align=1 (i32.const 0) (get_local 0x36a))
    (i64.store offset=0x36b align=1 (i32.const 0) (get_local 0x36b))
    (i64.store offset=0x36c align=1 (i32.const 0) (get_local 0x36c))
    (i64.store offset=0x36d align=1 (i32.const 0) (get_local 0x36d))
    (i64.store offset=0x36e align=1 (i32.const 0) (get_local 0x36e))
    (i64.store offset=0x36f align=1 (i32.const 0) (get_local 0x36f))
    (i64.store offset=0x370 align=1 (i32.const 0) (get_local 0x370))
    (i64.store offset=0x371 align=1 (i32.const 0) (get_local 0x371))
    (i64.store offset=0x372 align=1 (i32.const 0) (get_local 0x372))
    (i64.store offset=0x373 align=1 (i32.const 0) (get_local 0x373))
    (i64.store offset=0x374 align=1 (i32.const 0) (get_local 0x374))
    (i64.store offset=0x375 align=1 (i32.const 0) (get_local 0x375))
    (i64.store offset=0x376 align=1 (i32.const 0) (get_local 0x376))
    (i64.store offset=0x377 align=1 (i32.const 0) (get_local 0x377))
    (i64.store offset=0x378 align=1 (i32.const 0) (get_local 0x378))
    (i64.store offset=0x379 align=1 (i32.const 0) (get_local 0x379))
    (i64.store offset=0x37a align=1 (i32.const 0) (get_local 0x37a))
    (i64.store offset=0x37b align=1 (i32.const 0) (get_local 0x37b))
    (i64.store offset=0x37c align=1 (i32.const 0) (get_local 0x37c))
    (i64.store offset=0x37d align=1 (i32.const 0) (get_local 0x37d))
    (i64.store offset=0x37e align=1 (i32.const 0) (get_local 0x37e))
    (i64.store offset=0x37f align=1 (i32.const 0) (get_local 0x37f))
    (i64.store offset=0x380 align=1 (i32.const 0) (get_local 0x380))
    (i64.store offset=0x381 align=1 (i32.const 0) (get_local 0x381))
    (i64.store offset=0x382 align=1 (i32.const 0) (get_local 0x382))
    (i64.store offset=0x383 align=1 (i32.const 0) (get_local 0x383))
    (i64.store offset=0x384 align=1 (i32.const 0) (get_local 0x384))
    (i64.store offset=0x385 align=1 (i32.const 0) (get_local 0x385))
    (i64.store offset=0x386 align=1 (i32.const 0) (get_local 0x386))
    (i64.store offset=0x387 align=1 (i32.const 0) (get_local 0x387))
    (i64.store offset=0x388 align=1 (i32.const 0) (get_local 0x388))
    (i64.store offset=0x389 align=1 (i32.const 0) (get_local 0x389))
    (i64.store offset=0x38a align=1 (i32.const 0) (get_local 0x38a))
    (i64.store offset=0x38b align=1 (i32.const 0) (get_local 0x38b))
    (i64.store offset=0x38c align=1 (i32.const 0) (get_local 0x38c))
    (i64.store offset=0x38d align=1 (i32.const 0) (get_local 0x38d))
    (i64.store offset=0x38e align=1 (i32.const 0) (get_local 0x38e))
    (i64.store offset=0x38f align=1 (i32.const 0) (get_local 0x38f))
    (i64.store offset=0x390 align=1 (i32.const 0) (get_local 0x390))
    (i64.store offset=0x391 align=1 (i32.const 0) (get_local 0x391))
    (i64.store offset=0x392 align=1 (i32.const 0) (get_local 0x392))
    (i64.store offset=0x393 align=1 (i32.const 0) (get_local 0x393))
    (i64.store offset=0x394 align=1 (i32.const 0) (get_local 0x394))
    (i64.store offset=0x395 align=1 (i32.const 0) (get_local 0x395))
    (i64.store offset=0x396 align=1 (i32.const 0) (get_local 0x396))
    (i64.store offset=0x397 align=1 (i32.const 0) (get_local 0x397))
    (i64.store offset=0x398 align=1 (i32.const 0) (get_local 0x398))
    (i64.store offset=0x399 align=1 (i32.const 0) (get_local 0x399))
    (i64.store offset=0x39a align=1 (i32.const 0) (get_local 0x39a))
    (i64.store offset=0x39b align=1 (i32.const 0) (get_local 0x39b))
    (i64.store offset=0x39c align=1 (i32.const 0) (get_local 0x39c))
    (i64.store offset=0x39d align=1 (i32.const 0) (get_local 0x39d))
    (i64.store offset=0x39e align=1 (i32.const 0) (get_local 0x39e))
    (i64.store offset=0x39f align=1 (i32.const 0) (get_local 0x39f))
    (i64.store offset=0x3a0 align=1 (i32.const 0) (get_local 0x3a0))
    (i64.store offset=0x3a1 align=1 (i32.const 0) (get_local 0x3a1))
    (i64.store offset=0x3a2 align=1 (i32.const 0) (get_local 0x3a2))
    (i64.store offset=0x3a3 align=1 (i32.const 0) (get_local 0x3a3))
    (i64.store offset=0x3a4 align=1 (i32.const 0) (get_local 0x3a4))
    (i64.store offset=0x3a5 align=1 (i32.const 0) (get_local 0x3a5))
    (i64.store offset=0x3a6 align=1 (i32.const 0) (get_local 0x3a6))
    (i64.store offset=0x3a7 align=1 (i32.const 0) (get_local 0x3a7))
    (i64.store offset=0x3a8 align=1 (i32.const 0) (get_local 0x3a8))
    (i64.store offset=0x3a9 align=1 (i32.const 0) (get_local 0x3a9))
    (i64.store offset=0x3aa align=1 (i32.const 0) (get_local 0x3aa))
    (i64.store offset=0x3ab align=1 (i32.const 0) (get_local 0x3ab))
    (i64.store offset=0x3ac align=1 (i32.const 0) (get_local 0x3ac))
    (i64.store offset=0x3ad align=1 (i32.const 0) (get_local 0x3ad))
    (i64.store offset=0x3ae align=1 (i32.const 0) (get_local 0x3ae))
    (i64.store offset=0x3af align=1 (i32.const 0) (get_local 0x3af))
    (i64.store offset=0x3b0 align=1 (i32.const 0) (get_local 0x3b0))
    (i64.store offset=0x3b1 align=1 (i32.const 0) (get_local 0x3b1))
    (i64.store offset=0x3b2 align=1 (i32.const 0) (get_local 0x3b2))
    (i64.store offset=0x3b3 align=1 (i32.const 0) (get_local 0x3b3))
    (i64.store offset=0x3b4 align=1 (i32.const 0) (get_local 0x3b4))
    (i64.store offset=0x3b5 align=1 (i32.const 0) (get_local 0x3b5))
    (i64.store offset=0x3b6 align=1 (i32.const 0) (get_local 0x3b6))
    (i64.store offset=0x3b7 align=1 (i32.const 0) (get_local 0x3b7))
    (i64.store offset=0x3b8 align=1 (i32.const 0) (get_local 0x3b8))
    (i64.store offset=0x3b9 align=1 (i32.const 0) (get_local 0x3b9))
    (i64.store offset=0x3ba align=1 (i32.const 0) (get_local 0x3ba))
    (i64.store offset=0x3bb align=1 (i32.const 0) (get_local 0x3bb))
    (i64.store offset=0x3bc align=1 (i32.const 0) (get_local 0x3bc))
    (i64.store offset=0x3bd align=1 (i32.const 0) (get_local 0x3bd))
    (i64.store offset=0x3be align=1 (i32.const 0) (get_local 0x3be))
    (i64.store offset=0x3bf align=1 (i32.const 0) (get_local 0x3bf))
    (i64.store offset=0x3c0 align=1 (i32.const 0) (get_local 0x3c0))
    (i64.store offset=0x3c1 align=1 (i32.const 0) (get_local 0x3c1))
    (i64.store offset=0x3c2 align=1 (i32.const 0) (get_local 0x3c2))
    (i64.store offset=0x3c3 align=1 (i32.const 0) (get_local 0x3c3))
    (i64.store offset=0x3c4 align=1 (i32.const 0) (get_local 0x3c4))
    (i64.store offset=0x3c5 align=1 (i32.const 0) (get_local 0x3c5))
    (i64.store offset=0x3c6 align=1 (i32.const 0) (get_local 0x3c6))
    (i64.store offset=0x3c7 align=1 (i32.const 0) (get_local 0x3c7))
    (i64.store offset=0x3c8 align=1 (i32.const 0) (get_local 0x3c8))
    (i64.store offset=0x3c9 align=1 (i32.const 0) (get_local 0x3c9))
    (i64.store offset=0x3ca align=1 (i32.const 0) (get_local 0x3ca))
    (i64.store offset=0x3cb align=1 (i32.const 0) (get_local 0x3cb))
    (i64.store offset=0x3cc align=1 (i32.const 0) (get_local 0x3cc))
    (i64.store offset=0x3cd align=1 (i32.const 0) (get_local 0x3cd))
    (i64.store offset=0x3ce align=1 (i32.const 0) (get_local 0x3ce))
    (i64.store offset=0x3cf align=1 (i32.const 0) (get_local 0x3cf))
    (i64.store offset=0x3d0 align=1 (i32.const 0) (get_local 0x3d0))
    (i64.store offset=0x3d1 align=1 (i32.const 0) (get_local 0x3d1))
    (i64.store offset=0x3d2 align=1 (i32.const 0) (get_local 0x3d2))
    (i64.store offset=0x3d3 align=1 (i32.const 0) (get_local 0x3d3))
    (i64.store offset=0x3d4 align=1 (i32.const 0) (get_local 0x3d4))
    (i64.store offset=0x3d5 align=1 (i32.const 0) (get_local 0x3d5))
    (i64.store offset=0x3d6 align=1 (i32.const 0) (get_local 0x3d6))
    (i64.store offset=0x3d7 align=1 (i32.const 0) (get_local 0x3d7))
    (i64.store offset=0x3d8 align=1 (i32.const 0) (get_local 0x3d8))
    (i64.store offset=0x3d9 align=1 (i32.const 0) (get_local 0x3d9))
    (i64.store offset=0x3da align=1 (i32.const 0) (get_local 0x3da))
    (i64.store offset=0x3db align=1 (i32.const 0) (get_local 0x3db))
    (i64.store offset=0x3dc align=1 (i32.const 0) (get_local 0x3dc))
    (i64.store offset=0x3dd align=1 (i32.const 0) (get_local 0x3dd))
    (i64.store offset=0x3de align=1 (i32.const 0) (get_local 0x3de))
    (i64.store offset=0x3df align=1 (i32.const 0) (get_local 0x3df))
    (i64.store offset=0x3e0 align=1 (i32.const 0) (get_local 0x3e0))
    (i64.store offset=0x3e1 align=1 (i32.const 0) (get_local 0x3e1))
    (i64.store offset=0x3e2 align=1 (i32.const 0) (get_local 0x3e2))
    (i64.store offset=0x3e3 align=1 (i32.const 0) (get_local 0x3e3))
    (i64.store offset=0x3e4 align=1 (i32.const 0) (get_local 0x3e4))
    (i64.store offset=0x3e5 align=1 (i32.const 0) (get_local 0x3e5))
    (i64.store offset=0x3e6 align=1 (i32.const 0) (get_local 0x3e6))
    (i64.store offset=0x3e7 align=1 (i32.const 0) (get_local 0x3e7))
    (i64.store offset=0x3e8 align=1 (i32.const 0) (get_local 0x3e8))
    (i64.store offset=0x3e9 align=1 (i32.const 0) (get_local 0x3e9))
    (i64.store offset=0x3ea align=1 (i32.const 0) (get_local 0x3ea))
    (i64.store offset=0x3eb align=1 (i32.const 0) (get_local 0x3eb))
    (i64.store offset=0x3ec align=1 (i32.const 0) (get_local 0x3ec))
    (i64.store offset=0x3ed align=1 (i32.const 0) (get_local 0x3ed))
    (i64.store offset=0x3ee align=1 (i32.const 0) (get_local 0x3ee))
    (i64.store offset=0x3ef align=1 (i32.const 0) (get_local 0x3ef))
    (i64.store offset=0x3f0 align=1 (i32.const 0) (get_local 0x3f0))
    (i64.store offset=0x3f1 align=1 (i32.const 0) (get_local 0x3f1))
    (i64.store offset=0x3f2 align=1 (i32.const 0) (get_local 0x3f2))
    (i64.store offset=0x3f3 align=1 (i32.const 0) (get_local 0x3f3))
    (i64.store offset=0x3f4 align=1 (i32.const 0) (get_local 0x3f4))
    (i64.store offset=0x3f5 align=1 (i32.const 0) (get_local 0x3f5))
    (i64.store offset=0x3f6 align=1 (i32.const 0) (get_local 0x3f6))
    (i64.store offset=0x3f7 align=1 (i32.const 0) (get_local 0x3f7))
    (i64.store offset=0x3f8 align=1 (i32.const 0) (get_local 0x3f8))
    (i64.store offset=0x3f9 align=1 (i32.const 0) (get_local 0x3f9))
    (i64.store offset=0x3fa align=1 (i32.const 0) (get_local 0x3fa))
    (i64.store offset=0x3fb align=1 (i32.const 0) (get_local 0x3fb))
    (i64.store offset=0x3fc align=1 (i32.const 0) (get_local 0x3fc))
    (i64.store offset=0x3fd align=1 (i32.const 0) (get_local 0x3fd))
    (i64.store offset=0x3fe align=1 (i32.const 0) (get_local 0x3fe))
    (i64.store offset=0x3ff align=1 (i32.const 0) (get_local 0x3ff))
    (i64.store offset=0x400 align=1 (i32.const 0) (get_local 0x400))
    (i64.store offset=0x401 align=1 (i32.const 0) (get_local 0x401))
    (i64.store offset=0x402 align=1 (i32.const 0) (get_local 0x402))
    (i64.store offset=0x403 align=1 (i32.const 0) (get_local 0x403))
    (i64.store offset=0x404 align=1 (i32.const 0) (get_local 0x404))
    (i64.store offset=0x405 align=1 (i32.const 0) (get_local 0x405))
    (i64.store offset=0x406 align=1 (i32.const 0) (get_local 0x406))
    (i64.store offset=0x407 align=1 (i32.const 0) (get_local 0x407))
    (i64.store offset=0x408 align=1 (i32.const 0) (get_local 0x408))
    (i64.store offset=0x409 align=1 (i32.const 0) (get_local 0x409))
    (i64.store offset=0x40a align=1 (i32.const 0) (get_local 0x40a))
    (i64.store offset=0x40b align=1 (i32.const 0) (get_local 0x40b))
    (i64.store offset=0x40c align=1 (i32.const 0) (get_local 0x40c))
    (i64.store offset=0x40d align=1 (i32.const 0) (get_local 0x40d))
    (i64.store offset=0x40e align=1 (i32.const 0) (get_local 0x40e))
    (i64.store offset=0x40f align=1 (i32.const 0) (get_local 0x40f))
    (i64.store offset=0x410 align=1 (i32.const 0) (get_local 0x410))
    (i64.store offset=0x411 align=1 (i32.const 0) (get_local 0x411))
    (i64.store offset=0x412 align=1 (i32.const 0) (get_local 0x412))
    (i64.store offset=0x413 align=1 (i32.const 0) (get_local 0x413))
    (i64.store offset=0x414 align=1 (i32.const 0) (get_local 0x414))
    (i64.store offset=0x415 align=1 (i32.const 0) (get_local 0x415))
    (i64.store offset=0x416 align=1 (i32.const 0) (get_local 0x416))
    (i64.store offset=0x417 align=1 (i32.const 0) (get_local 0x417))
    (i64.store offset=0x418 align=1 (i32.const 0) (get_local 0x418))
    (i64.store offset=0x419 align=1 (i32.const 0) (get_local 0x419))
    (i64.store offset=0x41a align=1 (i32.const 0) (get_local 0x41a))
    (i64.store offset=0x41b align=1 (i32.const 0) (get_local 0x41b))
    (i64.store offset=0x41c align=1 (i32.const 0) (get_local 0x41c))
    (i64.store offset=0x41d align=1 (i32.const 0) (get_local 0x41d))
    (i64.store offset=0x41e align=1 (i32.const 0) (get_local 0x41e))
    (i64.store offset=0x41f align=1 (i32.const 0) (get_local 0x41f))
  )
)

(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 0)) "call stack exhausted")
(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 100)) "call stack exhausted")
(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 200)) "call stack exhausted")
(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 300)) "call stack exhausted")
(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 400)) "call stack exhausted")
(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 500)) "call stack exhausted")
(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 600)) "call stack exhausted")
(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 700)) "call stack exhausted")
(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 800)) "call stack exhausted")
(assert_exhaustion (invoke "test-guard-page-skip" (i32.const 900)) "call stack exhausted")