;;-------------------------------------------------------------------------------------------------------
;; Copyright (C) Microsoft Corporation and contributors. All rights reserved.
;; Licensed under the MIT license. See LICENSE.txt file in the project root for full license information.
;;-------------------------------------------------------------------------------------------------------

(module
    (import "dummy" "memory" (memory 1))

        (func (export "i32x4_replace0") (param i32 i32) (local m128)
            (set_local 2 (i32x4.splat (get_local 0)))
            (set_local 2 (i32x4.replace_lane lane=0 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i32x4_replace1") (param i32 i32) (local m128)
            (set_local 2 (i32x4.splat (get_local 0)))
            (set_local 2 (i32x4.replace_lane lane=1 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i32x4_replace2") (param i32 i32) (local m128)
            (set_local 2 (i32x4.splat (get_local 0)))
            (set_local 2 (i32x4.replace_lane lane=2 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i32x4_replace3") (param i32 i32) (local m128)
            (set_local 2 (i32x4.splat (get_local 0)))
            (set_local 2 (i32x4.replace_lane lane=3 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i16x8_replace0") (param i32 i32) (local m128)
            (set_local 2 (i16x8.splat (get_local 0)))
            (set_local 2 (i16x8.replace_lane lane=0 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i16x8_replace1") (param i32 i32) (local m128)
            (set_local 2 (i16x8.splat (get_local 0)))
            (set_local 2 (i16x8.replace_lane lane=1 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i16x8_replace2") (param i32 i32) (local m128)
            (set_local 2 (i16x8.splat (get_local 0)))
            (set_local 2 (i16x8.replace_lane lane=2 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i16x8_replace3") (param i32 i32) (local m128)
            (set_local 2 (i16x8.splat (get_local 0)))
            (set_local 2 (i16x8.replace_lane lane=3 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i16x8_replace4") (param i32 i32) (local m128)
            (set_local 2 (i16x8.splat (get_local 0)))
            (set_local 2 (i16x8.replace_lane lane=4 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i16x8_replace5") (param i32 i32) (local m128)
            (set_local 2 (i16x8.splat (get_local 0)))
            (set_local 2 (i16x8.replace_lane lane=5 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i16x8_replace6") (param i32 i32) (local m128)
            (set_local 2 (i16x8.splat (get_local 0)))
            (set_local 2 (i16x8.replace_lane lane=6 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i16x8_replace7") (param i32 i32) (local m128)
            (set_local 2 (i16x8.splat (get_local 0)))
            (set_local 2 (i16x8.replace_lane lane=7 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace0") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=0 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace1") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=1 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace2") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=2 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace3") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=3 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace4") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=4 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace5") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=5 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace6") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=6 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace7") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=7 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace8") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=8 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace9") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=9 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace10") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=10 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace11") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=11 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace12") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=12 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace13") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=13 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace14") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=14 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "i8x16_replace15") (param i32 i32) (local m128)
            (set_local 2 (i8x16.splat (get_local 0)))
            (set_local 2 (i8x16.replace_lane lane=15 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "f32x4_replace0") (param f32 f32) (local m128)
            (set_local 2 (f32x4.splat (get_local 0)))
            (set_local 2 (f32x4.replace_lane lane=0 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "f32x4_replace1") (param f32 f32) (local m128)
            (set_local 2 (f32x4.splat (get_local 0)))
            (set_local 2 (f32x4.replace_lane lane=1 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "f32x4_replace2") (param f32 f32) (local m128)
            (set_local 2 (f32x4.splat (get_local 0)))
            (set_local 2 (f32x4.replace_lane lane=2 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "f32x4_replace3") (param f32 f32) (local m128)
            (set_local 2 (f32x4.splat (get_local 0)))
            (set_local 2 (f32x4.replace_lane lane=3 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "f64x2_replace0") (param f64 f64) (local m128)
            (set_local 2 (f64x2.splat (get_local 0)))
            (set_local 2 (f64x2.replace_lane lane=0 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )

        (func (export "f64x2_replace1") (param f64 f64) (local m128)
            (set_local 2 (f64x2.splat (get_local 0)))
            (set_local 2 (f64x2.replace_lane lane=1 (get_local 2) (get_local 1)))
            (m128.store offset=0 align=4 (i32.const 0) (get_local 2))
        )
)
