//-------------------------------------------------------------------------------------------------------
// Copyright (C) Microsoft Corporation and contributors. All rights reserved.
// Licensed under the MIT license. See LICENSE.txt file in the project root for full license information.
//-------------------------------------------------------------------------------------------------------

#define o(form) OPBYTE_ ## form
#ifndef f
# define f(form) FORM_ ## form
#endif

//    opcode         layout  attribute      byte2 form        opbyte        dope                         leadin    legal form
MACRO(ADC          , Reg2  , None         , R010, f(BINOP)  , o(ADC)      , DOPEQ|DSETCC|DCOMMOP       , OLB_NONE, LEGAL_RM_RM_RMI)
MACRO(ADD          , Reg2  , None         , R000, f(BINOP)  , o(ADD)      , DOPEQ|DSETCC|DCOMMOP       , OLB_NONE, LEGAL_RM_RM_RMI)
MACRO(ADDPD        , Reg2  , None         , RNON, f(MODRM)  , o(ADDPD)    , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(ADDPS        , Reg2  , None         , RNON, f(MODRM)  , o(ADDPS)    , DNO16|DOPEQ|DZEROF|DCOMMOP , OLB_NONE, LEGAL_R_R_RM   )
MACRO(ADDSD        , Reg2  , None         , RNON, f(MODRM)  , o(ADDSD)    , DNO16|DOPEQ|DCOMMOP|DF2    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(ADDSS        , Reg2  , None         , RNON, f(MODRM)  , o(ADDSS)    , DNO16|DOPEQ|DF3|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(AND          , Reg2  , None         , R100, f(BINOP)  , o(AND)      , DOPEQ|DSETCC|DCOMMOP       , OLB_NONE, LEGAL_RM_RM_RMI)
MACRO(ANDNPD       , Reg2  , None         , RNON, f(MODRM)  , o(ANDNPD)   , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(ANDNPS       , Reg2  , None         , RNON, f(MODRM)  , o(ANDNPS)   , DNO16|DOPEQ|DZEROF         , OLB_NONE, LEGAL_R_R_RM   )
MACRO(ANDPD        , Reg2  , None         , RNON, f(MODRM)  , o(ANDPD)    , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(ANDPS        , Reg2  , None         , RNON, f(MODRM)  , o(ANDPS)    , DNO16|DOPEQ|DZEROF|DCOMMOP , OLB_NONE, LEGAL_R_R_RM   )
MACRO(BSF          , Reg2  , None         , RNON, f(MODRM)  , o(BSF)      , DZEROF|DDST|DSETCC         , OLB_NONE, LEGAL_R_RM     )
MACRO(BSR          , Reg2  , None         , RNON, f(MODRM)  , o(BSR)      , DZEROF|DDST|DSETCC         , OLB_NONE, LEGAL_R_RM     )
MACRO(BT           , Reg2  , OpSideEffect , R100, f(SPMOD)  , o(BT)       , DZEROF|DSETCC              , OLB_NONE, LEGAL_N_RM_RI  )
MACRO(BTR          , Reg2  , OpSideEffect , R110, f(SPMOD)  , o(BTR)      , DOPEQ|DZEROF|DSETCC        , OLB_NONE, LEGAL_RM_RM_RI )
MACRO(CALL         , CallI , OpSideEffect , R010, f(CALL)   , o(CALL)     , DSETCC                     , OLB_NONE, LEGAL_CALL     )
MACRO(CDQ          , Empty , OpSideEffect , RNON, f(NO)     , o(CDQ)      , DNO16                      , OLB_NONE, LEGAL_R        )
MACRO(CMOVA        , Reg2  , None         , RNON, f(MODRM)  , o(CMOVA)    , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVAE       , Reg2  , None         , RNON, f(MODRM)  , o(CMOVAE)   , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVB        , Reg2  , None         , RNON, f(MODRM)  , o(CMOVB)    , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVBE       , Reg2  , None         , RNON, f(MODRM)  , o(CMOVBE)   , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVE        , Reg2  , None         , RNON, f(MODRM)  , o(CMOVE)    , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVG        , Reg2  , None         , RNON, f(MODRM)  , o(CMOVG)    , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVGE       , Reg2  , None         , RNON, f(MODRM)  , o(CMOVGE)   , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVL        , Reg2  , None         , RNON, f(MODRM)  , o(CMOVL)    , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVLE       , Reg2  , None         , RNON, f(MODRM)  , o(CMOVLE)   , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVNE       , Reg2  , None         , RNON, f(MODRM)  , o(CMOVNE)   , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVNO       , Reg2  , None         , RNON, f(MODRM)  , o(CMOVNO)   , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVNP       , Reg2  , None         , RNON, f(MODRM)  , o(CMOVNP)   , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVNS       , Reg2  , None         , RNON, f(MODRM)  , o(CMOVNS)   , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVO        , Reg2  , None         , RNON, f(MODRM)  , o(CMOVO)    , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVP        , Reg2  , None         , RNON, f(MODRM)  , o(CMOVP)    , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMOVS        , Reg2  , None         , RNON, f(MODRM)  , o(CMOVS)    , DZEROF|DDST|DUSECC         , OLB_NONE, LEGAL_CUSTOM   )
MACRO(CMP          , Empty , OpSideEffect , R111, f(BINOP)  , o(CMP)      , DSETCC                     , OLB_NONE, LEGAL_N_RM_RMI )
MACRO(CMPEQPD      , Empty , None         , RNON, f(MODRM)  , o(CMPPD)    , D66|DSSE|DOPEQ             , OLB_NONE, LEGAL_R_R_RM   )
MACRO(CMPEQPS      , Empty , None         , RNON, f(MODRM)  , o(CMPPS)    , DZEROF|DSSE|DOPEQ          , OLB_NONE, LEGAL_R_R_RM   )
MACRO(CMPLEPD      , Empty , None         , RNON, f(MODRM)  , o(CMPPD)    , D66|DSSE|DOPEQ             , OLB_NONE, LEGAL_R_R_RM   )
MACRO(CMPLEPS      , Empty , None         , RNON, f(MODRM)  , o(CMPPS)    , DZEROF|DSSE|DOPEQ          , OLB_NONE, LEGAL_R_R_RM   )
MACRO(CMPLTPD      , Empty , None         , RNON, f(MODRM)  , o(CMPPD)    , D66|DSSE|DOPEQ             , OLB_NONE, LEGAL_R_R_RM   )
MACRO(CMPLTPS      , Empty , None         , RNON, f(MODRM)  , o(CMPPS)    , DZEROF|DSSE|DOPEQ          , OLB_NONE, LEGAL_R_R_RM   )
MACRO(CMPNEQPD     , Empty , None         , RNON, f(MODRM)  , o(CMPPD)    , D66|DSSE|DOPEQ             , OLB_NONE, LEGAL_R_R_RM   )
MACRO(CMPNEQPS     , Empty , None         , RNON, f(MODRM)  , o(CMPPS)    , DZEROF|DSSE|DOPEQ          , OLB_NONE, LEGAL_R_R_RM   )
MACRO(CMPUNORDPS   , Empty , None         , RNON, f(MODRM)  , o(CMPPS)    , DZEROF|DSSE|DOPEQ          , OLB_NONE, LEGAL_R_R_RM   )
MACRO(CMPXCHG8B    , Reg1  , OpSideEffect , R001, f(MODRM)  , o(CMPXCHG8B), DNO16|DZEROF|DSETCC        , OLB_NONE, LEGAL_CUSTOM   )
MACRO(COMISD       , Empty , OpSideEffect , RNON, f(MODRM)  , o(COMISD)   , DNO16|D66|DSETCC           , OLB_NONE, LEGAL_N_R_RM   )
MACRO(COMISS       , Empty , OpSideEffect , RNON, f(MODRM)  , o(COMISS)   , DNO16|DZEROF|DSETCC        , OLB_NONE, LEGAL_N_R_RM   )
MACRO(CVTDQ2PD     , Reg2  , None         , RNON, f(MODRM)  , o(CVTDQ2PD) , DDST|DNO16|DF3             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTDQ2PS     , Reg2  , None         , RNON, f(MODRM)  , o(CVTDQ2PS) , DDST|DNO16|DZEROF          , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTPD2PS     , Reg2  , None         , RNON, f(MODRM)  , o(CVTPD2PS) , DDST|DNO16|D66             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTPS2PD     , Reg2  , None         , RNON, f(MODRM)  , o(CVTPS2PD) , DDST|DNO16|DZEROF          , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTSD2SI     , Reg2  , None         , RNON, f(MODRM)  , o(CVTSD2SI) , DDST|DNO16|DF2             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTSD2SS     , Reg2  , None         , RNON, f(MODRM)  , o(CVTSD2SS) , DDST|DNO16|DF2             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTSI2SD     , Reg2  , None         , RNON, f(MODRM)  , o(CVTSI2SD) , DDST|DNO16|DF2             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTSI2SS     , Reg2  , None         , RNON, f(MODRM)  , o(CVTSI2SS) , DDST|DNO16|DF3             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTSS2SD     , Reg2  , None         , RNON, f(MODRM)  , o(CVTSD2SS) , DDST|DNO16|DF3             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTSS2SI     , Reg2  , None         , RNON, f(MODRM)  , o(CVTSS2SI) , DDST|DNO16|DF3             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTTPD2DQ    , Reg2  , None         , RNON, f(MODRM)  , o(CVTTPD2DQ), DDST|DNO16|D66             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTTPS2DQ    , Reg2  , None         , RNON, f(MODRM)  , o(CVTTPS2DQ), DDST|DNO16|DF3             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTTSD2SI    , Reg2  , None         , RNON, f(MODRM)  , o(CVTTSD2SI), DDST|DNO16|DF2             , OLB_NONE, LEGAL_R_RM     )
MACRO(CVTTSS2SI    , Reg2  , None         , RNON, f(MODRM)  , o(CVTTSS2SI), DDST|DNO16|DF3             , OLB_NONE, LEGAL_R_RM     )
MACRO(DEC          , Reg2  , None         , R001, f(INCDEC) , o(DEC)      , DOPEQ|DSETCC               , OLB_NONE, LEGAL_RM_RM    )
MACRO(DIV          , Reg3  , None         , R110, f(MULDIV) , o(DIV)      , DSETCC                     , OLB_NONE, LEGAL_R_R_RM   )
MACRO(DIVPD        , Reg3  , None         , RNON, f(MODRM)  , o(DIVPD)    , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(DIVPS        , Reg3  , None         , RNON, f(MODRM)  , o(DIVPS)    , DNO16|DOPEQ|DZEROF         , OLB_NONE, LEGAL_R_R_RM   )
MACRO(DIVSD        , Reg3  , None         , RNON, f(MODRM)  , o(DIVSD)    , DNO16|DOPEQ|DF2            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(DIVSS        , Reg3  , None         , RNON, f(MODRM)  , o(DIVSS)    , DNO16|DOPEQ|DF3            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(FISTTP       , Reg2  , None         , R001, f(FILD)   , o(FISTTP)   , DFLT|NDPdec|DDST           , OLB_NONE, LEGAL_M        )
MACRO(FLD          , Reg2  , None         , R000, f(FLD)    , o(FLD)      , DFLT|NDPinc|DDST|DOPEQ     , OLB_NONE, LEGAL_M_M      )
MACRO(FSTP         , Reg1  , None         , R011, f(FLD)    , o(FSTP)     , DDST|DFLT                  , OLB_NONE, LEGAL_M        )
MACRO(IDIV         , Reg3  , None         , R111, f(MULDIV) , o(IDIV)     , DSETCC                     , OLB_NONE, LEGAL_R_R_RM   )
MACRO(IMUL         , Reg3  , None         , R101, f(MULDIV) , o(IMUL)     , DSETCC                     , OLB_NONE, LEGAL_R_R_RM   )
MACRO(IMUL2        , Reg3  , None         , RNON, f(SPMOD)  , o(IMUL2)    , DOPEQ|DSETCC|DZEROF|DCOMMOP, OLB_NONE, LEGAL_R_R_RMI  )
MACRO(INC          , Reg2  , None         , R000, f(INCDEC) , o(INC)      , DOPEQ|DSETCC               , OLB_NONE, LEGAL_RM_RM    )
MACRO(INT          , Reg1  , OpSideEffect , RNON, f(SPECIAL), o(INT)      , DUSECC|DSETCC              , OLB_NONE, LEGAL_N_I      )
MACRO(JA           , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JAE          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JB           , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JBE          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JEQ          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JGE          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JGT          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JLE          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JLT          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JMP          , Br    , OpSideEffect , R100, f(JMP)    , o(JMP)      , DNO16                      , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JNE          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JNO          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JNP          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JNSB         , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JO           , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JP           , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(JSB          , BrReg2, OpSideEffect , RNON, f(SPECIAL), o(JCC)      , DUSECC|DNO16               , OLB_NONE, LEGAL_CUSTOM   )
MACRO(LAHF         , Reg1  , None         , RNON, f(NO)     , o(LAHF)     , DUSECC                     , OLB_NONE, LEGAL_R        )
MACRO(LEA          , Reg2  , None         , RNON, f(MODRM)  , o(LEA)      , DDST                       , OLB_NONE, LEGAL_R_M      )
MACRO(LOCKCMPXCHG8B, Reg1  , OpSideEffect , R001, f(MODRM)  , o(CMPXCHG8B), DNO16|DZEROF|DSETCC|DLOCK  , OLB_NONE, LEGAL_CUSTOM   )
MACRO(LZCNT        , Reg2  , None         , RNON, f(MODRM)  , o(LZCNT)    , DF3|DSETCC|DDST            , OLB_NONE, LEGAL_R_RM     )
MACRO(MAXPD        , Reg2  , None         , RNON, f(MODRM)  , o(MAXPD)    , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(MAXPS        , Reg2  , None         , RNON, f(MODRM)  , o(MAXPS)    , DNO16|DOPEQ|DZEROF         , OLB_NONE, LEGAL_R_R_RM   )
MACRO(MINPD        , Reg2  , None         , RNON, f(MODRM)  , o(MINPD)    , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(MINPS        , Reg2  , None         , RNON, f(MODRM)  , o(MINPS)    , DNO16|DOPEQ|DZEROF         , OLB_NONE, LEGAL_R_R_RM   )
MACRO(MOV          , Reg2  , None         , R000, f(MOV)    , o(MOV)      , DDST                       , OLB_NONE, LEGAL_CUSTOM   )
MACRO(MOVAPS       , Reg2  , None         , RNON, f(SPECIAL), o(MOVAPS)   , DDST|DNO16|DZEROF          , OLB_NONE, LEGAL_RM_RM    )
MACRO(MOVD         , Reg2  , None         , RNON, f(SPECIAL), o(MOVD)     , DDST|DNO16|D66             , OLB_NONE, LEGAL_RM_RM    )
MACRO(MOVHLPS      , Reg2  , None         , RNON, f(SPECIAL), o(MOVHLPS)  , DDST|DNO16|DZEROF          , OLB_NONE, LEGAL_R_R      )
MACRO(MOVHPD       , Reg2  , None         , RNON, f(SPECIAL), o(MOVHPD)   , DDST|DNO16|D66             , OLB_NONE, LEGAL_RM_RM    )
MACRO(MOVLHPS      , Reg2  , None         , RNON, f(SPECIAL), o(MOVLHPS)  , DDST|DNO16|DZEROF          , OLB_NONE, LEGAL_R_R      )
MACRO(MOVLPD       , Reg2  , None         , RNON, f(SPECIAL), o(MOVLPD)   , DDST|DNO16|D66             , OLB_NONE, LEGAL_RM_RM    )
MACRO(MOVMSKPD     , Reg2  , None         , RNON, f(SPECIAL), o(MOVMSKPD) , DDST|DNO16|D66             , OLB_NONE, LEGAL_R_R      )
MACRO(MOVMSKPS     , Reg2  , None         , RNON, f(SPECIAL), o(MOVMSKPS) , DDST|DNO16|DZEROF          , OLB_NONE, LEGAL_R_R      )
MACRO(MOVSD_ZERO   , Reg2  , None         , RNON, f(MODRM)  , o(MOVSD)    , 0                          , OLB_NONE, LEGAL_RM       )
MACRO(MOVSD        , Reg2  , None         , RNON, f(MODRM)  , o(MOVSD)    , DDST|DNO16|DF2             , OLB_NONE, LEGAL_RM_RM    )
MACRO(MOVSS        , Reg2  , None         , RNON, f(SPECIAL), o(MOVSS)    , DDST|DNO16|DF3             , OLB_NONE, LEGAL_RM_RM    )
MACRO(MOVSX        , Reg2  , None         , RNON, f(MODRM)  , o(MOVSX)    , DZEROF|DDST                , OLB_NONE, LEGAL_R_RM     )
MACRO(MOVSXW       , Reg2  , None         , RNON, f(MODRM)  , o(MOVSXW)   , DZEROF|DDST                , OLB_NONE, LEGAL_RM_RM    )
MACRO(MOVUPS       , Reg2  , None         , RNON, f(SPECIAL), o(MOVUPS)   , DDST|DNO16|DZEROF          , OLB_NONE, LEGAL_RM_RM    )
MACRO(MOVZX        , Reg2  , None         , RNON, f(MODRM)  , o(MOVZX)    , DZEROF|DDST                , OLB_NONE, LEGAL_R_RM     )
MACRO(MOVZXW       , Reg2  , None         , RNON, f(MODRM)  , o(MOVZXW)   , DZEROF|DDST                , OLB_NONE, LEGAL_R_RM     )
MACRO(MULPD        , Reg3  , None         , RNON, f(MODRM)  , o(MULPD)    , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(MULPS        , Reg3  , None         , RNON, f(MODRM)  , o(MULPS)    , DNO16|DOPEQ|DZEROF|DCOMMOP , OLB_NONE, LEGAL_R_R_RM   )
MACRO(MULSD        , Reg3  , None         , RNON, f(MODRM)  , o(MULSD)    , DNO16|DOPEQ|DF2            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(MULSS        , Reg3  , None         , RNON, f(MODRM)  , o(MULSS)    , DNO16|DOPEQ|DF3|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(NEG          , Reg2  , None         , R011, f(MODRMW) , o(NEG)      , DOPEQ|DSETCC               , OLB_NONE, LEGAL_RM_RM    )
MACRO(NOP          , Empty , None         , RNON, f(SPECIAL), o(NOP)      , DNO16                      , OLB_NONE, LEGAL_CUSTOM   )
MACRO(NOT          , Reg2  , None         , R010, f(MODRMW) , o(NOT)      , DOPEQ                      , OLB_NONE, LEGAL_RM_RM    )
MACRO(OR           , Reg2  , None         , R001, f(BINOP)  , o(OR)       , DOPEQ|DSETCC|DCOMMOP       , OLB_NONE, LEGAL_RM_RM_RMI)
MACRO(ORPS         , Reg2  , None         , R001, f(MODRM)  , o(ORPS)     , DOPEQ|DOPEQ|DZEROF|DCOMMOP , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PADDB        , Reg2  , None         , RNON, f(MODRM)  , o(PADDB)    , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PADDD        , Reg2  , None         , RNON, f(MODRM)  , o(PADDD)    , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PADDQ        , Reg2  , None         , RNON, f(MODRM)  , o(PADDQ)    , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PADDSB       , Reg2  , None         , RNON, f(MODRM)  , o(PADDSB)   , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PADDSW       , Reg2  , None         , RNON, f(MODRM)  , o(PADDSW)   , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PADDUSB      , Reg2  , None         , RNON, f(MODRM)  , o(PADDUSB)  , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PADDUSW      , Reg2  , None         , RNON, f(MODRM)  , o(PADDUSW)  , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PADDW        , Reg2  , None         , RNON, f(MODRM)  , o(PADDW)    , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PAND         , Reg2  , None         , RNON, f(MODRM)  , o(PAND)     , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PANDN        , Reg2  , None         , RNON, f(MODRM)  , o(PANDN)    , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PCMPEQB      , Reg2  , None         , RNON, f(MODRM)  , o(PCMPEQB)  , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PCMPEQD      , Reg2  , None         , RNON, f(MODRM)  , o(PCMPEQD)  , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PCMPEQW      , Reg2  , None         , RNON, f(MODRM)  , o(PCMPEQW)  , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PCMPGTB      , Reg2  , None         , RNON, f(MODRM)  , o(PCMPGTB)  , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PCMPGTD      , Reg2  , None         , RNON, f(MODRM)  , o(PCMPGTD)  , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PCMPGTW      , Reg2  , None         , RNON, f(MODRM)  , o(PCMPGTW)  , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PEXTRD       , Reg3  , None         , RNON, f(SPECIAL), o(PEXTRD)   , DDST|DNO16|DSSE|D66        , OLB_0F3A, LEGAL_RM_R_I   )
MACRO(PEXTRW       , Reg3  , None         , RNON, f(MODRM)  , o(PEXTRW)   , DDST|DNO16|D66|DSSE        , OLB_NONE, LEGAL_RM_R_I   )
MACRO(PINSRD       , Reg3  , None         , RNON, f(MODRM)  , o(PINSRD)   , DDST|DNO16|D66|DSSE        , OLB_0F3A, LEGAL_R_RM_I   )
MACRO(PINSRW       , Reg3  , None         , RNON, f(MODRM)  , o(PINSRW)   , DDST|DNO16|D66|DSSE        , OLB_NONE, LEGAL_R_RM_I   )
MACRO(PMAXSW       , Reg2  , None         , RNON, f(MODRM)  , o(PMAXSW)   , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PMAXUB       , Reg2  , None         , RNON, f(MODRM)  , o(PMAXUB)   , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PMINSW       , Reg2  , None         , RNON, f(MODRM)  , o(PMINSW)   , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PMINUB       , Reg2  , None         , RNON, f(MODRM)  , o(PMINUB)   , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PMOVMSKB     , Reg2  , None         , RNON, f(SPECIAL), o(PMOVMSKB) , DDST|DNO16|D66             , OLB_NONE, LEGAL_R_R      )
MACRO(PMULLW       , Reg2  , None         , RNON, f(MODRM)  , o(PMULLW)   , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PMULUDQ      , Reg2  , None         , RNON, f(MODRM)  , o(PMULUDQ)  , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(POP          , Reg1  , OpSideEffect , R000, f(PSHPOP) , o(POP)      , DDST                       , OLB_NONE, LEGAL_R_OR     )
MACRO(POPCNT       , Reg2  , None         , RNON, f(MODRM)  , o(POPCNT)   , DF3|DDST|DSETCC            , OLB_NONE, LEGAL_R_RM     )
MACRO(POR          , Reg2  , None         , RNON, f(MODRM)  , o(POR)      , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PSHUFD       , Reg3  , None         , RNON, f(MODRM)  , o(PSHUFD)   , DDST|DNO16|D66|DSSE        , OLB_NONE, LEGAL_R_RM_I   )
MACRO(PSLLD        , Reg2  , None         , R110, f(SPECIAL), o(PSLLD)    , DNO16|DOPEQ|D66|DSSE       , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSLLDQ       , Reg2  , None         , R111, f(SPECIAL), o(PSLLDQ)   , DDST|DNO16|DOPEQ|D66|DSSE  , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSLLQ        , Reg2  , None         , RNON, f(MODRM)  , o(PSLLQ)    , DNO16|DOPEQ|D66|DSSE       , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSLLW        , Reg2  , None         , R110, f(SPECIAL), o(PSLLW)    , DNO16|DOPEQ|D66|DSSE       , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSRAD        , Reg2  , None         , R100, f(SPECIAL), o(PSRAD)    , DNO16|DOPEQ|D66|DSSE       , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSRAW        , Reg2  , None         , R100, f(SPECIAL), o(PSRAW)    , DNO16|DOPEQ|D66|DSSE       , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSRLD        , Reg2  , None         , R010, f(SPECIAL), o(PSRLD)    , DNO16|DOPEQ|D66|DSSE       , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSRLDQ       , Reg2  , None         , R011, f(SPECIAL), o(PSRLDQ)   , DDST|DNO16|DOPEQ|D66|DSSE  , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSRLQ        , Reg2  , None         , RNON, f(MODRM)  , o(PSRLQ)    , DNO16|DOPEQ|D66|DSSE       , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSRLW        , Reg2  , None         , R010, f(SPECIAL), o(PSRLW)    , DNO16|DOPEQ|D66|DSSE       , OLB_NONE, LEGAL_R_R_RI   )
MACRO(PSUBB        , Reg2  , None         , RNON, f(MODRM)  , o(PSUBB)    , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PSUBD        , Reg2  , None         , RNON, f(MODRM)  , o(PSUBD)    , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PSUBQ        , Reg2  , None         , RNON, f(MODRM)  , o(PSUBQ)    , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PSUBSB       , Reg2  , None         , RNON, f(MODRM)  , o(PSUBSB)   , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PSUBSW       , Reg2  , None         , RNON, f(MODRM)  , o(PSUBSW)   , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PSUBUSB      , Reg2  , None         , RNON, f(MODRM)  , o(PSUBUSB)  , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PSUBUSW      , Reg2  , None         , RNON, f(MODRM)  , o(PSUBUSW)  , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PSUBW        , Reg2  , None         , RNON, f(MODRM)  , o(PSUBW)    , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PUNPCKLBW    , Reg2  , None         , RNON, f(MODRM)  , o(PUNPCKLBW), DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PUNPCKLDQ    , Reg2  , None         , RNON, f(MODRM)  , o(PUNPCKLDQ), DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PUNPCKLWD    , Reg2  , None         , RNON, f(MODRM)  , o(PUNPCKLWD), DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(PUSH         , Reg1  , OpSideEffect , R110, f(PSHPOP) , o(PUSH)     , 0                          , OLB_NONE, LEGAL_N_RMI    )
MACRO(PXOR         , Reg2  , None         , RNON, f(MODRM)  , o(PXOR)     , DNO16|DOPEQ|D66|DCOMMOP    , OLB_NONE, LEGAL_R_R_RM   )
MACRO(RET          , Empty , OpSideEffect , RNON, f(SPECIAL), o(RET)      , DSETCC                     , OLB_NONE, LEGAL_N_I_OR   )
MACRO(ROL          , Reg2  , None         , R000, f(SHIFT)  , o(ROL)      , DOPEQ|DSETCC               , OLB_NONE, LEGAL_RM_RM_RI )
MACRO(ROR          , Reg2  , None         , R001, f(SHIFT)  , o(ROR)      , DOPEQ|DSETCC               , OLB_NONE, LEGAL_RM_RM_RI )
MACRO(ROUNDSD      , Reg3  , None         , RNON, f(MODRM)  , o(ROUNDSD)  , DDST|DNO16|DSSE|D66        , OLB_0F3A, LEGAL_R_RM_I   )
MACRO(ROUNDSS      , Reg3  , None         , RNON, f(MODRM)  , o(ROUNDSS)  , DDST|DNO16|DSSE|D66        , OLB_0F3A, LEGAL_R_RM_I   )
MACRO(SAR          , Reg2  , None         , R111, f(SHIFT)  , o(SAR)      , DOPEQ|DSETCC               , OLB_NONE, LEGAL_RM_RM_RI )
MACRO(SBB          , Reg2  , None         , R011, f(BINOP)  , o(SBB)      , DOPEQ|DUSECC|DSETCC        , OLB_NONE, LEGAL_RM_RM_RMI)
MACRO(SETA         , Reg1  , None         , RNON, f(MODRM)  , o(SETA)     , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETAE        , Reg1  , None         , RNON, f(MODRM)  , o(SETAE)    , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETB         , Reg1  , None         , RNON, f(MODRM)  , o(SETB)     , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETBE        , Reg1  , None         , RNON, f(MODRM)  , o(SETBE)    , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETE         , Reg1  , None         , RNON, f(MODRM)  , o(SETE)     , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETG         , Reg1  , None         , RNON, f(MODRM)  , o(SETG)     , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETGE        , Reg1  , None         , RNON, f(MODRM)  , o(SETGE)    , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETL         , Reg1  , None         , RNON, f(MODRM)  , o(SETL)     , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETLE        , Reg1  , None         , RNON, f(MODRM)  , o(SETLE)    , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETNE        , Reg1  , None         , RNON, f(MODRM)  , o(SETNE)    , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SETO         , Reg1  , None         , RNON, f(MODRM)  , o(SETO)     , DOPEQ|DUSECC|DZEROF|DDST   , OLB_NONE, LEGAL_RM_RM    )
MACRO(SHL          , Reg2  , None         , R100, f(SHIFT)  , o(SHL)      , DOPEQ|DSETCC               , OLB_NONE, LEGAL_RM_RM_RI )
MACRO(SHR          , Reg2  , None         , R101, f(SHIFT)  , o(SHR)      , DOPEQ|DSETCC               , OLB_NONE, LEGAL_RM_RM_RI )
MACRO(SHUFPD       , Reg2  , None         , RNON, f(MODRM)  , o(SHUFPD)   , DDST|DNO16|D66|DSSE        , OLB_NONE, LEGAL_R_RM_I   )
MACRO(SHUFPS       , Reg2  , None         , RNON, f(MODRM)  , o(SHUFPS)   , DDST|DNO16|DZEROF|DSSE     , OLB_NONE, LEGAL_R_RM_I   )
MACRO(SQRTPD       , Reg2  , None         , RNON, f(MODRM)  , o(SQRTPD)   , DDST|DNO16|D66             , OLB_NONE, LEGAL_R_RM     )
MACRO(SQRTPS       , Reg2  , None         , RNON, f(MODRM)  , o(SQRTPS)   , DDST|DNO16|DZEROF          , OLB_NONE, LEGAL_R_RM     )
MACRO(SQRTSD       , Reg2  , None         , RNON, f(MODRM)  , o(SQRTSD)   , DDST|DNO16|DF2             , OLB_NONE, LEGAL_R_RM     )
MACRO(SQRTSS       , Reg2  , None         , RNON, f(MODRM)  , o(SQRTSS)   , DDST|DNO16|DF3             , OLB_NONE, LEGAL_R_RM     )
MACRO(SUB          , Reg2  , None         , R101, f(BINOP)  , o(SUB)      , DOPEQ|DSETCC               , OLB_NONE, LEGAL_RM_RM_RMI)
MACRO(SUBPD        , Reg3  , None         , RNON, f(MODRM)  , o(SUBPD)    , DNO16|DOPEQ|D66            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(SUBPS        , Reg3  , None         , RNON, f(MODRM)  , o(SUBPS)    , DNO16|DOPEQ|DZEROF         , OLB_NONE, LEGAL_R_R_RM   )
MACRO(SUBSD        , Reg3  , None         , RNON, f(MODRM)  , o(SUBSD)    , DNO16|DOPEQ|DF2            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(SUBSS        , Reg3  , None         , RNON, f(MODRM)  , o(SUBSS)    , DNO16|DOPEQ|DF3            , OLB_NONE, LEGAL_R_R_RM   )
MACRO(TEST_AH      , Empty , None         , R000, f(TEST_AH), o(TEST_AH)  , DSETCC|DCOMMOP             , OLB_NONE, LEGAL_N_RM_RI  )
MACRO(TEST         , Empty , None         , R000, f(TEST)   , o(TEST)     , DSETCC|DCOMMOP             , OLB_NONE, LEGAL_N_RM_RI  )
MACRO(TZCNT        , Reg2  , None         , RNON, f(MODRM)  , o(TZCNT)    , DF3|DSETCC|DDST            , OLB_NONE, LEGAL_R_RM     )
MACRO(UCOMISD      , Empty , None         , RNON, f(MODRM)  , o(UCOMISD)  , DNO16|D66|DSETCC           , OLB_NONE, LEGAL_N_R_RM   )
MACRO(UCOMISS      , Empty , None         , RNON, f(MODRM)  , o(UCOMISS)  , DNO16|DZEROF|DSETCC        , OLB_NONE, LEGAL_N_R_RM   )
MACRO(XCHG         , Reg2  , None         , RNON, f(XCHG)   , o(XCHG)     , DOPEQ                      , OLB_NONE, LEGAL_RM_RM_RM )
MACRO(XOR          , Reg2  , None         , R110, f(BINOP)  , o(XOR)      , DOPEQ|DSETCC|DCOMMOP       , OLB_NONE, LEGAL_RM_RM_RMI)
MACRO(XORPS        , Reg3  , None         , RNON, f(MODRM)  , o(XORPS)    , DNO16|DOPEQ|DZEROF|DCOMMOP , OLB_NONE, LEGAL_R_R_RM   )

#undef o
#undef f
