//-------------------------------------------------------------------------------------------------------
// Copyright (C) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.txt file in the project root for full license information.
//-------------------------------------------------------------------------------------------------------

// See: https://github.com/Microsoft/ChakraCore/pull/4016
// Test interpretation of military time zone
runTest("2011-11-08 19:48:43a", "2011-11-08T19:48:43.000+01:00");
runTest("2011-11-08 19:48:43 a", "2011-11-08T19:48:43.000+01:00");
runTest("2011-11-08 19:48:43 b", "2011-11-08T19:48:43.000+02:00");
runTest("2011-11-08 19:48:43 c", "2011-11-08T19:48:43.000+03:00");
runTest("2011-11-08 19:48:43 d", "2011-11-08T19:48:43.000+04:00");
runTest("2011-11-08 19:48:43 e", "2011-11-08T19:48:43.000+05:00");
runTest("2011-11-08 19:48:43 f", "2011-11-08T19:48:43.000+06:00");
runTest("2011-11-08 19:48:43 g", "2011-11-08T19:48:43.000+07:00");
runTest("2011-11-08 19:48:43 h", "2011-11-08T19:48:43.000+08:00");
runTest("2011-11-08 19:48:43 i", "2011-11-08T19:48:43.000+09:00");
runTest("2011-11-08 19:48:43 j", null);
runTest("2011-11-08 19:48:43 k", "2011-11-08T19:48:43.000+10:00");
runTest("2011-11-08 19:48:43 l", "2011-11-08T19:48:43.000+11:00");
runTest("2011-11-08 19:48:43 m", "2011-11-08T19:48:43.000+12:00");
runTest("2011-11-08 19:48:43 n", "2011-11-08T19:48:43.000-01:00");
runTest("2011-11-08 19:48:43 o", "2011-11-08T19:48:43.000-02:00");
runTest("2011-11-08 19:48:43 p", "2011-11-08T19:48:43.000-03:00");
runTest("2011-11-08 19:48:43 q", "2011-11-08T19:48:43.000-04:00");
runTest("2011-11-08 19:48:43 r", "2011-11-08T19:48:43.000-05:00");
runTest("2011-11-08 19:48:43 s", "2011-11-08T19:48:43.000-06:00");
runTest("2011-11-08 19:48:43 t", "2011-11-08T19:48:43.000-07:00");
runTest("2011-11-08 19:48:43 u", "2011-11-08T19:48:43.000-08:00");
runTest("2011-11-08 19:48:43 v", "2011-11-08T19:48:43.000-09:00");
runTest("2011-11-08 19:48:43 w", "2011-11-08T19:48:43.000-10:00");
runTest("2011-11-08 19:48:43 x", "2011-11-08T19:48:43.000-11:00");
runTest("2011-11-08 19:48:43 y", "2011-11-08T19:48:43.000-12:00");
runTest("2011-11-08 19:48:43 z", "2011-11-08T19:48:43.000Z");

function runTest(dateToTest, isoDate) {
    if (isoDate === null) {
        if (isNaN(Date.parse(dateToTest))) {
            console.log("PASS");
        } else {
            console.log("Wrong date parsing result: Date.parse(\"" + dateToTest + "\") should return NaN");
        }
    } else {
        if (Date.parse(dateToTest) === Date.parse(isoDate)) {
            console.log("PASS");
        } else {
            console.log("Wrong date parsing result: Date.parse(\"" + dateToTest + "\") should equal Date.parse(\"" + isoDate + "\")");
        }
    }
}
