(module
  (func (export "i32.trunc_s:sat_f32") (param $x f32) (result i32) (i32.trunc_s:sat/f32 (get_local $x)))
  (func (export "i32.trunc_u:sat_f32") (param $x f32) (result i32) (i32.trunc_u:sat/f32 (get_local $x)))
  (func (export "i32.trunc_s:sat_f64") (param $x f64) (result i32) (i32.trunc_s:sat/f64 (get_local $x)))
  (func (export "i32.trunc_u:sat_f64") (param $x f64) (result i32) (i32.trunc_u:sat/f64 (get_local $x)))
  (func (export "i64.trunc_s:sat_f32") (param $x f32) (result i64) (i64.trunc_s:sat/f32 (get_local $x)))
  (func (export "i64.trunc_u:sat_f32") (param $x f32) (result i64) (i64.trunc_u:sat/f32 (get_local $x)))
  (func (export "i64.trunc_s:sat_f64") (param $x f64) (result i64) (i64.trunc_s:sat/f64 (get_local $x)))
  (func (export "i64.trunc_u:sat_f64") (param $x f64) (result i64) (i64.trunc_u:sat/f64 (get_local $x)))
)

;; Saturating conversions: test all the same values as the non-saturating conversions.

(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const 0.0)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -0.0)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const 1.0)) (i32.const 1))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const 0x1.19999ap+0)) (i32.const 1))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const 1.5)) (i32.const 1))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -1.0)) (i32.const -1))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -0x1.19999ap+0)) (i32.const -1))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -1.5)) (i32.const -1))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -1.9)) (i32.const -1))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -2.0)) (i32.const -2))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const 2147483520.0)) (i32.const 2147483520))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -2147483648.0)) (i32.const -2147483648))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const 2147483648.0)) (i32.const 0x7fffffff))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -2147483904.0)) (i32.const 0x80000000))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const inf)) (i32.const 0x7fffffff))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -inf)) (i32.const 0x80000000))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const nan)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -nan)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f32" (f32.const -nan:0x200000)) (i32.const 0))

(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 0.0)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const -0.0)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 1.0)) (i32.const 1))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 0x1.19999ap+0)) (i32.const 1))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 1.5)) (i32.const 1))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 1.9)) (i32.const 1))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 2.0)) (i32.const 2))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 2147483648)) (i32.const -2147483648)) ;; 0x1.00000p+31 -> 8000 0000
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 4294967040.0)) (i32.const -256))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const -0x1.ccccccp-1)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const -0x1.fffffep-1)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const 4294967296.0)) (i32.const 0xffffffff))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const -1.0)) (i32.const 0x00000000))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const inf)) (i32.const 0xffffffff))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const -inf)) (i32.const 0x00000000))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const nan)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const -nan)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f32" (f32.const -nan:0x200000)) (i32.const 0))

(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const 0.0)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -0.0)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const 1.0)) (i32.const 1))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const 0x1.199999999999ap+0)) (i32.const 1))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const 1.5)) (i32.const 1))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -1.0)) (i32.const -1))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -0x1.199999999999ap+0)) (i32.const -1))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -1.5)) (i32.const -1))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -1.9)) (i32.const -1))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -2.0)) (i32.const -2))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const 2147483647.0)) (i32.const 2147483647))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -2147483648.0)) (i32.const -2147483648))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const 2147483648.0)) (i32.const 0x7fffffff))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -2147483649.0)) (i32.const 0x80000000))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const inf)) (i32.const 0x7fffffff))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -inf)) (i32.const 0x80000000))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const nan)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -nan)) (i32.const 0))
(assert_return (invoke "i32.trunc_s:sat_f64" (f64.const -nan:0x4000000000000)) (i32.const 0))

(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 0.0)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const -0.0)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 1.0)) (i32.const 1))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 0x1.199999999999ap+0)) (i32.const 1))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 1.5)) (i32.const 1))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 1.9)) (i32.const 1))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 2.0)) (i32.const 2))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 2147483648)) (i32.const -2147483648)) ;; 0x1.00000p+31 -> 8000 0000
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 4294967295.0)) (i32.const -1))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const -0x1.ccccccccccccdp-1)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const -0x1.fffffffffffffp-1)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 1e8)) (i32.const 100000000))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 4294967296.0)) (i32.const 0xffffffff))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const -1.0)) (i32.const 0x00000000))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 1e16)) (i32.const 0xffffffff))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 1e30)) (i32.const 0xffffffff))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const 9223372036854775808)) (i32.const 0xffffffff))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const inf)) (i32.const 0xffffffff))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const -inf)) (i32.const 0x00000000))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const nan)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const -nan)) (i32.const 0))
(assert_return (invoke "i32.trunc_u:sat_f64" (f64.const -nan:0x4000000000000)) (i32.const 0))

(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const 0.0)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -0.0)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const 0x1p-149)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -0x1p-149)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const 1.0)) (i64.const 1))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const 0x1.19999ap+0)) (i64.const 1))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const 1.5)) (i64.const 1))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -1.0)) (i64.const -1))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -0x1.19999ap+0)) (i64.const -1))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -1.5)) (i64.const -1))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -1.9)) (i64.const -1))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -2.0)) (i64.const -2))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const 4294967296)) (i64.const 4294967296)) ;; 0x1.00000p+32 -> 1 0000 0000
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -4294967296)) (i64.const -4294967296)) ;; -0x1.00000p+32 -> ffff ffff 0000 0000
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const 9223371487098961920.0)) (i64.const 9223371487098961920))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -9223372036854775808.0)) (i64.const -9223372036854775808))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const 9223372036854775808.0)) (i64.const 0x7fffffffffffffff))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -9223373136366403584.0)) (i64.const 0x8000000000000000))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const inf)) (i64.const 0x7fffffffffffffff))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -inf)) (i64.const 0x8000000000000000))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const nan)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const nan:0x200000)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -nan)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f32" (f32.const -nan:0x200000)) (i64.const 0))

(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const 0.0)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const -0.0)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const 0x1p-149)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const -0x1p-149)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const 1.0)) (i64.const 1))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const 0x1.19999ap+0)) (i64.const 1))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const 1.5)) (i64.const 1))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const 4294967296)) (i64.const 4294967296))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const 18446742974197923840.0)) (i64.const -1099511627776))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const -0x1.ccccccp-1)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const -0x1.fffffep-1)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const 18446744073709551616.0)) (i64.const 0xffffffffffffffff))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const -1.0)) (i64.const 0x0000000000000000))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const inf)) (i64.const 0xffffffffffffffff))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const -inf)) (i64.const 0x0000000000000000))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const nan)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const nan:0x200000)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const -nan)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f32" (f32.const -nan:0x200000)) (i64.const 0))

(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const 0.0)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -0.0)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const 0x0.0000000000001p-1022)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -0x0.0000000000001p-1022)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const 1.0)) (i64.const 1))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const 0x1.199999999999ap+0)) (i64.const 1))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const 1.5)) (i64.const 1))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -1.0)) (i64.const -1))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -0x1.199999999999ap+0)) (i64.const -1))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -1.5)) (i64.const -1))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -1.9)) (i64.const -1))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -2.0)) (i64.const -2))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const 4294967296)) (i64.const 4294967296)) ;; 0x1.00000p+32 -> 1 0000 0000
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -4294967296)) (i64.const -4294967296)) ;; -0x1.00000p+32 -> ffff ffff 0000 0000
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const 9223372036854774784.0)) (i64.const 9223372036854774784))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -9223372036854775808.0)) (i64.const -9223372036854775808))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const 9223372036854775808.0)) (i64.const 0x7fffffffffffffff))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -9223372036854777856.0)) (i64.const 0x8000000000000000))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const inf)) (i64.const 0x7fffffffffffffff))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -inf)) (i64.const 0x8000000000000000))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const nan)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const nan:0x4000000000000)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -nan)) (i64.const 0))
(assert_return (invoke "i64.trunc_s:sat_f64" (f64.const -nan:0x4000000000000)) (i64.const 0))

(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 0.0)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const -0.0)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 0x0.0000000000001p-1022)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const -0x0.0000000000001p-1022)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 1.0)) (i64.const 1))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 0x1.199999999999ap+0)) (i64.const 1))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 1.5)) (i64.const 1))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 4294967295)) (i64.const 0xffffffff))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 4294967296)) (i64.const 0x100000000))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 18446744073709549568.0)) (i64.const -2048))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const -0x1.ccccccccccccdp-1)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const -0x1.fffffffffffffp-1)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 1e8)) (i64.const 100000000))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 1e16)) (i64.const 10000000000000000))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 9223372036854775808)) (i64.const -9223372036854775808))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const 18446744073709551616.0)) (i64.const 0xffffffffffffffff))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const -1.0)) (i64.const 0x0000000000000000))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const inf)) (i64.const 0xffffffffffffffff))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const -inf)) (i64.const 0x0000000000000000))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const nan)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const nan:0x4000000000000)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const -nan)) (i64.const 0))
(assert_return (invoke "i64.trunc_u:sat_f64" (f64.const -nan:0x4000000000000)) (i64.const 0))
