/* Generated by re2c 0.16 */
#line 1 "src/wast-lexer.cc"
/*
 * Copyright 2016 WebAssembly Community Group participants
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "wast-lexer.h"

#include <cassert>
#include <cstdio>

#include "config.h"

#include "lexer-source.h"
#include "wast-parser.h"
#include "wast-parser-lexer-shared.h"

/* must be included after so some typedefs will be defined */
#include "wast-parser-gen.hh"

#define YYMAXFILL 29

#define INITIAL_LEXER_BUFFER_SIZE (64 * 1024)

#define YY_USER_ACTION                  \
  {                                     \
    loc->filename = filename_;          \
    loc->line = line_;                  \
    loc->first_column = COLUMN(token_); \
    loc->last_column = COLUMN(cursor_); \
  }

#define RETURN(name) \
  YY_USER_ACTION;    \
  return WABT_TOKEN_TYPE_##name

#define ERROR(...) \
  YY_USER_ACTION;  \
  wast_parser_error(loc, this, parser, __VA_ARGS__)

#define BEGIN(c) cond = (c)
#define FILL(n)                                \
  do {                                         \
    if (WABT_FAILED(Fill(loc, parser, (n)))) { \
      RETURN(EOF);                             \
    }                                          \
  } while (0)

#define MAYBE_MALFORMED_UTF8(desc)                \
  if (!(eof_ && limit_ - cursor_ <= YYMAXFILL)) { \
    ERROR("malformed utf-8%s", desc);             \
  }                                               \
  continue

#define yytext (token_)
#define yyleng (cursor_ - token_)

/* p must be a pointer somewhere in the lexer buffer */
#define FILE_OFFSET(p) ((p) - (buffer_) + buffer_file_offset_)
#define COLUMN(p) (FILE_OFFSET(p) - line_file_offset_ + 1)

#define COMMENT_NESTING (comment_nesting_)
#define NEWLINE                               \
  do {                                        \
    line_++;                                  \
    line_file_offset_ = FILE_OFFSET(cursor_); \
  } while (0)

#define TEXT                 \
  lval->text.start = yytext; \
  lval->text.length = yyleng

#define TEXT_AT(offset)               \
  lval->text.start = yytext + offset; \
  lval->text.length = yyleng - offset

#define TYPE(type_) lval->type = Type::type_

#define OPCODE(name) lval->opcode = Opcode::name

#define LITERAL(type_)                     \
  lval->literal.type = LiteralType::type_; \
  lval->literal.text.start = yytext;       \
  lval->literal.text.length = yyleng

namespace wabt {

WastLexer::WastLexer(std::unique_ptr<LexerSource> source, const char* filename)
    : source_(std::move(source)),
      line_finder_(source_->Clone()),
      filename_(filename),
      line_(1),
      comment_nesting_(0),
      buffer_file_offset_(0),
      line_file_offset_(0),
      eof_(false),
      buffer_(nullptr),
      buffer_size_(0),
      marker_(nullptr),
      token_(nullptr),
      cursor_(nullptr),
      limit_(nullptr) {}

WastLexer::~WastLexer() {
  delete[] buffer_;
}

// static
std::unique_ptr<WastLexer> WastLexer::CreateFileLexer(const char* filename) {
  std::unique_ptr<LexerSource> source(new LexerSourceFile(filename));
  return std::unique_ptr<WastLexer>(new WastLexer(std::move(source), filename));
}

// static
std::unique_ptr<WastLexer> WastLexer::CreateBufferLexer(const char* filename,
                                                        const void* data,
                                                        size_t size) {
  std::unique_ptr<LexerSource> source(new LexerSourceBuffer(data, size));
  return std::unique_ptr<WastLexer>(new WastLexer(std::move(source), filename));
}

Result WastLexer::Fill(Location* loc, WastParser* parser, size_t need) {
  if (eof_)
    return Result::Error;
  size_t free = token_ - buffer_;
  assert(static_cast<size_t>(cursor_ - buffer_) >= free);
  // Our buffer is too small, need to realloc.
  if (free < need) {
    char* old_buffer = buffer_;
    size_t old_buffer_size = buffer_size_;
    size_t new_buffer_size =
        old_buffer_size ? old_buffer_size * 2 : INITIAL_LEXER_BUFFER_SIZE;
    // Make sure there is enough space for the bytes requested (need) and an
    // additional YYMAXFILL bytes which is needed for the re2c lexer
    // implementation when the eof is reached.
    while ((new_buffer_size - old_buffer_size) + free < need + YYMAXFILL)
      new_buffer_size *= 2;

    char* new_buffer = new char[new_buffer_size];
    if (limit_ > token_)
      memmove(new_buffer, token_, limit_ - token_);
    buffer_ = new_buffer;
    buffer_size_ = new_buffer_size;
    token_ = new_buffer + (token_ - old_buffer) - free;
    marker_ = new_buffer + (marker_ - old_buffer) - free;
    cursor_ = new_buffer + (cursor_ - old_buffer) - free;
    limit_ = new_buffer + (limit_ - old_buffer) - free;
    buffer_file_offset_ += free;
    free += new_buffer_size - old_buffer_size;
    delete[] old_buffer;
  } else {
    // Shift everything down to make more room in the buffer.
    if (limit_ > token_)
      memmove(buffer_, token_, limit_ - token_);
    token_ -= free;
    marker_ -= free;
    cursor_ -= free;
    limit_ -= free;
    buffer_file_offset_ += free;
  }
  // Read the new data into the buffer.
  limit_ += source_->Fill(limit_, free);

  // If at the end of file, need to fill YYMAXFILL more characters with "fake
  // characters", that are not a lexeme nor a lexeme suffix. see
  // http://re2c.org/examples/example_03.html.
  if (limit_ < buffer_ + buffer_size_ - YYMAXFILL) {
    eof_ = true;
    // Fill with 0xff, since that is an invalid utf-8 byte.
    memset(limit_, 0xff, YYMAXFILL);
    limit_ += YYMAXFILL;
  }
  return Result::Ok;
}

int WastLexer::GetToken(Token* lval, Location* loc, WastParser* parser) {
  enum {
    YYCOND_INIT,
    YYCOND_BAD_TEXT,
    YYCOND_LINE_COMMENT,
    YYCOND_BLOCK_COMMENT,
    YYCOND_i = YYCOND_INIT,
  } cond = YYCOND_INIT;

  for (;;) {
    token_ = cursor_;
    
#line 201 "src/prebuilt/wast-lexer-gen.cc"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	if (cond < 2) {
		if (cond < 1) {
			goto YYCOND_i;
		} else {
			goto YYCOND_BAD_TEXT;
		}
	} else {
		if (cond < 3) {
			goto YYCOND_LINE_COMMENT;
		} else {
			goto YYCOND_BLOCK_COMMENT;
		}
	}
/* *********************************** */
YYCOND_BAD_TEXT:
	if ((limit_ - cursor_) < 5) FILL(5);
	yych = *cursor_;
	if (yych <= 0x7F) {
		if (yych <= '!') {
			if (yych == '\n') goto yy5;
			if (yych >= ' ') goto yy7;
		} else {
			if (yych <= '"') goto yy9;
			if (yych == '\\') goto yy11;
			goto yy7;
		}
	} else {
		if (yych <= 0xEF) {
			if (yych <= 0xC1) goto yy12;
			if (yych <= 0xDF) goto yy14;
			if (yych <= 0xE0) goto yy15;
			goto yy16;
		} else {
			if (yych <= 0xF0) goto yy17;
			if (yych <= 0xF3) goto yy18;
			if (yych <= 0xF4) goto yy19;
			goto yy12;
		}
	}
	++cursor_;
yy4:
#line 251 "src/wast-lexer.cc"
	{ ERROR("illegal character in string");
                                  continue; }
#line 249 "src/prebuilt/wast-lexer-gen.cc"
yy5:
	++cursor_;
	BEGIN(YYCOND_i);
#line 244 "src/wast-lexer.cc"
	{ ERROR("newline in string");
                                  NEWLINE;
                                  continue; }
#line 257 "src/prebuilt/wast-lexer-gen.cc"
yy7:
	++cursor_;
#line 243 "src/wast-lexer.cc"
	{ continue; }
#line 262 "src/prebuilt/wast-lexer-gen.cc"
yy9:
	++cursor_;
	BEGIN(YYCOND_i);
#line 250 "src/wast-lexer.cc"
	{ TEXT; RETURN(TEXT); }
#line 268 "src/prebuilt/wast-lexer-gen.cc"
yy11:
	yyaccept = 0;
	yych = *(marker_ = ++cursor_);
	if (yych <= 'f') {
		if (yych <= '/') {
			if (yych <= '!') {
				if (yych == '\n') goto yy4;
				goto yy20;
			} else {
				if (yych <= '"') goto yy7;
				if (yych == '\'') goto yy7;
				goto yy20;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= '9') goto yy22;
				if (yych <= '@') goto yy20;
				goto yy22;
			} else {
				if (yych == '\\') goto yy7;
				if (yych <= '`') goto yy20;
				goto yy22;
			}
		}
	} else {
		if (yych <= 0x7F) {
			if (yych <= 'q') {
				if (yych == 'n') goto yy7;
				goto yy20;
			} else {
				if (yych == 's') goto yy20;
				if (yych <= 't') goto yy7;
				goto yy20;
			}
		} else {
			if (yych <= 0xEF) {
				if (yych <= 0xC1) goto yy4;
				if (yych <= 0xDF) goto yy23;
				if (yych <= 0xE0) goto yy25;
				goto yy26;
			} else {
				if (yych <= 0xF0) goto yy27;
				if (yych <= 0xF3) goto yy28;
				if (yych <= 0xF4) goto yy29;
				goto yy4;
			}
		}
	}
yy12:
	++cursor_;
yy13:
#line 253 "src/wast-lexer.cc"
	{ MAYBE_MALFORMED_UTF8(" in string"); }
#line 322 "src/prebuilt/wast-lexer-gen.cc"
yy14:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy13;
	if (yych <= 0xBF) goto yy7;
	goto yy13;
yy15:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x9F) goto yy13;
	if (yych <= 0xBF) goto yy30;
	goto yy13;
yy16:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy13;
	if (yych <= 0xBF) goto yy30;
	goto yy13;
yy17:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x8F) goto yy13;
	if (yych <= 0xBF) goto yy31;
	goto yy13;
yy18:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy13;
	if (yych <= 0xBF) goto yy31;
	goto yy13;
yy19:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy13;
	if (yych <= 0x8F) goto yy31;
	goto yy13;
yy20:
	++cursor_;
yy21:
#line 247 "src/wast-lexer.cc"
	{ ERROR("bad escape \"%.*s\"",
                                        static_cast<int>(yyleng), yytext);
                                  continue; }
#line 365 "src/prebuilt/wast-lexer-gen.cc"
yy22:
	yych = *++cursor_;
	if (yych <= '@') {
		if (yych <= '/') goto yy21;
		if (yych <= '9') goto yy7;
		goto yy21;
	} else {
		if (yych <= 'F') goto yy7;
		if (yych <= '`') goto yy21;
		if (yych <= 'f') goto yy7;
		goto yy21;
	}
yy23:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy20;
yy24:
	cursor_ = marker_;
	if (yyaccept == 0) {
		goto yy4;
	} else {
		goto yy13;
	}
yy25:
	yych = *++cursor_;
	if (yych <= 0x9F) goto yy24;
	if (yych <= 0xBF) goto yy23;
	goto yy24;
yy26:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy23;
	goto yy24;
yy27:
	yych = *++cursor_;
	if (yych <= 0x8F) goto yy24;
	if (yych <= 0xBF) goto yy26;
	goto yy24;
yy28:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy26;
	goto yy24;
yy29:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0x8F) goto yy26;
	goto yy24;
yy30:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy7;
	goto yy24;
yy31:
	++cursor_;
	if ((yych = *cursor_) <= 0x7F) goto yy24;
	if (yych <= 0xBF) goto yy30;
	goto yy24;
/* *********************************** */
YYCOND_BLOCK_COMMENT:
	if ((limit_ - cursor_) < 4) FILL(4);
	yych = *cursor_;
	if (yych <= 0x7F) {
		if (yych <= '\'') {
			if (yych == '\n') goto yy36;
		} else {
			if (yych <= '(') goto yy38;
			if (yych == ';') goto yy39;
		}
	} else {
		if (yych <= 0xEF) {
			if (yych <= 0xC1) goto yy40;
			if (yych <= 0xDF) goto yy42;
			if (yych <= 0xE0) goto yy43;
			goto yy44;
		} else {
			if (yych <= 0xF0) goto yy45;
			if (yych <= 0xF3) goto yy46;
			if (yych <= 0xF4) goto yy47;
			goto yy40;
		}
	}
yy34:
	++cursor_;
yy35:
#line 482 "src/wast-lexer.cc"
	{ continue; }
#line 453 "src/prebuilt/wast-lexer-gen.cc"
yy36:
	++cursor_;
#line 481 "src/wast-lexer.cc"
	{ NEWLINE; continue; }
#line 458 "src/prebuilt/wast-lexer-gen.cc"
yy38:
	yych = *++cursor_;
	if (yych == ';') goto yy48;
	goto yy35;
yy39:
	yych = *++cursor_;
	if (yych == ')') goto yy50;
	goto yy35;
yy40:
	++cursor_;
yy41:
#line 483 "src/wast-lexer.cc"
	{ MAYBE_MALFORMED_UTF8(" in block comment"); }
#line 472 "src/prebuilt/wast-lexer-gen.cc"
yy42:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy41;
	if (yych <= 0xBF) goto yy34;
	goto yy41;
yy43:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x9F) goto yy41;
	if (yych <= 0xBF) goto yy52;
	goto yy41;
yy44:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy41;
	if (yych <= 0xBF) goto yy52;
	goto yy41;
yy45:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x8F) goto yy41;
	if (yych <= 0xBF) goto yy54;
	goto yy41;
yy46:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy41;
	if (yych <= 0xBF) goto yy54;
	goto yy41;
yy47:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy41;
	if (yych <= 0x8F) goto yy54;
	goto yy41;
yy48:
	++cursor_;
#line 477 "src/wast-lexer.cc"
	{ COMMENT_NESTING++; continue; }
#line 507 "src/prebuilt/wast-lexer-gen.cc"
yy50:
	++cursor_;
#line 478 "src/wast-lexer.cc"
	{ if (--COMMENT_NESTING == 0)
                                    BEGIN(YYCOND_INIT);
                                  continue; }
#line 514 "src/prebuilt/wast-lexer-gen.cc"
yy52:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy53;
	if (yych <= 0xBF) goto yy34;
yy53:
	cursor_ = marker_;
	goto yy41;
yy54:
	++cursor_;
	if ((yych = *cursor_) <= 0x7F) goto yy53;
	if (yych <= 0xBF) goto yy52;
	goto yy53;
/* *********************************** */
YYCOND_LINE_COMMENT:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		if ((limit_ - cursor_) < 2) FILL(2);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy58;
		}
		if (yych <= 0xE0) {
			if (yych <= '\n') goto yy60;
			if (yych <= 0xC1) goto yy62;
			if (yych <= 0xDF) goto yy64;
			goto yy65;
		} else {
			if (yych <= 0xF0) {
				if (yych <= 0xEF) goto yy66;
				goto yy67;
			} else {
				if (yych <= 0xF3) goto yy68;
				if (yych <= 0xF4) goto yy69;
				goto yy62;
			}
		}
yy57:
#line 475 "src/wast-lexer.cc"
		{ continue; }
#line 587 "src/prebuilt/wast-lexer-gen.cc"
yy58:
		yyaccept = 0;
		marker_ = ++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy58;
		}
		if (yych <= 0xEF) {
			if (yych <= 0xC1) goto yy57;
			if (yych <= 0xDF) goto yy70;
			if (yych <= 0xE0) goto yy72;
			goto yy73;
		} else {
			if (yych <= 0xF0) goto yy74;
			if (yych <= 0xF3) goto yy75;
			if (yych <= 0xF4) goto yy76;
			goto yy57;
		}
yy60:
		++cursor_;
		BEGIN(YYCOND_i);
#line 474 "src/wast-lexer.cc"
		{ NEWLINE; continue; }
#line 612 "src/prebuilt/wast-lexer-gen.cc"
yy62:
		++cursor_;
yy63:
#line 490 "src/wast-lexer.cc"
		{ MAYBE_MALFORMED_UTF8(""); }
#line 618 "src/prebuilt/wast-lexer-gen.cc"
yy64:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy63;
		if (yych <= 0xBF) goto yy58;
		goto yy63;
yy65:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x9F) goto yy63;
		if (yych <= 0xBF) goto yy70;
		goto yy63;
yy66:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy63;
		if (yych <= 0xBF) goto yy70;
		goto yy63;
yy67:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x8F) goto yy63;
		if (yych <= 0xBF) goto yy73;
		goto yy63;
yy68:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy63;
		if (yych <= 0xBF) goto yy73;
		goto yy63;
yy69:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy63;
		if (yych <= 0x8F) goto yy73;
		goto yy63;
yy70:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy71;
		if (yych <= 0xBF) goto yy58;
yy71:
		cursor_ = marker_;
		if (yyaccept == 0) {
			goto yy57;
		} else {
			goto yy63;
		}
yy72:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x9F) goto yy71;
		if (yych <= 0xBF) goto yy70;
		goto yy71;
yy73:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy71;
		if (yych <= 0xBF) goto yy70;
		goto yy71;
yy74:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x8F) goto yy71;
		if (yych <= 0xBF) goto yy73;
		goto yy71;
yy75:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy71;
		if (yych <= 0xBF) goto yy73;
		goto yy71;
yy76:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy71;
		if (yych <= 0x8F) goto yy73;
		goto yy71;
	}
/* *********************************** */
YYCOND_i:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   4,   0,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36, 104,   0, 104, 104, 104, 104, 104, 
			 32,  32, 104, 104,  40, 104, 104, 104, 
			248, 248, 248, 248, 248, 248, 248, 248, 
			248, 248, 104,  32, 104, 104, 104, 104, 
			104, 232, 232, 232, 232, 232, 232, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104,  40,  72,  40, 104, 104, 
			104, 232, 232, 232, 232, 232, 232, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104,  40, 104,  40, 104,  32, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		if ((limit_ - cursor_) < 29) FILL(29);
		yych = *cursor_;
		if (yybm[0+yych] & 4) {
			goto yy81;
		}
		if (yych <= 'e') {
			if (yych <= '+') {
				if (yych <= '#') {
					if (yych <= 0x1F) {
						if (yych <= 0x08) goto yy79;
						if (yych <= '\n') goto yy84;
					} else {
						if (yych == '"') goto yy89;
						goto yy86;
					}
				} else {
					if (yych <= '(') {
						if (yych <= '$') goto yy91;
						if (yych <= '\'') goto yy86;
						goto yy92;
					} else {
						if (yych <= ')') goto yy94;
						if (yych <= '*') goto yy86;
						goto yy96;
					}
				}
			} else {
				if (yych <= ':') {
					if (yych <= '/') {
						if (yych == '-') goto yy96;
						goto yy86;
					} else {
						if (yych <= '0') goto yy97;
						if (yych <= '9') goto yy99;
						goto yy86;
					}
				} else {
					if (yych <= 'a') {
						if (yych <= ';') goto yy101;
						if (yych <= '`') goto yy86;
						goto yy102;
					} else {
						if (yych <= 'b') goto yy103;
						if (yych <= 'c') goto yy104;
						if (yych <= 'd') goto yy105;
						goto yy106;
					}
				}
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'l') {
					if (yych <= 'h') {
						if (yych <= 'f') goto yy107;
						if (yych <= 'g') goto yy108;
						goto yy86;
					} else {
						if (yych <= 'i') goto yy109;
						if (yych <= 'k') goto yy86;
						goto yy110;
					}
				} else {
					if (yych <= 'o') {
						if (yych <= 'm') goto yy111;
						if (yych <= 'n') goto yy112;
						goto yy113;
					} else {
						if (yych <= 'p') goto yy114;
						if (yych <= 'q') goto yy115;
						goto yy116;
					}
				}
			} else {
				if (yych <= 0xC1) {
					if (yych <= 'u') {
						if (yych <= 's') goto yy117;
						if (yych <= 't') goto yy118;
						goto yy119;
					} else {
						if (yych <= '~') goto yy86;
						if (yych >= 0x80) goto yy120;
					}
				} else {
					if (yych <= 0xEF) {
						if (yych <= 0xDF) goto yy122;
						if (yych <= 0xE0) goto yy123;
						goto yy124;
					} else {
						if (yych <= 0xF0) goto yy125;
						if (yych <= 0xF3) goto yy126;
						if (yych <= 0xF4) goto yy127;
						goto yy120;
					}
				}
			}
		}
yy79:
		++cursor_;
yy80:
#line 489 "src/wast-lexer.cc"
		{ ERROR("unexpected char"); continue; }
#line 841 "src/prebuilt/wast-lexer-gen.cc"
yy81:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 4) {
			goto yy81;
		}
#line 485 "src/wast-lexer.cc"
		{ continue; }
#line 851 "src/prebuilt/wast-lexer-gen.cc"
yy84:
		++cursor_;
#line 484 "src/wast-lexer.cc"
		{ NEWLINE; continue; }
#line 856 "src/prebuilt/wast-lexer-gen.cc"
yy86:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy87:
		if (yybm[0+yych] & 8) {
			goto yy86;
		}
yy88:
#line 486 "src/wast-lexer.cc"
		{ ERROR("unexpected token \"%.*s\"",
                                        static_cast<int>(yyleng), yytext);
                                  continue; }
#line 870 "src/prebuilt/wast-lexer-gen.cc"
yy89:
		yyaccept = 0;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x1F) goto yy90;
		if (yych <= 0x7F) goto yy129;
		if (yych <= 0xC1) goto yy90;
		if (yych <= 0xF4) goto yy129;
yy90:
		BEGIN(YYCOND_BAD_TEXT);
#line 242 "src/wast-lexer.cc"
		{ continue; }
#line 882 "src/prebuilt/wast-lexer-gen.cc"
yy91:
		yych = *++cursor_;
		if (yych <= '\'') {
			if (yych == '!') goto yy141;
			if (yych <= '"') goto yy88;
			goto yy141;
		} else {
			if (yych <= ':') {
				if (yych <= ')') goto yy88;
				goto yy141;
			} else {
				if (yych <= ';') goto yy88;
				if (yych <= '~') goto yy141;
				goto yy88;
			}
		}
yy92:
		++cursor_;
		if ((yych = *cursor_) == ';') goto yy143;
#line 233 "src/wast-lexer.cc"
		{ RETURN(LPAR); }
#line 904 "src/prebuilt/wast-lexer-gen.cc"
yy94:
		++cursor_;
#line 234 "src/wast-lexer.cc"
		{ RETURN(RPAR); }
#line 909 "src/prebuilt/wast-lexer-gen.cc"
yy96:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych <= '/') goto yy87;
			if (yych <= '0') goto yy145;
			if (yych <= '9') goto yy147;
			goto yy87;
		} else {
			if (yych <= 'i') goto yy149;
			if (yych == 'n') goto yy150;
			goto yy87;
		}
yy97:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 16) {
			goto yy99;
		}
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych >= '#') goto yy86;
			} else {
				if (yych <= ')') goto yy98;
				if (yych == '.') goto yy151;
				goto yy86;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= ';') goto yy98;
				if (yych == 'E') goto yy154;
				goto yy86;
			} else {
				if (yych <= 'w') {
					if (yych <= 'e') goto yy154;
					goto yy86;
				} else {
					if (yych <= 'x') goto yy155;
					if (yych <= '~') goto yy86;
				}
			}
		}
yy98:
#line 235 "src/wast-lexer.cc"
		{ LITERAL(Int); RETURN(NAT); }
#line 954 "src/prebuilt/wast-lexer-gen.cc"
yy99:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yybm[0+yych] & 16) {
			goto yy99;
		}
		if (yych <= '.') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy98;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy98;
				if (yych <= '-') goto yy86;
				goto yy151;
			}
		} else {
			if (yych <= 'E') {
				if (yych == ';') goto yy98;
				if (yych <= 'D') goto yy86;
				goto yy154;
			} else {
				if (yych == 'e') goto yy154;
				if (yych <= '~') goto yy86;
				goto yy98;
			}
		}
yy101:
		yych = *++cursor_;
		if (yych == ';') goto yy156;
		goto yy80;
yy102:
		yych = *++cursor_;
		if (yych <= 'm') {
			if (yych == 'l') goto yy158;
			goto yy87;
		} else {
			if (yych <= 'n') goto yy159;
			if (yych == 's') goto yy160;
			goto yy87;
		}
yy103:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'i') goto yy161;
			goto yy87;
		} else {
			if (yych <= 'l') goto yy162;
			if (yych == 'r') goto yy163;
			goto yy87;
		}
yy104:
		yych = *++cursor_;
		if (yych == 'a') goto yy165;
		if (yych == 'u') goto yy166;
		goto yy87;
yy105:
		yych = *++cursor_;
		if (yych == 'a') goto yy167;
		if (yych == 'r') goto yy168;
		goto yy87;
yy106:
		yych = *++cursor_;
		if (yych <= 'm') {
			if (yych == 'l') goto yy169;
			goto yy87;
		} else {
			if (yych <= 'n') goto yy170;
			if (yych == 'x') goto yy171;
			goto yy87;
		}
yy107:
		yych = *++cursor_;
		if (yych <= '5') {
			if (yych == '3') goto yy172;
			goto yy87;
		} else {
			if (yych <= '6') goto yy173;
			if (yych == 'u') goto yy174;
			goto yy87;
		}
yy108:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'e') goto yy175;
			goto yy87;
		} else {
			if (yych <= 'l') goto yy176;
			if (yych == 'r') goto yy177;
			goto yy87;
		}
yy109:
		yych = *++cursor_;
		if (yych <= 'e') {
			if (yych <= '3') {
				if (yych <= '2') goto yy87;
				goto yy178;
			} else {
				if (yych == '6') goto yy179;
				goto yy87;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'f') goto yy180;
				goto yy87;
			} else {
				if (yych <= 'm') goto yy182;
				if (yych <= 'n') goto yy183;
				goto yy87;
			}
		}
yy110:
		yych = *++cursor_;
		if (yych == 'o') goto yy184;
		goto yy87;
yy111:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy185;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy186;
			if (yych == 'u') goto yy187;
			goto yy87;
		}
yy112:
		yych = *++cursor_;
		if (yych == 'a') goto yy188;
		if (yych == 'o') goto yy189;
		goto yy87;
yy113:
		yych = *++cursor_;
		if (yych == 'f') goto yy190;
		goto yy87;
yy114:
		yych = *++cursor_;
		if (yych == 'a') goto yy191;
		goto yy87;
yy115:
		yych = *++cursor_;
		if (yych == 'u') goto yy192;
		goto yy87;
yy116:
		yych = *++cursor_;
		if (yych == 'e') goto yy193;
		goto yy87;
yy117:
		yych = *++cursor_;
		if (yych == 'e') goto yy194;
		if (yych == 't') goto yy195;
		goto yy87;
yy118:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy196;
		case 'e':	goto yy197;
		case 'h':	goto yy198;
		case 'r':	goto yy199;
		case 'y':	goto yy200;
		default:	goto yy87;
		}
yy119:
		yych = *++cursor_;
		if (yych == 'n') goto yy201;
		goto yy87;
yy120:
		++cursor_;
yy121:
#line 490 "src/wast-lexer.cc"
		{ MAYBE_MALFORMED_UTF8(""); }
#line 1126 "src/prebuilt/wast-lexer-gen.cc"
yy122:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy121;
		if (yych <= 0xBF) goto yy79;
		goto yy121;
yy123:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x9F) goto yy121;
		if (yych <= 0xBF) goto yy202;
		goto yy121;
yy124:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy121;
		if (yych <= 0xBF) goto yy202;
		goto yy121;
yy125:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x8F) goto yy121;
		if (yych <= 0xBF) goto yy203;
		goto yy121;
yy126:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy121;
		if (yych <= 0xBF) goto yy203;
		goto yy121;
yy127:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy121;
		if (yych <= 0x8F) goto yy203;
		goto yy121;
yy128:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy129:
		if (yybm[0+yych] & 32) {
			goto yy128;
		}
		if (yych <= 0xDF) {
			if (yych <= '"') {
				if (yych >= ' ') goto yy131;
			} else {
				if (yych <= '\\') goto yy133;
				if (yych >= 0xC2) goto yy134;
			}
		} else {
			if (yych <= 0xF0) {
				if (yych <= 0xE0) goto yy135;
				if (yych <= 0xEF) goto yy136;
				goto yy137;
			} else {
				if (yych <= 0xF3) goto yy138;
				if (yych <= 0xF4) goto yy139;
			}
		}
yy130:
		cursor_ = marker_;
		if (yyaccept == 0) {
			goto yy90;
		} else {
			goto yy121;
		}
yy131:
		++cursor_;
#line 241 "src/wast-lexer.cc"
		{ TEXT; RETURN(TEXT); }
#line 1198 "src/prebuilt/wast-lexer-gen.cc"
yy133:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '[') {
			if (yych <= '\'') {
				if (yych == '"') goto yy128;
				if (yych <= '&') goto yy130;
				goto yy128;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy130;
					goto yy204;
				} else {
					if (yych <= '@') goto yy130;
					if (yych <= 'F') goto yy204;
					goto yy130;
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') {
					if (yych <= '\\') goto yy128;
					goto yy130;
				} else {
					if (yych <= 'f') goto yy204;
					if (yych <= 'm') goto yy130;
					goto yy128;
				}
			} else {
				if (yych <= 'r') {
					if (yych <= 'q') goto yy130;
					goto yy128;
				} else {
					if (yych == 't') goto yy128;
					goto yy130;
				}
			}
		}
yy134:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy130;
		if (yych <= 0xBF) goto yy128;
		goto yy130;
yy135:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x9F) goto yy130;
		if (yych <= 0xBF) goto yy134;
		goto yy130;
yy136:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy130;
		if (yych <= 0xBF) goto yy134;
		goto yy130;
yy137:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x8F) goto yy130;
		if (yych <= 0xBF) goto yy136;
		goto yy130;
yy138:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy130;
		if (yych <= 0xBF) goto yy136;
		goto yy130;
yy139:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy130;
		if (yych <= 0x8F) goto yy136;
		goto yy130;
yy140:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy141:
		if (yybm[0+yych] & 64) {
			goto yy140;
		}
		if (yych <= ')') goto yy142;
		if (yych <= ',') goto yy86;
		if (yych <= ';') goto yy142;
		if (yych <= '}') goto yy86;
yy142:
#line 471 "src/wast-lexer.cc"
		{ TEXT; RETURN(VAR); }
#line 1295 "src/prebuilt/wast-lexer-gen.cc"
yy143:
		++cursor_;
		BEGIN(YYCOND_BLOCK_COMMENT);
#line 476 "src/wast-lexer.cc"
		{ COMMENT_NESTING = 1; continue; }
#line 1301 "src/prebuilt/wast-lexer-gen.cc"
yy145:
		++cursor_;
		if ((yych = *cursor_) <= '9') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych >= '#') goto yy86;
			} else {
				if (yych <= '-') {
					if (yych >= '*') goto yy86;
				} else {
					if (yych <= '.') goto yy151;
					if (yych <= '/') goto yy86;
					goto yy147;
				}
			}
		} else {
			if (yych <= 'd') {
				if (yych <= ';') {
					if (yych <= ':') goto yy86;
				} else {
					if (yych == 'E') goto yy154;
					goto yy86;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'e') goto yy154;
					goto yy86;
				} else {
					if (yych <= 'x') goto yy205;
					if (yych <= '~') goto yy86;
				}
			}
		}
yy146:
#line 236 "src/wast-lexer.cc"
		{ LITERAL(Int); RETURN(INT); }
#line 1338 "src/prebuilt/wast-lexer-gen.cc"
yy147:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yych <= '/') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy146;
				goto yy86;
			} else {
				if (yych <= ')') goto yy146;
				if (yych == '.') goto yy151;
				goto yy86;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '9') goto yy147;
				if (yych == ';') goto yy146;
				goto yy86;
			} else {
				if (yych <= 'd') {
					if (yych <= 'E') goto yy154;
					goto yy86;
				} else {
					if (yych <= 'e') goto yy154;
					if (yych <= '~') goto yy86;
					goto yy146;
				}
			}
		}
yy149:
		yych = *++cursor_;
		if (yych == 'n') goto yy206;
		goto yy87;
yy150:
		yych = *++cursor_;
		if (yych == 'a') goto yy188;
		goto yy87;
yy151:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy153;
				if (yych <= '/') goto yy86;
				goto yy151;
			}
		} else {
			if (yych <= 'E') {
				if (yych == ';') goto yy153;
				if (yych <= 'D') goto yy86;
				goto yy154;
			} else {
				if (yych == 'e') goto yy154;
				if (yych <= '~') goto yy86;
			}
		}
yy153:
#line 237 "src/wast-lexer.cc"
		{ LITERAL(Float); RETURN(FLOAT); }
#line 1403 "src/prebuilt/wast-lexer-gen.cc"
yy154:
		yych = *++cursor_;
		if (yych <= ',') {
			if (yych == '+') goto yy207;
			goto yy87;
		} else {
			if (yych <= '-') goto yy207;
			if (yych <= '/') goto yy87;
			if (yych <= '9') goto yy208;
			goto yy87;
		}
yy155:
		yych = *++cursor_;
		if (yybm[0+yych] & 128) {
			goto yy210;
		}
		goto yy87;
yy156:
		++cursor_;
		BEGIN(YYCOND_LINE_COMMENT);
#line 473 "src/wast-lexer.cc"
		{ continue; }
#line 1426 "src/prebuilt/wast-lexer-gen.cc"
yy158:
		yych = *++cursor_;
		if (yych == 'i') goto yy212;
		goto yy87;
yy159:
		yych = *++cursor_;
		if (yych == 'y') goto yy213;
		goto yy87;
yy160:
		yych = *++cursor_;
		if (yych == 's') goto yy214;
		goto yy87;
yy161:
		yych = *++cursor_;
		if (yych == 'n') goto yy215;
		goto yy87;
yy162:
		yych = *++cursor_;
		if (yych == 'o') goto yy216;
		goto yy87;
yy163:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy164;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy217;
				if (yych <= '~') goto yy86;
			}
		}
yy164:
#line 266 "src/wast-lexer.cc"
		{ RETURN(BR); }
#line 1467 "src/prebuilt/wast-lexer-gen.cc"
yy165:
		yych = *++cursor_;
		if (yych == 'l') goto yy218;
		if (yych == 't') goto yy219;
		goto yy87;
yy166:
		yych = *++cursor_;
		if (yych == 'r') goto yy220;
		goto yy87;
yy167:
		yych = *++cursor_;
		if (yych == 't') goto yy221;
		goto yy87;
yy168:
		yych = *++cursor_;
		if (yych == 'o') goto yy222;
		goto yy87;
yy169:
		yych = *++cursor_;
		if (yych == 'e') goto yy223;
		if (yych == 's') goto yy224;
		goto yy87;
yy170:
		yych = *++cursor_;
		if (yych == 'd') goto yy225;
		goto yy87;
yy171:
		yych = *++cursor_;
		if (yych == 'c') goto yy227;
		if (yych == 'p') goto yy228;
		goto yy87;
yy172:
		yych = *++cursor_;
		if (yych == '2') goto yy229;
		goto yy87;
yy173:
		yych = *++cursor_;
		if (yych == '4') goto yy231;
		goto yy87;
yy174:
		yych = *++cursor_;
		if (yych == 'n') goto yy233;
		goto yy87;
yy175:
		yych = *++cursor_;
		if (yych == 't') goto yy234;
		goto yy87;
yy176:
		yych = *++cursor_;
		if (yych == 'o') goto yy236;
		goto yy87;
yy177:
		yych = *++cursor_;
		if (yych == 'o') goto yy237;
		goto yy87;
yy178:
		yych = *++cursor_;
		if (yych == '2') goto yy238;
		goto yy87;
yy179:
		yych = *++cursor_;
		if (yych == '4') goto yy240;
		goto yy87;
yy180:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 262 "src/wast-lexer.cc"
		{ RETURN(IF); }
#line 1538 "src/prebuilt/wast-lexer-gen.cc"
yy182:
		yych = *++cursor_;
		if (yych == 'p') goto yy242;
		goto yy87;
yy183:
		yych = *++cursor_;
		if (yych == 'f') goto yy243;
		if (yych == 'v') goto yy245;
		goto yy87;
yy184:
		yych = *++cursor_;
		if (yych == 'c') goto yy246;
		if (yych == 'o') goto yy247;
		goto yy87;
yy185:
		yych = *++cursor_;
		if (yych == 'm') goto yy248;
		goto yy87;
yy186:
		yych = *++cursor_;
		if (yych == 'd') goto yy249;
		goto yy87;
yy187:
		yych = *++cursor_;
		if (yych == 't') goto yy250;
		goto yy87;
yy188:
		yych = *++cursor_;
		if (yych == 'n') goto yy252;
		goto yy87;
yy189:
		yych = *++cursor_;
		if (yych == 'p') goto yy254;
		goto yy87;
yy190:
		yych = *++cursor_;
		if (yych == 'f') goto yy256;
		goto yy87;
yy191:
		yych = *++cursor_;
		if (yych == 'r') goto yy257;
		goto yy87;
yy192:
		yych = *++cursor_;
		if (yych == 'o') goto yy258;
		goto yy87;
yy193:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'g') goto yy259;
			goto yy87;
		} else {
			if (yych <= 's') goto yy260;
			if (yych <= 't') goto yy261;
			goto yy87;
		}
yy194:
		yych = *++cursor_;
		if (yych == 'l') goto yy262;
		if (yych == 't') goto yy263;
		goto yy87;
yy195:
		yych = *++cursor_;
		if (yych == 'a') goto yy264;
		goto yy87;
yy196:
		yych = *++cursor_;
		if (yych == 'b') goto yy265;
		goto yy87;
yy197:
		yych = *++cursor_;
		if (yych == 'e') goto yy266;
		goto yy87;
yy198:
		yych = *++cursor_;
		if (yych == 'e') goto yy267;
		if (yych == 'r') goto yy268;
		goto yy87;
yy199:
		yych = *++cursor_;
		if (yych == 'y') goto yy269;
		goto yy87;
yy200:
		yych = *++cursor_;
		if (yych == 'p') goto yy271;
		goto yy87;
yy201:
		yych = *++cursor_;
		if (yych == 'r') goto yy272;
		goto yy87;
yy202:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy130;
		if (yych <= 0xBF) goto yy79;
		goto yy130;
yy203:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy130;
		if (yych <= 0xBF) goto yy202;
		goto yy130;
yy204:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '@') {
			if (yych <= '/') goto yy130;
			if (yych <= '9') goto yy128;
			goto yy130;
		} else {
			if (yych <= 'F') goto yy128;
			if (yych <= '`') goto yy130;
			if (yych <= 'f') goto yy128;
			goto yy130;
		}
yy205:
		yych = *++cursor_;
		if (yych <= '@') {
			if (yych <= '/') goto yy87;
			if (yych <= '9') goto yy273;
			goto yy87;
		} else {
			if (yych <= 'F') goto yy273;
			if (yych <= '`') goto yy87;
			if (yych <= 'f') goto yy273;
			goto yy87;
		}
yy206:
		yych = *++cursor_;
		if (yych == 'f') goto yy243;
		goto yy87;
yy207:
		yych = *++cursor_;
		if (yych <= '/') goto yy87;
		if (yych >= ':') goto yy87;
yy208:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy153;
				goto yy86;
			} else {
				if (yych <= '"') goto yy153;
				if (yych <= '\'') goto yy86;
				goto yy153;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy208;
				goto yy86;
			} else {
				if (yych <= ';') goto yy153;
				if (yych <= '~') goto yy86;
				goto yy153;
			}
		}
yy210:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy210;
		}
		if (yych <= '-') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy98;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy98;
				goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '.') goto yy275;
				if (yych <= ':') goto yy86;
				goto yy98;
			} else {
				if (yych == 'p') goto yy277;
				if (yych <= '~') goto yy86;
				goto yy98;
			}
		}
yy212:
		yych = *++cursor_;
		if (yych == 'g') goto yy278;
		goto yy87;
yy213:
		yych = *++cursor_;
		if (yych == 'f') goto yy279;
		goto yy87;
yy214:
		yych = *++cursor_;
		if (yych == 'e') goto yy280;
		goto yy87;
yy215:
		yych = *++cursor_;
		if (yych == 'a') goto yy281;
		goto yy87;
yy216:
		yych = *++cursor_;
		if (yych == 'c') goto yy282;
		goto yy87;
yy217:
		yych = *++cursor_;
		if (yych == 'i') goto yy283;
		if (yych == 't') goto yy284;
		goto yy87;
yy218:
		yych = *++cursor_;
		if (yych == 'l') goto yy285;
		goto yy87;
yy219:
		yych = *++cursor_;
		if (yych == 'c') goto yy287;
		goto yy87;
yy220:
		yych = *++cursor_;
		if (yych == 'r') goto yy288;
		goto yy87;
yy221:
		yych = *++cursor_;
		if (yych == 'a') goto yy289;
		goto yy87;
yy222:
		yych = *++cursor_;
		if (yych == 'p') goto yy291;
		goto yy87;
yy223:
		yych = *++cursor_;
		if (yych == 'm') goto yy293;
		goto yy87;
yy224:
		yych = *++cursor_;
		if (yych == 'e') goto yy295;
		goto yy87;
yy225:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 272 "src/wast-lexer.cc"
		{ RETURN(END); }
#line 1784 "src/prebuilt/wast-lexer-gen.cc"
yy227:
		yych = *++cursor_;
		if (yych == 'e') goto yy297;
		goto yy87;
yy228:
		yych = *++cursor_;
		if (yych == 'o') goto yy298;
		goto yy87;
yy229:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy230;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy299;
				goto yy86;
			} else {
				if (yych <= ';') goto yy230;
				if (yych <= '~') goto yy86;
			}
		}
yy230:
#line 256 "src/wast-lexer.cc"
		{ TYPE(F32); RETURN(VALUE_TYPE); }
#line 1814 "src/prebuilt/wast-lexer-gen.cc"
yy231:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy232;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy300;
				goto yy86;
			} else {
				if (yych <= ';') goto yy232;
				if (yych <= '~') goto yy86;
			}
		}
yy232:
#line 257 "src/wast-lexer.cc"
		{ TYPE(F64); RETURN(VALUE_TYPE); }
#line 1836 "src/prebuilt/wast-lexer-gen.cc"
yy233:
		yych = *++cursor_;
		if (yych == 'c') goto yy301;
		goto yy87;
yy234:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy235;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy303;
				if (yych <= '~') goto yy86;
			}
		}
yy235:
#line 455 "src/wast-lexer.cc"
		{ RETURN(GET); }
#line 1861 "src/prebuilt/wast-lexer-gen.cc"
yy236:
		yych = *++cursor_;
		if (yych == 'b') goto yy304;
		goto yy87;
yy237:
		yych = *++cursor_;
		if (yych == 'w') goto yy305;
		goto yy87;
yy238:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy239;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy306;
				goto yy86;
			} else {
				if (yych <= ';') goto yy239;
				if (yych <= '~') goto yy86;
			}
		}
yy239:
#line 254 "src/wast-lexer.cc"
		{ TYPE(I32); RETURN(VALUE_TYPE); }
#line 1891 "src/prebuilt/wast-lexer-gen.cc"
yy240:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy241;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy307;
				goto yy86;
			} else {
				if (yych <= ';') goto yy241;
				if (yych <= '~') goto yy86;
			}
		}
yy241:
#line 255 "src/wast-lexer.cc"
		{ TYPE(I64); RETURN(VALUE_TYPE); }
#line 1913 "src/prebuilt/wast-lexer-gen.cc"
yy242:
		yych = *++cursor_;
		if (yych == 'o') goto yy308;
		goto yy87;
yy243:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 239 "src/wast-lexer.cc"
		{ LITERAL(Infinity); RETURN(FLOAT); }
#line 1925 "src/prebuilt/wast-lexer-gen.cc"
yy245:
		yych = *++cursor_;
		if (yych == 'o') goto yy309;
		goto yy87;
yy246:
		yych = *++cursor_;
		if (yych == 'a') goto yy310;
		goto yy87;
yy247:
		yych = *++cursor_;
		if (yych == 'p') goto yy311;
		goto yy87;
yy248:
		yych = *++cursor_;
		if (yych == 'o') goto yy313;
		goto yy87;
yy249:
		yych = *++cursor_;
		if (yych == 'u') goto yy314;
		goto yy87;
yy250:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 259 "src/wast-lexer.cc"
		{ RETURN(MUT); }
#line 1953 "src/prebuilt/wast-lexer-gen.cc"
yy252:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy253;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '9') goto yy86;
				goto yy315;
			} else {
				if (yych <= ';') goto yy253;
				if (yych <= '~') goto yy86;
			}
		}
yy253:
#line 240 "src/wast-lexer.cc"
		{ LITERAL(Nan); RETURN(FLOAT); }
#line 1975 "src/prebuilt/wast-lexer-gen.cc"
yy254:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 260 "src/wast-lexer.cc"
		{ RETURN(NOP); }
#line 1983 "src/prebuilt/wast-lexer-gen.cc"
yy256:
		yych = *++cursor_;
		if (yych == 's') goto yy316;
		goto yy87;
yy257:
		yych = *++cursor_;
		if (yych == 'a') goto yy317;
		goto yy87;
yy258:
		yych = *++cursor_;
		if (yych == 't') goto yy318;
		goto yy87;
yy259:
		yych = *++cursor_;
		if (yych == 'i') goto yy319;
		goto yy87;
yy260:
		yych = *++cursor_;
		if (yych == 'u') goto yy320;
		goto yy87;
yy261:
		yych = *++cursor_;
		if (yych == 'h') goto yy321;
		if (yych == 'u') goto yy322;
		goto yy87;
yy262:
		yych = *++cursor_;
		if (yych == 'e') goto yy323;
		goto yy87;
yy263:
		yych = *++cursor_;
		if (yych == '_') goto yy324;
		goto yy87;
yy264:
		yych = *++cursor_;
		if (yych == 'r') goto yy325;
		goto yy87;
yy265:
		yych = *++cursor_;
		if (yych == 'l') goto yy326;
		goto yy87;
yy266:
		yych = *++cursor_;
		if (yych == '_') goto yy327;
		goto yy87;
yy267:
		yych = *++cursor_;
		if (yych == 'n') goto yy328;
		goto yy87;
yy268:
		yych = *++cursor_;
		if (yych == 'o') goto yy330;
		goto yy87;
yy269:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 466 "src/wast-lexer.cc"
		{ RETURN(TRY); }
#line 2044 "src/prebuilt/wast-lexer-gen.cc"
yy271:
		yych = *++cursor_;
		if (yych == 'e') goto yy331;
		goto yy87;
yy272:
		yych = *++cursor_;
		if (yych == 'e') goto yy333;
		goto yy87;
yy273:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy146;
				goto yy86;
			} else {
				if (yych <= '-') {
					if (yych <= ')') goto yy146;
					goto yy86;
				} else {
					if (yych <= '.') goto yy275;
					if (yych <= '/') goto yy86;
					goto yy273;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= ';') {
					if (yych <= ':') goto yy86;
					goto yy146;
				} else {
					if (yych <= '@') goto yy86;
					if (yych <= 'F') goto yy273;
					goto yy86;
				}
			} else {
				if (yych <= 'o') {
					if (yych <= 'f') goto yy273;
					goto yy86;
				} else {
					if (yych <= 'p') goto yy277;
					if (yych <= '~') goto yy86;
					goto yy146;
				}
			}
		}
yy275:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy86;
				if (yych <= '"') goto yy88;
				goto yy86;
			} else {
				if (yych <= ')') goto yy88;
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy275;
				goto yy86;
			}
		} else {
			if (yych <= '`') {
				if (yych <= ';') goto yy88;
				if (yych <= '@') goto yy86;
				if (yych <= 'F') goto yy275;
				goto yy86;
			} else {
				if (yych <= 'o') {
					if (yych <= 'f') goto yy275;
					goto yy86;
				} else {
					if (yych <= 'p') goto yy277;
					if (yych <= '~') goto yy86;
					goto yy88;
				}
			}
		}
yy277:
		yych = *++cursor_;
		if (yych <= ',') {
			if (yych == '+') goto yy334;
			goto yy87;
		} else {
			if (yych <= '-') goto yy334;
			if (yych <= '/') goto yy87;
			if (yych <= '9') goto yy335;
			goto yy87;
		}
yy278:
		yych = *++cursor_;
		if (yych == 'n') goto yy338;
		goto yy87;
yy279:
		yych = *++cursor_;
		if (yych == 'u') goto yy339;
		goto yy87;
yy280:
		yych = *++cursor_;
		if (yych == 'r') goto yy340;
		goto yy87;
yy281:
		yych = *++cursor_;
		if (yych == 'r') goto yy341;
		goto yy87;
yy282:
		yych = *++cursor_;
		if (yych == 'k') goto yy342;
		goto yy87;
yy283:
		yych = *++cursor_;
		if (yych == 'f') goto yy344;
		goto yy87;
yy284:
		yych = *++cursor_;
		if (yych == 'a') goto yy346;
		goto yy87;
yy285:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy286;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy347;
				if (yych <= '~') goto yy86;
			}
		}
yy286:
#line 269 "src/wast-lexer.cc"
		{ RETURN(CALL); }
#line 2184 "src/prebuilt/wast-lexer-gen.cc"
yy287:
		yych = *++cursor_;
		if (yych == 'h') goto yy348;
		goto yy87;
yy288:
		yych = *++cursor_;
		if (yych == 'e') goto yy350;
		goto yy87;
yy289:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 448 "src/wast-lexer.cc"
		{ RETURN(DATA); }
#line 2200 "src/prebuilt/wast-lexer-gen.cc"
yy291:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 271 "src/wast-lexer.cc"
		{ RETURN(DROP); }
#line 2208 "src/prebuilt/wast-lexer-gen.cc"
yy293:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 447 "src/wast-lexer.cc"
		{ RETURN(ELEM); }
#line 2216 "src/prebuilt/wast-lexer-gen.cc"
yy295:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 264 "src/wast-lexer.cc"
		{ RETURN(ELSE); }
#line 2224 "src/prebuilt/wast-lexer-gen.cc"
yy297:
		yych = *++cursor_;
		if (yych == 'p') goto yy351;
		goto yy87;
yy298:
		yych = *++cursor_;
		if (yych == 'r') goto yy352;
		goto yy87;
yy299:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy353;
		case 'c':	goto yy354;
		case 'd':	goto yy355;
		case 'e':	goto yy356;
		case 'f':	goto yy357;
		case 'g':	goto yy358;
		case 'l':	goto yy359;
		case 'm':	goto yy360;
		case 'n':	goto yy361;
		case 'r':	goto yy362;
		case 's':	goto yy363;
		case 't':	goto yy364;
		default:	goto yy87;
		}
yy300:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy365;
		case 'c':	goto yy366;
		case 'd':	goto yy367;
		case 'e':	goto yy368;
		case 'f':	goto yy369;
		case 'g':	goto yy370;
		case 'l':	goto yy371;
		case 'm':	goto yy372;
		case 'n':	goto yy373;
		case 'p':	goto yy374;
		case 'r':	goto yy375;
		case 's':	goto yy376;
		case 't':	goto yy377;
		default:	goto yy87;
		}
yy301:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 436 "src/wast-lexer.cc"
		{ RETURN(FUNC); }
#line 2275 "src/prebuilt/wast-lexer-gen.cc"
yy303:
		yych = *++cursor_;
		if (yych == 'g') goto yy378;
		if (yych == 'l') goto yy379;
		goto yy87;
yy304:
		yych = *++cursor_;
		if (yych == 'a') goto yy380;
		goto yy87;
yy305:
		yych = *++cursor_;
		if (yych == '_') goto yy381;
		goto yy87;
yy306:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy382;
		case 'c':	goto yy383;
		case 'd':	goto yy384;
		case 'e':	goto yy385;
		case 'g':	goto yy386;
		case 'l':	goto yy387;
		case 'm':	goto yy388;
		case 'n':	goto yy389;
		case 'o':	goto yy390;
		case 'p':	goto yy391;
		case 'r':	goto yy392;
		case 's':	goto yy393;
		case 't':	goto yy394;
		case 'w':	goto yy395;
		case 'x':	goto yy396;
		default:	goto yy87;
		}
yy307:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy397;
		case 'c':	goto yy398;
		case 'd':	goto yy399;
		case 'e':	goto yy400;
		case 'g':	goto yy401;
		case 'l':	goto yy402;
		case 'm':	goto yy403;
		case 'n':	goto yy404;
		case 'o':	goto yy405;
		case 'p':	goto yy406;
		case 'r':	goto yy407;
		case 's':	goto yy408;
		case 't':	goto yy409;
		case 'x':	goto yy410;
		default:	goto yy87;
		}
yy308:
		yych = *++cursor_;
		if (yych == 'r') goto yy411;
		goto yy87;
yy309:
		yych = *++cursor_;
		if (yych == 'k') goto yy412;
		goto yy87;
yy310:
		yych = *++cursor_;
		if (yych == 'l') goto yy413;
		goto yy87;
yy311:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 265 "src/wast-lexer.cc"
		{ RETURN(LOOP); }
#line 2347 "src/prebuilt/wast-lexer-gen.cc"
yy313:
		yych = *++cursor_;
		if (yych == 'r') goto yy415;
		goto yy87;
yy314:
		yych = *++cursor_;
		if (yych == 'l') goto yy416;
		goto yy87;
yy315:
		yych = *++cursor_;
		if (yych == '0') goto yy417;
		goto yy87;
yy316:
		yych = *++cursor_;
		if (yych == 'e') goto yy418;
		goto yy87;
yy317:
		yych = *++cursor_;
		if (yych == 'm') goto yy419;
		goto yy87;
yy318:
		yych = *++cursor_;
		if (yych == 'e') goto yy421;
		goto yy87;
yy319:
		yych = *++cursor_;
		if (yych == 's') goto yy423;
		goto yy87;
yy320:
		yych = *++cursor_;
		if (yych == 'l') goto yy424;
		goto yy87;
yy321:
		yych = *++cursor_;
		if (yych == 'r') goto yy425;
		goto yy87;
yy322:
		yych = *++cursor_;
		if (yych == 'r') goto yy426;
		goto yy87;
yy323:
		yych = *++cursor_;
		if (yych == 'c') goto yy427;
		goto yy87;
yy324:
		yych = *++cursor_;
		if (yych == 'g') goto yy428;
		if (yych == 'l') goto yy429;
		goto yy87;
yy325:
		yych = *++cursor_;
		if (yych == 't') goto yy430;
		goto yy87;
yy326:
		yych = *++cursor_;
		if (yych == 'e') goto yy432;
		goto yy87;
yy327:
		yych = *++cursor_;
		if (yych == 'l') goto yy434;
		goto yy87;
yy328:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 263 "src/wast-lexer.cc"
		{ RETURN(THEN); }
#line 2416 "src/prebuilt/wast-lexer-gen.cc"
yy330:
		yych = *++cursor_;
		if (yych == 'w') goto yy435;
		goto yy87;
yy331:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 435 "src/wast-lexer.cc"
		{ RETURN(TYPE); }
#line 2428 "src/prebuilt/wast-lexer-gen.cc"
yy333:
		yych = *++cursor_;
		if (yych == 'a') goto yy437;
		goto yy87;
yy334:
		yych = *++cursor_;
		if (yych <= '/') goto yy87;
		if (yych >= ':') goto yy87;
yy335:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy337;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy335;
				goto yy86;
			} else {
				if (yych <= ';') goto yy337;
				if (yych <= '~') goto yy86;
			}
		}
yy337:
#line 238 "src/wast-lexer.cc"
		{ LITERAL(Hexfloat); RETURN(FLOAT); }
#line 2461 "src/prebuilt/wast-lexer-gen.cc"
yy338:
		yych = *++cursor_;
		if (yych == '=') goto yy438;
		goto yy87;
yy339:
		yych = *++cursor_;
		if (yych == 'n') goto yy439;
		goto yy87;
yy340:
		yych = *++cursor_;
		if (yych == 't') goto yy440;
		goto yy87;
yy341:
		yych = *++cursor_;
		if (yych == 'y') goto yy441;
		goto yy87;
yy342:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 261 "src/wast-lexer.cc"
		{ RETURN(BLOCK); }
#line 2485 "src/prebuilt/wast-lexer-gen.cc"
yy344:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 267 "src/wast-lexer.cc"
		{ RETURN(BR_IF); }
#line 2493 "src/prebuilt/wast-lexer-gen.cc"
yy346:
		yych = *++cursor_;
		if (yych == 'b') goto yy443;
		goto yy87;
yy347:
		yych = *++cursor_;
		if (yych == 'i') goto yy444;
		goto yy87;
yy348:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy349;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy445;
				if (yych <= '~') goto yy86;
			}
		}
yy349:
#line 467 "src/wast-lexer.cc"
		{ RETURN(CATCH); }
#line 2522 "src/prebuilt/wast-lexer-gen.cc"
yy350:
		yych = *++cursor_;
		if (yych == 'n') goto yy446;
		goto yy87;
yy351:
		yych = *++cursor_;
		if (yych == 't') goto yy447;
		goto yy87;
yy352:
		yych = *++cursor_;
		if (yych == 't') goto yy449;
		goto yy87;
yy353:
		yych = *++cursor_;
		if (yych == 'b') goto yy451;
		if (yych == 'd') goto yy452;
		goto yy87;
yy354:
		yych = *++cursor_;
		if (yych == 'e') goto yy453;
		if (yych == 'o') goto yy454;
		goto yy87;
yy355:
		yych = *++cursor_;
		if (yych == 'e') goto yy455;
		if (yych == 'i') goto yy456;
		goto yy87;
yy356:
		yych = *++cursor_;
		if (yych == 'q') goto yy457;
		goto yy87;
yy357:
		yych = *++cursor_;
		if (yych == 'l') goto yy459;
		goto yy87;
yy358:
		yych = *++cursor_;
		if (yych == 'e') goto yy460;
		if (yych == 't') goto yy462;
		goto yy87;
yy359:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy464;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy466;
			if (yych == 't') goto yy467;
			goto yy87;
		}
yy360:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy469;
			goto yy87;
		} else {
			if (yych <= 'i') goto yy470;
			if (yych == 'u') goto yy471;
			goto yy87;
		}
yy361:
		yych = *++cursor_;
		if (yych == 'e') goto yy472;
		goto yy87;
yy362:
		yych = *++cursor_;
		if (yych == 'e') goto yy474;
		goto yy87;
yy363:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'q') goto yy475;
			goto yy87;
		} else {
			if (yych <= 't') goto yy476;
			if (yych <= 'u') goto yy477;
			goto yy87;
		}
yy364:
		yych = *++cursor_;
		if (yych == 'r') goto yy478;
		goto yy87;
yy365:
		yych = *++cursor_;
		if (yych == 'b') goto yy479;
		if (yych == 'd') goto yy480;
		goto yy87;
yy366:
		yych = *++cursor_;
		if (yych == 'e') goto yy481;
		if (yych == 'o') goto yy482;
		goto yy87;
yy367:
		yych = *++cursor_;
		if (yych == 'i') goto yy483;
		goto yy87;
yy368:
		yych = *++cursor_;
		if (yych == 'q') goto yy484;
		goto yy87;
yy369:
		yych = *++cursor_;
		if (yych == 'l') goto yy486;
		goto yy87;
yy370:
		yych = *++cursor_;
		if (yych == 'e') goto yy487;
		if (yych == 't') goto yy489;
		goto yy87;
yy371:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy491;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy493;
			if (yych == 't') goto yy494;
			goto yy87;
		}
yy372:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy496;
			goto yy87;
		} else {
			if (yych <= 'i') goto yy497;
			if (yych == 'u') goto yy498;
			goto yy87;
		}
yy373:
		yych = *++cursor_;
		if (yych == 'e') goto yy499;
		goto yy87;
yy374:
		yych = *++cursor_;
		if (yych == 'r') goto yy501;
		goto yy87;
yy375:
		yych = *++cursor_;
		if (yych == 'e') goto yy502;
		goto yy87;
yy376:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'q') goto yy503;
			goto yy87;
		} else {
			if (yych <= 't') goto yy504;
			if (yych <= 'u') goto yy505;
			goto yy87;
		}
yy377:
		yych = *++cursor_;
		if (yych == 'r') goto yy506;
		goto yy87;
yy378:
		yych = *++cursor_;
		if (yych == 'l') goto yy507;
		goto yy87;
yy379:
		yych = *++cursor_;
		if (yych == 'o') goto yy508;
		goto yy87;
yy380:
		yych = *++cursor_;
		if (yych == 'l') goto yy509;
		goto yy87;
yy381:
		yych = *++cursor_;
		if (yych == 'm') goto yy511;
		goto yy87;
yy382:
		yych = *++cursor_;
		if (yych == 'd') goto yy512;
		if (yych == 'n') goto yy513;
		goto yy87;
yy383:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'l') goto yy514;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy515;
			if (yych == 't') goto yy516;
			goto yy87;
		}
yy384:
		yych = *++cursor_;
		if (yych == 'i') goto yy517;
		goto yy87;
yy385:
		yych = *++cursor_;
		if (yych == 'q') goto yy518;
		goto yy87;
yy386:
		yych = *++cursor_;
		if (yych == 'e') goto yy520;
		if (yych == 't') goto yy521;
		goto yy87;
yy387:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy522;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy523;
			if (yych == 't') goto yy524;
			goto yy87;
		}
yy388:
		yych = *++cursor_;
		if (yych == 'u') goto yy525;
		goto yy87;
yy389:
		yych = *++cursor_;
		if (yych == 'e') goto yy526;
		goto yy87;
yy390:
		yych = *++cursor_;
		if (yych == 'r') goto yy528;
		goto yy87;
yy391:
		yych = *++cursor_;
		if (yych == 'o') goto yy530;
		goto yy87;
yy392:
		yych = *++cursor_;
		if (yych == 'e') goto yy531;
		if (yych == 'o') goto yy532;
		goto yy87;
yy393:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'h') goto yy533;
			goto yy87;
		} else {
			if (yych <= 't') goto yy534;
			if (yych <= 'u') goto yy535;
			goto yy87;
		}
yy394:
		yych = *++cursor_;
		if (yych == 'r') goto yy536;
		goto yy87;
yy395:
		yych = *++cursor_;
		if (yych == 'r') goto yy537;
		goto yy87;
yy396:
		yych = *++cursor_;
		if (yych == 'o') goto yy538;
		goto yy87;
yy397:
		yych = *++cursor_;
		if (yych == 'd') goto yy539;
		if (yych == 'n') goto yy540;
		goto yy87;
yy398:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'l') goto yy541;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy542;
			if (yych == 't') goto yy543;
			goto yy87;
		}
yy399:
		yych = *++cursor_;
		if (yych == 'i') goto yy544;
		goto yy87;
yy400:
		yych = *++cursor_;
		if (yych == 'q') goto yy545;
		if (yych == 'x') goto yy547;
		goto yy87;
yy401:
		yych = *++cursor_;
		if (yych == 'e') goto yy548;
		if (yych == 't') goto yy549;
		goto yy87;
yy402:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy550;
			goto yy87;
		} else {
			if (yych <= 'o') goto yy551;
			if (yych == 't') goto yy552;
			goto yy87;
		}
yy403:
		yych = *++cursor_;
		if (yych == 'u') goto yy553;
		goto yy87;
yy404:
		yych = *++cursor_;
		if (yych == 'e') goto yy554;
		goto yy87;
yy405:
		yych = *++cursor_;
		if (yych == 'r') goto yy556;
		goto yy87;
yy406:
		yych = *++cursor_;
		if (yych == 'o') goto yy558;
		goto yy87;
yy407:
		yych = *++cursor_;
		if (yych == 'e') goto yy559;
		if (yych == 'o') goto yy560;
		goto yy87;
yy408:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'h') goto yy561;
			goto yy87;
		} else {
			if (yych <= 't') goto yy562;
			if (yych <= 'u') goto yy563;
			goto yy87;
		}
yy409:
		yych = *++cursor_;
		if (yych == 'r') goto yy564;
		goto yy87;
yy410:
		yych = *++cursor_;
		if (yych == 'o') goto yy565;
		goto yy87;
yy411:
		yych = *++cursor_;
		if (yych == 't') goto yy566;
		goto yy87;
yy412:
		yych = *++cursor_;
		if (yych == 'e') goto yy568;
		goto yy87;
yy413:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 439 "src/wast-lexer.cc"
		{ RETURN(LOCAL); }
#line 2868 "src/prebuilt/wast-lexer-gen.cc"
yy415:
		yych = *++cursor_;
		if (yych == 'y') goto yy570;
		goto yy87;
yy416:
		yych = *++cursor_;
		if (yych == 'e') goto yy572;
		goto yy87;
yy417:
		yych = *++cursor_;
		if (yych == 'x') goto yy574;
		goto yy87;
yy418:
		yych = *++cursor_;
		if (yych == 't') goto yy575;
		goto yy87;
yy419:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 437 "src/wast-lexer.cc"
		{ RETURN(PARAM); }
#line 2892 "src/prebuilt/wast-lexer-gen.cc"
yy421:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 443 "src/wast-lexer.cc"
		{ RETURN(QUOTE); }
#line 2900 "src/prebuilt/wast-lexer-gen.cc"
yy423:
		yych = *++cursor_;
		if (yych == 't') goto yy577;
		goto yy87;
yy424:
		yych = *++cursor_;
		if (yych == 't') goto yy578;
		goto yy87;
yy425:
		yych = *++cursor_;
		if (yych == 'o') goto yy580;
		goto yy87;
yy426:
		yych = *++cursor_;
		if (yych == 'n') goto yy581;
		goto yy87;
yy427:
		yych = *++cursor_;
		if (yych == 't') goto yy583;
		goto yy87;
yy428:
		yych = *++cursor_;
		if (yych == 'l') goto yy585;
		goto yy87;
yy429:
		yych = *++cursor_;
		if (yych == 'o') goto yy586;
		goto yy87;
yy430:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 446 "src/wast-lexer.cc"
		{ RETURN(START); }
#line 2936 "src/prebuilt/wast-lexer-gen.cc"
yy432:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 444 "src/wast-lexer.cc"
		{ RETURN(TABLE); }
#line 2944 "src/prebuilt/wast-lexer-gen.cc"
yy434:
		yych = *++cursor_;
		if (yych == 'o') goto yy587;
		goto yy87;
yy435:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 469 "src/wast-lexer.cc"
		{ RETURN(THROW); }
#line 2956 "src/prebuilt/wast-lexer-gen.cc"
yy437:
		yych = *++cursor_;
		if (yych == 'c') goto yy588;
		goto yy87;
yy438:
		yych = *++cursor_;
		if (yych <= '/') goto yy87;
		if (yych <= '0') goto yy589;
		if (yych <= '9') goto yy591;
		goto yy87;
yy439:
		yych = *++cursor_;
		if (yych == 'c') goto yy593;
		goto yy87;
yy440:
		yych = *++cursor_;
		if (yych == '_') goto yy595;
		goto yy87;
yy441:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 442 "src/wast-lexer.cc"
		{ RETURN(BIN); }
#line 2982 "src/prebuilt/wast-lexer-gen.cc"
yy443:
		yych = *++cursor_;
		if (yych == 'l') goto yy596;
		goto yy87;
yy444:
		yych = *++cursor_;
		if (yych == 'n') goto yy597;
		goto yy87;
yy445:
		yych = *++cursor_;
		if (yych == 'a') goto yy598;
		goto yy87;
yy446:
		yych = *++cursor_;
		if (yych == 't') goto yy599;
		goto yy87;
yy447:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 452 "src/wast-lexer.cc"
		{ RETURN(EXCEPT); }
#line 3006 "src/prebuilt/wast-lexer-gen.cc"
yy449:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 451 "src/wast-lexer.cc"
		{ RETURN(EXPORT); }
#line 3014 "src/prebuilt/wast-lexer-gen.cc"
yy451:
		yych = *++cursor_;
		if (yych == 's') goto yy600;
		goto yy87;
yy452:
		yych = *++cursor_;
		if (yych == 'd') goto yy602;
		goto yy87;
yy453:
		yych = *++cursor_;
		if (yych == 'i') goto yy604;
		goto yy87;
yy454:
		yych = *++cursor_;
		if (yych == 'n') goto yy605;
		if (yych == 'p') goto yy606;
		goto yy87;
yy455:
		yych = *++cursor_;
		if (yych == 'm') goto yy607;
		goto yy87;
yy456:
		yych = *++cursor_;
		if (yych == 'v') goto yy608;
		goto yy87;
yy457:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 394 "src/wast-lexer.cc"
		{ OPCODE(F32Eq); RETURN(COMPARE); }
#line 3047 "src/prebuilt/wast-lexer-gen.cc"
yy459:
		yych = *++cursor_;
		if (yych == 'o') goto yy610;
		goto yy87;
yy460:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 404 "src/wast-lexer.cc"
		{ OPCODE(F32Ge); RETURN(COMPARE); }
#line 3059 "src/prebuilt/wast-lexer-gen.cc"
yy462:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 402 "src/wast-lexer.cc"
		{ OPCODE(F32Gt); RETURN(COMPARE); }
#line 3067 "src/prebuilt/wast-lexer-gen.cc"
yy464:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 400 "src/wast-lexer.cc"
		{ OPCODE(F32Le); RETURN(COMPARE); }
#line 3075 "src/prebuilt/wast-lexer-gen.cc"
yy466:
		yych = *++cursor_;
		if (yych == 'a') goto yy611;
		goto yy87;
yy467:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 398 "src/wast-lexer.cc"
		{ OPCODE(F32Lt); RETURN(COMPARE); }
#line 3087 "src/prebuilt/wast-lexer-gen.cc"
yy469:
		yych = *++cursor_;
		if (yych == 'x') goto yy612;
		goto yy87;
yy470:
		yych = *++cursor_;
		if (yych == 'n') goto yy614;
		goto yy87;
yy471:
		yych = *++cursor_;
		if (yych == 'l') goto yy616;
		goto yy87;
yy472:
		++cursor_;
		if ((yych = *cursor_) <= ':') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= 'a') {
				if (yych <= ';') goto yy473;
				if (yych <= '`') goto yy86;
				goto yy618;
			} else {
				if (yych == 'g') goto yy619;
				if (yych <= '~') goto yy86;
			}
		}
yy473:
#line 396 "src/wast-lexer.cc"
		{ OPCODE(F32Ne); RETURN(COMPARE); }
#line 3122 "src/prebuilt/wast-lexer-gen.cc"
yy474:
		yych = *++cursor_;
		if (yych == 'i') goto yy621;
		goto yy87;
yy475:
		yych = *++cursor_;
		if (yych == 'r') goto yy622;
		goto yy87;
yy476:
		yych = *++cursor_;
		if (yych == 'o') goto yy623;
		goto yy87;
yy477:
		yych = *++cursor_;
		if (yych == 'b') goto yy624;
		goto yy87;
yy478:
		yych = *++cursor_;
		if (yych == 'u') goto yy626;
		goto yy87;
yy479:
		yych = *++cursor_;
		if (yych == 's') goto yy627;
		goto yy87;
yy480:
		yych = *++cursor_;
		if (yych == 'd') goto yy629;
		goto yy87;
yy481:
		yych = *++cursor_;
		if (yych == 'i') goto yy631;
		goto yy87;
yy482:
		yych = *++cursor_;
		if (yych == 'n') goto yy632;
		if (yych == 'p') goto yy633;
		goto yy87;
yy483:
		yych = *++cursor_;
		if (yych == 'v') goto yy634;
		goto yy87;
yy484:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 395 "src/wast-lexer.cc"
		{ OPCODE(F64Eq); RETURN(COMPARE); }
#line 3171 "src/prebuilt/wast-lexer-gen.cc"
yy486:
		yych = *++cursor_;
		if (yych == 'o') goto yy636;
		goto yy87;
yy487:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 405 "src/wast-lexer.cc"
		{ OPCODE(F64Ge); RETURN(COMPARE); }
#line 3183 "src/prebuilt/wast-lexer-gen.cc"
yy489:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 403 "src/wast-lexer.cc"
		{ OPCODE(F64Gt); RETURN(COMPARE); }
#line 3191 "src/prebuilt/wast-lexer-gen.cc"
yy491:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 401 "src/wast-lexer.cc"
		{ OPCODE(F64Le); RETURN(COMPARE); }
#line 3199 "src/prebuilt/wast-lexer-gen.cc"
yy493:
		yych = *++cursor_;
		if (yych == 'a') goto yy637;
		goto yy87;
yy494:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 399 "src/wast-lexer.cc"
		{ OPCODE(F64Lt); RETURN(COMPARE); }
#line 3211 "src/prebuilt/wast-lexer-gen.cc"
yy496:
		yych = *++cursor_;
		if (yych == 'x') goto yy638;
		goto yy87;
yy497:
		yych = *++cursor_;
		if (yych == 'n') goto yy640;
		goto yy87;
yy498:
		yych = *++cursor_;
		if (yych == 'l') goto yy642;
		goto yy87;
yy499:
		++cursor_;
		if ((yych = *cursor_) <= ':') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= 'a') {
				if (yych <= ';') goto yy500;
				if (yych <= '`') goto yy86;
				goto yy644;
			} else {
				if (yych == 'g') goto yy645;
				if (yych <= '~') goto yy86;
			}
		}
yy500:
#line 397 "src/wast-lexer.cc"
		{ OPCODE(F64Ne); RETURN(COMPARE); }
#line 3246 "src/prebuilt/wast-lexer-gen.cc"
yy501:
		yych = *++cursor_;
		if (yych == 'o') goto yy647;
		goto yy87;
yy502:
		yych = *++cursor_;
		if (yych == 'i') goto yy648;
		goto yy87;
yy503:
		yych = *++cursor_;
		if (yych == 'r') goto yy649;
		goto yy87;
yy504:
		yych = *++cursor_;
		if (yych == 'o') goto yy650;
		goto yy87;
yy505:
		yych = *++cursor_;
		if (yych == 'b') goto yy651;
		goto yy87;
yy506:
		yych = *++cursor_;
		if (yych == 'u') goto yy653;
		goto yy87;
yy507:
		yych = *++cursor_;
		if (yych == 'o') goto yy654;
		goto yy87;
yy508:
		yych = *++cursor_;
		if (yych == 'c') goto yy655;
		goto yy87;
yy509:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 440 "src/wast-lexer.cc"
		{ RETURN(GLOBAL); }
#line 3286 "src/prebuilt/wast-lexer-gen.cc"
yy511:
		yych = *++cursor_;
		if (yych == 'e') goto yy656;
		goto yy87;
yy512:
		yych = *++cursor_;
		if (yych == 'd') goto yy657;
		goto yy87;
yy513:
		yych = *++cursor_;
		if (yych == 'd') goto yy659;
		goto yy87;
yy514:
		yych = *++cursor_;
		if (yych == 'z') goto yy661;
		goto yy87;
yy515:
		yych = *++cursor_;
		if (yych == 'n') goto yy663;
		goto yy87;
yy516:
		yych = *++cursor_;
		if (yych == 'z') goto yy664;
		goto yy87;
yy517:
		yych = *++cursor_;
		if (yych == 'v') goto yy666;
		goto yy87;
yy518:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy519;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'y') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'z') goto yy667;
				if (yych <= '~') goto yy86;
			}
		}
yy519:
#line 374 "src/wast-lexer.cc"
		{ OPCODE(I32Eq); RETURN(COMPARE); }
#line 3335 "src/prebuilt/wast-lexer-gen.cc"
yy520:
		yych = *++cursor_;
		if (yych == '_') goto yy669;
		goto yy87;
yy521:
		yych = *++cursor_;
		if (yych == '_') goto yy670;
		goto yy87;
yy522:
		yych = *++cursor_;
		if (yych == '_') goto yy671;
		goto yy87;
yy523:
		yych = *++cursor_;
		if (yych == 'a') goto yy672;
		goto yy87;
yy524:
		yych = *++cursor_;
		if (yych == '_') goto yy673;
		goto yy87;
yy525:
		yych = *++cursor_;
		if (yych == 'l') goto yy674;
		goto yy87;
yy526:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 376 "src/wast-lexer.cc"
		{ OPCODE(I32Ne); RETURN(COMPARE); }
#line 3367 "src/prebuilt/wast-lexer-gen.cc"
yy528:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 346 "src/wast-lexer.cc"
		{ OPCODE(I32Or); RETURN(BINARY); }
#line 3375 "src/prebuilt/wast-lexer-gen.cc"
yy530:
		yych = *++cursor_;
		if (yych == 'p') goto yy676;
		goto yy87;
yy531:
		yych = *++cursor_;
		if (yych == 'i') goto yy677;
		if (yych == 'm') goto yy678;
		goto yy87;
yy532:
		yych = *++cursor_;
		if (yych == 't') goto yy679;
		goto yy87;
yy533:
		yych = *++cursor_;
		if (yych == 'l') goto yy680;
		if (yych == 'r') goto yy682;
		goto yy87;
yy534:
		yych = *++cursor_;
		if (yych == 'o') goto yy683;
		goto yy87;
yy535:
		yych = *++cursor_;
		if (yych == 'b') goto yy684;
		goto yy87;
yy536:
		yych = *++cursor_;
		if (yych == 'u') goto yy686;
		goto yy87;
yy537:
		yych = *++cursor_;
		if (yych == 'a') goto yy687;
		goto yy87;
yy538:
		yych = *++cursor_;
		if (yych == 'r') goto yy688;
		goto yy87;
yy539:
		yych = *++cursor_;
		if (yych == 'd') goto yy690;
		goto yy87;
yy540:
		yych = *++cursor_;
		if (yych == 'd') goto yy692;
		goto yy87;
yy541:
		yych = *++cursor_;
		if (yych == 'z') goto yy694;
		goto yy87;
yy542:
		yych = *++cursor_;
		if (yych == 'n') goto yy696;
		goto yy87;
yy543:
		yych = *++cursor_;
		if (yych == 'z') goto yy697;
		goto yy87;
yy544:
		yych = *++cursor_;
		if (yych == 'v') goto yy699;
		goto yy87;
yy545:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy546;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= 'y') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= 'z') goto yy700;
				if (yych <= '~') goto yy86;
			}
		}
yy546:
#line 375 "src/wast-lexer.cc"
		{ OPCODE(I64Eq); RETURN(COMPARE); }
#line 3458 "src/prebuilt/wast-lexer-gen.cc"
yy547:
		yych = *++cursor_;
		if (yych == 't') goto yy702;
		goto yy87;
yy548:
		yych = *++cursor_;
		if (yych == '_') goto yy703;
		goto yy87;
yy549:
		yych = *++cursor_;
		if (yych == '_') goto yy704;
		goto yy87;
yy550:
		yych = *++cursor_;
		if (yych == '_') goto yy705;
		goto yy87;
yy551:
		yych = *++cursor_;
		if (yych == 'a') goto yy706;
		goto yy87;
yy552:
		yych = *++cursor_;
		if (yych == '_') goto yy707;
		goto yy87;
yy553:
		yych = *++cursor_;
		if (yych == 'l') goto yy708;
		goto yy87;
yy554:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 377 "src/wast-lexer.cc"
		{ OPCODE(I64Ne); RETURN(COMPARE); }
#line 3494 "src/prebuilt/wast-lexer-gen.cc"
yy556:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 347 "src/wast-lexer.cc"
		{ OPCODE(I64Or); RETURN(BINARY); }
#line 3502 "src/prebuilt/wast-lexer-gen.cc"
yy558:
		yych = *++cursor_;
		if (yych == 'p') goto yy710;
		goto yy87;
yy559:
		yych = *++cursor_;
		if (yych == 'i') goto yy711;
		if (yych == 'm') goto yy712;
		goto yy87;
yy560:
		yych = *++cursor_;
		if (yych == 't') goto yy713;
		goto yy87;
yy561:
		yych = *++cursor_;
		if (yych == 'l') goto yy714;
		if (yych == 'r') goto yy716;
		goto yy87;
yy562:
		yych = *++cursor_;
		if (yych == 'o') goto yy717;
		goto yy87;
yy563:
		yych = *++cursor_;
		if (yych == 'b') goto yy718;
		goto yy87;
yy564:
		yych = *++cursor_;
		if (yych == 'u') goto yy720;
		goto yy87;
yy565:
		yych = *++cursor_;
		if (yych == 'r') goto yy721;
		goto yy87;
yy566:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 450 "src/wast-lexer.cc"
		{ RETURN(IMPORT); }
#line 3544 "src/prebuilt/wast-lexer-gen.cc"
yy568:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 454 "src/wast-lexer.cc"
		{ RETURN(INVOKE); }
#line 3552 "src/prebuilt/wast-lexer-gen.cc"
yy570:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 445 "src/wast-lexer.cc"
		{ RETURN(MEMORY); }
#line 3560 "src/prebuilt/wast-lexer-gen.cc"
yy572:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 441 "src/wast-lexer.cc"
		{ RETURN(MODULE); }
#line 3568 "src/prebuilt/wast-lexer-gen.cc"
yy574:
		yych = *++cursor_;
		if (yych <= '@') {
			if (yych <= '/') goto yy87;
			if (yych <= '9') goto yy723;
			goto yy87;
		} else {
			if (yych <= 'F') goto yy723;
			if (yych <= '`') goto yy87;
			if (yych <= 'f') goto yy723;
			goto yy87;
		}
yy575:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy576;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '<') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '=') goto yy725;
				if (yych <= '~') goto yy86;
			}
		}
yy576:
#line 449 "src/wast-lexer.cc"
		{ RETURN(OFFSET); }
#line 3601 "src/prebuilt/wast-lexer-gen.cc"
yy577:
		yych = *++cursor_;
		if (yych == 'e') goto yy726;
		goto yy87;
yy578:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 438 "src/wast-lexer.cc"
		{ RETURN(RESULT); }
#line 3613 "src/prebuilt/wast-lexer-gen.cc"
yy580:
		yych = *++cursor_;
		if (yych == 'w') goto yy727;
		goto yy87;
yy581:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 273 "src/wast-lexer.cc"
		{ RETURN(RETURN); }
#line 3625 "src/prebuilt/wast-lexer-gen.cc"
yy583:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 431 "src/wast-lexer.cc"
		{ RETURN(SELECT); }
#line 3633 "src/prebuilt/wast-lexer-gen.cc"
yy585:
		yych = *++cursor_;
		if (yych == 'o') goto yy729;
		goto yy87;
yy586:
		yych = *++cursor_;
		if (yych == 'c') goto yy730;
		goto yy87;
yy587:
		yych = *++cursor_;
		if (yych == 'c') goto yy731;
		goto yy87;
yy588:
		yych = *++cursor_;
		if (yych == 'h') goto yy732;
		goto yy87;
yy589:
		++cursor_;
		if ((yych = *cursor_) <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy591;
				if (yych <= ':') goto yy86;
			} else {
				if (yych == 'x') goto yy733;
				if (yych <= '~') goto yy86;
			}
		}
yy590:
#line 303 "src/wast-lexer.cc"
		{ TEXT_AT(6); RETURN(ALIGN_EQ_NAT); }
#line 3671 "src/prebuilt/wast-lexer-gen.cc"
yy591:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy590;
				goto yy86;
			} else {
				if (yych <= '"') goto yy590;
				if (yych <= '\'') goto yy86;
				goto yy590;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy591;
				goto yy86;
			} else {
				if (yych <= ';') goto yy590;
				if (yych <= '~') goto yy86;
				goto yy590;
			}
		}
yy593:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 258 "src/wast-lexer.cc"
		{ RETURN(ANYFUNC); }
#line 3703 "src/prebuilt/wast-lexer-gen.cc"
yy595:
		yych = *++cursor_;
		switch (yych) {
		case 'e':	goto yy734;
		case 'i':	goto yy735;
		case 'm':	goto yy736;
		case 'r':	goto yy737;
		case 't':	goto yy738;
		case 'u':	goto yy739;
		default:	goto yy87;
		}
yy596:
		yych = *++cursor_;
		if (yych == 'e') goto yy740;
		goto yy87;
yy597:
		yych = *++cursor_;
		if (yych == 'd') goto yy742;
		goto yy87;
yy598:
		yych = *++cursor_;
		if (yych == 'l') goto yy743;
		goto yy87;
yy599:
		yych = *++cursor_;
		if (yych == '_') goto yy744;
		goto yy87;
yy600:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 318 "src/wast-lexer.cc"
		{ OPCODE(F32Abs); RETURN(UNARY); }
#line 3738 "src/prebuilt/wast-lexer-gen.cc"
yy602:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 360 "src/wast-lexer.cc"
		{ OPCODE(F32Add); RETURN(BINARY); }
#line 3746 "src/prebuilt/wast-lexer-gen.cc"
yy604:
		yych = *++cursor_;
		if (yych == 'l') goto yy745;
		goto yy87;
yy605:
		yych = *++cursor_;
		if (yych == 's') goto yy747;
		if (yych == 'v') goto yy748;
		goto yy87;
yy606:
		yych = *++cursor_;
		if (yych == 'y') goto yy749;
		goto yy87;
yy607:
		yych = *++cursor_;
		if (yych == 'o') goto yy750;
		goto yy87;
yy608:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 366 "src/wast-lexer.cc"
		{ OPCODE(F32Div); RETURN(BINARY); }
#line 3771 "src/prebuilt/wast-lexer-gen.cc"
yy610:
		yych = *++cursor_;
		if (yych == 'o') goto yy751;
		goto yy87;
yy611:
		yych = *++cursor_;
		if (yych == 'd') goto yy752;
		goto yy87;
yy612:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 370 "src/wast-lexer.cc"
		{ OPCODE(F32Max); RETURN(BINARY); }
#line 3787 "src/prebuilt/wast-lexer-gen.cc"
yy614:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 368 "src/wast-lexer.cc"
		{ OPCODE(F32Min); RETURN(BINARY); }
#line 3795 "src/prebuilt/wast-lexer-gen.cc"
yy616:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 364 "src/wast-lexer.cc"
		{ OPCODE(F32Mul); RETURN(BINARY); }
#line 3803 "src/prebuilt/wast-lexer-gen.cc"
yy618:
		yych = *++cursor_;
		if (yych == 'r') goto yy754;
		goto yy87;
yy619:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 316 "src/wast-lexer.cc"
		{ OPCODE(F32Neg); RETURN(UNARY); }
#line 3815 "src/prebuilt/wast-lexer-gen.cc"
yy621:
		yych = *++cursor_;
		if (yych == 'n') goto yy755;
		goto yy87;
yy622:
		yych = *++cursor_;
		if (yych == 't') goto yy756;
		goto yy87;
yy623:
		yych = *++cursor_;
		if (yych == 'r') goto yy758;
		goto yy87;
yy624:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 362 "src/wast-lexer.cc"
		{ OPCODE(F32Sub); RETURN(BINARY); }
#line 3835 "src/prebuilt/wast-lexer-gen.cc"
yy626:
		yych = *++cursor_;
		if (yych == 'n') goto yy759;
		goto yy87;
yy627:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 319 "src/wast-lexer.cc"
		{ OPCODE(F64Abs); RETURN(UNARY); }
#line 3847 "src/prebuilt/wast-lexer-gen.cc"
yy629:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 361 "src/wast-lexer.cc"
		{ OPCODE(F64Add); RETURN(BINARY); }
#line 3855 "src/prebuilt/wast-lexer-gen.cc"
yy631:
		yych = *++cursor_;
		if (yych == 'l') goto yy760;
		goto yy87;
yy632:
		yych = *++cursor_;
		if (yych == 's') goto yy762;
		if (yych == 'v') goto yy763;
		goto yy87;
yy633:
		yych = *++cursor_;
		if (yych == 'y') goto yy764;
		goto yy87;
yy634:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 367 "src/wast-lexer.cc"
		{ OPCODE(F64Div); RETURN(BINARY); }
#line 3876 "src/prebuilt/wast-lexer-gen.cc"
yy636:
		yych = *++cursor_;
		if (yych == 'o') goto yy765;
		goto yy87;
yy637:
		yych = *++cursor_;
		if (yych == 'd') goto yy766;
		goto yy87;
yy638:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 371 "src/wast-lexer.cc"
		{ OPCODE(F64Max); RETURN(BINARY); }
#line 3892 "src/prebuilt/wast-lexer-gen.cc"
yy640:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 369 "src/wast-lexer.cc"
		{ OPCODE(F64Min); RETURN(BINARY); }
#line 3900 "src/prebuilt/wast-lexer-gen.cc"
yy642:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 365 "src/wast-lexer.cc"
		{ OPCODE(F64Mul); RETURN(BINARY); }
#line 3908 "src/prebuilt/wast-lexer-gen.cc"
yy644:
		yych = *++cursor_;
		if (yych == 'r') goto yy768;
		goto yy87;
yy645:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 317 "src/wast-lexer.cc"
		{ OPCODE(F64Neg); RETURN(UNARY); }
#line 3920 "src/prebuilt/wast-lexer-gen.cc"
yy647:
		yych = *++cursor_;
		if (yych == 'm') goto yy769;
		goto yy87;
yy648:
		yych = *++cursor_;
		if (yych == 'n') goto yy770;
		goto yy87;
yy649:
		yych = *++cursor_;
		if (yych == 't') goto yy771;
		goto yy87;
yy650:
		yych = *++cursor_;
		if (yych == 'r') goto yy773;
		goto yy87;
yy651:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 363 "src/wast-lexer.cc"
		{ OPCODE(F64Sub); RETURN(BINARY); }
#line 3944 "src/prebuilt/wast-lexer-gen.cc"
yy653:
		yych = *++cursor_;
		if (yych == 'n') goto yy774;
		goto yy87;
yy654:
		yych = *++cursor_;
		if (yych == 'b') goto yy775;
		goto yy87;
yy655:
		yych = *++cursor_;
		if (yych == 'a') goto yy776;
		goto yy87;
yy656:
		yych = *++cursor_;
		if (yych == 'm') goto yy777;
		goto yy87;
yy657:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 330 "src/wast-lexer.cc"
		{ OPCODE(I32Add); RETURN(BINARY); }
#line 3968 "src/prebuilt/wast-lexer-gen.cc"
yy659:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 344 "src/wast-lexer.cc"
		{ OPCODE(I32And); RETURN(BINARY); }
#line 3976 "src/prebuilt/wast-lexer-gen.cc"
yy661:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 310 "src/wast-lexer.cc"
		{ OPCODE(I32Clz); RETURN(UNARY); }
#line 3984 "src/prebuilt/wast-lexer-gen.cc"
yy663:
		yych = *++cursor_;
		if (yych == 's') goto yy778;
		goto yy87;
yy664:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 312 "src/wast-lexer.cc"
		{ OPCODE(I32Ctz); RETURN(UNARY); }
#line 3996 "src/prebuilt/wast-lexer-gen.cc"
yy666:
		yych = *++cursor_;
		if (yych == '_') goto yy779;
		goto yy87;
yy667:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 308 "src/wast-lexer.cc"
		{ OPCODE(I32Eqz); RETURN(CONVERT); }
#line 4008 "src/prebuilt/wast-lexer-gen.cc"
yy669:
		yych = *++cursor_;
		if (yych == 's') goto yy780;
		if (yych == 'u') goto yy782;
		goto yy87;
yy670:
		yych = *++cursor_;
		if (yych == 's') goto yy784;
		if (yych == 'u') goto yy786;
		goto yy87;
yy671:
		yych = *++cursor_;
		if (yych == 's') goto yy788;
		if (yych == 'u') goto yy790;
		goto yy87;
yy672:
		yych = *++cursor_;
		if (yych == 'd') goto yy792;
		goto yy87;
yy673:
		yych = *++cursor_;
		if (yych == 's') goto yy794;
		if (yych == 'u') goto yy796;
		goto yy87;
yy674:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 334 "src/wast-lexer.cc"
		{ OPCODE(I32Mul); RETURN(BINARY); }
#line 4040 "src/prebuilt/wast-lexer-gen.cc"
yy676:
		yych = *++cursor_;
		if (yych == 'c') goto yy798;
		goto yy87;
yy677:
		yych = *++cursor_;
		if (yych == 'n') goto yy799;
		goto yy87;
yy678:
		yych = *++cursor_;
		if (yych == '_') goto yy800;
		goto yy87;
yy679:
		yych = *++cursor_;
		if (yych == 'l') goto yy801;
		if (yych == 'r') goto yy803;
		goto yy87;
yy680:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 350 "src/wast-lexer.cc"
		{ OPCODE(I32Shl); RETURN(BINARY); }
#line 4065 "src/prebuilt/wast-lexer-gen.cc"
yy682:
		yych = *++cursor_;
		if (yych == '_') goto yy805;
		goto yy87;
yy683:
		yych = *++cursor_;
		if (yych == 'r') goto yy806;
		goto yy87;
yy684:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 332 "src/wast-lexer.cc"
		{ OPCODE(I32Sub); RETURN(BINARY); }
#line 4081 "src/prebuilt/wast-lexer-gen.cc"
yy686:
		yych = *++cursor_;
		if (yych == 'n') goto yy807;
		goto yy87;
yy687:
		yych = *++cursor_;
		if (yych == 'p') goto yy808;
		goto yy87;
yy688:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 348 "src/wast-lexer.cc"
		{ OPCODE(I32Xor); RETURN(BINARY); }
#line 4097 "src/prebuilt/wast-lexer-gen.cc"
yy690:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 331 "src/wast-lexer.cc"
		{ OPCODE(I64Add); RETURN(BINARY); }
#line 4105 "src/prebuilt/wast-lexer-gen.cc"
yy692:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 345 "src/wast-lexer.cc"
		{ OPCODE(I64And); RETURN(BINARY); }
#line 4113 "src/prebuilt/wast-lexer-gen.cc"
yy694:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 311 "src/wast-lexer.cc"
		{ OPCODE(I64Clz); RETURN(UNARY); }
#line 4121 "src/prebuilt/wast-lexer-gen.cc"
yy696:
		yych = *++cursor_;
		if (yych == 's') goto yy809;
		goto yy87;
yy697:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 313 "src/wast-lexer.cc"
		{ OPCODE(I64Ctz); RETURN(UNARY); }
#line 4133 "src/prebuilt/wast-lexer-gen.cc"
yy699:
		yych = *++cursor_;
		if (yych == '_') goto yy810;
		goto yy87;
yy700:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 309 "src/wast-lexer.cc"
		{ OPCODE(I64Eqz); RETURN(CONVERT); }
#line 4145 "src/prebuilt/wast-lexer-gen.cc"
yy702:
		yych = *++cursor_;
		if (yych == 'e') goto yy811;
		goto yy87;
yy703:
		yych = *++cursor_;
		if (yych == 's') goto yy812;
		if (yych == 'u') goto yy814;
		goto yy87;
yy704:
		yych = *++cursor_;
		if (yych == 's') goto yy816;
		if (yych == 'u') goto yy818;
		goto yy87;
yy705:
		yych = *++cursor_;
		if (yych == 's') goto yy820;
		if (yych == 'u') goto yy822;
		goto yy87;
yy706:
		yych = *++cursor_;
		if (yych == 'd') goto yy824;
		goto yy87;
yy707:
		yych = *++cursor_;
		if (yych == 's') goto yy826;
		if (yych == 'u') goto yy828;
		goto yy87;
yy708:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 335 "src/wast-lexer.cc"
		{ OPCODE(I64Mul); RETURN(BINARY); }
#line 4181 "src/prebuilt/wast-lexer-gen.cc"
yy710:
		yych = *++cursor_;
		if (yych == 'c') goto yy830;
		goto yy87;
yy711:
		yych = *++cursor_;
		if (yych == 'n') goto yy831;
		goto yy87;
yy712:
		yych = *++cursor_;
		if (yych == '_') goto yy832;
		goto yy87;
yy713:
		yych = *++cursor_;
		if (yych == 'l') goto yy833;
		if (yych == 'r') goto yy835;
		goto yy87;
yy714:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 351 "src/wast-lexer.cc"
		{ OPCODE(I64Shl); RETURN(BINARY); }
#line 4206 "src/prebuilt/wast-lexer-gen.cc"
yy716:
		yych = *++cursor_;
		if (yych == '_') goto yy837;
		goto yy87;
yy717:
		yych = *++cursor_;
		if (yych == 'r') goto yy838;
		goto yy87;
yy718:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 333 "src/wast-lexer.cc"
		{ OPCODE(I64Sub); RETURN(BINARY); }
#line 4222 "src/prebuilt/wast-lexer-gen.cc"
yy720:
		yych = *++cursor_;
		if (yych == 'n') goto yy839;
		goto yy87;
yy721:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 349 "src/wast-lexer.cc"
		{ OPCODE(I64Xor); RETURN(BINARY); }
#line 4234 "src/prebuilt/wast-lexer-gen.cc"
yy723:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy253;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy253;
				if (yych <= '/') goto yy86;
				goto yy723;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy253;
				if (yych <= '@') goto yy86;
				goto yy723;
			} else {
				if (yych <= '`') goto yy86;
				if (yych <= 'f') goto yy723;
				if (yych <= '~') goto yy86;
				goto yy253;
			}
		}
yy725:
		yych = *++cursor_;
		if (yych <= '/') goto yy87;
		if (yych <= '0') goto yy840;
		if (yych <= '9') goto yy842;
		goto yy87;
yy726:
		yych = *++cursor_;
		if (yych == 'r') goto yy844;
		goto yy87;
yy727:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 470 "src/wast-lexer.cc"
		{ RETURN(RETHROW); }
#line 4278 "src/prebuilt/wast-lexer-gen.cc"
yy729:
		yych = *++cursor_;
		if (yych == 'b') goto yy846;
		goto yy87;
yy730:
		yych = *++cursor_;
		if (yych == 'a') goto yy847;
		goto yy87;
yy731:
		yych = *++cursor_;
		if (yych == 'a') goto yy848;
		goto yy87;
yy732:
		yych = *++cursor_;
		if (yych == 'a') goto yy849;
		goto yy87;
yy733:
		yych = *++cursor_;
		if (yych <= '@') {
			if (yych <= '/') goto yy87;
			if (yych <= '9') goto yy850;
			goto yy87;
		} else {
			if (yych <= 'F') goto yy850;
			if (yych <= '`') goto yy87;
			if (yych <= 'f') goto yy850;
			goto yy87;
		}
yy734:
		yych = *++cursor_;
		if (yych == 'x') goto yy852;
		goto yy87;
yy735:
		yych = *++cursor_;
		if (yych == 'n') goto yy853;
		goto yy87;
yy736:
		yych = *++cursor_;
		if (yych == 'a') goto yy854;
		goto yy87;
yy737:
		yych = *++cursor_;
		if (yych == 'e') goto yy855;
		goto yy87;
yy738:
		yych = *++cursor_;
		if (yych == 'r') goto yy856;
		goto yy87;
yy739:
		yych = *++cursor_;
		if (yych == 'n') goto yy857;
		goto yy87;
yy740:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 268 "src/wast-lexer.cc"
		{ RETURN(BR_TABLE); }
#line 4338 "src/prebuilt/wast-lexer-gen.cc"
yy742:
		yych = *++cursor_;
		if (yych == 'i') goto yy858;
		goto yy87;
yy743:
		yych = *++cursor_;
		if (yych == 'l') goto yy859;
		goto yy87;
yy744:
		yych = *++cursor_;
		if (yych == 'm') goto yy861;
		goto yy87;
yy745:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 322 "src/wast-lexer.cc"
		{ OPCODE(F32Ceil); RETURN(UNARY); }
#line 4358 "src/prebuilt/wast-lexer-gen.cc"
yy747:
		yych = *++cursor_;
		if (yych == 't') goto yy862;
		goto yy87;
yy748:
		yych = *++cursor_;
		if (yych == 'e') goto yy864;
		goto yy87;
yy749:
		yych = *++cursor_;
		if (yych == 's') goto yy865;
		goto yy87;
yy750:
		yych = *++cursor_;
		if (yych == 't') goto yy866;
		goto yy87;
yy751:
		yych = *++cursor_;
		if (yych == 'r') goto yy867;
		goto yy87;
yy752:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 281 "src/wast-lexer.cc"
		{ OPCODE(F32Load); RETURN(LOAD); }
#line 4386 "src/prebuilt/wast-lexer-gen.cc"
yy754:
		yych = *++cursor_;
		if (yych == 'e') goto yy869;
		goto yy87;
yy755:
		yych = *++cursor_;
		if (yych == 't') goto yy870;
		goto yy87;
yy756:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 320 "src/wast-lexer.cc"
		{ OPCODE(F32Sqrt); RETURN(UNARY); }
#line 4402 "src/prebuilt/wast-lexer-gen.cc"
yy758:
		yych = *++cursor_;
		if (yych == 'e') goto yy871;
		goto yy87;
yy759:
		yych = *++cursor_;
		if (yych == 'c') goto yy873;
		goto yy87;
yy760:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 323 "src/wast-lexer.cc"
		{ OPCODE(F64Ceil); RETURN(UNARY); }
#line 4418 "src/prebuilt/wast-lexer-gen.cc"
yy762:
		yych = *++cursor_;
		if (yych == 't') goto yy875;
		goto yy87;
yy763:
		yych = *++cursor_;
		if (yych == 'e') goto yy877;
		goto yy87;
yy764:
		yych = *++cursor_;
		if (yych == 's') goto yy878;
		goto yy87;
yy765:
		yych = *++cursor_;
		if (yych == 'r') goto yy879;
		goto yy87;
yy766:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 282 "src/wast-lexer.cc"
		{ OPCODE(F64Load); RETURN(LOAD); }
#line 4442 "src/prebuilt/wast-lexer-gen.cc"
yy768:
		yych = *++cursor_;
		if (yych == 'e') goto yy881;
		goto yy87;
yy769:
		yych = *++cursor_;
		if (yych == 'o') goto yy882;
		goto yy87;
yy770:
		yych = *++cursor_;
		if (yych == 't') goto yy883;
		goto yy87;
yy771:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 321 "src/wast-lexer.cc"
		{ OPCODE(F64Sqrt); RETURN(UNARY); }
#line 4462 "src/prebuilt/wast-lexer-gen.cc"
yy773:
		yych = *++cursor_;
		if (yych == 'e') goto yy884;
		goto yy87;
yy774:
		yych = *++cursor_;
		if (yych == 'c') goto yy886;
		goto yy87;
yy775:
		yych = *++cursor_;
		if (yych == 'a') goto yy888;
		goto yy87;
yy776:
		yych = *++cursor_;
		if (yych == 'l') goto yy889;
		goto yy87;
yy777:
		yych = *++cursor_;
		if (yych == 'o') goto yy891;
		goto yy87;
yy778:
		yych = *++cursor_;
		if (yych == 't') goto yy892;
		goto yy87;
yy779:
		yych = *++cursor_;
		if (yych == 's') goto yy894;
		if (yych == 'u') goto yy896;
		goto yy87;
yy780:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 390 "src/wast-lexer.cc"
		{ OPCODE(I32GeS); RETURN(COMPARE); }
#line 4499 "src/prebuilt/wast-lexer-gen.cc"
yy782:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 392 "src/wast-lexer.cc"
		{ OPCODE(I32GeU); RETURN(COMPARE); }
#line 4507 "src/prebuilt/wast-lexer-gen.cc"
yy784:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 386 "src/wast-lexer.cc"
		{ OPCODE(I32GtS); RETURN(COMPARE); }
#line 4515 "src/prebuilt/wast-lexer-gen.cc"
yy786:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 388 "src/wast-lexer.cc"
		{ OPCODE(I32GtU); RETURN(COMPARE); }
#line 4523 "src/prebuilt/wast-lexer-gen.cc"
yy788:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 382 "src/wast-lexer.cc"
		{ OPCODE(I32LeS); RETURN(COMPARE); }
#line 4531 "src/prebuilt/wast-lexer-gen.cc"
yy790:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 384 "src/wast-lexer.cc"
		{ OPCODE(I32LeU); RETURN(COMPARE); }
#line 4539 "src/prebuilt/wast-lexer-gen.cc"
yy792:
		++cursor_;
		if ((yych = *cursor_) <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy898;
				if (yych <= '7') goto yy86;
				goto yy899;
			} else {
				if (yych == ';') goto yy793;
				if (yych <= '~') goto yy86;
			}
		}
yy793:
#line 279 "src/wast-lexer.cc"
		{ OPCODE(I32Load); RETURN(LOAD); }
#line 4562 "src/prebuilt/wast-lexer-gen.cc"
yy794:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 378 "src/wast-lexer.cc"
		{ OPCODE(I32LtS); RETURN(COMPARE); }
#line 4570 "src/prebuilt/wast-lexer-gen.cc"
yy796:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 380 "src/wast-lexer.cc"
		{ OPCODE(I32LtU); RETURN(COMPARE); }
#line 4578 "src/prebuilt/wast-lexer-gen.cc"
yy798:
		yych = *++cursor_;
		if (yych == 'n') goto yy900;
		goto yy87;
yy799:
		yych = *++cursor_;
		if (yych == 't') goto yy901;
		goto yy87;
yy800:
		yych = *++cursor_;
		if (yych == 's') goto yy902;
		if (yych == 'u') goto yy904;
		goto yy87;
yy801:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 356 "src/wast-lexer.cc"
		{ OPCODE(I32Rotl); RETURN(BINARY); }
#line 4599 "src/prebuilt/wast-lexer-gen.cc"
yy803:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 358 "src/wast-lexer.cc"
		{ OPCODE(I32Rotr); RETURN(BINARY); }
#line 4607 "src/prebuilt/wast-lexer-gen.cc"
yy805:
		yych = *++cursor_;
		if (yych == 's') goto yy906;
		if (yych == 'u') goto yy908;
		goto yy87;
yy806:
		yych = *++cursor_;
		if (yych == 'e') goto yy910;
		goto yy87;
yy807:
		yych = *++cursor_;
		if (yych == 'c') goto yy912;
		goto yy87;
yy808:
		yych = *++cursor_;
		if (yych == '/') goto yy913;
		goto yy87;
yy809:
		yych = *++cursor_;
		if (yych == 't') goto yy914;
		goto yy87;
yy810:
		yych = *++cursor_;
		if (yych == 's') goto yy916;
		if (yych == 'u') goto yy918;
		goto yy87;
yy811:
		yych = *++cursor_;
		if (yych == 'n') goto yy920;
		goto yy87;
yy812:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 391 "src/wast-lexer.cc"
		{ OPCODE(I64GeS); RETURN(COMPARE); }
#line 4645 "src/prebuilt/wast-lexer-gen.cc"
yy814:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 393 "src/wast-lexer.cc"
		{ OPCODE(I64GeU); RETURN(COMPARE); }
#line 4653 "src/prebuilt/wast-lexer-gen.cc"
yy816:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 387 "src/wast-lexer.cc"
		{ OPCODE(I64GtS); RETURN(COMPARE); }
#line 4661 "src/prebuilt/wast-lexer-gen.cc"
yy818:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 389 "src/wast-lexer.cc"
		{ OPCODE(I64GtU); RETURN(COMPARE); }
#line 4669 "src/prebuilt/wast-lexer-gen.cc"
yy820:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 383 "src/wast-lexer.cc"
		{ OPCODE(I64LeS); RETURN(COMPARE); }
#line 4677 "src/prebuilt/wast-lexer-gen.cc"
yy822:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 385 "src/wast-lexer.cc"
		{ OPCODE(I64LeU); RETURN(COMPARE); }
#line 4685 "src/prebuilt/wast-lexer-gen.cc"
yy824:
		++cursor_;
		if ((yych = *cursor_) <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy825;
				if (yych <= '0') goto yy86;
				goto yy921;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy922;
				if (yych <= '7') goto yy86;
				goto yy923;
			} else {
				if (yych == ';') goto yy825;
				if (yych <= '~') goto yy86;
			}
		}
yy825:
#line 280 "src/wast-lexer.cc"
		{ OPCODE(I64Load); RETURN(LOAD); }
#line 4710 "src/prebuilt/wast-lexer-gen.cc"
yy826:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 379 "src/wast-lexer.cc"
		{ OPCODE(I64LtS); RETURN(COMPARE); }
#line 4718 "src/prebuilt/wast-lexer-gen.cc"
yy828:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 381 "src/wast-lexer.cc"
		{ OPCODE(I64LtU); RETURN(COMPARE); }
#line 4726 "src/prebuilt/wast-lexer-gen.cc"
yy830:
		yych = *++cursor_;
		if (yych == 'n') goto yy924;
		goto yy87;
yy831:
		yych = *++cursor_;
		if (yych == 't') goto yy925;
		goto yy87;
yy832:
		yych = *++cursor_;
		if (yych == 's') goto yy926;
		if (yych == 'u') goto yy928;
		goto yy87;
yy833:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 357 "src/wast-lexer.cc"
		{ OPCODE(I64Rotl); RETURN(BINARY); }
#line 4747 "src/prebuilt/wast-lexer-gen.cc"
yy835:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 359 "src/wast-lexer.cc"
		{ OPCODE(I64Rotr); RETURN(BINARY); }
#line 4755 "src/prebuilt/wast-lexer-gen.cc"
yy837:
		yych = *++cursor_;
		if (yych == 's') goto yy930;
		if (yych == 'u') goto yy932;
		goto yy87;
yy838:
		yych = *++cursor_;
		if (yych == 'e') goto yy934;
		goto yy87;
yy839:
		yych = *++cursor_;
		if (yych == 'c') goto yy936;
		goto yy87;
yy840:
		++cursor_;
		if ((yych = *cursor_) <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy842;
				if (yych <= ':') goto yy86;
			} else {
				if (yych == 'x') goto yy937;
				if (yych <= '~') goto yy86;
			}
		}
yy841:
#line 302 "src/wast-lexer.cc"
		{ TEXT_AT(7); RETURN(OFFSET_EQ_NAT); }
#line 4790 "src/prebuilt/wast-lexer-gen.cc"
yy842:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy841;
				goto yy86;
			} else {
				if (yych <= '"') goto yy841;
				if (yych <= '\'') goto yy86;
				goto yy841;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy86;
				if (yych <= '9') goto yy842;
				goto yy86;
			} else {
				if (yych <= ';') goto yy841;
				if (yych <= '~') goto yy86;
				goto yy841;
			}
		}
yy844:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 453 "src/wast-lexer.cc"
		{ RETURN(REGISTER); }
#line 4822 "src/prebuilt/wast-lexer-gen.cc"
yy846:
		yych = *++cursor_;
		if (yych == 'a') goto yy938;
		goto yy87;
yy847:
		yych = *++cursor_;
		if (yych == 'l') goto yy939;
		goto yy87;
yy848:
		yych = *++cursor_;
		if (yych == 'l') goto yy941;
		goto yy87;
yy849:
		yych = *++cursor_;
		if (yych == 'b') goto yy943;
		goto yy87;
yy850:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy590;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy590;
				if (yych <= '/') goto yy86;
				goto yy850;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy590;
				if (yych <= '@') goto yy86;
				goto yy850;
			} else {
				if (yych <= '`') goto yy86;
				if (yych <= 'f') goto yy850;
				if (yych <= '~') goto yy86;
				goto yy590;
			}
		}
yy852:
		yych = *++cursor_;
		if (yych == 'h') goto yy944;
		goto yy87;
yy853:
		yych = *++cursor_;
		if (yych == 'v') goto yy945;
		goto yy87;
yy854:
		yych = *++cursor_;
		if (yych == 'l') goto yy946;
		goto yy87;
yy855:
		yych = *++cursor_;
		if (yych == 't') goto yy947;
		goto yy87;
yy856:
		yych = *++cursor_;
		if (yych == 'a') goto yy948;
		goto yy87;
yy857:
		yych = *++cursor_;
		if (yych == 'l') goto yy949;
		goto yy87;
yy858:
		yych = *++cursor_;
		if (yych == 'r') goto yy950;
		goto yy87;
yy859:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 468 "src/wast-lexer.cc"
		{ RETURN(CATCH_ALL); }
#line 4900 "src/prebuilt/wast-lexer-gen.cc"
yy861:
		yych = *++cursor_;
		if (yych == 'e') goto yy951;
		goto yy87;
yy862:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 306 "src/wast-lexer.cc"
		{ TYPE(F32); RETURN(CONST); }
#line 4912 "src/prebuilt/wast-lexer-gen.cc"
yy864:
		yych = *++cursor_;
		if (yych == 'r') goto yy952;
		goto yy87;
yy865:
		yych = *++cursor_;
		if (yych == 'i') goto yy953;
		goto yy87;
yy866:
		yych = *++cursor_;
		if (yych == 'e') goto yy954;
		goto yy87;
yy867:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 324 "src/wast-lexer.cc"
		{ OPCODE(F32Floor); RETURN(UNARY); }
#line 4932 "src/prebuilt/wast-lexer-gen.cc"
yy869:
		yych = *++cursor_;
		if (yych == 's') goto yy955;
		goto yy87;
yy870:
		yych = *++cursor_;
		if (yych == 'e') goto yy956;
		goto yy87;
yy871:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 285 "src/wast-lexer.cc"
		{ OPCODE(F32Store); RETURN(STORE); }
#line 4948 "src/prebuilt/wast-lexer-gen.cc"
yy873:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 326 "src/wast-lexer.cc"
		{ OPCODE(F32Trunc); RETURN(UNARY); }
#line 4956 "src/prebuilt/wast-lexer-gen.cc"
yy875:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 307 "src/wast-lexer.cc"
		{ TYPE(F64); RETURN(CONST); }
#line 4964 "src/prebuilt/wast-lexer-gen.cc"
yy877:
		yych = *++cursor_;
		if (yych == 'r') goto yy957;
		goto yy87;
yy878:
		yych = *++cursor_;
		if (yych == 'i') goto yy958;
		goto yy87;
yy879:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 325 "src/wast-lexer.cc"
		{ OPCODE(F64Floor); RETURN(UNARY); }
#line 4980 "src/prebuilt/wast-lexer-gen.cc"
yy881:
		yych = *++cursor_;
		if (yych == 's') goto yy959;
		goto yy87;
yy882:
		yych = *++cursor_;
		if (yych == 't') goto yy960;
		goto yy87;
yy883:
		yych = *++cursor_;
		if (yych == 'e') goto yy961;
		goto yy87;
yy884:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 286 "src/wast-lexer.cc"
		{ OPCODE(F64Store); RETURN(STORE); }
#line 5000 "src/prebuilt/wast-lexer-gen.cc"
yy886:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 327 "src/wast-lexer.cc"
		{ OPCODE(F64Trunc); RETURN(UNARY); }
#line 5008 "src/prebuilt/wast-lexer-gen.cc"
yy888:
		yych = *++cursor_;
		if (yych == 'l') goto yy962;
		goto yy87;
yy889:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 274 "src/wast-lexer.cc"
		{ RETURN(GET_LOCAL); }
#line 5020 "src/prebuilt/wast-lexer-gen.cc"
yy891:
		yych = *++cursor_;
		if (yych == 'r') goto yy964;
		goto yy87;
yy892:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 304 "src/wast-lexer.cc"
		{ TYPE(I32); RETURN(CONST); }
#line 5032 "src/prebuilt/wast-lexer-gen.cc"
yy894:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 336 "src/wast-lexer.cc"
		{ OPCODE(I32DivS); RETURN(BINARY); }
#line 5040 "src/prebuilt/wast-lexer-gen.cc"
yy896:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 338 "src/wast-lexer.cc"
		{ OPCODE(I32DivU); RETURN(BINARY); }
#line 5048 "src/prebuilt/wast-lexer-gen.cc"
yy898:
		yych = *++cursor_;
		if (yych == '6') goto yy965;
		goto yy87;
yy899:
		yych = *++cursor_;
		if (yych == '_') goto yy966;
		goto yy87;
yy900:
		yych = *++cursor_;
		if (yych == 't') goto yy967;
		goto yy87;
yy901:
		yych = *++cursor_;
		if (yych == 'e') goto yy969;
		goto yy87;
yy902:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 340 "src/wast-lexer.cc"
		{ OPCODE(I32RemS); RETURN(BINARY); }
#line 5072 "src/prebuilt/wast-lexer-gen.cc"
yy904:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 342 "src/wast-lexer.cc"
		{ OPCODE(I32RemU); RETURN(BINARY); }
#line 5080 "src/prebuilt/wast-lexer-gen.cc"
yy906:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 352 "src/wast-lexer.cc"
		{ OPCODE(I32ShrS); RETURN(BINARY); }
#line 5088 "src/prebuilt/wast-lexer-gen.cc"
yy908:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 354 "src/wast-lexer.cc"
		{ OPCODE(I32ShrU); RETURN(BINARY); }
#line 5096 "src/prebuilt/wast-lexer-gen.cc"
yy910:
		++cursor_;
		if ((yych = *cursor_) <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych >= '*') goto yy86;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy970;
				if (yych <= '7') goto yy86;
				goto yy971;
			} else {
				if (yych == ';') goto yy911;
				if (yych <= '~') goto yy86;
			}
		}
yy911:
#line 283 "src/wast-lexer.cc"
		{ OPCODE(I32Store); RETURN(STORE); }
#line 5119 "src/prebuilt/wast-lexer-gen.cc"
yy912:
		yych = *++cursor_;
		if (yych == '_') goto yy973;
		goto yy87;
yy913:
		yych = *++cursor_;
		if (yych == 'i') goto yy974;
		goto yy87;
yy914:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 305 "src/wast-lexer.cc"
		{ TYPE(I64); RETURN(CONST); }
#line 5135 "src/prebuilt/wast-lexer-gen.cc"
yy916:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 337 "src/wast-lexer.cc"
		{ OPCODE(I64DivS); RETURN(BINARY); }
#line 5143 "src/prebuilt/wast-lexer-gen.cc"
yy918:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 339 "src/wast-lexer.cc"
		{ OPCODE(I64DivU); RETURN(BINARY); }
#line 5151 "src/prebuilt/wast-lexer-gen.cc"
yy920:
		yych = *++cursor_;
		if (yych == 'd') goto yy975;
		goto yy87;
yy921:
		yych = *++cursor_;
		if (yych == '6') goto yy976;
		goto yy87;
yy922:
		yych = *++cursor_;
		if (yych == '2') goto yy977;
		goto yy87;
yy923:
		yych = *++cursor_;
		if (yych == '_') goto yy978;
		goto yy87;
yy924:
		yych = *++cursor_;
		if (yych == 't') goto yy979;
		goto yy87;
yy925:
		yych = *++cursor_;
		if (yych == 'e') goto yy981;
		goto yy87;
yy926:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 341 "src/wast-lexer.cc"
		{ OPCODE(I64RemS); RETURN(BINARY); }
#line 5183 "src/prebuilt/wast-lexer-gen.cc"
yy928:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 343 "src/wast-lexer.cc"
		{ OPCODE(I64RemU); RETURN(BINARY); }
#line 5191 "src/prebuilt/wast-lexer-gen.cc"
yy930:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 353 "src/wast-lexer.cc"
		{ OPCODE(I64ShrS); RETURN(BINARY); }
#line 5199 "src/prebuilt/wast-lexer-gen.cc"
yy932:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 355 "src/wast-lexer.cc"
		{ OPCODE(I64ShrU); RETURN(BINARY); }
#line 5207 "src/prebuilt/wast-lexer-gen.cc"
yy934:
		++cursor_;
		if ((yych = *cursor_) <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy935;
				if (yych <= '0') goto yy86;
				goto yy982;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy983;
				if (yych <= '7') goto yy86;
				goto yy984;
			} else {
				if (yych == ';') goto yy935;
				if (yych <= '~') goto yy86;
			}
		}
yy935:
#line 284 "src/wast-lexer.cc"
		{ OPCODE(I64Store); RETURN(STORE); }
#line 5232 "src/prebuilt/wast-lexer-gen.cc"
yy936:
		yych = *++cursor_;
		if (yych == '_') goto yy986;
		goto yy87;
yy937:
		yych = *++cursor_;
		if (yych <= '@') {
			if (yych <= '/') goto yy87;
			if (yych <= '9') goto yy987;
			goto yy87;
		} else {
			if (yych <= 'F') goto yy987;
			if (yych <= '`') goto yy87;
			if (yych <= 'f') goto yy987;
			goto yy87;
		}
yy938:
		yych = *++cursor_;
		if (yych == 'l') goto yy989;
		goto yy87;
yy939:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 275 "src/wast-lexer.cc"
		{ RETURN(SET_LOCAL); }
#line 5260 "src/prebuilt/wast-lexer-gen.cc"
yy941:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 276 "src/wast-lexer.cc"
		{ RETURN(TEE_LOCAL); }
#line 5268 "src/prebuilt/wast-lexer-gen.cc"
yy943:
		yych = *++cursor_;
		if (yych == 'l') goto yy991;
		goto yy87;
yy944:
		yych = *++cursor_;
		if (yych == 'a') goto yy992;
		goto yy87;
yy945:
		yych = *++cursor_;
		if (yych == 'a') goto yy993;
		goto yy87;
yy946:
		yych = *++cursor_;
		if (yych == 'f') goto yy994;
		goto yy87;
yy947:
		yych = *++cursor_;
		if (yych == 'u') goto yy995;
		goto yy87;
yy948:
		yych = *++cursor_;
		if (yych == 'p') goto yy996;
		goto yy87;
yy949:
		yych = *++cursor_;
		if (yych == 'i') goto yy998;
		goto yy87;
yy950:
		yych = *++cursor_;
		if (yych == 'e') goto yy999;
		goto yy87;
yy951:
		yych = *++cursor_;
		if (yych == 'm') goto yy1000;
		goto yy87;
yy952:
		yych = *++cursor_;
		if (yych == 't') goto yy1001;
		goto yy87;
yy953:
		yych = *++cursor_;
		if (yych == 'g') goto yy1002;
		goto yy87;
yy954:
		yych = *++cursor_;
		if (yych == '/') goto yy1003;
		goto yy87;
yy955:
		yych = *++cursor_;
		if (yych == 't') goto yy1004;
		goto yy87;
yy956:
		yych = *++cursor_;
		if (yych == 'r') goto yy1006;
		goto yy87;
yy957:
		yych = *++cursor_;
		if (yych == 't') goto yy1007;
		goto yy87;
yy958:
		yych = *++cursor_;
		if (yych == 'g') goto yy1008;
		goto yy87;
yy959:
		yych = *++cursor_;
		if (yych == 't') goto yy1009;
		goto yy87;
yy960:
		yych = *++cursor_;
		if (yych == 'e') goto yy1011;
		goto yy87;
yy961:
		yych = *++cursor_;
		if (yych == 'r') goto yy1012;
		goto yy87;
yy962:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 277 "src/wast-lexer.cc"
		{ RETURN(GET_GLOBAL); }
#line 5352 "src/prebuilt/wast-lexer-gen.cc"
yy964:
		yych = *++cursor_;
		if (yych == 'y') goto yy1013;
		goto yy87;
yy965:
		yych = *++cursor_;
		if (yych == '_') goto yy1015;
		goto yy87;
yy966:
		yych = *++cursor_;
		if (yych == 's') goto yy1016;
		if (yych == 'u') goto yy1018;
		goto yy87;
yy967:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 314 "src/wast-lexer.cc"
		{ OPCODE(I32Popcnt); RETURN(UNARY); }
#line 5373 "src/prebuilt/wast-lexer-gen.cc"
yy969:
		yych = *++cursor_;
		if (yych == 'r') goto yy1020;
		goto yy87;
yy970:
		yych = *++cursor_;
		if (yych == '6') goto yy1021;
		goto yy87;
yy971:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 297 "src/wast-lexer.cc"
		{ OPCODE(I32Store8); RETURN(STORE); }
#line 5389 "src/prebuilt/wast-lexer-gen.cc"
yy973:
		yych = *++cursor_;
		if (yych == 's') goto yy1023;
		if (yych == 'u') goto yy1024;
		goto yy87;
yy974:
		yych = *++cursor_;
		if (yych == '6') goto yy1025;
		goto yy87;
yy975:
		yych = *++cursor_;
		if (yych == '_') goto yy1026;
		goto yy87;
yy976:
		yych = *++cursor_;
		if (yych == '_') goto yy1027;
		goto yy87;
yy977:
		yych = *++cursor_;
		if (yych == '_') goto yy1028;
		goto yy87;
yy978:
		yych = *++cursor_;
		if (yych == 's') goto yy1029;
		if (yych == 'u') goto yy1031;
		goto yy87;
yy979:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 315 "src/wast-lexer.cc"
		{ OPCODE(I64Popcnt); RETURN(UNARY); }
#line 5423 "src/prebuilt/wast-lexer-gen.cc"
yy981:
		yych = *++cursor_;
		if (yych == 'r') goto yy1033;
		goto yy87;
yy982:
		yych = *++cursor_;
		if (yych == '6') goto yy1034;
		goto yy87;
yy983:
		yych = *++cursor_;
		if (yych == '2') goto yy1036;
		goto yy87;
yy984:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 298 "src/wast-lexer.cc"
		{ OPCODE(I64Store8); RETURN(STORE); }
#line 5443 "src/prebuilt/wast-lexer-gen.cc"
yy986:
		yych = *++cursor_;
		if (yych == 's') goto yy1038;
		if (yych == 'u') goto yy1039;
		goto yy87;
yy987:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy86;
				goto yy841;
			} else {
				if (yych <= '\'') goto yy86;
				if (yych <= ')') goto yy841;
				if (yych <= '/') goto yy86;
				goto yy987;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy841;
				if (yych <= '@') goto yy86;
				goto yy987;
			} else {
				if (yych <= '`') goto yy86;
				if (yych <= 'f') goto yy987;
				if (yych <= '~') goto yy86;
				goto yy841;
			}
		}
yy989:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 278 "src/wast-lexer.cc"
		{ RETURN(SET_GLOBAL); }
#line 5482 "src/prebuilt/wast-lexer-gen.cc"
yy991:
		yych = *++cursor_;
		if (yych == 'e') goto yy1040;
		goto yy87;
yy992:
		yych = *++cursor_;
		if (yych == 'u') goto yy1042;
		goto yy87;
yy993:
		yych = *++cursor_;
		if (yych == 'l') goto yy1043;
		goto yy87;
yy994:
		yych = *++cursor_;
		if (yych == 'o') goto yy1044;
		goto yy87;
yy995:
		yych = *++cursor_;
		if (yych == 'r') goto yy1045;
		goto yy87;
yy996:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 464 "src/wast-lexer.cc"
		{ RETURN(ASSERT_TRAP); }
#line 5510 "src/prebuilt/wast-lexer-gen.cc"
yy998:
		yych = *++cursor_;
		if (yych == 'n') goto yy1046;
		goto yy87;
yy999:
		yych = *++cursor_;
		if (yych == 'c') goto yy1047;
		goto yy87;
yy1000:
		yych = *++cursor_;
		if (yych == 'o') goto yy1048;
		goto yy87;
yy1001:
		yych = *++cursor_;
		if (yych == '_') goto yy1049;
		goto yy87;
yy1002:
		yych = *++cursor_;
		if (yych == 'n') goto yy1050;
		goto yy87;
yy1003:
		yych = *++cursor_;
		if (yych == 'f') goto yy1052;
		goto yy87;
yy1004:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 328 "src/wast-lexer.cc"
		{ OPCODE(F32Nearest); RETURN(UNARY); }
#line 5542 "src/prebuilt/wast-lexer-gen.cc"
yy1006:
		yych = *++cursor_;
		if (yych == 'p') goto yy1053;
		goto yy87;
yy1007:
		yych = *++cursor_;
		if (yych == '_') goto yy1054;
		goto yy87;
yy1008:
		yych = *++cursor_;
		if (yych == 'n') goto yy1055;
		goto yy87;
yy1009:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 329 "src/wast-lexer.cc"
		{ OPCODE(F64Nearest); RETURN(UNARY); }
#line 5562 "src/prebuilt/wast-lexer-gen.cc"
yy1011:
		yych = *++cursor_;
		if (yych == '/') goto yy1057;
		goto yy87;
yy1012:
		yych = *++cursor_;
		if (yych == 'p') goto yy1058;
		goto yy87;
yy1013:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 434 "src/wast-lexer.cc"
		{ RETURN(GROW_MEMORY); }
#line 5578 "src/prebuilt/wast-lexer-gen.cc"
yy1015:
		yych = *++cursor_;
		if (yych == 's') goto yy1059;
		if (yych == 'u') goto yy1061;
		goto yy87;
yy1016:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 287 "src/wast-lexer.cc"
		{ OPCODE(I32Load8S); RETURN(LOAD); }
#line 5591 "src/prebuilt/wast-lexer-gen.cc"
yy1018:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 289 "src/wast-lexer.cc"
		{ OPCODE(I32Load8U); RETURN(LOAD); }
#line 5599 "src/prebuilt/wast-lexer-gen.cc"
yy1020:
		yych = *++cursor_;
		if (yych == 'p') goto yy1063;
		goto yy87;
yy1021:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 299 "src/wast-lexer.cc"
		{ OPCODE(I32Store16); RETURN(STORE); }
#line 5611 "src/prebuilt/wast-lexer-gen.cc"
yy1023:
		yych = *++cursor_;
		if (yych == '/') goto yy1064;
		goto yy87;
yy1024:
		yych = *++cursor_;
		if (yych == '/') goto yy1065;
		goto yy87;
yy1025:
		yych = *++cursor_;
		if (yych == '4') goto yy1066;
		goto yy87;
yy1026:
		yych = *++cursor_;
		if (yych == 's') goto yy1068;
		if (yych == 'u') goto yy1069;
		goto yy87;
yy1027:
		yych = *++cursor_;
		if (yych == 's') goto yy1070;
		if (yych == 'u') goto yy1072;
		goto yy87;
yy1028:
		yych = *++cursor_;
		if (yych == 's') goto yy1074;
		if (yych == 'u') goto yy1076;
		goto yy87;
yy1029:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 288 "src/wast-lexer.cc"
		{ OPCODE(I64Load8S); RETURN(LOAD); }
#line 5646 "src/prebuilt/wast-lexer-gen.cc"
yy1031:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 290 "src/wast-lexer.cc"
		{ OPCODE(I64Load8U); RETURN(LOAD); }
#line 5654 "src/prebuilt/wast-lexer-gen.cc"
yy1033:
		yych = *++cursor_;
		if (yych == 'p') goto yy1078;
		goto yy87;
yy1034:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 300 "src/wast-lexer.cc"
		{ OPCODE(I64Store16); RETURN(STORE); }
#line 5666 "src/prebuilt/wast-lexer-gen.cc"
yy1036:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 301 "src/wast-lexer.cc"
		{ OPCODE(I64Store32); RETURN(STORE); }
#line 5674 "src/prebuilt/wast-lexer-gen.cc"
yy1038:
		yych = *++cursor_;
		if (yych == '/') goto yy1079;
		goto yy87;
yy1039:
		yych = *++cursor_;
		if (yych == '/') goto yy1080;
		goto yy87;
yy1040:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 432 "src/wast-lexer.cc"
		{ RETURN(UNREACHABLE); }
#line 5690 "src/prebuilt/wast-lexer-gen.cc"
yy1042:
		yych = *++cursor_;
		if (yych == 's') goto yy1081;
		goto yy87;
yy1043:
		yych = *++cursor_;
		if (yych == 'i') goto yy1082;
		goto yy87;
yy1044:
		yych = *++cursor_;
		if (yych == 'r') goto yy1083;
		goto yy87;
yy1045:
		yych = *++cursor_;
		if (yych == 'n') goto yy1084;
		goto yy87;
yy1046:
		yych = *++cursor_;
		if (yych == 'k') goto yy1086;
		goto yy87;
yy1047:
		yych = *++cursor_;
		if (yych == 't') goto yy1087;
		goto yy87;
yy1048:
		yych = *++cursor_;
		if (yych == 'r') goto yy1089;
		goto yy87;
yy1049:
		yych = *++cursor_;
		if (yych == 's') goto yy1090;
		if (yych == 'u') goto yy1091;
		goto yy87;
yy1050:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 372 "src/wast-lexer.cc"
		{ OPCODE(F32Copysign); RETURN(BINARY); }
#line 5731 "src/prebuilt/wast-lexer-gen.cc"
yy1052:
		yych = *++cursor_;
		if (yych == '6') goto yy1092;
		goto yy87;
yy1053:
		yych = *++cursor_;
		if (yych == 'r') goto yy1093;
		goto yy87;
yy1054:
		yych = *++cursor_;
		if (yych == 's') goto yy1094;
		if (yych == 'u') goto yy1095;
		goto yy87;
yy1055:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 373 "src/wast-lexer.cc"
		{ OPCODE(F64Copysign); RETURN(BINARY); }
#line 5752 "src/prebuilt/wast-lexer-gen.cc"
yy1057:
		yych = *++cursor_;
		if (yych == 'f') goto yy1096;
		goto yy87;
yy1058:
		yych = *++cursor_;
		if (yych == 'r') goto yy1097;
		goto yy87;
yy1059:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 291 "src/wast-lexer.cc"
		{ OPCODE(I32Load16S); RETURN(LOAD); }
#line 5768 "src/prebuilt/wast-lexer-gen.cc"
yy1061:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 293 "src/wast-lexer.cc"
		{ OPCODE(I32Load16U); RETURN(LOAD); }
#line 5776 "src/prebuilt/wast-lexer-gen.cc"
yy1063:
		yych = *++cursor_;
		if (yych == 'r') goto yy1098;
		goto yy87;
yy1064:
		yych = *++cursor_;
		if (yych == 'f') goto yy1099;
		goto yy87;
yy1065:
		yych = *++cursor_;
		if (yych == 'f') goto yy1100;
		goto yy87;
yy1066:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 408 "src/wast-lexer.cc"
		{ OPCODE(I32WrapI64); RETURN(CONVERT); }
#line 5796 "src/prebuilt/wast-lexer-gen.cc"
yy1068:
		yych = *++cursor_;
		if (yych == '/') goto yy1101;
		goto yy87;
yy1069:
		yych = *++cursor_;
		if (yych == '/') goto yy1102;
		goto yy87;
yy1070:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 292 "src/wast-lexer.cc"
		{ OPCODE(I64Load16S); RETURN(LOAD); }
#line 5812 "src/prebuilt/wast-lexer-gen.cc"
yy1072:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 294 "src/wast-lexer.cc"
		{ OPCODE(I64Load16U); RETURN(LOAD); }
#line 5820 "src/prebuilt/wast-lexer-gen.cc"
yy1074:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 295 "src/wast-lexer.cc"
		{ OPCODE(I64Load32S); RETURN(LOAD); }
#line 5828 "src/prebuilt/wast-lexer-gen.cc"
yy1076:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 296 "src/wast-lexer.cc"
		{ OPCODE(I64Load32U); RETURN(LOAD); }
#line 5836 "src/prebuilt/wast-lexer-gen.cc"
yy1078:
		yych = *++cursor_;
		if (yych == 'r') goto yy1103;
		goto yy87;
yy1079:
		yych = *++cursor_;
		if (yych == 'f') goto yy1104;
		goto yy87;
yy1080:
		yych = *++cursor_;
		if (yych == 'f') goto yy1105;
		goto yy87;
yy1081:
		yych = *++cursor_;
		if (yych == 't') goto yy1106;
		goto yy87;
yy1082:
		yych = *++cursor_;
		if (yych == 'd') goto yy1107;
		goto yy87;
yy1083:
		yych = *++cursor_;
		if (yych == 'm') goto yy1109;
		goto yy87;
yy1084:
		++cursor_;
		if ((yych = *cursor_) <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy86;
			} else {
				if (yych <= '"') goto yy1085;
				if (yych <= '\'') goto yy86;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy86;
			} else {
				if (yych <= '_') goto yy1110;
				if (yych <= '~') goto yy86;
			}
		}
yy1085:
#line 459 "src/wast-lexer.cc"
		{ RETURN(ASSERT_RETURN); }
#line 5881 "src/prebuilt/wast-lexer-gen.cc"
yy1086:
		yych = *++cursor_;
		if (yych == 'a') goto yy1111;
		goto yy87;
yy1087:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 270 "src/wast-lexer.cc"
		{ RETURN(CALL_INDIRECT); }
#line 5893 "src/prebuilt/wast-lexer-gen.cc"
yy1089:
		yych = *++cursor_;
		if (yych == 'y') goto yy1112;
		goto yy87;
yy1090:
		yych = *++cursor_;
		if (yych == '/') goto yy1114;
		goto yy87;
yy1091:
		yych = *++cursor_;
		if (yych == '/') goto yy1115;
		goto yy87;
yy1092:
		yych = *++cursor_;
		if (yych == '4') goto yy1116;
		goto yy87;
yy1093:
		yych = *++cursor_;
		if (yych == 'e') goto yy1118;
		goto yy87;
yy1094:
		yych = *++cursor_;
		if (yych == '/') goto yy1119;
		goto yy87;
yy1095:
		yych = *++cursor_;
		if (yych == '/') goto yy1120;
		goto yy87;
yy1096:
		yych = *++cursor_;
		if (yych == '3') goto yy1121;
		goto yy87;
yy1097:
		yych = *++cursor_;
		if (yych == 'e') goto yy1122;
		goto yy87;
yy1098:
		yych = *++cursor_;
		if (yych == 'e') goto yy1123;
		goto yy87;
yy1099:
		yych = *++cursor_;
		if (yych == '3') goto yy1124;
		if (yych == '6') goto yy1125;
		goto yy87;
yy1100:
		yych = *++cursor_;
		if (yych == '3') goto yy1126;
		if (yych == '6') goto yy1127;
		goto yy87;
yy1101:
		yych = *++cursor_;
		if (yych == 'i') goto yy1128;
		goto yy87;
yy1102:
		yych = *++cursor_;
		if (yych == 'i') goto yy1129;
		goto yy87;
yy1103:
		yych = *++cursor_;
		if (yych == 'e') goto yy1130;
		goto yy87;
yy1104:
		yych = *++cursor_;
		if (yych == '3') goto yy1131;
		if (yych == '6') goto yy1132;
		goto yy87;
yy1105:
		yych = *++cursor_;
		if (yych == '3') goto yy1133;
		if (yych == '6') goto yy1134;
		goto yy87;
yy1106:
		yych = *++cursor_;
		if (yych == 'i') goto yy1135;
		goto yy87;
yy1107:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 457 "src/wast-lexer.cc"
		{ RETURN(ASSERT_INVALID); }
#line 5977 "src/prebuilt/wast-lexer-gen.cc"
yy1109:
		yych = *++cursor_;
		if (yych == 'e') goto yy1136;
		goto yy87;
yy1110:
		yych = *++cursor_;
		if (yych == 'a') goto yy1137;
		if (yych == 'c') goto yy1138;
		goto yy87;
yy1111:
		yych = *++cursor_;
		if (yych == 'b') goto yy1139;
		goto yy87;
yy1112:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 433 "src/wast-lexer.cc"
		{ RETURN(CURRENT_MEMORY); }
#line 5998 "src/prebuilt/wast-lexer-gen.cc"
yy1114:
		yych = *++cursor_;
		if (yych == 'i') goto yy1140;
		goto yy87;
yy1115:
		yych = *++cursor_;
		if (yych == 'i') goto yy1141;
		goto yy87;
yy1116:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 426 "src/wast-lexer.cc"
		{ OPCODE(F32DemoteF64); RETURN(CONVERT); }
#line 6014 "src/prebuilt/wast-lexer-gen.cc"
yy1118:
		yych = *++cursor_;
		if (yych == 't') goto yy1142;
		goto yy87;
yy1119:
		yych = *++cursor_;
		if (yych == 'i') goto yy1143;
		goto yy87;
yy1120:
		yych = *++cursor_;
		if (yych == 'i') goto yy1144;
		goto yy87;
yy1121:
		yych = *++cursor_;
		if (yych == '2') goto yy1145;
		goto yy87;
yy1122:
		yych = *++cursor_;
		if (yych == 't') goto yy1147;
		goto yy87;
yy1123:
		yych = *++cursor_;
		if (yych == 't') goto yy1148;
		goto yy87;
yy1124:
		yych = *++cursor_;
		if (yych == '2') goto yy1149;
		goto yy87;
yy1125:
		yych = *++cursor_;
		if (yych == '4') goto yy1151;
		goto yy87;
yy1126:
		yych = *++cursor_;
		if (yych == '2') goto yy1153;
		goto yy87;
yy1127:
		yych = *++cursor_;
		if (yych == '4') goto yy1155;
		goto yy87;
yy1128:
		yych = *++cursor_;
		if (yych == '3') goto yy1157;
		goto yy87;
yy1129:
		yych = *++cursor_;
		if (yych == '3') goto yy1158;
		goto yy87;
yy1130:
		yych = *++cursor_;
		if (yych == 't') goto yy1159;
		goto yy87;
yy1131:
		yych = *++cursor_;
		if (yych == '2') goto yy1160;
		goto yy87;
yy1132:
		yych = *++cursor_;
		if (yych == '4') goto yy1162;
		goto yy87;
yy1133:
		yych = *++cursor_;
		if (yych == '2') goto yy1164;
		goto yy87;
yy1134:
		yych = *++cursor_;
		if (yych == '4') goto yy1166;
		goto yy87;
yy1135:
		yych = *++cursor_;
		if (yych == 'o') goto yy1168;
		goto yy87;
yy1136:
		yych = *++cursor_;
		if (yych == 'd') goto yy1169;
		goto yy87;
yy1137:
		yych = *++cursor_;
		if (yych == 'r') goto yy1171;
		goto yy87;
yy1138:
		yych = *++cursor_;
		if (yych == 'a') goto yy1172;
		goto yy87;
yy1139:
		yych = *++cursor_;
		if (yych == 'l') goto yy1173;
		goto yy87;
yy1140:
		yych = *++cursor_;
		if (yych == '3') goto yy1174;
		if (yych == '6') goto yy1175;
		goto yy87;
yy1141:
		yych = *++cursor_;
		if (yych == '3') goto yy1176;
		if (yych == '6') goto yy1177;
		goto yy87;
yy1142:
		yych = *++cursor_;
		if (yych == '/') goto yy1178;
		goto yy87;
yy1143:
		yych = *++cursor_;
		if (yych == '3') goto yy1179;
		if (yych == '6') goto yy1180;
		goto yy87;
yy1144:
		yych = *++cursor_;
		if (yych == '3') goto yy1181;
		if (yych == '6') goto yy1182;
		goto yy87;
yy1145:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 425 "src/wast-lexer.cc"
		{ OPCODE(F64PromoteF32); RETURN(CONVERT); }
#line 6134 "src/prebuilt/wast-lexer-gen.cc"
yy1147:
		yych = *++cursor_;
		if (yych == '/') goto yy1183;
		goto yy87;
yy1148:
		yych = *++cursor_;
		if (yych == '/') goto yy1184;
		goto yy87;
yy1149:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 409 "src/wast-lexer.cc"
		{ OPCODE(I32TruncSF32); RETURN(CONVERT); }
#line 6150 "src/prebuilt/wast-lexer-gen.cc"
yy1151:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 411 "src/wast-lexer.cc"
		{ OPCODE(I32TruncSF64); RETURN(CONVERT); }
#line 6158 "src/prebuilt/wast-lexer-gen.cc"
yy1153:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 413 "src/wast-lexer.cc"
		{ OPCODE(I32TruncUF32); RETURN(CONVERT); }
#line 6166 "src/prebuilt/wast-lexer-gen.cc"
yy1155:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 415 "src/wast-lexer.cc"
		{ OPCODE(I32TruncUF64); RETURN(CONVERT); }
#line 6174 "src/prebuilt/wast-lexer-gen.cc"
yy1157:
		yych = *++cursor_;
		if (yych == '2') goto yy1185;
		goto yy87;
yy1158:
		yych = *++cursor_;
		if (yych == '2') goto yy1187;
		goto yy87;
yy1159:
		yych = *++cursor_;
		if (yych == '/') goto yy1189;
		goto yy87;
yy1160:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 410 "src/wast-lexer.cc"
		{ OPCODE(I64TruncSF32); RETURN(CONVERT); }
#line 6194 "src/prebuilt/wast-lexer-gen.cc"
yy1162:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 412 "src/wast-lexer.cc"
		{ OPCODE(I64TruncSF64); RETURN(CONVERT); }
#line 6202 "src/prebuilt/wast-lexer-gen.cc"
yy1164:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 414 "src/wast-lexer.cc"
		{ OPCODE(I64TruncUF32); RETURN(CONVERT); }
#line 6210 "src/prebuilt/wast-lexer-gen.cc"
yy1166:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 416 "src/wast-lexer.cc"
		{ OPCODE(I64TruncUF64); RETURN(CONVERT); }
#line 6218 "src/prebuilt/wast-lexer-gen.cc"
yy1168:
		yych = *++cursor_;
		if (yych == 'n') goto yy1190;
		goto yy87;
yy1169:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 456 "src/wast-lexer.cc"
		{ RETURN(ASSERT_MALFORMED); }
#line 6230 "src/prebuilt/wast-lexer-gen.cc"
yy1171:
		yych = *++cursor_;
		if (yych == 'i') goto yy1192;
		goto yy87;
yy1172:
		yych = *++cursor_;
		if (yych == 'n') goto yy1193;
		goto yy87;
yy1173:
		yych = *++cursor_;
		if (yych == 'e') goto yy1194;
		goto yy87;
yy1174:
		yych = *++cursor_;
		if (yych == '2') goto yy1196;
		goto yy87;
yy1175:
		yych = *++cursor_;
		if (yych == '4') goto yy1198;
		goto yy87;
yy1176:
		yych = *++cursor_;
		if (yych == '2') goto yy1200;
		goto yy87;
yy1177:
		yych = *++cursor_;
		if (yych == '4') goto yy1202;
		goto yy87;
yy1178:
		yych = *++cursor_;
		if (yych == 'i') goto yy1204;
		goto yy87;
yy1179:
		yych = *++cursor_;
		if (yych == '2') goto yy1205;
		goto yy87;
yy1180:
		yych = *++cursor_;
		if (yych == '4') goto yy1207;
		goto yy87;
yy1181:
		yych = *++cursor_;
		if (yych == '2') goto yy1209;
		goto yy87;
yy1182:
		yych = *++cursor_;
		if (yych == '4') goto yy1211;
		goto yy87;
yy1183:
		yych = *++cursor_;
		if (yych == 'i') goto yy1213;
		goto yy87;
yy1184:
		yych = *++cursor_;
		if (yych == 'f') goto yy1214;
		goto yy87;
yy1185:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 406 "src/wast-lexer.cc"
		{ OPCODE(I64ExtendSI32); RETURN(CONVERT); }
#line 6294 "src/prebuilt/wast-lexer-gen.cc"
yy1187:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 407 "src/wast-lexer.cc"
		{ OPCODE(I64ExtendUI32); RETURN(CONVERT); }
#line 6302 "src/prebuilt/wast-lexer-gen.cc"
yy1189:
		yych = *++cursor_;
		if (yych == 'f') goto yy1215;
		goto yy87;
yy1190:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 465 "src/wast-lexer.cc"
		{ RETURN(ASSERT_EXHAUSTION); }
#line 6314 "src/prebuilt/wast-lexer-gen.cc"
yy1192:
		yych = *++cursor_;
		if (yych == 't') goto yy1216;
		goto yy87;
yy1193:
		yych = *++cursor_;
		if (yych == 'o') goto yy1217;
		goto yy87;
yy1194:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 458 "src/wast-lexer.cc"
		{ RETURN(ASSERT_UNLINKABLE); }
#line 6330 "src/prebuilt/wast-lexer-gen.cc"
yy1196:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 417 "src/wast-lexer.cc"
		{ OPCODE(F32ConvertSI32); RETURN(CONVERT); }
#line 6338 "src/prebuilt/wast-lexer-gen.cc"
yy1198:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 419 "src/wast-lexer.cc"
		{ OPCODE(F32ConvertSI64); RETURN(CONVERT); }
#line 6346 "src/prebuilt/wast-lexer-gen.cc"
yy1200:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 421 "src/wast-lexer.cc"
		{ OPCODE(F32ConvertUI32); RETURN(CONVERT); }
#line 6354 "src/prebuilt/wast-lexer-gen.cc"
yy1202:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 423 "src/wast-lexer.cc"
		{ OPCODE(F32ConvertUI64); RETURN(CONVERT); }
#line 6362 "src/prebuilt/wast-lexer-gen.cc"
yy1204:
		yych = *++cursor_;
		if (yych == '3') goto yy1218;
		goto yy87;
yy1205:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 418 "src/wast-lexer.cc"
		{ OPCODE(F64ConvertSI32); RETURN(CONVERT); }
#line 6374 "src/prebuilt/wast-lexer-gen.cc"
yy1207:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 420 "src/wast-lexer.cc"
		{ OPCODE(F64ConvertSI64); RETURN(CONVERT); }
#line 6382 "src/prebuilt/wast-lexer-gen.cc"
yy1209:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 422 "src/wast-lexer.cc"
		{ OPCODE(F64ConvertUI32); RETURN(CONVERT); }
#line 6390 "src/prebuilt/wast-lexer-gen.cc"
yy1211:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 424 "src/wast-lexer.cc"
		{ OPCODE(F64ConvertUI64); RETURN(CONVERT); }
#line 6398 "src/prebuilt/wast-lexer-gen.cc"
yy1213:
		yych = *++cursor_;
		if (yych == '6') goto yy1219;
		goto yy87;
yy1214:
		yych = *++cursor_;
		if (yych == '3') goto yy1220;
		goto yy87;
yy1215:
		yych = *++cursor_;
		if (yych == '6') goto yy1221;
		goto yy87;
yy1216:
		yych = *++cursor_;
		if (yych == 'h') goto yy1222;
		goto yy87;
yy1217:
		yych = *++cursor_;
		if (yych == 'n') goto yy1223;
		goto yy87;
yy1218:
		yych = *++cursor_;
		if (yych == '2') goto yy1224;
		goto yy87;
yy1219:
		yych = *++cursor_;
		if (yych == '4') goto yy1226;
		goto yy87;
yy1220:
		yych = *++cursor_;
		if (yych == '2') goto yy1228;
		goto yy87;
yy1221:
		yych = *++cursor_;
		if (yych == '4') goto yy1230;
		goto yy87;
yy1222:
		yych = *++cursor_;
		if (yych == 'm') goto yy1232;
		goto yy87;
yy1223:
		yych = *++cursor_;
		if (yych == 'i') goto yy1233;
		goto yy87;
yy1224:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 427 "src/wast-lexer.cc"
		{ OPCODE(F32ReinterpretI32); RETURN(CONVERT); }
#line 6450 "src/prebuilt/wast-lexer-gen.cc"
yy1226:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 429 "src/wast-lexer.cc"
		{ OPCODE(F64ReinterpretI64); RETURN(CONVERT); }
#line 6458 "src/prebuilt/wast-lexer-gen.cc"
yy1228:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 428 "src/wast-lexer.cc"
		{ OPCODE(I32ReinterpretF32); RETURN(CONVERT); }
#line 6466 "src/prebuilt/wast-lexer-gen.cc"
yy1230:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 430 "src/wast-lexer.cc"
		{ OPCODE(I64ReinterpretF64); RETURN(CONVERT); }
#line 6474 "src/prebuilt/wast-lexer-gen.cc"
yy1232:
		yych = *++cursor_;
		if (yych == 'e') goto yy1234;
		goto yy87;
yy1233:
		yych = *++cursor_;
		if (yych == 'c') goto yy1235;
		goto yy87;
yy1234:
		yych = *++cursor_;
		if (yych == 't') goto yy1236;
		goto yy87;
yy1235:
		yych = *++cursor_;
		if (yych == 'a') goto yy1237;
		goto yy87;
yy1236:
		yych = *++cursor_;
		if (yych == 'i') goto yy1238;
		goto yy87;
yy1237:
		yych = *++cursor_;
		if (yych == 'l') goto yy1239;
		goto yy87;
yy1238:
		yych = *++cursor_;
		if (yych == 'c') goto yy1240;
		goto yy87;
yy1239:
		yych = *++cursor_;
		if (yych == '_') goto yy1241;
		goto yy87;
yy1240:
		yych = *++cursor_;
		if (yych == '_') goto yy1242;
		goto yy87;
yy1241:
		yych = *++cursor_;
		if (yych == 'n') goto yy1243;
		goto yy87;
yy1242:
		yych = *++cursor_;
		if (yych == 'n') goto yy1244;
		goto yy87;
yy1243:
		yych = *++cursor_;
		if (yych == 'a') goto yy1245;
		goto yy87;
yy1244:
		yych = *++cursor_;
		if (yych == 'a') goto yy1246;
		goto yy87;
yy1245:
		yych = *++cursor_;
		if (yych == 'n') goto yy1247;
		goto yy87;
yy1246:
		yych = *++cursor_;
		if (yych == 'n') goto yy1249;
		goto yy87;
yy1247:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 460 "src/wast-lexer.cc"
		{
                                  RETURN(ASSERT_RETURN_CANONICAL_NAN); }
#line 6543 "src/prebuilt/wast-lexer-gen.cc"
yy1249:
		++cursor_;
		if (yybm[0+(yych = *cursor_)] & 8) {
			goto yy86;
		}
#line 462 "src/wast-lexer.cc"
		{
                                  RETURN(ASSERT_RETURN_ARITHMETIC_NAN); }
#line 6552 "src/prebuilt/wast-lexer-gen.cc"
	}
}
#line 491 "src/wast-lexer.cc"

  }
}

}  // namespace wabt
