'use strict';
const common = require('../common');

const expectedDeprecationWarning = 'Unhandled promise rejections are ' +
                                   'deprecated. In the future, promise ' +
                                   'rejections that are not handled will ' +
                                   'terminate the Node.js process with a ' +
                                   'non-zero exit code.';
const expectedPromiseWarning = 'Unhandled promise rejection (rejection id: ' +
                               '1): [object Object]';

function throwErr() {
  throw new Error('Error from proxy');
}

const thorny = new Proxy({}, {
  getPrototypeOf: throwErr,
  setPrototypeOf: throwErr,
  isExtensible: throwErr,
  preventExtensions: throwErr,
  getOwnPropertyDescriptor: throwErr,
  defineProperty: throwErr,
  has: throwErr,
  get: throwErr,
  set: throwErr,
  deleteProperty: throwErr,
  ownKeys: throwErr,
  apply: throwErr,
  construct: throwErr
});

if (!common.isChakraEngine) {
  common.expectWarning({
    DeprecationWarning: expectedDeprecationWarning,
    UnhandledPromiseRejectionWarning: expectedPromiseWarning,
  });
}

// ensure this doesn't crash
Promise.reject(thorny);
