<h1 align="center">
	<br>
	<img width="300" src="https://rawgit.com/floatdrop/pinkie/master/media/logo.png" alt="pinkie">
	<br>
	<br>
</h1>

> Itty bitty little wittle twinkie pinkie [ES6 Promise](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-promise-objects) implementation

[![Build Status](https://travis-ci.org/floatdrop/pinkie.svg?branch=master)](https://travis-ci.org/floatdrop/pinkie)

There are [tons of Promise implementations](https://github.com/sorrycc/awesome-javascript#control-flow) out there, but all of them focused on browser compatibility and often bloated with functionality.

This module focused to be exactly Promise specification polyfill (like [native-promise-only](https://github.com/getify/native-promise-only)), but in NodeJS land (it should be browserify-able thou).


## Install

```
$ npm install --save pinkie
```


## Usage

```js
var Promise = require('pinkie');

new Promise(function (resolve, reject) {
	got('google.com', function (err, data) {
		if (err) {
			return reject(err);
		}

		resolve(data);
	});
});
//=> Promise
```


### API

`pinkie` exports bare [ES6 Promise](https://people.mozilla.org/~jorendorff/es6-draft.html#sec-promise-objects) implementation. In case you forgot:

#### new Promise(executor)

Returns new instance of `Promise`.

##### executor

*Required*
Type: `function`

Function with two arguments resolve and reject. The first argument fulfills the promise, the second argument rejects it.

#### pinkie.all(promises)

Returns a promise that resolves when all of the promises in the `promises` Array argument have resolved.

#### pinkie.race(promises)

Returns a promise that resolves or rejects as soon as one of the promises in the `promises` Array resolves or rejects, with the value or reason from that promise.

#### pinkie.reject(reason)

Returns a Promise object that is rejected with the given `reason`.

#### pinkie.resolve(value)

Returns a Promise object that is resolved with the given `value`. If the `value` is a thenable (i.e. has a then method), the returned promise will "follow" that thenable, adopting its eventual state; otherwise the returned promise will be fulfilled with the `value`.

## License

MIT © [Vsevolod Strukchinsky](http://github.com/floatdrop)
