# repeat-string [![NPM version](https://badge.fury.io/js/repeat-string.svg)](http://badge.fury.io/js/repeat-string)  [![Build Status](https://travis-ci.org/jonschlinkert/repeat-string.svg)](https://travis-ci.org/jonschlinkert/repeat-string)

> Repeat the given string n times. Fastest implementation for repeating a string.

## Install with [npm](npmjs.org)

```bash
npm i repeat-string --save
```
## Install with [bower](https://github.com/bower/bower)

```bash
bower install repeat-string --save
```

## Usage

### [repeat](./index.js#L34)

Repeat the given `string` the specified `number` of times.

* `string` **{String}**: The string to repeat
* `number` **{Number}**: The number of times to repeat the string
* `returns` **{String}**: Repeated string

**Example:**

```js
var repeat = require('repeat-string');
repeat('A', 5);
//=> AAAAA
```

## Benchmarks

Repeat string is significantly faster than [repeating](https://github.com/sindresorhus/repeating).

```bash
# 20,000x
  repeat-string.js x 16,634,213 ops/sec ±0.92% (93 runs sampled)
  repeating.js x 5,883,928 ops/sec ±0.95% (93 runs sampled)

# 2,000x
  repeat-string.js x 17,438,654 ops/sec ±0.76% (97 runs sampled)
  repeating.js x 6,639,978 ops/sec ±0.84% (97 runs sampled)

# 250x
  repeat-string.js x 16,246,885 ops/sec ±0.81% (92 runs sampled)
  repeating.js x 7,659,342 ops/sec ±0.67% (99 runs sampled)

# 50x
  repeat-string.js x 15,803,340 ops/sec ±0.74% (92 runs sampled)
  repeating.js x 9,668,300 ops/sec ±0.89% (98 runs sampled)

# 5x
  repeat-string.js x 16,926,291 ops/sec ±0.78% (97 runs sampled)
  repeating.js x 12,215,384 ops/sec ±1.01% (96 runs sampled)
```

**Run the benchmarks**

Install dev dependencies:

```bash
npm i -d && node benchmark
```

### Other javascript/node.js utils
[repeat-element](https://github.com/jonschlinkert/repeat-element): Create an array by repeating the given string n times.

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/repeat-string/issues)

## Running tests
Install dev dependencies:

```bash
npm i -d && npm test
```

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License
Copyright (c) 2015 Jon Schlinkert
Released under the MIT license

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on April 01, 2015._
